/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res.aar;

import com.android.aapt.ConfigurationOuterClass;
import com.android.aapt.Resources;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.AttrResourceValueImpl;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValueImpl;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.res.aar.AarArrayResourceItem;
import com.android.tools.idea.res.aar.AarAttrResourceItem;
import com.android.tools.idea.res.aar.AarConfiguration;
import com.android.tools.idea.res.aar.AarDensityBasedFileResourceItem;
import com.android.tools.idea.res.aar.AarFileResourceItem;
import com.android.tools.idea.res.aar.AarPluralsResourceItem;
import com.android.tools.idea.res.aar.AarResourceItem;
import com.android.tools.idea.res.aar.AarSourceResourceRepository;
import com.android.tools.idea.res.aar.AarStyleResourceItem;
import com.android.tools.idea.res.aar.AarStyleableResourceItem;
import com.android.tools.idea.res.aar.AarTextValueResourceItem;
import com.android.tools.idea.res.aar.AarValueResourceItem;
import com.android.tools.idea.res.aar.ProtoConfigurationDecoder;
import com.android.tools.idea.res.aar.ProtoStyledStringDecoder;
import com.android.utils.XmlUtils;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.BitUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AarProtoResourceRepository
extends AarSourceResourceRepository {
    private static final Logger LOG = Logger.getInstance(AarProtoResourceRepository.class);
    private static final String RESOURCE_TABLE_ENTRY = "resources.pb";
    private static final int COMPLEX_UNIT_MASK = 15;
    private static final String[] DIMEN_SUFFIXES = new String[]{"px", "dp", "sp", "pt", "in", "mm"};
    private static final String[] FRACTION_SUFFIXES = new String[]{"%", "%p"};
    private static final int COMPLEX_RADIX_SHIFT = 4;
    private static final int COMPLEX_RADIX_MASK = 3;
    private static final double[] RADIX_FACTORS = new double[]{1.0, 0.0078125, 3.0517578125E-5, 1.1920928955078125E-7};
    private static final int COMPLEX_MANTISSA_SHIFT = 8;
    @NotNull
    private final File myResApkFileOrFolder;
    private String myFilesystemProtocol;
    private String myResourcePathPrefix;
    private String myResourceUrlPrefix;
    private ResourceUrlParser myUrlParser;

    private AarProtoResourceRepository(@NotNull File apkFileOrFolder, @NotNull ResourceNamespace namespace, @Nullable String libraryName) {
        if (apkFileOrFolder == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(0);
        }
        if (namespace == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(1);
        }
        super(apkFileOrFolder.getParentFile(), namespace, libraryName);
        this.myResApkFileOrFolder = apkFileOrFolder;
    }

    @NotNull
    public static AarProtoResourceRepository createProtoRepository(@NotNull File apkFileOrFolder, @Nullable String libraryName) {
        if (apkFileOrFolder == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(2);
        }
        DataLoader loader = new DataLoader(apkFileOrFolder);
        try {
            loader.load();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            AarProtoResourceRepository aarProtoResourceRepository = new AarProtoResourceRepository(apkFileOrFolder, AarProtoResourceRepository.getNamespace(loader.packageName), libraryName);
            if (aarProtoResourceRepository == null) {
                AarProtoResourceRepository.$$$reportNull$$$0(3);
            }
            return aarProtoResourceRepository;
        }
        AarProtoResourceRepository repository = new AarProtoResourceRepository(apkFileOrFolder, AarProtoResourceRepository.getNamespace(loader.packageName), libraryName);
        repository.load(loader);
        AarProtoResourceRepository aarProtoResourceRepository = repository;
        if (aarProtoResourceRepository == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(4);
        }
        return aarProtoResourceRepository;
    }

    @NotNull
    private static ResourceNamespace getNamespace(@Nullable String packageName) {
        ResourceNamespace resourceNamespace = packageName == null ? ResourceNamespace.RES_AUTO : ResourceNamespace.fromPackageName((String)packageName);
        if (resourceNamespace == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(5);
        }
        return resourceNamespace;
    }

    private void load(@NotNull DataLoader loader) {
        if (loader == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(6);
        }
        this.loadResourceTable(loader.resourceTableMsg);
        if (loader.loadedFromResApk) {
            this.myFilesystemProtocol = "apk";
            this.myResourcePathPrefix = this.myResApkFileOrFolder.getPath() + "!/";
        } else {
            this.myFilesystemProtocol = "file";
            this.myResourcePathPrefix = this.myResApkFileOrFolder.getAbsolutePath() + File.separator;
        }
        this.myResourceUrlPrefix = this.myFilesystemProtocol + "://" + this.myResourcePathPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadResourceTable(@NotNull Resources.ResourceTable resourceTableMsg) {
        if (resourceTableMsg == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(7);
        }
        HashMap<ConfigurationOuterClass.Configuration, AarConfiguration> configCache = new HashMap<ConfigurationOuterClass.Configuration, AarConfiguration>();
        this.myUrlParser = new ResourceUrlParser();
        try {
            for (Resources.Package packageMsg : resourceTableMsg.getPackageList()) {
                for (Resources.Type typeMsg : packageMsg.getTypeList()) {
                    ResourceType resourceType = ResourceType.fromClassName((String)typeMsg.getName());
                    if (resourceType == null) {
                        LOG.warn("Unexpected resource type: " + typeMsg.getName());
                        continue;
                    }
                    for (Resources.Entry entryMsg : typeMsg.getEntryList()) {
                        String resourceName = entryMsg.getName();
                        Resources.Visibility visibilityMsg = entryMsg.getVisibility();
                        ResourceVisibility visibility = AarProtoResourceRepository.computeVisibility(visibilityMsg);
                        for (Resources.ConfigValue configValueMsg : entryMsg.getConfigValueList()) {
                            AarConfiguration configuration = this.getConfiguration(configValueMsg.getConfig(), configCache);
                            Resources.Value valueMsg = configValueMsg.getValue();
                            AarResourceItem item = this.createResourceItem(valueMsg, resourceType, resourceName, configuration, visibility);
                            if (item == null) continue;
                            this.addResourceItem((ResourceItem)item);
                        }
                    }
                }
            }
        }
        finally {
            this.myUrlParser = null;
        }
    }

    @Nullable
    final PathString getPathString(@Nullable String relativeResourcePath) {
        return relativeResourcePath == null ? null : new PathString(this.myFilesystemProtocol, this.myResourcePathPrefix + relativeResourcePath);
    }

    @Nullable
    final String getResourceUrl(@Nullable String relativeResourcePath) {
        return relativeResourcePath == null ? null : this.myResourceUrlPrefix + relativeResourcePath;
    }

    @Nullable
    private AarResourceItem createResourceItem(@NotNull Resources.Value valueMsg, @NotNull ResourceType resourceType, @NotNull String resourceName, @NotNull AarConfiguration configuration, @NotNull ResourceVisibility visibility) {
        if (valueMsg == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(8);
        }
        if (resourceType == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(9);
        }
        if (resourceName == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(10);
        }
        if (configuration == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(11);
        }
        if (visibility == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(12);
        }
        switch (valueMsg.getValueCase()) {
            case ITEM: {
                return this.createResourceItem(valueMsg.getItem(), resourceType, resourceName, configuration, visibility);
            }
            case COMPOUND_VALUE: {
                String description = valueMsg.getComment();
                if (CharMatcher.whitespace().matchesAllOf((CharSequence)description)) {
                    description = null;
                }
                return this.createResourceItem(valueMsg.getCompoundValue(), resourceName, configuration, visibility, description);
            }
        }
        LOG.warn("Unexpected Value message: " + valueMsg);
        return null;
    }

    @Nullable
    private AarResourceItem createResourceItem(@NotNull Resources.Item itemMsg, @NotNull ResourceType resourceType, @NotNull String resourceName, @NotNull AarConfiguration configuration, @NotNull ResourceVisibility visibility) {
        if (itemMsg == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(13);
        }
        if (resourceType == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(14);
        }
        if (resourceName == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(15);
        }
        if (configuration == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(16);
        }
        if (visibility == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(17);
        }
        switch (itemMsg.getValueCase()) {
            case FILE: {
                Density densityValue;
                String path = itemMsg.getFile().getPath();
                FolderConfiguration config = configuration.getFolderConfiguration();
                DensityQualifier densityQualifier = config.getDensityQualifier();
                if (densityQualifier != null && (densityValue = densityQualifier.getValue()) != null) {
                    return new AarDensityBasedFileResourceItem(resourceType, resourceName, configuration, visibility, path, densityValue);
                }
                return new AarFileResourceItem(resourceType, resourceName, configuration, visibility, path);
            }
            case REF: {
                String ref = this.decode(itemMsg.getRef());
                return AarProtoResourceRepository.createResourceItem(resourceType, resourceName, configuration, visibility, ref);
            }
            case STR: {
                String textValue = itemMsg.getStr().getValue();
                return new AarTextValueResourceItem(resourceType, resourceName, configuration, visibility, textValue, null);
            }
            case RAW_STR: {
                String str = itemMsg.getRawStr().getValue();
                return AarProtoResourceRepository.createResourceItem(resourceType, resourceName, configuration, visibility, str);
            }
            case PRIM: {
                String str = AarProtoResourceRepository.decode(itemMsg.getPrim());
                return AarProtoResourceRepository.createResourceItem(resourceType, resourceName, configuration, visibility, str);
            }
            case STYLED_STR: {
                Resources.StyledString styledStrMsg = itemMsg.getStyledStr();
                String textValue = styledStrMsg.getValue();
                String rawXmlValue = ProtoStyledStringDecoder.getRawXmlValue(styledStrMsg);
                return new AarTextValueResourceItem(resourceType, resourceName, configuration, visibility, textValue, rawXmlValue);
            }
            case ID: {
                return AarProtoResourceRepository.createResourceItem(resourceType, resourceName, configuration, visibility, "");
            }
        }
        LOG.warn("Unexpected Item message: " + itemMsg);
        return null;
    }

    @NotNull
    private static AarResourceItem createResourceItem(@NotNull ResourceType resourceType, @NotNull String resourceName, @NotNull AarConfiguration configuration, @NotNull ResourceVisibility visibility, @Nullable String value2) {
        if (resourceType == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(18);
        }
        if (resourceName == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(19);
        }
        if (configuration == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(20);
        }
        if (visibility == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(21);
        }
        AarValueResourceItem aarValueResourceItem = new AarValueResourceItem(resourceType, resourceName, configuration, visibility, value2);
        if (aarValueResourceItem == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(22);
        }
        return aarValueResourceItem;
    }

    @Nullable
    private AarResourceItem createResourceItem(@NotNull Resources.CompoundValue compoundValueMsg, @NotNull String resourceName, @NotNull AarConfiguration configuration, @NotNull ResourceVisibility visibility, @Nullable String description) {
        if (compoundValueMsg == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(23);
        }
        if (resourceName == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(24);
        }
        if (configuration == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(25);
        }
        if (visibility == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(26);
        }
        switch (compoundValueMsg.getValueCase()) {
            case ATTR: {
                return AarProtoResourceRepository.createAttr(compoundValueMsg.getAttr(), resourceName, configuration, visibility, description);
            }
            case STYLE: {
                return this.createStyle(compoundValueMsg.getStyle(), resourceName, configuration, visibility);
            }
            case STYLEABLE: {
                return this.createStyleable(compoundValueMsg.getStyleable(), resourceName, configuration, visibility);
            }
            case ARRAY: {
                return this.createArray(compoundValueMsg.getArray(), resourceName, configuration, visibility);
            }
            case PLURAL: {
                return this.createPlurals(compoundValueMsg.getPlural(), resourceName, configuration, visibility);
            }
        }
        LOG.warn("Unexpected CompoundValue message: " + compoundValueMsg);
        return null;
    }

    @Nullable
    private static AarAttrResourceItem createAttr(@NotNull Resources.Attribute attributeMsg, @NotNull String resourceName, @NotNull AarConfiguration configuration, @NotNull ResourceVisibility visibility, @Nullable String description) {
        if (attributeMsg == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(27);
        }
        if (resourceName == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(28);
        }
        if (configuration == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(29);
        }
        if (visibility == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(30);
        }
        Set<AttributeFormat> formats = AarProtoResourceRepository.decodeFormatFlags(attributeMsg.getFormatFlags());
        ImmutableMap.Builder valueMap = ImmutableMap.builder();
        ImmutableMap.Builder valueDescriptionMap = ImmutableMap.builder();
        List symbolList = attributeMsg.getSymbolList();
        if (symbolList.isEmpty() && attributeMsg.getFormatFlags() == Resources.Attribute.FormatFlags.ANY.getNumber()) {
            return null;
        }
        for (Resources.Attribute.Symbol symbolMsg : symbolList) {
            String name = symbolMsg.getName().getName();
            int slashPos = name.lastIndexOf(47);
            if (slashPos >= 0) {
                name = name.substring(slashPos + 1);
            }
            String symbolDescription = symbolMsg.getComment();
            if (CharMatcher.whitespace().matchesAllOf((CharSequence)symbolDescription)) {
                symbolDescription = null;
            }
            valueMap.put((Object)name, (Object)symbolMsg.getValue());
            if (symbolDescription == null) continue;
            valueDescriptionMap.put((Object)name, (Object)symbolDescription);
        }
        return new AarAttrResourceItem(resourceName, configuration, visibility, description, formats, (Map<String, Integer>)valueMap.build(), (Map<String, String>)valueDescriptionMap.build());
    }

    @NotNull
    private AarStyleResourceItem createStyle(@NotNull Resources.Style styleMsg, @NotNull String resourceName, @NotNull AarConfiguration configuration, @NotNull ResourceVisibility visibility) {
        if (styleMsg == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(31);
        }
        if (resourceName == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(32);
        }
        if (configuration == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(33);
        }
        if (visibility == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(34);
        }
        String parentStyle = styleMsg.getParent().getName();
        ArrayList<StyleItemResourceValue> styleItems = new ArrayList<StyleItemResourceValue>(styleMsg.getEntryCount());
        for (Resources.Style.Entry entryMsg : styleMsg.getEntryList()) {
            String url = entryMsg.getKey().getName();
            this.myUrlParser.parseResourceUrl(url);
            String name = this.myUrlParser.withoutType();
            String value2 = this.decode(entryMsg.getItem());
            StyleItemResourceValueImpl itemValue = new StyleItemResourceValueImpl(this.getNamespace(), name, value2, this.getLibraryName());
            styleItems.add((StyleItemResourceValue)itemValue);
        }
        AarStyleResourceItem aarStyleResourceItem = new AarStyleResourceItem(resourceName, configuration, visibility, parentStyle, styleItems);
        if (aarStyleResourceItem == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(35);
        }
        return aarStyleResourceItem;
    }

    @NotNull
    private AarStyleableResourceItem createStyleable(@NotNull Resources.Styleable styleableMsg, @NotNull String resourceName, @NotNull AarConfiguration configuration, @NotNull ResourceVisibility visibility) {
        if (styleableMsg == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(36);
        }
        if (resourceName == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(37);
        }
        if (configuration == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(38);
        }
        if (visibility == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(39);
        }
        ArrayList<AttrResourceValue> attrs = new ArrayList<AttrResourceValue>(styleableMsg.getEntryCount());
        for (Resources.Styleable.Entry entryMsg : styleableMsg.getEntryList()) {
            String url = entryMsg.getAttr().getName();
            this.myUrlParser.parseResourceUrl(url);
            String packageName = this.myUrlParser.getPackageName();
            ResourceNamespace namespace = packageName == null ? this.getNamespace() : ResourceNamespace.fromPackageName((String)packageName);
            AttrResourceValueImpl attrValue = new AttrResourceValueImpl(namespace, ResourceType.ATTR, this.myUrlParser.getName(), this.getLibraryName());
            attrs.add((AttrResourceValue)attrValue);
        }
        AarStyleableResourceItem aarStyleableResourceItem = new AarStyleableResourceItem(resourceName, configuration, visibility, attrs);
        if (aarStyleableResourceItem == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(40);
        }
        return aarStyleableResourceItem;
    }

    @NotNull
    private AarArrayResourceItem createArray(@NotNull Resources.Array arrayMsg, @NotNull String resourceName, @NotNull AarConfiguration configuration, @NotNull ResourceVisibility visibility) {
        if (arrayMsg == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(41);
        }
        if (resourceName == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(42);
        }
        if (configuration == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(43);
        }
        if (visibility == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(44);
        }
        ArrayList<String> elements = new ArrayList<String>(arrayMsg.getElementCount());
        for (Resources.Array.Element elementMsg : arrayMsg.getElementList()) {
            String text = this.decode(elementMsg.getItem());
            if (text == null) continue;
            elements.add(text);
        }
        AarArrayResourceItem aarArrayResourceItem = new AarArrayResourceItem(resourceName, configuration, visibility, elements);
        if (aarArrayResourceItem == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(45);
        }
        return aarArrayResourceItem;
    }

    @NotNull
    private AarPluralsResourceItem createPlurals(@NotNull Resources.Plural pluralMsg, @NotNull String resourceName, @NotNull AarConfiguration configuration, @NotNull ResourceVisibility visibility) {
        if (pluralMsg == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(46);
        }
        if (resourceName == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(47);
        }
        if (configuration == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(48);
        }
        if (visibility == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(49);
        }
        ArrayList<String> quantities = new ArrayList<String>(pluralMsg.getEntryCount());
        ArrayList<String> values2 = new ArrayList<String>(pluralMsg.getEntryCount());
        for (Resources.Plural.Entry entryMsg : pluralMsg.getEntryList()) {
            quantities.add(AarProtoResourceRepository.getQuantity(entryMsg.getArity()));
            values2.add(this.decode(entryMsg.getItem()));
        }
        AarPluralsResourceItem aarPluralsResourceItem = new AarPluralsResourceItem(resourceName, configuration, visibility, quantities, values2);
        if (aarPluralsResourceItem == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(50);
        }
        return aarPluralsResourceItem;
    }

    @NotNull
    private static String getQuantity(@NotNull Resources.Plural.Arity arity) {
        if (arity == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(51);
        }
        switch (arity) {
            case ZERO: {
                if ("zero" == null) {
                    AarProtoResourceRepository.$$$reportNull$$$0(52);
                }
                return "zero";
            }
            case ONE: {
                if ("one" == null) {
                    AarProtoResourceRepository.$$$reportNull$$$0(53);
                }
                return "one";
            }
            case TWO: {
                if ("two" == null) {
                    AarProtoResourceRepository.$$$reportNull$$$0(54);
                }
                return "two";
            }
            case FEW: {
                if ("few" == null) {
                    AarProtoResourceRepository.$$$reportNull$$$0(55);
                }
                return "few";
            }
            case MANY: {
                if ("many" == null) {
                    AarProtoResourceRepository.$$$reportNull$$$0(56);
                }
                return "many";
            }
        }
        if ("other" == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(57);
        }
        return "other";
    }

    @NotNull
    private static ResourceVisibility computeVisibility(@NotNull Resources.Visibility visibilityMsg) {
        if (visibilityMsg == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(58);
        }
        switch (visibilityMsg.getLevel()) {
            case UNKNOWN: {
                ResourceVisibility resourceVisibility = ResourceVisibility.PRIVATE_XML_ONLY;
                if (resourceVisibility == null) {
                    AarProtoResourceRepository.$$$reportNull$$$0(59);
                }
                return resourceVisibility;
            }
            case PRIVATE: {
                ResourceVisibility resourceVisibility = ResourceVisibility.PRIVATE;
                if (resourceVisibility == null) {
                    AarProtoResourceRepository.$$$reportNull$$$0(60);
                }
                return resourceVisibility;
            }
            case PUBLIC: {
                ResourceVisibility resourceVisibility = ResourceVisibility.PUBLIC;
                if (resourceVisibility == null) {
                    AarProtoResourceRepository.$$$reportNull$$$0(61);
                }
                return resourceVisibility;
            }
        }
        ResourceVisibility resourceVisibility = ResourceVisibility.UNDEFINED;
        if (resourceVisibility == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(62);
        }
        return resourceVisibility;
    }

    private void addResourceItem(@NotNull ResourceItem item) {
        if (item == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(63);
        }
        ListMultimap multimap = this.getFullTable().getOrPutEmpty(this.getNamespace(), item.getType());
        multimap.put((Object)item.getName(), (Object)item);
    }

    @Nullable
    private String decode(@NotNull Resources.Item itemMsg) {
        if (itemMsg == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(64);
        }
        switch (itemMsg.getValueCase()) {
            case REF: {
                return this.decode(itemMsg.getRef());
            }
            case STR: {
                return itemMsg.getStr().getValue();
            }
            case RAW_STR: {
                return itemMsg.getRawStr().getValue();
            }
            case STYLED_STR: {
                return itemMsg.getStyledStr().getValue();
            }
            case FILE: {
                return itemMsg.getFile().getPath();
            }
            case ID: {
                return null;
            }
            case PRIM: {
                return AarProtoResourceRepository.decode(itemMsg.getPrim());
            }
        }
        return null;
    }

    @NotNull
    private String decode(@NotNull Resources.Reference referenceMsg) {
        String name;
        if (referenceMsg == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(65);
        }
        if ((name = referenceMsg.getName()).isEmpty()) {
            if ("@null" == null) {
                AarProtoResourceRepository.$$$reportNull$$$0(66);
            }
            return "@null";
        }
        if (referenceMsg.getType() == Resources.Reference.Type.ATTRIBUTE) {
            this.myUrlParser.parseResourceUrl(name);
            if (this.myUrlParser.isType(ResourceType.ATTR.getName())) {
                name = this.myUrlParser.withoutType();
            }
            String string = '?' + name;
            if (string == null) {
                AarProtoResourceRepository.$$$reportNull$$$0(67);
            }
            return string;
        }
        String string = '@' + name;
        if (string == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(68);
        }
        return string;
    }

    @Nullable
    private static String decode(@NotNull Resources.Primitive primitiveMsg) {
        if (primitiveMsg == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(69);
        }
        switch (primitiveMsg.getOneofValueCase()) {
            case NULL_VALUE: {
                return null;
            }
            case EMPTY_VALUE: {
                return "";
            }
            case FLOAT_VALUE: {
                return XmlUtils.trimInsignificantZeros((String)Float.toString(primitiveMsg.getFloatValue()));
            }
            case DIMENSION_VALUE: {
                return AarProtoResourceRepository.decodeComplexDimensionValue(primitiveMsg.getDimensionValue(), 1.0, DIMEN_SUFFIXES);
            }
            case FRACTION_VALUE: {
                return AarProtoResourceRepository.decodeComplexDimensionValue(primitiveMsg.getFractionValue(), 100.0, FRACTION_SUFFIXES);
            }
            case INT_DECIMAL_VALUE: {
                return Integer.toString(primitiveMsg.getIntDecimalValue());
            }
            case INT_HEXADECIMAL_VALUE: {
                return String.format("0x%X", primitiveMsg.getIntHexadecimalValue());
            }
            case BOOLEAN_VALUE: {
                return Boolean.toString(primitiveMsg.getBooleanValue());
            }
            case COLOR_ARGB8_VALUE: {
                return String.format("#%08X", primitiveMsg.getColorArgb8Value());
            }
            case COLOR_RGB8_VALUE: {
                return String.format("#%06X", primitiveMsg.getColorRgb8Value() & 0xFFFFFF);
            }
            case COLOR_ARGB4_VALUE: {
                int argb = primitiveMsg.getColorArgb4Value();
                return String.format("#%X%X%X%X", argb >>> 24 & 0xF, argb >>> 16 & 0xF, argb >>> 8 & 0xF, argb & 0xF);
            }
            case COLOR_RGB4_VALUE: {
                int rgb = primitiveMsg.getColorRgb4Value();
                return String.format("#%X%X%X", rgb >>> 16 & 0xF, rgb >>> 8 & 0xF, rgb & 0xF);
            }
        }
        LOG.warn("Unexpected Primitive message: " + primitiveMsg);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static String decodeComplexDimensionValue(int bits, double scaleFactor, @NotNull String[] stringArray) {
        void unitSuffixes;
        int unitCode;
        if (stringArray == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(70);
        }
        void unit = (unitCode = bits & 0xF) < ((void)unitSuffixes).length ? unitSuffixes[unitCode] : " unknown unit: " + unitCode;
        int radix = bits >> 4 & 3;
        int mantissa = bits >> 8;
        double value2 = (double)mantissa * RADIX_FACTORS[radix] * scaleFactor;
        return XmlUtils.trimInsignificantZeros((String)String.format(Locale.US, "%.5g", value2)) + (String)unit;
    }

    @NotNull
    private static Set<AttributeFormat> decodeFormatFlags(int flags) {
        EnumSet<AttributeFormat> result2 = EnumSet.noneOf(AttributeFormat.class);
        if (BitUtil.isSet((int)flags, (int)1)) {
            result2.add(AttributeFormat.REFERENCE);
        }
        if (BitUtil.isSet((int)flags, (int)2)) {
            result2.add(AttributeFormat.STRING);
        }
        if (BitUtil.isSet((int)flags, (int)4)) {
            result2.add(AttributeFormat.INTEGER);
        }
        if (BitUtil.isSet((int)flags, (int)8)) {
            result2.add(AttributeFormat.BOOLEAN);
        }
        if (BitUtil.isSet((int)flags, (int)16)) {
            result2.add(AttributeFormat.COLOR);
        }
        if (BitUtil.isSet((int)flags, (int)32)) {
            result2.add(AttributeFormat.FLOAT);
        }
        if (BitUtil.isSet((int)flags, (int)64)) {
            result2.add(AttributeFormat.DIMENSION);
        }
        if (BitUtil.isSet((int)flags, (int)128)) {
            result2.add(AttributeFormat.FRACTION);
        }
        if (BitUtil.isSet((int)flags, (int)65536)) {
            result2.add(AttributeFormat.ENUM);
        }
        if (BitUtil.isSet((int)flags, (int)131072)) {
            result2.add(AttributeFormat.FLAGS);
        }
        Set<AttributeFormat> set = Collections.unmodifiableSet(result2);
        if (set == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(71);
        }
        return set;
    }

    @NotNull
    private AarConfiguration getConfiguration(@NotNull ConfigurationOuterClass.Configuration configMsg, @NotNull Map<ConfigurationOuterClass.Configuration, AarConfiguration> cache) {
        AarConfiguration aarConfiguration;
        if (configMsg == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(72);
        }
        if (cache == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(73);
        }
        if ((aarConfiguration = cache.get(configMsg)) != null) {
            AarConfiguration aarConfiguration2 = aarConfiguration;
            if (aarConfiguration2 == null) {
                AarProtoResourceRepository.$$$reportNull$$$0(74);
            }
            return aarConfiguration2;
        }
        FolderConfiguration configuration = ProtoConfigurationDecoder.getConfiguration(configMsg);
        aarConfiguration = new AarConfiguration(this, configuration);
        cache.put(configMsg, aarConfiguration);
        AarConfiguration aarConfiguration3 = aarConfiguration;
        if (aarConfiguration3 == null) {
            AarProtoResourceRepository.$$$reportNull$$$0(75);
        }
        return aarConfiguration3;
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + '@' + Integer.toHexString(System.identityHashCode((Object)this)) + " for " + this.myResApkFileOrFolder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 22: 
            case 35: 
            case 40: 
            case 45: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 74: 
            case 75: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 22: 
            case 35: 
            case 40: 
            case 45: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 74: 
            case 75: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apkFileOrFolder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 22: 
            case 35: 
            case 40: 
            case 45: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 74: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/aar/AarProtoResourceRepository";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceTableMsg";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueMsg";
                break;
            }
            case 9: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 10: 
            case 15: 
            case 19: 
            case 24: 
            case 28: 
            case 32: 
            case 37: 
            case 42: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 11: 
            case 16: 
            case 20: 
            case 25: 
            case 29: 
            case 33: 
            case 38: 
            case 43: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 12: 
            case 17: 
            case 21: 
            case 26: 
            case 30: 
            case 34: 
            case 39: 
            case 44: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
            case 13: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemMsg";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compoundValueMsg";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeMsg";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleMsg";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleableMsg";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayMsg";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluralMsg";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arity";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibilityMsg";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceMsg";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primitiveMsg";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unitSuffixes";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configMsg";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/aar/AarProtoResourceRepository";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createProtoRepository";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createResourceItem";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createStyle";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createStyleable";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createArray";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "createPlurals";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuantity";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "computeVisibility";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "decode";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "decodeFormatFlags";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createProtoRepository";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 22: 
            case 35: 
            case 40: 
            case 45: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 74: 
            case 75: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadResourceTable";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createResourceItem";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createAttr";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createStyle";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createStyleable";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createArray";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createPlurals";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getQuantity";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "computeVisibility";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "addResourceItem";
                break;
            }
            case 64: 
            case 65: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "decode";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "decodeComplexDimensionValue";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 22: 
            case 35: 
            case 40: 
            case 45: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 74: 
            case 75: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DataLoader {
        private final File resApkFileOrFolder;
        Resources.ResourceTable resourceTableMsg;
        String packageName;
        boolean loadedFromResApk;

        DataLoader(@NotNull File resApkFileOrFolder) {
            if (resApkFileOrFolder == null) {
                DataLoader.$$$reportNull$$$0(0);
            }
            this.resApkFileOrFolder = resApkFileOrFolder;
        }

        void load() throws IOException {
            try {
                this.resourceTableMsg = this.readResourceTableFromResourcesPbFile();
                this.packageName = AndroidManifestUtils.getPackageNameFromManifestFile(new PathString(new File(this.resApkFileOrFolder, "AndroidManifest.xml")));
            }
            catch (FileNotFoundException e) {
                try (ZipFile zipFile = new ZipFile(this.resApkFileOrFolder);){
                    this.resourceTableMsg = DataLoader.readResourceTableFromResApk(zipFile);
                    this.packageName = AndroidManifestUtils.getPackageNameFromResApk(zipFile);
                }
                this.loadedFromResApk = true;
            }
        }

        @Nullable
        private Resources.ResourceTable readResourceTableFromResourcesPbFile() throws IOException {
            File file = new File(this.resApkFileOrFolder, AarProtoResourceRepository.RESOURCE_TABLE_ENTRY);
            try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
                Resources.ResourceTable resourceTable = Resources.ResourceTable.parseFrom((InputStream)stream);
                return resourceTable;
            }
        }

        @NotNull
        private static Resources.ResourceTable readResourceTableFromResApk(@NotNull ZipFile resApk) throws IOException {
            Resources.ResourceTable resourceTable;
            ZipEntry zipEntry;
            if (resApk == null) {
                DataLoader.$$$reportNull$$$0(1);
            }
            if ((zipEntry = resApk.getEntry(AarProtoResourceRepository.RESOURCE_TABLE_ENTRY)) == null) {
                throw new IOException("\"resources.pb\" not found in " + resApk.getName());
            }
            try (BufferedInputStream stream = new BufferedInputStream(resApk.getInputStream(zipEntry));){
                Resources.ResourceTable resourceTable2 = Resources.ResourceTable.parseFrom((InputStream)stream);
                resourceTable = resourceTable2;
            }
            if (resourceTable == null) {
                DataLoader.$$$reportNull$$$0(2);
            }
            return resourceTable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resApkFileOrFolder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resApk";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/res/aar/AarProtoResourceRepository$DataLoader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/res/aar/AarProtoResourceRepository$DataLoader";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readResourceTableFromResApk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "readResourceTableFromResApk";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ResourceUrlParser {
        @NotNull
        String resourceUrl = "";
        int prefixEnd;
        int colonPos;
        int slashPos;

        private ResourceUrlParser() {
        }

        void parseResourceUrl(@NotNull String resourceUrl) {
            if (resourceUrl == null) {
                ResourceUrlParser.$$$reportNull$$$0(0);
            }
            this.resourceUrl = resourceUrl;
            this.prefixEnd = resourceUrl.startsWith("@") ? (resourceUrl.startsWith("@+") ? 2 : 1) : (resourceUrl.startsWith("?") ? 1 : 0);
            if (resourceUrl.startsWith("*", this.prefixEnd)) {
                ++this.prefixEnd;
            }
            this.slashPos = resourceUrl.lastIndexOf(47);
            this.colonPos = this.slashPos >= 0 ? resourceUrl.lastIndexOf(58, this.slashPos) : resourceUrl.lastIndexOf(58);
        }

        @Nullable
        String getPackageName() {
            return this.colonPos > this.prefixEnd ? this.resourceUrl.substring(this.prefixEnd, this.colonPos) : null;
        }

        int getTypeStart() {
            return this.colonPos >= 0 ? this.colonPos + 1 : this.prefixEnd;
        }

        boolean isType(@NotNull String type) {
            if (type == null) {
                ResourceUrlParser.$$$reportNull$$$0(1);
            }
            if (this.slashPos < 0) {
                return false;
            }
            int typeStart = this.getTypeStart();
            return this.resourceUrl.startsWith(type) && this.slashPos == typeStart + type.length();
        }

        @NotNull
        String getName() {
            int nameStart = this.slashPos >= 0 ? this.slashPos + 1 : (this.colonPos >= 0 ? this.colonPos + 1 : this.prefixEnd);
            String string = this.resourceUrl.substring(nameStart);
            if (string == null) {
                ResourceUrlParser.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        String withoutType() {
            if (this.slashPos < 0) {
                String string = this.resourceUrl;
                if (string == null) {
                    ResourceUrlParser.$$$reportNull$$$0(3);
                }
                return string;
            }
            int typeStart = this.getTypeStart();
            if (typeStart == 0) {
                String string = this.resourceUrl.substring(this.slashPos + 1);
                if (string == null) {
                    ResourceUrlParser.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = this.resourceUrl.substring(0, typeStart) + this.resourceUrl.substring(this.slashPos + 1);
            if (string == null) {
                ResourceUrlParser.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceUrl";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/res/aar/AarProtoResourceRepository$ResourceUrlParser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/res/aar/AarProtoResourceRepository$ResourceUrlParser";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withoutType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "parseResourceUrl";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isType";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

