/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.util.PathString;
import com.android.tools.idea.res.PsiProjectListener;
import com.android.tools.idea.res.SampleDataListenerKt;
import com.android.tools.idea.res.SampleDataResourceRepository;
import com.android.tools.idea.util.FileExtensions;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 /2\u00020\u00012\u00020\u0002:\u0001/B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0017H\u0016J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0017H\u0016J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0017H\u0016J\u0006\u0010\u001c\u001a\u00020\u0011J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\"\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0015H\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010'\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\nH\u0002J\u0010\u0010,\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0017H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007RL\u0010\b\u001a@\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f \u000b*\u001e\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f0\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/android/tools/idea/res/SampleDataListener;", "Lcom/intellij/psi/PsiTreeChangeAdapter;", "Lcom/intellij/openapi/vfs/VirtualFileListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "reposToInvalidate", "", "Lcom/android/ide/common/util/PathString;", "kotlin.jvm.PlatformType", "Lcom/android/tools/idea/res/SampleDataResourceRepository;", "", "subscribed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "beforeFileDeletion", "", "event", "Lcom/intellij/openapi/vfs/VirtualFileEvent;", "beforeFileMovement", "Lcom/intellij/openapi/vfs/VirtualFileMoveEvent;", "childAdded", "Lcom/intellij/psi/PsiTreeChangeEvent;", "childMoved", "childRemoved", "childReplaced", "childrenChanged", "ensureSubscribed", "fileChangePending", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileChanged", "fileCreated", "fileDeleted", "fileMoved", "findRepoToInvalidate", "isPossiblyRelevant", "", "isRelevant", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "pendingFileChangeComplete", "path", "propertyChanged", "Lcom/intellij/openapi/vfs/VirtualFilePropertyEvent;", "psiFileChanged", "Companion", "intellij.android.core"})
public final class SampleDataListener
extends PsiTreeChangeAdapter
implements VirtualFileListener {
    private final Map<PathString, SampleDataResourceRepository> reposToInvalidate;
    private AtomicBoolean subscribed;
    @NotNull
    private final Project project;
    private static final Logger LOG;
    public static final Companion Companion;

    public final void ensureSubscribed() {
        if (this.subscribed.compareAndSet(false, true)) {
            VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this, (Disposable)this.project);
            PsiProjectListener.getInstance(this.project).setSampleDataListener(this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRelevant(VirtualFile file, AndroidFacet facet) {
        if (facet.isDisposed()) return false;
        if (!SampleDataResourceRepository.SampleDataRepositoryManager.getInstance(facet).hasRepository()) return false;
        Module module = facet.getModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"facet.module");
        if (!SampleDataListenerKt.access$isSampleDataFile(module, file)) return false;
        return true;
    }

    private final boolean isPossiblyRelevant(VirtualFile file) {
        String string;
        String it = string = file.getExtension();
        boolean bl = false;
        return Intrinsics.areEqual((Object)it, (Object)"java") ^ true && Intrinsics.areEqual((Object)it, (Object)"xml") ^ true;
    }

    private final SampleDataResourceRepository findRepoToInvalidate(VirtualFile file) {
        if (!this.isPossiblyRelevant(file)) {
            return null;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance(file, this.project);
        if (androidFacet == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)androidFacet), (String)"AndroidFacet.getInstance\u2026, project) ?: return null");
        AndroidFacet facet = androidFacet;
        return this.isRelevant(file, facet) ? SampleDataResourceRepository.getInstance(facet) : null;
    }

    private final void fileChanged(VirtualFile file) {
        block0: {
            SampleDataResourceRepository sampleDataResourceRepository = this.findRepoToInvalidate(file);
            if (sampleDataResourceRepository == null) break block0;
            SampleDataListener.Companion.invalidateBecauseOf(sampleDataResourceRepository, FileExtensions.toPathString(file));
        }
    }

    private final void psiFileChanged(PsiTreeChangeEvent event) {
        block0: {
            PsiFile psiFile;
            PsiFile psiFile2 = event.getFile();
            if (psiFile2 == null || (psiFile2 = psiFile2.getVirtualFile()) == null) break block0;
            PsiFile it = psiFile = psiFile2;
            boolean bl = false;
            this.fileChanged((VirtualFile)it);
        }
    }

    private final void fileChangePending(VirtualFile file) {
        block0: {
            SampleDataResourceRepository sampleDataResourceRepository;
            SampleDataResourceRepository sampleDataResourceRepository2 = this.findRepoToInvalidate(file);
            if (sampleDataResourceRepository2 == null) break block0;
            SampleDataResourceRepository repo = sampleDataResourceRepository = sampleDataResourceRepository2;
            boolean bl = false;
            Map<PathString, SampleDataResourceRepository> map2 = this.reposToInvalidate;
            PathString pathString = FileExtensions.toPathString(file);
            SampleDataResourceRepository sampleDataResourceRepository3 = repo;
            map2.put(pathString, sampleDataResourceRepository3);
        }
    }

    private final void pendingFileChangeComplete(PathString path) {
        block0: {
            SampleDataResourceRepository sampleDataResourceRepository = this.reposToInvalidate.remove(path);
            if (sampleDataResourceRepository == null) break block0;
            SampleDataListener.Companion.invalidateBecauseOf(sampleDataResourceRepository, path);
        }
    }

    public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
        this.fileChangePending(virtualFile);
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        VirtualFile virtualFile = event.getOldParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.oldParent");
        PathString pathString = FileExtensions.toPathString(virtualFile);
        String string = event.getFileName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.fileName");
        this.pendingFileChangeComplete(pathString.resolve(string));
        VirtualFile virtualFile2 = event.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"event.file");
        this.fileChanged(virtualFile2);
    }

    public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
        this.fileChangePending(virtualFile);
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
        this.pendingFileChangeComplete(FileExtensions.toPathString(virtualFile));
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
        this.fileChanged(virtualFile);
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
        this.fileChanged(virtualFile);
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.psiFileChanged(event);
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.psiFileChanged(event);
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.psiFileChanged(event);
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.psiFileChanged(event);
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.psiFileChanged(event);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public SampleDataListener(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        Map map2 = ContainerUtil.createWeakValueMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"ContainerUtil.createWeak\u2026DataResourceRepository>()");
        this.reposToInvalidate = map2;
        this.subscribed = new AtomicBoolean(false);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(SampleDataListener.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(SampleDataListener::class.java)");
        LOG = logger;
    }

    @JvmStatic
    @NotNull
    public static final SampleDataListener getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    public static final void ensureSubscribed(@NotNull Project project) {
        Companion.ensureSubscribed(project);
    }

    @JvmStatic
    private static final void invalidateBecauseOf(@NotNull SampleDataResourceRepository $receiver, PathString modifiedPath) {
        SampleDataListener.Companion.invalidateBecauseOf($receiver, modifiedPath);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0014\u0010\u000b\u001a\u00020\u0006*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/res/SampleDataListener$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "ensureSubscribed", "", "project", "Lcom/intellij/openapi/project/Project;", "getInstance", "Lcom/android/tools/idea/res/SampleDataListener;", "invalidateBecauseOf", "Lcom/android/tools/idea/res/SampleDataResourceRepository;", "modifiedPath", "Lcom/android/ide/common/util/PathString;", "intellij.android.core"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final SampleDataListener getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = ServiceManager.getService((Project)project, SampleDataListener.class);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            return (SampleDataListener)((Object)object);
        }

        @JvmStatic
        public final void ensureSubscribed(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            this.getInstance(project).ensureSubscribed();
        }

        @JvmStatic
        private final void invalidateBecauseOf(@NotNull SampleDataResourceRepository $receiver, PathString modifiedPath) {
            LOG.info("Invalidating SampleDataResourceRepository because " + modifiedPath + " was modified.");
            $receiver.invalidate();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

