/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.SdkConstants;
import com.android.builder.model.AaptOptions;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.TextResourceValue;
import com.android.ide.common.resources.AbstractResourceRepository;
import com.android.ide.common.resources.DataBindingResourceType;
import com.android.ide.common.resources.MergeConsumer;
import com.android.ide.common.resources.MergedResourceWriter;
import com.android.ide.common.resources.MergingException;
import com.android.ide.common.resources.NoOpResourcePreprocessor;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceMerger;
import com.android.ide.common.resources.ResourceMergerItem;
import com.android.ide.common.resources.ResourcePreprocessor;
import com.android.ide.common.resources.ResourceSet;
import com.android.ide.common.resources.ResourceTable;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.res.DataBindingInfo;
import com.android.tools.idea.res.LayoutDataBindingInfo;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MergedDataBindingInfo;
import com.android.tools.idea.res.PsiDataBindingResourceItem;
import com.android.tools.idea.res.PsiProjectListener;
import com.android.tools.idea.res.PsiResourceFile;
import com.android.tools.idea.res.PsiResourceItem;
import com.android.tools.idea.res.ResourceFileAdapter;
import com.android.tools.idea.res.ResourceFolderRepositoryFileCacheService;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceItemSource;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.lint.detector.api.Lint;
import com.android.utils.ILogger;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResourceFolderRepository
extends LocalResourceRepository
implements SingleNamespaceResourceRepository {
    private static final Logger LOG = Logger.getInstance(ResourceFolderRepository.class);
    private final Module myModule;
    private final AndroidFacet myFacet;
    private final PsiListener myListener;
    private final VirtualFile myResourceDir;
    @NotNull
    private final ResourceNamespace myNamespace;
    @GuardedBy(value="AbstractResourceRepository.ITEM_MAP_LOCK")
    private final ResourceTable myFullTable;
    private final Map<VirtualFile, ResourceItemSource<? extends ResourceItem>> sources;
    private Map<String, DataBindingInfo> myDataBindingResourceFiles;
    private long myDataBindingResourceFilesModificationCount;
    private final Object SCAN_LOCK;
    private Set<PsiFile> myPendingScans;
    InitialScanState myInitialScanState;
    static int ourFullRescans;

    private ResourceFolderRepository(@NotNull AndroidFacet facet, @NotNull VirtualFile resourceDir, @NotNull ResourceNamespace namespace) {
        if (facet == null) {
            ResourceFolderRepository.$$$reportNull$$$0(0);
        }
        if (resourceDir == null) {
            ResourceFolderRepository.$$$reportNull$$$0(1);
        }
        if (namespace == null) {
            ResourceFolderRepository.$$$reportNull$$$0(2);
        }
        super(resourceDir.getName());
        this.myFullTable = new ResourceTable();
        this.sources = new HashMap<VirtualFile, ResourceItemSource<? extends ResourceItem>>();
        this.myDataBindingResourceFiles = new HashMap<String, DataBindingInfo>();
        this.myDataBindingResourceFilesModificationCount = Long.MIN_VALUE;
        this.SCAN_LOCK = new Object();
        this.myFacet = facet;
        this.myModule = facet.getModule();
        this.myListener = new PsiListener();
        this.myResourceDir = resourceDir;
        this.myNamespace = namespace;
        ResourceMerger merger = this.loadPreviousStateIfExists();
        this.myInitialScanState = new InitialScanState(merger, VfsUtilCore.virtualToIoFile((VirtualFile)this.myResourceDir));
        this.scanRemainingFiles();
        Application app = ApplicationManager.getApplication();
        if (!(this.hasFreshFileCache() || this.namespacesUsed() || app.isUnitTestMode())) {
            this.saveStateToFile();
        }
        if (!app.isUnitTestMode()) {
            this.myInitialScanState = null;
        }
    }

    @NotNull
    AndroidFacet getFacet() {
        AndroidFacet androidFacet = this.myFacet;
        if (androidFacet == null) {
            ResourceFolderRepository.$$$reportNull$$$0(3);
        }
        return androidFacet;
    }

    @NotNull
    public VirtualFile getResourceDir() {
        VirtualFile virtualFile = this.myResourceDir;
        if (virtualFile == null) {
            ResourceFolderRepository.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    @Override
    @Nullable
    public String getLibraryName() {
        return null;
    }

    @Nullable
    public String getPackageName() {
        return AndroidManifestUtils.getPackageName(this.myFacet);
    }

    @NotNull
    static ResourceFolderRepository create(@NotNull AndroidFacet facet, @NotNull VirtualFile dir, @NotNull ResourceNamespace namespace) {
        if (facet == null) {
            ResourceFolderRepository.$$$reportNull$$$0(5);
        }
        if (dir == null) {
            ResourceFolderRepository.$$$reportNull$$$0(6);
        }
        if (namespace == null) {
            ResourceFolderRepository.$$$reportNull$$$0(7);
        }
        ResourceFolderRepository resourceFolderRepository = new ResourceFolderRepository(facet, dir, namespace);
        if (resourceFolderRepository == null) {
            ResourceFolderRepository.$$$reportNull$$$0(8);
        }
        return resourceFolderRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveStateToFile() {
        File blobRoot = ResourceFolderRepositoryFileCacheService.get().getResourceDir(this.myModule.getProject(), this.myResourceDir);
        if (blobRoot == null) {
            return;
        }
        try {
            NoOpResourcePreprocessor preprocessor = NoOpResourcePreprocessor.INSTANCE;
            File tempDirectory = FileUtil.createTempDirectory((String)"resource", (String)"tmp", (boolean)false);
            try {
                MergedResourceWriter consumer = MergedResourceWriter.createWriterWithoutPngCruncher((File)blobRoot, null, null, (ResourcePreprocessor)preprocessor, (File)tempDirectory);
                this.myInitialScanState.myResourceMerger.writeBlobToWithTimestamps(blobRoot, (MergeConsumer)consumer);
            }
            finally {
                FileUtil.delete((File)tempDirectory);
            }
        }
        catch (MergingException | IOException e) {
            LOG.error("Failed to saveStateToFile", e);
            FileUtil.delete((File)blobRoot);
        }
    }

    private ResourceMerger loadPreviousStateIfExists() {
        if (this.namespacesUsed()) {
            return this.createFreshResourceMerger();
        }
        File blobRoot = ResourceFolderRepositoryFileCacheService.get().getResourceDir(this.myModule.getProject(), this.myResourceDir);
        if (blobRoot == null || !blobRoot.exists()) {
            return this.createFreshResourceMerger();
        }
        ResourceMerger merger = new ResourceMerger(0);
        try {
            if (!merger.loadFromBlob(blobRoot, false)) {
                LOG.warn("failed to loadPreviousStateIfExists " + blobRoot);
                return this.createFreshResourceMerger();
            }
        }
        catch (MergingException e) {
            LOG.warn("failed to loadPreviousStateIfExists " + blobRoot, (Throwable)e);
            return this.createFreshResourceMerger();
        }
        HashSet<ResourceFile> resourceFiles = new HashSet<ResourceFile>();
        List resourceSets = merger.getDataSets();
        if (resourceSets.size() != 1) {
            LOG.error("Expecting exactly one resource set, but found " + resourceSets.size());
            return this.createFreshResourceMerger();
        }
        ResourceSet dataSet = (ResourceSet)resourceSets.get(0);
        List sourceFiles = dataSet.getSourceFiles();
        if (sourceFiles.size() != 1) {
            LOG.error("Expecting exactly source files (res/ directories), but found " + sourceFiles.size());
            return this.createFreshResourceMerger();
        }
        File myResourceDirFile = VfsUtilCore.virtualToIoFile((VirtualFile)this.myResourceDir);
        if (!FileUtil.filesEqual((File)((File)sourceFiles.get(0)), (File)myResourceDirFile)) {
            LOG.warn(String.format("source file %1$s, does not match resource dir %2$s", sourceFiles.get(0), myResourceDirFile));
            return this.createFreshResourceMerger();
        }
        HashMap<ResourceType, ListMultimap<String, ResourceItem>> result2 = new HashMap<ResourceType, ListMultimap<String, ResourceItem>>();
        for (ResourceMergerItem item : dataSet.getDataMap().values()) {
            ResourceFile file = (ResourceFile)item.getSourceFile();
            if (file != null) {
                if (!resourceFiles.contains(file)) {
                    VirtualFile vFile = VfsUtil.findFileByIoFile((File)file.getFile(), (boolean)false);
                    if (vFile == null) {
                        item.setIgnoredFromDiskMerge(true);
                        continue;
                    }
                    resourceFiles.add(file);
                    this.sources.put(vFile, new ResourceFileAdapter(file));
                }
                ResourceFolderRepository.addToResult(result2, (ResourceItem)item);
                continue;
            }
            item.setIgnoredFromDiskMerge(true);
        }
        this.commitToRepository(result2);
        return merger;
    }

    private boolean namespacesUsed() {
        return ResourceRepositoryManager.getOrCreateInstance(this.myFacet).getNamespacing() != AaptOptions.Namespacing.DISABLED;
    }

    private static void addToResult(Map<ResourceType, ListMultimap<String, ResourceItem>> result2, ResourceItem item) {
        result2.computeIfAbsent(item.getType(), t -> LinkedListMultimap.create()).put((Object)item.getName(), (Object)item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitToRepository(Map<ResourceType, ListMultimap<String, ResourceItem>> itemsByType) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (Map.Entry<ResourceType, ListMultimap<String, ResourceItem>> entry : itemsByType.entrySet()) {
                this.getMap(this.myNamespace, entry.getKey(), true).putAll((Multimap)entry.getValue());
            }
        }
    }

    private ResourceMerger createFreshResourceMerger() {
        ResourceMerger merger = new ResourceMerger(0);
        ResourceSet myData = new ResourceSet(this.myResourceDir.getName(), this.myNamespace, this.getLibraryName(), false);
        File resourceDir = VfsUtilCore.virtualToIoFile((VirtualFile)this.myResourceDir);
        myData.addSource(resourceDir);
        merger.addDataSet(myData);
        return merger;
    }

    boolean hasFreshFileCache() {
        return this.myInitialScanState.numXmlReparsed * 4 <= this.myInitialScanState.numXml;
    }

    private void scanRemainingFiles() {
        if (!this.myResourceDir.isValid()) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(() -> this.getPsiDirsForListener(this.myResourceDir));
        HashMap<ResourceType, ListMultimap<String, ResourceItem>> result2 = new HashMap<ResourceType, ListMultimap<String, ResourceItem>>();
        this.scanResFolder(result2, this.myResourceDir);
        ApplicationManager.getApplication().runReadAction(() -> this.scanQueuedPsiResources(result2));
        this.commitToRepository(result2);
    }

    private void getPsiDirsForListener(@NotNull VirtualFile resourceDir) {
        PsiManager manager;
        PsiDirectory resourceDirPsi;
        if (resourceDir == null) {
            ResourceFolderRepository.$$$reportNull$$$0(9);
        }
        if ((resourceDirPsi = (manager = PsiManager.getInstance((Project)this.myModule.getProject())).findDirectory(resourceDir)) != null) {
            resourceDirPsi.getSubdirectories();
        }
    }

    private void scanQueuedPsiResources(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> result2) {
        PsiFile file;
        if (result2 == null) {
            ResourceFolderRepository.$$$reportNull$$$0(10);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.myModule.getProject());
        for (PsiValueResourceQueueEntry valueResource : this.myInitialScanState.myPsiValueResourceQueue) {
            file = psiManager.findFile(valueResource.file);
            if (file == null) continue;
            this.scanValueFileAsPsi(result2, file, valueResource.folderConfiguration);
        }
        for (PsiFileResourceQueueEntry fileResource : this.myInitialScanState.myPsiFileResourceQueue) {
            if (!fileResource.file.isValid() || (file = psiManager.findFile(fileResource.file)) == null) continue;
            List resourceTypes = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)fileResource.folderType);
            assert (resourceTypes.size() >= 1) : fileResource.folderType;
            ResourceType type = (ResourceType)resourceTypes.get(0);
            this.scanFileResourceFileAsPsi(result2, fileResource.folderType, fileResource.folderConfiguration, type, true, file);
        }
    }

    @Nullable
    private PsiFile ensureValid(@NotNull PsiFile psiFile) {
        Project project;
        if (psiFile == null) {
            ResourceFolderRepository.$$$reportNull$$$0(11);
        }
        if (psiFile.isValid()) {
            return psiFile;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile != null && virtualFile.exists() && !(project = this.myModule.getProject()).isDisposed()) {
            return PsiManager.getInstance((Project)project).findFile(virtualFile);
        }
        return null;
    }

    private void scanResFolder(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> result2, @NotNull VirtualFile resDir) {
        if (result2 == null) {
            ResourceFolderRepository.$$$reportNull$$$0(12);
        }
        if (resDir == null) {
            ResourceFolderRepository.$$$reportNull$$$0(13);
        }
        for (VirtualFile subDir : resDir.getChildren()) {
            FolderConfiguration folderConfiguration;
            String name;
            ResourceFolderType folderType;
            if (!subDir.isValid() || !subDir.isDirectory() || (folderType = ResourceFolderType.getFolderType((String)(name = subDir.getName()))) == null || (folderConfiguration = FolderConfiguration.getConfigForFolder((String)name)) == null) continue;
            String qualifiers = ResourceFolderRepository.getQualifiers(name);
            if (folderType == ResourceFolderType.VALUES) {
                this.scanValueResFolder(result2, subDir, qualifiers, folderConfiguration);
                continue;
            }
            this.scanFileResourceFolder(result2, subDir, folderType, qualifiers, folderConfiguration);
        }
    }

    private static String getQualifiers(String dirName) {
        int index = dirName.indexOf(45);
        return index != -1 ? dirName.substring(index + 1) : "";
    }

    private void scanFileResourceFolder(@NotNull Map<ResourceType, ListMultimap<String, ResourceItem>> result2, @NotNull VirtualFile directory, ResourceFolderType folderType, String qualifiers, FolderConfiguration folderConfiguration) {
        if (result2 == null) {
            ResourceFolderRepository.$$$reportNull$$$0(14);
        }
        if (directory == null) {
            ResourceFolderRepository.$$$reportNull$$$0(15);
        }
        List resourceTypes = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
        assert (resourceTypes.size() >= 1) : folderType;
        ResourceType type = (ResourceType)resourceTypes.get(0);
        boolean idGeneratingFolder = FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType);
        for (VirtualFile file : directory.getChildren()) {
            boolean idGeneratingFile;
            if (!file.isValid() || file.isDirectory()) continue;
            FileType fileType = file.getFileType();
            boolean bl = idGeneratingFile = idGeneratingFolder && fileType == StdFileTypes.XML;
            if (!PsiProjectListener.isRelevantFileType(fileType) && folderType != ResourceFolderType.RAW) continue;
            this.scanFileResourceFile(result2, qualifiers, folderType, folderConfiguration, type, idGeneratingFile, file);
        }
    }

    private void scanFileResourceFileAsPsi(Map<ResourceType, ListMultimap<String, ResourceItem>> result2, ResourceFolderType folderType, FolderConfiguration folderConfiguration, ResourceType type, boolean idGenerating, PsiFile file) {
        PsiResourceItem item = PsiResourceItem.forFile(ResourceHelper.getResourceName(file), type, this.myNamespace, file, false);
        if (idGenerating) {
            ArrayList<PsiResourceItem> items2 = new ArrayList<PsiResourceItem>();
            items2.add(item);
            ResourceFolderRepository.addToResult(result2, item);
            this.addIds(result2, items2, file);
            PsiResourceFile resourceFile = new PsiResourceFile(file, items2, folderType, folderConfiguration);
            this.scanDataBinding(resourceFile, this.getModificationCount());
            this.sources.put(file.getVirtualFile(), resourceFile);
        } else {
            PsiResourceFile resourceFile = new PsiResourceFile(file, Collections.singletonList(item), folderType, folderConfiguration);
            this.sources.put(file.getVirtualFile(), resourceFile);
            ResourceFolderRepository.addToResult(result2, item);
        }
    }

    private void scanFileResourceFile(Map<ResourceType, ListMultimap<String, ResourceItem>> result2, String qualifiers, ResourceFolderType folderType, FolderConfiguration folderConfiguration, ResourceType type, boolean idGenerating, VirtualFile file) {
        ResourceFile resourceFile;
        if (idGenerating) {
            if (this.sources.containsKey(file)) {
                this.myInitialScanState.countCacheHit();
                return;
            }
            try {
                boolean isDensityBasedResource;
                resourceFile = this.myInitialScanState.loadFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
                if (resourceFile == null) {
                    this.myInitialScanState.queuePsiFileResourceScan(new PsiFileResourceQueueEntry(file, qualifiers, folderType, folderConfiguration));
                    return;
                }
                boolean bl = isDensityBasedResource = folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.MIPMAP;
                if (!isDensityBasedResource) {
                    this.myInitialScanState.countCacheMiss();
                }
                for (ResourceMergerItem item : resourceFile.getItems()) {
                    ResourceFolderRepository.addToResult(result2, (ResourceItem)item);
                    if (!isDensityBasedResource) continue;
                    item.setIgnoredFromDiskMerge(true);
                }
            }
            catch (MergingException e) {
                this.myInitialScanState.queuePsiFileResourceScan(new PsiFileResourceQueueEntry(file, qualifiers, folderType, folderConfiguration));
                return;
            }
        } else {
            String name = ResourceHelper.getResourceName(file);
            ResourceMergerItem item = new ResourceMergerItem(name, this.myNamespace, type, null, this.getLibraryName());
            ResourceFolderRepository.addToResult(result2, (ResourceItem)item);
            resourceFile = new ResourceFile(VfsUtilCore.virtualToIoFile((VirtualFile)file), item, folderConfiguration);
            item.setIgnoredFromDiskMerge(true);
        }
        this.sources.put(file, new ResourceFileAdapter(resourceFile));
    }

    @Override
    @Nullable
    public DataBindingInfo getDataBindingInfoForLayout(String layoutName) {
        List resourceItems = this.getResources(this.myNamespace, ResourceType.LAYOUT, layoutName);
        for (ResourceItem item : resourceItems) {
            PsiResourceFile source;
            if (!(item instanceof PsiResourceItem) || (source = ((PsiResourceItem)item).getSourceFile()) == null) continue;
            return source.getDataBindingInfo();
        }
        return null;
    }

    @Override
    @NotNull
    public Map<String, DataBindingInfo> getDataBindingResourceFiles() {
        long modificationCount = this.getModificationCount();
        if (this.myDataBindingResourceFilesModificationCount == modificationCount) {
            Map<String, DataBindingInfo> map2 = this.myDataBindingResourceFiles;
            if (map2 == null) {
                ResourceFolderRepository.$$$reportNull$$$0(16);
            }
            return map2;
        }
        this.myDataBindingResourceFilesModificationCount = modificationCount;
        Map<String, List<LayoutDataBindingInfo>> infoFilesByConfiguration = this.sources.values().stream().map(resourceFile -> resourceFile instanceof PsiResourceFile ? ((PsiResourceFile)resourceFile).getDataBindingInfo() : null).filter(Objects::nonNull).collect(Collectors.groupingBy(LayoutDataBindingInfo::getFileName));
        Map<String, DataBindingInfo> selected = infoFilesByConfiguration.entrySet().stream().flatMap(entry -> {
            if (((List)entry.getValue()).size() == 1) {
                LayoutDataBindingInfo info2 = (LayoutDataBindingInfo)((List)entry.getValue()).get(0);
                info2.setMergedInfo(null);
                return ((List)entry.getValue()).stream();
            }
            MergedDataBindingInfo mergedDataBindingInfo = new MergedDataBindingInfo((List)entry.getValue());
            ((List)entry.getValue()).forEach(info -> info.setMergedInfo(mergedDataBindingInfo));
            ArrayList<MergedDataBindingInfo> list = new ArrayList<MergedDataBindingInfo>(1 + ((List)entry.getValue()).size());
            list.add(mergedDataBindingInfo);
            list.addAll((Collection)entry.getValue());
            return list.stream();
        }).collect(Collectors.toMap(DataBindingInfo::getQualifiedName, kls -> kls));
        Map<String, DataBindingInfo> map3 = this.myDataBindingResourceFiles = Collections.unmodifiableMap(selected);
        if (map3 == null) {
            ResourceFolderRepository.$$$reportNull$$$0(17);
        }
        return map3;
    }

    @Nullable
    private static XmlTag getLayoutTag(PsiElement element) {
        if (!(element instanceof XmlFile)) {
            return null;
        }
        XmlTag rootTag = ((XmlFile)element).getRootTag();
        if (rootTag != null && "layout".equals(rootTag.getName())) {
            return rootTag;
        }
        return null;
    }

    @Nullable
    private static XmlTag getDataTag(XmlTag layoutTag) {
        return layoutTag.findFirstSubTag("data");
    }

    private static void scanDataBindingDataTag(PsiResourceFile resourceFile, @Nullable XmlTag dataTag, long modificationCount) {
        LayoutDataBindingInfo info = resourceFile.getDataBindingInfo();
        assert (info != null);
        ArrayList<PsiDataBindingResourceItem> items2 = new ArrayList<PsiDataBindingResourceItem>();
        if (dataTag == null) {
            info.replaceItems(items2, modificationCount);
            return;
        }
        HashSet<String> usedNames = new HashSet<String>();
        for (XmlTag tag : dataTag.findSubTags("variable")) {
            String name;
            String nameValue = tag.getAttributeValue("name");
            if (nameValue == null || !StringUtil.isNotEmpty((String)(name = DataBindingUtil.convertToJavaFieldName(StringUtil.unescapeXml((String)nameValue)))) || !usedNames.add(name)) continue;
            PsiDataBindingResourceItem item = new PsiDataBindingResourceItem(name, DataBindingResourceType.VARIABLE, tag, resourceFile);
            items2.add(item);
        }
        HashSet<String> usedAliases = new HashSet<String>();
        for (XmlTag tag : dataTag.findSubTags("import")) {
            int lastIndexOfDot;
            String typeValue = tag.getAttributeValue("type");
            if (typeValue == null) continue;
            String type = StringUtil.unescapeXml((String)typeValue);
            String aliasValue = tag.getAttributeValue("alias");
            String alias = null;
            if (aliasValue != null) {
                alias = StringUtil.unescapeXml((String)aliasValue);
            }
            if (alias == null && (lastIndexOfDot = type.lastIndexOf(46)) >= 0) {
                alias = type.substring(lastIndexOfDot + 1);
            }
            if (!StringUtil.isNotEmpty((String)alias) || !usedAliases.add(type)) continue;
            PsiDataBindingResourceItem item = new PsiDataBindingResourceItem(alias, DataBindingResourceType.IMPORT, tag, resourceFile);
            items2.add(item);
        }
        info.replaceItems(items2, modificationCount);
    }

    private void scanDataBinding(PsiResourceFile resourceFile, long modificationCount) {
        boolean hasClassNameAttr;
        String classPackage;
        String className;
        if (resourceFile.getFolderType() != ResourceFolderType.LAYOUT) {
            resourceFile.setDataBindingInfo(null);
            return;
        }
        XmlTag layout2 = ResourceFolderRepository.getLayoutTag((PsiElement)resourceFile.getPsiFile());
        if (layout2 == null) {
            resourceFile.setDataBindingInfo(null);
            return;
        }
        XmlTag dataTag = ResourceFolderRepository.getDataTag(layout2);
        String modulePackage = MergedManifest.get(this.myFacet).getPackage();
        String classAttrValue = null;
        if (dataTag != null && (classAttrValue = dataTag.getAttributeValue("class")) != null) {
            classAttrValue = StringUtil.unescapeXml((String)classAttrValue);
        }
        if (StringUtil.isEmpty(classAttrValue)) {
            className = DataBindingUtil.convertToJavaClassName(resourceFile.getName()) + "Binding";
            classPackage = modulePackage + ".databinding";
            hasClassNameAttr = false;
        } else {
            hasClassNameAttr = true;
            int firstDotIndex = classAttrValue.indexOf(46);
            if (firstDotIndex < 0) {
                classPackage = modulePackage + ".databinding";
                className = classAttrValue;
            } else {
                int lastDotIndex = classAttrValue.lastIndexOf(46);
                classPackage = firstDotIndex == 0 ? modulePackage + classAttrValue.substring(0, lastDotIndex) : classAttrValue.substring(0, lastDotIndex);
                className = classAttrValue.substring(lastDotIndex + 1);
            }
        }
        if (resourceFile.getDataBindingInfo() == null) {
            resourceFile.setDataBindingInfo(new LayoutDataBindingInfo(this.myFacet, resourceFile, className, classPackage, hasClassNameAttr));
        } else {
            resourceFile.getDataBindingInfo().update(className, classPackage, hasClassNameAttr, modificationCount);
        }
        ResourceFolderRepository.scanDataBindingDataTag(resourceFile, dataTag, modificationCount);
    }

    @NotNull
    @GuardedBy(value="AbstractResourceRepository.ITEM_MAP_LOCK")
    protected ResourceTable getFullTable() {
        ResourceTable resourceTable = this.myFullTable;
        if (resourceTable == null) {
            ResourceFolderRepository.$$$reportNull$$$0(18);
        }
        return resourceTable;
    }

    @Nullable
    @Contract(value="_, _, true -> !null")
    @GuardedBy(value="AbstractResourceRepository.ITEM_MAP_LOCK")
    protected ListMultimap<String, ResourceItem> getMap(@NotNull ResourceNamespace namespace, @NotNull ResourceType type, boolean create2) {
        ListMultimap multimap;
        if (namespace == null) {
            ResourceFolderRepository.$$$reportNull$$$0(19);
        }
        if (type == null) {
            ResourceFolderRepository.$$$reportNull$$$0(20);
        }
        if ((multimap = (ListMultimap)this.myFullTable.get((Object)namespace, (Object)type)) == null && create2) {
            multimap = LinkedListMultimap.create();
            this.myFullTable.put((Object)namespace, (Object)type, (Object)multimap);
        }
        return multimap;
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        ResourceNamespace resourceNamespace = this.myNamespace;
        if (resourceNamespace == null) {
            ResourceFolderRepository.$$$reportNull$$$0(21);
        }
        return resourceNamespace;
    }

    private void addIds(Map<ResourceType, ListMultimap<String, ResourceItem>> result2, List<PsiResourceItem> items2, PsiFile file) {
        this.addIds(result2, items2, (PsiElement)file, false);
    }

    private void addIds(Map<ResourceType, ListMultimap<String, ResourceItem>> result2, List<PsiResourceItem> items2, PsiElement element, boolean calledFromPsiListener) {
        HashMap<String, XmlTag> pendingResourceIds = new HashMap<String, XmlTag>();
        Collection xmlTags = PsiTreeUtil.findChildrenOfType((PsiElement)element, XmlTag.class);
        if (element instanceof XmlTag) {
            this.addId(result2, items2, (XmlTag)element, pendingResourceIds, calledFromPsiListener);
        }
        if (!xmlTags.isEmpty()) {
            for (XmlTag xmlTag : xmlTags) {
                this.addId(result2, items2, xmlTag, pendingResourceIds, calledFromPsiListener);
            }
        }
        if (!pendingResourceIds.isEmpty()) {
            for (Map.Entry entry : pendingResourceIds.entrySet()) {
                String id = (String)entry.getKey();
                PsiResourceItem item = PsiResourceItem.forXmlTag(id, ResourceType.ID, this.myNamespace, (XmlTag)entry.getValue(), calledFromPsiListener);
                items2.add(item);
                ResourceFolderRepository.addToResult(result2, item);
            }
        }
    }

    private void addId(Map<ResourceType, ListMultimap<String, ResourceItem>> result2, List<PsiResourceItem> items2, XmlTag tag, Map<String, XmlTag> pendingResourceIds, boolean calledFromPsiListener) {
        assert (tag.isValid());
        ListMultimap<String, ResourceItem> idMultimap = result2.get(ResourceType.ID);
        for (XmlAttribute attribute : tag.getAttributes()) {
            String value2;
            if (!"http://schemas.android.com/apk/res/android".equals(attribute.getNamespace()) || (value2 = attribute.getValue()) == null || !value2.startsWith("@+id/") || "id".equals(attribute.getLocalName())) continue;
            String id = value2.substring("@+id/".length());
            if (idMultimap == null || idMultimap.containsKey((Object)id) || pendingResourceIds.containsKey(id)) continue;
            pendingResourceIds.put(id, tag);
        }
        String id = tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android");
        if (id != null) {
            if (id.startsWith("@id/")) {
                if (!pendingResourceIds.containsKey(id = id.substring("@id/".length()))) {
                    return;
                }
            } else if (id.startsWith("@+id/")) {
                id = id.substring("@+id/".length());
            } else {
                return;
            }
            if (StringUtil.isEmpty((String)id)) {
                return;
            }
            pendingResourceIds.remove(id);
            PsiResourceItem item = PsiResourceItem.forXmlTag(id, ResourceType.ID, this.myNamespace, tag, calledFromPsiListener);
            items2.add(item);
            ResourceFolderRepository.addToResult(result2, item);
        }
    }

    private void scanValueResFolder(Map<ResourceType, ListMultimap<String, ResourceItem>> result2, @NotNull VirtualFile directory, String qualifiers, FolderConfiguration folderConfiguration) {
        if (directory == null) {
            ResourceFolderRepository.$$$reportNull$$$0(22);
        }
        assert (directory.getName().startsWith("values"));
        for (VirtualFile file : directory.getChildren()) {
            if (!file.isValid() || file.isDirectory()) continue;
            this.scanValueFile(result2, qualifiers, file, folderConfiguration);
        }
    }

    private boolean scanValueFileAsPsi(Map<ResourceType, ListMultimap<String, ResourceItem>> result2, PsiFile file, FolderConfiguration folderConfiguration) {
        boolean added = false;
        FileType fileType = file.getFileType();
        if (fileType == StdFileTypes.XML) {
            XmlFile xmlFile = (XmlFile)file;
            assert (xmlFile.isValid());
            XmlDocument document = xmlFile.getDocument();
            if (document != null) {
                XmlTag root = document.getRootTag();
                if (root == null) {
                    return false;
                }
                if (!root.getName().equals("resources")) {
                    return false;
                }
                XmlTag[] subTags = root.getSubTags();
                ArrayList<PsiResourceItem> items2 = new ArrayList<PsiResourceItem>(subTags.length);
                for (XmlTag tag : subTags) {
                    XmlTag[] attrs;
                    ResourceType type;
                    String name = tag.getAttributeValue("name");
                    if (StringUtil.isEmpty((String)name) || (type = AndroidResourceUtil.getResourceTypeForResourceTag(tag)) == null) continue;
                    PsiResourceItem item = PsiResourceItem.forXmlTag(name, type, this.myNamespace, tag, false);
                    ResourceFolderRepository.addToResult(result2, item);
                    items2.add(item);
                    added = true;
                    if (type != ResourceType.STYLEABLE || (attrs = tag.getSubTags()).length <= 0) continue;
                    for (XmlTag child : attrs) {
                        String attrName = child.getAttributeValue("name");
                        if (StringUtil.isEmpty((String)attrName) || attrName.startsWith("android:") || child.getAttribute("format") == null && child.getSubTags().length <= 0) continue;
                        PsiResourceItem attrItem = PsiResourceItem.forXmlTag(attrName, ResourceType.ATTR, this.myNamespace, child, false);
                        items2.add(attrItem);
                        ResourceFolderRepository.addToResult(result2, attrItem);
                    }
                }
                PsiResourceFile resourceFile = new PsiResourceFile(file, items2, ResourceFolderType.VALUES, folderConfiguration);
                this.sources.put(file.getVirtualFile(), resourceFile);
            }
        }
        return added;
    }

    private void scanValueFile(Map<ResourceType, ListMultimap<String, ResourceItem>> result2, String qualifiers, VirtualFile virtualFile, FolderConfiguration folderConfiguration) {
        FileType fileType = virtualFile.getFileType();
        if (fileType == StdFileTypes.XML) {
            if (this.sources.containsKey(virtualFile)) {
                this.myInitialScanState.countCacheHit();
                return;
            }
            File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
            try {
                ResourceFile resourceFile = this.myInitialScanState.loadFile(file);
                if (resourceFile == null) {
                    this.myInitialScanState.queuePsiValueResourceScan(new PsiValueResourceQueueEntry(virtualFile, qualifiers, folderConfiguration));
                    return;
                }
                for (ResourceItem item : resourceFile.getItems()) {
                    ResourceFolderRepository.addToResult(result2, item);
                }
                this.myInitialScanState.countCacheMiss();
                this.sources.put(virtualFile, new ResourceFileAdapter(resourceFile));
            }
            catch (MergingException e) {
                this.myInitialScanState.queuePsiValueResourceScan(new PsiValueResourceQueueEntry(virtualFile, qualifiers, folderConfiguration));
            }
        }
    }

    private boolean convertToPsiIfNeeded(@NotNull PsiFile psiFile, ResourceFolderType folderType) {
        ResourceItemSource<? extends ResourceItem> resFile;
        if (psiFile == null) {
            ResourceFolderRepository.$$$reportNull$$$0(23);
        }
        if ((resFile = this.sources.get(psiFile.getVirtualFile())) instanceof PsiResourceFile) {
            return false;
        }
        this.rescan(psiFile, folderType);
        return true;
    }

    private boolean isResourceFolder(@Nullable PsiElement parent) {
        PsiDirectory directory;
        PsiDirectory parentDirectory;
        if (parent instanceof PsiDirectory && (parentDirectory = (directory = (PsiDirectory)parent).getParentDirectory()) != null) {
            VirtualFile dir = parentDirectory.getVirtualFile();
            return dir.equals(this.myResourceDir);
        }
        return false;
    }

    private boolean isResourceFile(PsiFile psiFile) {
        return this.isResourceFolder((PsiElement)psiFile.getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isScanPending(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            ResourceFolderRepository.$$$reportNull$$$0(24);
        }
        Object object = this.SCAN_LOCK;
        synchronized (object) {
            return this.myPendingScans != null && this.myPendingScans.contains(psiFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rescan(@NotNull PsiFile psiFile, @NotNull ResourceFolderType folderType) {
        if (psiFile == null) {
            ResourceFolderRepository.$$$reportNull$$$0(25);
        }
        if (folderType == null) {
            ResourceFolderRepository.$$$reportNull$$$0(26);
        }
        Object object = this.SCAN_LOCK;
        synchronized (object) {
            if (this.isScanPending(psiFile)) {
                return;
            }
            if (this.myPendingScans == null) {
                this.myPendingScans = new HashSet<PsiFile>();
            }
            this.myPendingScans.add(psiFile);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!psiFile.isValid()) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                boolean rescan;
                Object object = this.SCAN_LOCK;
                synchronized (object) {
                    rescan = this.myPendingScans != null && this.myPendingScans.contains(psiFile);
                }
                if (rescan) {
                    this.rescanImmediately(psiFile, folderType);
                    object = this.SCAN_LOCK;
                    synchronized (object) {
                        this.myPendingScans.remove(psiFile);
                        if (this.myPendingScans.isEmpty()) {
                            this.myPendingScans = null;
                        }
                    }
                }
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() {
        ArrayList<PsiFile> files2;
        super.sync();
        Object object = this.SCAN_LOCK;
        synchronized (object) {
            if (this.myPendingScans == null || this.myPendingScans.isEmpty()) {
                return;
            }
            files2 = new ArrayList<PsiFile>(this.myPendingScans);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (PsiFile file : files2) {
                ResourceFolderType folderType;
                if (!file.isValid() || (folderType = ResourceHelper.getFolderType(file)) == null) continue;
                this.rescanImmediately(file, folderType);
            }
        });
        object = this.SCAN_LOCK;
        synchronized (object) {
            this.myPendingScans = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescanImmediately(@NotNull PsiFile psiFile, @NotNull ResourceFolderType folderType) {
        if (psiFile == null) {
            ResourceFolderRepository.$$$reportNull$$$0(27);
        }
        if (folderType == null) {
            ResourceFolderRepository.$$$reportNull$$$0(28);
        }
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            ApplicationManager.getApplication().runReadAction(() -> this.rescanImmediately(psiFile, folderType));
            return;
        }
        if (psiFile.getProject().isDisposed()) {
            return;
        }
        HashMap<ResourceType, ListMultimap<String, ResourceItem>> result2 = new HashMap<ResourceType, ListMultimap<String, ResourceItem>>();
        PsiFile file = psiFile;
        if (folderType == ResourceFolderType.VALUES) {
            ++ourFullRescans;
            ResourceItemSource<? extends ResourceItem> source = this.sources.get(file.getVirtualFile());
            boolean removed = false;
            if (source != null) {
                for (ResourceItem resourceItem : source) {
                    removed |= this.removeItems(source, resourceItem.getType(), resourceItem.getName(), false);
                }
                this.sources.remove(file.getVirtualFile());
            }
            file = this.ensureValid(file);
            boolean added = false;
            if (file != null) {
                FolderConfiguration folderConfiguration;
                PsiDirectory psiDirectory = file.getParent();
                assert (psiDirectory != null);
                PsiDirectory fileParent = psiFile.getParent();
                if (fileParent != null && (folderConfiguration = FolderConfiguration.getConfigForFolder((String)fileParent.getName())) != null) {
                    added = this.scanValueFileAsPsi(result2, file, folderConfiguration);
                }
            }
            if (added || removed) {
                this.setModificationCount(ourModificationCounter.incrementAndGet());
                this.invalidateParentCaches();
            }
        } else {
            ResourceItemSource<? extends ResourceItem> source = this.sources.get(file.getVirtualFile());
            if (source instanceof PsiResourceFile) {
                PsiResourceFile psiResourceFile = (PsiResourceFile)source;
                if (FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType) && file.getFileType() == StdFileTypes.XML) {
                    ++ourFullRescans;
                    HashSet<String> idsBefore = new HashSet<String>();
                    HashSet<String> hashSet = new HashSet<String>();
                    Object fileParent = ITEM_MAP_LOCK;
                    synchronized (fileParent) {
                        ListMultimap map2 = (ListMultimap)this.myFullTable.get((Object)this.myNamespace, (Object)ResourceType.ID);
                        if (map2 != null) {
                            ArrayList<PsiResourceItem> idItems = new ArrayList<PsiResourceItem>();
                            for (PsiResourceItem item : psiResourceFile) {
                                if (item.getType() != ResourceType.ID) continue;
                                idsBefore.add(item.getName());
                                idItems.add(item);
                            }
                            for (String id : idsBefore) {
                                List mapItems = map2.get((Object)id);
                                if (mapItems == null || mapItems.isEmpty()) continue;
                                ArrayList<ResourceItem> toDelete = new ArrayList<ResourceItem>(mapItems.size());
                                for (ResourceItem mapItem : mapItems) {
                                    if (!(mapItem instanceof PsiResourceItem) || ((PsiResourceItem)mapItem).getSourceFile() != psiResourceFile) continue;
                                    toDelete.add(mapItem);
                                }
                                for (ResourceItem delete : toDelete) {
                                    map2.remove((Object)delete.getName(), (Object)delete);
                                }
                            }
                            for (PsiResourceItem item : idItems) {
                                psiResourceFile.removeItem(item);
                            }
                        }
                    }
                    ArrayList<PsiResourceItem> idItems = new ArrayList<PsiResourceItem>();
                    file = this.ensureValid(file);
                    if (file != null) {
                        this.addIds(result2, idItems, file);
                    }
                    if (!idItems.isEmpty()) {
                        for (PsiResourceItem item : idItems) {
                            psiResourceFile.addItem(item);
                        }
                        for (PsiResourceItem item : idItems) {
                            hashSet.add(item.getName());
                        }
                    }
                    this.rescanJustDataBinding(psiFile);
                    this.invalidateParentCaches(this.myNamespace, ResourceType.ID);
                }
            } else {
                boolean switchingToPsi;
                boolean bl = switchingToPsi = source != null;
                if (switchingToPsi) {
                    this.removeItemsFromSource(source);
                }
                ++ourFullRescans;
                PsiDirectory parent = file.getParent();
                assert (parent != null);
                List list = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
                assert (list.size() >= 1) : folderType;
                ResourceType type = (ResourceType)list.get(0);
                boolean idGeneratingFolder = FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType);
                if ((file = this.ensureValid(file)) != null) {
                    FolderConfiguration folderConfiguration;
                    PsiDirectory fileParent = psiFile.getParent();
                    if (fileParent != null && (folderConfiguration = FolderConfiguration.getConfigForFolder((String)fileParent.getName())) != null) {
                        boolean idGeneratingFile = idGeneratingFolder && file.getFileType() == StdFileTypes.XML;
                        this.scanFileResourceFileAsPsi(result2, folderType, folderConfiguration, type, idGeneratingFile, file);
                    }
                    this.setModificationCount(ourModificationCounter.incrementAndGet());
                    this.invalidateParentCaches();
                }
            }
        }
        this.commitToRepository(result2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeItems(ResourceItemSource source, ResourceType type, String name, boolean removeFromFile) {
        boolean removed = false;
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            List mapItems;
            ListMultimap map2 = (ListMultimap)this.myFullTable.get((Object)this.myNamespace, (Object)type);
            if (map2 != null && (mapItems = map2.get((Object)name)) != null) {
                ListIterator iterator = mapItems.listIterator();
                while (iterator.hasNext()) {
                    ResourceItem item = (ResourceItem)iterator.next();
                    if (!source.isSourceOf(item)) continue;
                    iterator.remove();
                    if (removeFromFile) {
                        source.removeItem(item);
                    }
                    removed = true;
                }
            }
        }
        return removed;
    }

    private void bitmapUpdated() {
        AndroidTargetData targetData;
        IAndroidTarget target;
        Module module = this.myFacet.getModule();
        ConfigurationManager configurationManager = ConfigurationManager.findExistingInstance(module);
        if (configurationManager != null && (target = configurationManager.getTarget()) != null && (targetData = AndroidTargetData.getTargetData(target, module)) != null) {
            targetData.clearLayoutBitmapCache(module);
        }
    }

    @NotNull
    public PsiTreeChangeListener getPsiListener() {
        PsiListener psiListener = this.myListener;
        if (psiListener == null) {
            ResourceFolderRepository.$$$reportNull$$$0(29);
        }
        return psiListener;
    }

    private void rescanJustDataBinding(@NotNull PsiFile psiFile) {
        ResourceItemSource<? extends ResourceItem> resFile;
        if (psiFile == null) {
            ResourceFolderRepository.$$$reportNull$$$0(30);
        }
        if ((resFile = this.sources.get(psiFile.getVirtualFile())) != null) {
            PsiResourceFile resourceFile = (PsiResourceFile)resFile;
            if (!resourceFile.getPsiFile().isValid()) {
                resourceFile.setPsiFile(psiFile, resourceFile.getFolderConfiguration());
            }
            this.setModificationCount(ourModificationCounter.incrementAndGet());
            this.scanDataBinding(resourceFile, this.getModificationCount());
        }
    }

    @Nullable
    private ResourceItemSource<? extends ResourceItem> findSource(String dirName, String fileName) {
        String folderTypeName;
        String qualifiers;
        int index = dirName.indexOf(45);
        if (index == -1) {
            qualifiers = "";
            folderTypeName = dirName;
        } else {
            qualifiers = dirName.substring(index + 1);
            folderTypeName = dirName.substring(0, index);
        }
        ResourceFolderType folderType = ResourceFolderType.getTypeByName((String)folderTypeName);
        FolderConfiguration folderConfiguration = FolderConfiguration.getConfigForQualifierString((String)qualifiers);
        if (folderConfiguration == null) {
            folderConfiguration = new FolderConfiguration();
        }
        for (ResourceItemSource<? extends ResourceItem> source : this.sources.values()) {
            String sourceFilename;
            if (source instanceof ResourceFileAdapter) {
                sourceFilename = ((ResourceFileAdapter)source).getResourceFile().getFile().getName();
            } else {
                VirtualFile virtualFile = source.getVirtualFile();
                String string = sourceFilename = virtualFile == null ? null : virtualFile.getName();
            }
            if (folderType != source.getFolderType() || !fileName.equals(sourceFilename) || !folderConfiguration.equals((Object)source.getFolderConfiguration())) continue;
            return source;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeItemsFromSource(ResourceItemSource<? extends ResourceItem> source) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (ResourceItem resourceItem : source) {
                this.removeItems(source, resourceItem.getType(), resourceItem.getName(), false);
            }
        }
    }

    private static boolean isItemElement(XmlTag xmlTag) {
        String tag = xmlTag.getName();
        if (tag.equals("resources")) {
            return false;
        }
        return tag.equals("item") || ResourceType.fromXmlTagName((String)tag) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ResourceItem findValueResourceItem(XmlTag tag, @NotNull PsiFile file) {
        if (file == null) {
            ResourceFolderRepository.$$$reportNull$$$0(31);
        }
        if (!tag.isValid()) {
            ResourceItemSource<? extends ResourceItem> resFile = this.sources.get(file.getVirtualFile());
            if (resFile != null) {
                assert (resFile instanceof PsiResourceFile);
                PsiResourceFile resourceFile = (PsiResourceFile)resFile;
                for (ResourceItem item : resourceFile) {
                    PsiResourceItem pri = (PsiResourceItem)item;
                    if (!pri.wasTag(tag)) continue;
                    return item;
                }
            }
            return null;
        }
        String name = tag.getAttributeValue("name");
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return name != null ? this.findValueResourceItem(tag, file, name) : null;
        }
    }

    @Nullable
    private ResourceItem findValueResourceItem(XmlTag tag, @NotNull PsiFile file, String name) {
        if (file == null) {
            ResourceFolderRepository.$$$reportNull$$$0(32);
        }
        ResourceType type = AndroidResourceUtil.getResourceTypeForResourceTag(tag);
        return this.findResourceItem(type, file, name, tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ResourceItem findResourceItem(@Nullable ResourceType type, @NotNull PsiFile file, @Nullable String name, @Nullable XmlTag tag) {
        if (file == null) {
            ResourceFolderRepository.$$$reportNull$$$0(33);
        }
        if (type == null || name == null) {
            return null;
        }
        File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file.getVirtualFile());
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ListMultimap map2 = (ListMultimap)this.myFullTable.get((Object)this.myNamespace, (Object)type);
            if (map2 == null) {
                return null;
            }
            List items2 = map2.get((Object)name);
            assert (items2 != null);
            if (tag != null) {
                for (ResourceItem resourceItem : items2) {
                    PsiResourceItem psiResourceItem;
                    if (!(resourceItem instanceof PsiResourceItem) || !(psiResourceItem = (PsiResourceItem)resourceItem).wasTag(tag)) continue;
                    return resourceItem;
                }
            } else {
                for (ResourceItem item : items2) {
                    if (item instanceof PsiResourceItem) {
                        if (!Objects.equals(((PsiResourceItem)item).getPsiFile(), file)) continue;
                        return item;
                    }
                    ResourceFile resourceFile = (ResourceFile)((ResourceMergerItem)item).getSourceFile();
                    if (resourceFile == null || !FileUtil.filesEqual((File)resourceFile.getFile(), (File)ioFile)) continue;
                    return item;
                }
            }
        }
        return null;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " for " + this.myResourceDir + ": @" + Integer.toHexString(System.identityHashCode((Object)this));
    }

    @Override
    @NotNull
    protected Set<VirtualFile> computeResourceDirs() {
        Set<VirtualFile> set = Collections.singleton(this.myResourceDir);
        if (set == null) {
            ResourceFolderRepository.$$$reportNull$$$0(34);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean equalFilesItems(ResourceFolderRepository other) {
        File otherResourceDir;
        File myResourceDirFile = VfsUtilCore.virtualToIoFile((VirtualFile)this.myResourceDir);
        if (!FileUtil.filesEqual((File)myResourceDirFile, (File)(otherResourceDir = VfsUtilCore.virtualToIoFile((VirtualFile)other.myResourceDir)))) {
            return false;
        }
        if (this.sources.size() != other.sources.size()) {
            return false;
        }
        for (Map.Entry<VirtualFile, ResourceItemSource<? extends ResourceItem>> fileEntry : this.sources.entrySet()) {
            ResourceItemSource<? extends ResourceItem> otherResFile = other.sources.get(fileEntry.getKey());
            if (otherResFile == null) {
                return false;
            }
            if (Objects.equals(fileEntry.getValue().getVirtualFile(), otherResFile.getVirtualFile())) continue;
            return false;
        }
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ResourceTable otherResourceTable = other.getFullTable();
            if (this.myFullTable.size() != otherResourceTable.size()) {
                return false;
            }
            for (Table.Cell cell : this.myFullTable.cellSet()) {
                assert (cell.getColumnKey() != null);
                ListMultimap ownEntries = (ListMultimap)cell.getValue();
                ListMultimap otherEntries = (ListMultimap)otherResourceTable.get(cell.getRowKey(), cell.getColumnKey());
                if (otherEntries == null != (ownEntries == null)) {
                    return false;
                }
                if (ownEntries == null) continue;
                if (otherEntries.size() != ownEntries.size()) {
                    return false;
                }
                for (Map.Entry itemEntry : ownEntries.entries()) {
                    List otherItemsList = otherEntries.get(itemEntry.getKey());
                    if (otherItemsList == null) {
                        return false;
                    }
                    ResourceItem item = (ResourceItem)itemEntry.getValue();
                    if (ContainerUtil.exists((Iterable)otherItemsList, otherItem -> {
                        if (!item.getReferenceToSelf().equals((Object)otherItem.getReferenceToSelf())) {
                            return false;
                        }
                        if (Objects.equals(item.getSource(), otherItem.getSource())) {
                            ResourceValue resourceValue2 = item.getResourceValue();
                            ResourceValue otherResourceValue = otherItem.getResourceValue();
                            switch (item.getType()) {
                                case ID: {
                                    break;
                                }
                                case STRING: {
                                    if (resourceValue2 instanceof TextResourceValue && otherResourceValue instanceof TextResourceValue) {
                                        if (Objects.equals(resourceValue2.getValue(), otherResourceValue.getValue())) break;
                                        return false;
                                    }
                                }
                                default: {
                                    if (Objects.equals(resourceValue2, otherResourceValue)) break;
                                    return false;
                                }
                            }
                        }
                        return true;
                    })) continue;
                    return false;
                }
            }
        }
        return this.myDataBindingResourceFiles.keySet().equals(other.myDataBindingResourceFiles.keySet());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 29: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 29: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceDir";
                break;
            }
            case 2: 
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/ResourceFolderRepository";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 11: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resDir";
                break;
            }
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderType";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/ResourceFolderRepository";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacet";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceDir";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataBindingResourceFiles";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullTable";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiListener";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "computeResourceDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 29: 
            case 34: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPsiDirsForListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "scanQueuedPsiResources";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "ensureValid";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "scanResFolder";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "scanFileResourceFolder";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getMap";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "scanValueResFolder";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "convertToPsiIfNeeded";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isScanPending";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "rescan";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "rescanImmediately";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "rescanJustDataBinding";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findValueResourceItem";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findResourceItem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 29: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class PsiListener
    extends PsiTreeChangeAdapter {
        private boolean myIgnoreChildrenChanged;
        private boolean mySeenPrePropertyChange;

        private PsiListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            PsiFile psiFile;
            if (event == null) {
                PsiListener.$$$reportNull$$$0(0);
            }
            if ((psiFile = event.getFile()) == null) {
                PsiDirectory directory;
                PsiElement child = event.getChild();
                if (child instanceof PsiFile) {
                    psiFile = (PsiFile)child;
                    if (PsiProjectListener.isRelevantFile(psiFile)) {
                        this.addFile(psiFile);
                    }
                } else if (child instanceof PsiDirectory && ResourceFolderRepository.this.isResourceFolder((PsiElement)(directory = (PsiDirectory)child))) {
                    for (PsiFile file : directory.getFiles()) {
                        if (!PsiProjectListener.isRelevantFile(file)) continue;
                        this.addFile(file);
                    }
                }
            } else if (PsiProjectListener.isRelevantFile(psiFile)) {
                if (ResourceFolderRepository.this.isScanPending(psiFile)) {
                    return;
                }
                ResourceFolderType folderType = ResourceHelper.getFolderType(psiFile);
                if (folderType != null && ResourceFolderRepository.this.isResourceFile(psiFile)) {
                    PsiElement child = event.getChild();
                    PsiElement parent = event.getParent();
                    if (folderType == ResourceFolderType.VALUES) {
                        if (child instanceof XmlTag) {
                            XmlTag parentTag;
                            XmlTag tag = (XmlTag)child;
                            if (ResourceFolderRepository.isItemElement(tag)) {
                                if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                    return;
                                }
                                ResourceItemSource source = (ResourceItemSource)ResourceFolderRepository.this.sources.get(psiFile.getVirtualFile());
                                if (source != null) {
                                    assert (source instanceof PsiResourceFile);
                                    PsiResourceFile psiResourceFile = (PsiResourceFile)source;
                                    String name = tag.getAttributeValue("name");
                                    if (!StringUtil.isEmpty((String)name)) {
                                        ResourceType type = AndroidResourceUtil.getResourceTypeForResourceTag(tag);
                                        if (type == ResourceType.STYLEABLE) {
                                            ResourceFolderRepository.this.rescan(psiFile, folderType);
                                            return;
                                        }
                                        if (type != null) {
                                            PsiResourceItem item = PsiResourceItem.forXmlTag(name, type, ResourceFolderRepository.this.myNamespace, tag, true);
                                            Object object = AbstractResourceRepository.ITEM_MAP_LOCK;
                                            synchronized (object) {
                                                ResourceFolderRepository.this.getMap(ResourceFolderRepository.this.myNamespace, type, true).put((Object)name, (Object)item);
                                                psiResourceFile.addItem(item);
                                                ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                                ResourceFolderRepository.this.invalidateParentCaches(ResourceFolderRepository.this.myNamespace, type);
                                                return;
                                            }
                                        }
                                    }
                                }
                            }
                            if ((parentTag = tag.getParentTag()) != null && ResourceType.fromXmlTagName((String)parentTag.getName()) != null) {
                                if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                    return;
                                }
                                ResourceItem parentItem = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile);
                                if (parentItem instanceof PsiResourceItem) {
                                    if (((PsiResourceItem)parentItem).recomputeValue()) {
                                        ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                    }
                                    return;
                                }
                            }
                            ResourceFolderRepository.this.rescan(psiFile, folderType);
                        } else {
                            if (parent instanceof XmlText) {
                                XmlText text = (XmlText)parent;
                                this.handleValueXmlTextEdit((PsiElement)text.getParentTag(), psiFile);
                                return;
                            }
                            if (child instanceof XmlText) {
                                this.handleValueXmlTextEdit(parent, psiFile);
                                return;
                            }
                            if (parent instanceof XmlComment || child instanceof XmlComment) {
                                return;
                            }
                        }
                        ResourceFolderRepository.this.rescan(psiFile, folderType);
                    } else if (FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType) && psiFile.getFileType() == StdFileTypes.XML) {
                        if (parent instanceof XmlComment || child instanceof XmlComment) {
                            return;
                        }
                        if (parent instanceof XmlText || child instanceof XmlText && child.getText().trim().isEmpty()) {
                            return;
                        }
                        if (parent instanceof XmlElement && child instanceof XmlElement) {
                            if (child instanceof XmlTag) {
                                ResourceItemSource resFile;
                                if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                    return;
                                }
                                if (this.affectsDataBinding((XmlTag)child)) {
                                    ResourceFolderRepository.this.rescanJustDataBinding(psiFile);
                                }
                                ArrayList ids = new ArrayList();
                                HashMap result2 = new HashMap();
                                ResourceFolderRepository.this.addIds(result2, ids, child, true);
                                ResourceFolderRepository.this.commitToRepository(result2);
                                if (!ids.isEmpty() && (resFile = (ResourceItemSource)ResourceFolderRepository.this.sources.get(psiFile.getVirtualFile())) != null) {
                                    assert (resFile instanceof PsiResourceFile);
                                    PsiResourceFile psiResourceFile = (PsiResourceFile)resFile;
                                    for (PsiResourceItem id : ids) {
                                        psiResourceFile.addItem(id);
                                    }
                                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                    ResourceFolderRepository.this.invalidateParentCaches(ResourceFolderRepository.this.myNamespace, ResourceType.ID);
                                }
                                return;
                            }
                            if (child instanceof XmlAttribute || parent instanceof XmlAttribute) {
                                XmlAttribute attribute;
                                XmlAttribute xmlAttribute = attribute = parent instanceof XmlAttribute ? (XmlAttribute)parent : (XmlAttribute)child;
                                if ("id".equals(attribute.getLocalName()) && "http://schemas.android.com/apk/res/android".equals(attribute.getNamespace())) {
                                    ResourceFolderRepository.this.rescan(psiFile, folderType);
                                } else if (this.affectsDataBinding(attribute)) {
                                    ResourceFolderRepository.this.rescanJustDataBinding(psiFile);
                                }
                            }
                        }
                    }
                }
            }
            this.myIgnoreChildrenChanged = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            block31: {
                ResourceFolderType folderType;
                PsiFile psiFile;
                block33: {
                    PsiElement parent;
                    PsiElement child;
                    block34: {
                        XmlTag parentTag;
                        block32: {
                            String dirName;
                            ResourceFolderType folderType2;
                            if (event == null) {
                                PsiListener.$$$reportNull$$$0(1);
                            }
                            if ((psiFile = event.getFile()) != null) break block32;
                            PsiElement child2 = event.getChild();
                            if (child2 instanceof PsiFile) {
                                psiFile = (PsiFile)child2;
                                if (PsiProjectListener.isRelevantFile(psiFile)) {
                                    this.removeFile(psiFile);
                                }
                                break block31;
                            } else if (child2 instanceof PsiDirectory && (folderType2 = ResourceFolderType.getFolderType((String)(dirName = ((PsiDirectory)child2).getName()))) != null) {
                                PsiDirectory parentDirectory = ((PsiDirectory)child2).getParent();
                                if (parentDirectory == null) {
                                    return;
                                }
                                VirtualFile dir = parentDirectory.getVirtualFile();
                                if (!ModuleResourceManagers.getInstance(ResourceFolderRepository.this.myFacet).getLocalResourceManager().isResourceDir(dir)) {
                                    return;
                                }
                                int index = dirName.indexOf(45);
                                String qualifiers = index == -1 ? "" : dirName.substring(index + 1);
                                ArrayList sources = new ArrayList(ResourceFolderRepository.this.sources.values());
                                for (ResourceItemSource source : sources) {
                                    ResourceFolderType resFolderType = source.getFolderType();
                                    if (folderType2 != resFolderType || !qualifiers.equals(source.getFolderConfiguration().getQualifierString())) continue;
                                    this.removeFile(source);
                                }
                            }
                            break block31;
                        }
                        if (!PsiProjectListener.isRelevantFile(psiFile)) break block31;
                        if (ResourceFolderRepository.this.isScanPending(psiFile)) {
                            return;
                        }
                        folderType = ResourceHelper.getFolderType(psiFile);
                        if (folderType == null || !ResourceFolderRepository.this.isResourceFile(psiFile)) break block31;
                        child = event.getChild();
                        parent = event.getParent();
                        if (folderType != ResourceFolderType.VALUES) break block33;
                        if (!(child instanceof XmlTag)) break block34;
                        XmlTag tag = (XmlTag)child;
                        if (parent instanceof XmlTag && ResourceType.fromXmlTagName((String)(parentTag = (XmlTag)parent).getName()) != null) {
                            if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                return;
                            }
                            ResourceItem resourceItem = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile);
                            if (resourceItem instanceof PsiResourceItem) {
                                ResourceItem declareStyleable;
                                if (((PsiResourceItem)resourceItem).recomputeValue()) {
                                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                }
                                if (resourceItem.getType() == ResourceType.ATTR && (parentTag = parentTag.getParentTag()) != null && parentTag.getName().equals("declare-styleable") && (declareStyleable = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile)) instanceof PsiResourceItem && ((PsiResourceItem)declareStyleable).recomputeValue()) {
                                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                }
                                return;
                            }
                        }
                        if (ResourceFolderRepository.isItemElement(tag)) {
                            if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                return;
                            }
                            ResourceItemSource source = (ResourceItemSource)ResourceFolderRepository.this.sources.get(psiFile.getVirtualFile());
                            if (source != null) {
                                ResourceType type;
                                String name;
                                PsiResourceFile resourceFile = (PsiResourceFile)source;
                                if (!tag.isValid()) {
                                    ResourceItem item = ResourceFolderRepository.this.findValueResourceItem(tag, psiFile);
                                    if (item == null) {
                                        ResourceFolderRepository.this.rescan(psiFile, folderType);
                                        return;
                                    }
                                    name = item.getName();
                                } else {
                                    name = tag.getAttributeValue("name");
                                }
                                if (name != null && (type = AndroidResourceUtil.getResourceTypeForResourceTag(tag)) != null) {
                                    Object object = AbstractResourceRepository.ITEM_MAP_LOCK;
                                    synchronized (object) {
                                        ListMultimap map2 = (ListMultimap)ResourceFolderRepository.this.myFullTable.get((Object)ResourceFolderRepository.this.myNamespace, (Object)type);
                                        if (map2 == null) {
                                            return;
                                        }
                                        if (ResourceFolderRepository.this.removeItems(resourceFile, type, name, true)) {
                                            ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                            ResourceFolderRepository.this.invalidateParentCaches(ResourceFolderRepository.this.myNamespace, type);
                                        }
                                    }
                                }
                                return;
                            }
                        }
                        ResourceFolderRepository.this.rescan(psiFile, folderType);
                        break block31;
                    }
                    if (parent instanceof XmlText) {
                        XmlText text = (XmlText)parent;
                        this.handleValueXmlTextEdit((PsiElement)text.getParentTag(), psiFile);
                        break block31;
                    } else if (child instanceof XmlText) {
                        this.handleValueXmlTextEdit(parent, psiFile);
                        break block31;
                    } else {
                        if (parent instanceof XmlComment || child instanceof XmlComment) {
                            return;
                        }
                        ResourceFolderRepository.this.rescan(psiFile, folderType);
                    }
                    break block31;
                }
                if (FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType) && psiFile.getFileType() == StdFileTypes.XML) {
                    ResourceFolderRepository.this.rescan(psiFile, folderType);
                }
            }
            this.myIgnoreChildrenChanged = true;
        }

        private void removeFile(@Nullable ResourceItemSource<? extends ResourceItem> source) {
            if (source == null) {
                return;
            }
            for (Map.Entry entry : ResourceFolderRepository.this.sources.entrySet()) {
                if (source != entry.getValue()) continue;
                VirtualFile keyFile = (VirtualFile)entry.getKey();
                ResourceFolderRepository.this.sources.remove(keyFile);
                break;
            }
            ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
            ResourceFolderRepository.this.invalidateParentCaches();
            ResourceFolderRepository.this.removeItemsFromSource(source);
        }

        private void removeFile(@NotNull PsiFile psiFile) {
            if (psiFile == null) {
                PsiListener.$$$reportNull$$$0(2);
            }
            assert (!psiFile.isValid() || PsiProjectListener.isRelevantFile(psiFile));
            ResourceItemSource source = (ResourceItemSource)ResourceFolderRepository.this.sources.get(psiFile.getVirtualFile());
            if (source == null) {
                return;
            }
            ResourceFolderRepository.this.sources.remove(psiFile.getVirtualFile());
            ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
            ResourceFolderRepository.this.invalidateParentCaches();
            ResourceFolderType folderType = ResourceHelper.getFolderType(psiFile);
            if (folderType == ResourceFolderType.VALUES || folderType != null && FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType) && psiFile.getFileType() == StdFileTypes.XML) {
                ResourceFolderRepository.this.removeItemsFromSource(source);
            } else if (folderType != null) {
                FileType fileType;
                if (folderType == ResourceFolderType.DRAWABLE && (fileType = psiFile.getFileType()).isBinary() && fileType == FileTypeManager.getInstance().getFileTypeByExtension("png")) {
                    ResourceFolderRepository.this.bitmapUpdated();
                }
                List resourceTypes = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
                for (ResourceType type : resourceTypes) {
                    if (type == ResourceType.ID) continue;
                    String name = ResourceHelper.getResourceName(psiFile);
                    ResourceFolderRepository.this.removeItems(source, type, name, false);
                }
            }
        }

        private void addFile(PsiFile psiFile) {
            assert (PsiProjectListener.isRelevantFile(psiFile));
            ResourceFolderType folderType = ResourceHelper.getFolderType(psiFile);
            if (folderType != null && ResourceFolderRepository.this.isResourceFile(psiFile)) {
                ResourceFolderRepository.this.rescanImmediately(psiFile, folderType);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            PsiFile psiFile;
            if (event == null) {
                PsiListener.$$$reportNull$$$0(3);
            }
            if ((psiFile = event.getFile()) != null) {
                if (ResourceFolderRepository.this.isScanPending(psiFile)) {
                    return;
                }
                if (PsiProjectListener.isRelevantFile(psiFile)) {
                    PsiElement parent;
                    ResourceFolderType folderType = ResourceHelper.getFolderType(psiFile);
                    if (folderType != null && FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType) && psiFile.getFileType() == StdFileTypes.XML) {
                        PsiElement parent2 = event.getParent();
                        PsiElement child = event.getChild();
                        if (parent2 instanceof XmlText || child instanceof XmlText || parent2 instanceof XmlComment || child instanceof XmlComment) {
                            return;
                        }
                        if (parent2 instanceof XmlElement && child instanceof XmlElement) {
                            if (event.getOldChild() == event.getNewChild()) {
                                ResourceFolderRepository.this.rescan(psiFile, folderType);
                                return;
                            }
                            if (child instanceof XmlAttributeValue) {
                                assert (parent2 instanceof XmlAttribute) : parent2;
                                XmlAttribute attribute = (XmlAttribute)parent2;
                                if ("id".equals(attribute.getLocalName()) && "http://schemas.android.com/apk/res/android".equals(attribute.getNamespace())) {
                                    ResourceItemSource source = (ResourceItemSource)ResourceFolderRepository.this.sources.get(psiFile.getVirtualFile());
                                    if (source != null) {
                                        XmlTag xmlTag = attribute.getParent();
                                        PsiElement oldChild = event.getOldChild();
                                        PsiElement newChild = event.getNewChild();
                                        if (oldChild instanceof XmlAttributeValue && newChild instanceof XmlAttributeValue) {
                                            String newName2;
                                            XmlAttributeValue oldValue = (XmlAttributeValue)oldChild;
                                            XmlAttributeValue newValue = (XmlAttributeValue)newChild;
                                            String oldName = Lint.stripIdPrefix((String)oldValue.getValue());
                                            if (oldName.equals(newName2 = Lint.stripIdPrefix((String)newValue.getValue()))) {
                                                return;
                                            }
                                            if (source instanceof PsiResourceFile) {
                                                PsiResourceFile psiResourceFile = (PsiResourceFile)source;
                                                ResourceItem item2 = ResourceFolderRepository.this.findResourceItem(ResourceType.ID, psiFile, oldName, xmlTag);
                                                Object object = AbstractResourceRepository.ITEM_MAP_LOCK;
                                                synchronized (object) {
                                                    ListMultimap map2;
                                                    if (item2 != null && (map2 = (ListMultimap)ResourceFolderRepository.this.myFullTable.get((Object)ResourceFolderRepository.this.myNamespace, (Object)item2.getType())) != null) {
                                                        map2.remove((Object)oldName, (Object)item2);
                                                        if (psiResourceFile.isSourceOf(item2)) {
                                                            psiResourceFile.removeItem((PsiResourceItem)item2);
                                                        }
                                                        if (!StringUtil.isEmpty((String)newName2)) {
                                                            PsiResourceItem newItem = PsiResourceItem.forXmlTag(newName2, ResourceType.ID, ResourceFolderRepository.this.myNamespace, xmlTag, true);
                                                            map2.put((Object)newName2, (Object)newItem);
                                                            psiResourceFile.addItem(newItem);
                                                        }
                                                        ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                                        ResourceFolderRepository.this.invalidateParentCaches(ResourceFolderRepository.this.myNamespace, ResourceType.ID);
                                                        return;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    ResourceFolderRepository.this.rescan(psiFile, folderType);
                                }
                            } else if (parent2 instanceof XmlAttributeValue) {
                                PsiElement grandParent = parent2.getParent();
                                if (grandParent instanceof XmlProcessingInstruction) {
                                    return;
                                }
                                assert (grandParent instanceof XmlAttribute) : parent2;
                                XmlAttribute attribute = (XmlAttribute)grandParent;
                                if ("id".equals(attribute.getLocalName()) && "http://schemas.android.com/apk/res/android".equals(attribute.getNamespace())) {
                                    ResourceItemSource resFile = (ResourceItemSource)ResourceFolderRepository.this.sources.get(psiFile.getVirtualFile());
                                    if (resFile != null) {
                                        String newName3;
                                        XmlTag xmlTag = attribute.getParent();
                                        PsiElement oldChild = event.getOldChild();
                                        PsiElement newChild = event.getNewChild();
                                        String oldName = Lint.stripIdPrefix((String)oldChild.getText());
                                        if (oldName.equals(newName3 = Lint.stripIdPrefix((String)newChild.getText()))) {
                                            return;
                                        }
                                        if (resFile instanceof PsiResourceFile) {
                                            PsiResourceFile psiResourceFile = (PsiResourceFile)resFile;
                                            ResourceItem item = ResourceFolderRepository.this.findResourceItem(ResourceType.ID, psiFile, oldName, xmlTag);
                                            if (item != null) {
                                                Object item2 = AbstractResourceRepository.ITEM_MAP_LOCK;
                                                synchronized (item2) {
                                                    ListMultimap map3 = (ListMultimap)ResourceFolderRepository.this.myFullTable.get((Object)ResourceFolderRepository.this.myNamespace, (Object)item.getType());
                                                    if (map3 != null) {
                                                        map3.remove((Object)oldName, (Object)item);
                                                        if (psiResourceFile.isSourceOf(item)) {
                                                            psiResourceFile.removeItem((PsiResourceItem)item);
                                                        }
                                                        if (!StringUtil.isEmpty((String)newName3)) {
                                                            PsiResourceItem newItem = PsiResourceItem.forXmlTag(newName3, ResourceType.ID, ResourceFolderRepository.this.myNamespace, xmlTag, true);
                                                            map3.put((Object)newName3, (Object)newItem);
                                                            psiResourceFile.addItem(newItem);
                                                        }
                                                        ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                                        ResourceFolderRepository.this.invalidateParentCaches(ResourceFolderRepository.this.myNamespace, ResourceType.ID);
                                                        return;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    ResourceFolderRepository.this.rescan(psiFile, folderType);
                                } else if (this.affectsDataBinding(attribute)) {
                                    ResourceFolderRepository.this.rescanJustDataBinding(psiFile);
                                } else if (folderType != ResourceFolderType.VALUES) {
                                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                }
                            }
                            return;
                        }
                        ResourceFolderRepository.this.rescan(psiFile, folderType);
                    } else if (folderType == ResourceFolderType.VALUES) {
                        PsiElement parent3 = event.getParent();
                        if (parent3 instanceof XmlElement) {
                            if (parent3 instanceof XmlComment) {
                                return;
                            }
                            if (parent3 instanceof XmlTag) {
                                XmlTag parentTag = (XmlTag)parent3;
                                if (ResourceType.fromXmlTagName((String)parentTag.getName()) != null) {
                                    if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                        return;
                                    }
                                    ResourceItem resourceItem = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile);
                                    if (resourceItem instanceof PsiResourceItem) {
                                        if (((PsiResourceItem)resourceItem).recomputeValue()) {
                                            ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                        }
                                        return;
                                    }
                                }
                                if (parentTag.getName().equals("resources") && event.getOldChild() instanceof XmlText && event.getNewChild() instanceof XmlText) {
                                    return;
                                }
                            }
                            if (parent3 instanceof XmlText) {
                                XmlText text = (XmlText)parent3;
                                this.handleValueXmlTextEdit((PsiElement)text.getParentTag(), psiFile);
                                return;
                            }
                            if (parent3 instanceof XmlAttributeValue) {
                                PsiElement attribute = parent3.getParent();
                                if (attribute instanceof XmlProcessingInstruction) {
                                    return;
                                }
                                PsiElement tag = attribute.getParent();
                                assert (attribute instanceof XmlAttribute) : attribute;
                                XmlAttribute xmlAttribute = (XmlAttribute)attribute;
                                assert (tag instanceof XmlTag) : tag;
                                XmlTag xmlTag = (XmlTag)tag;
                                String attributeName = xmlAttribute.getName();
                                if (ResourceFolderRepository.isItemElement(xmlTag) && attributeName.equals("name")) {
                                    ResourceType type = AndroidResourceUtil.getResourceTypeForResourceTag(xmlTag);
                                    if (type != null) {
                                        String newName4;
                                        String oldName = event.getOldChild().getText();
                                        if (oldName.equals(newName4 = event.getNewChild().getText())) {
                                            return;
                                        }
                                        if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                            return;
                                        }
                                        ResourceItem item = ResourceFolderRepository.this.findResourceItem(type, psiFile, oldName, xmlTag);
                                        if (item != null) {
                                            ResourceItem style;
                                            XmlTag parentTag;
                                            Object psiResourceFile = AbstractResourceRepository.ITEM_MAP_LOCK;
                                            synchronized (psiResourceFile) {
                                                ListMultimap map4 = (ListMultimap)ResourceFolderRepository.this.myFullTable.get((Object)ResourceFolderRepository.this.myNamespace, (Object)item.getType());
                                                if (map4 != null) {
                                                    map4.remove((Object)oldName, (Object)item);
                                                    if (!StringUtil.isEmpty((String)newName4)) {
                                                        PsiResourceItem newItem = PsiResourceItem.forXmlTag(newName4, type, ResourceFolderRepository.this.myNamespace, xmlTag, true);
                                                        map4.put((Object)newName4, (Object)newItem);
                                                        ResourceItemSource resFile = (ResourceItemSource)ResourceFolderRepository.this.sources.get(psiFile.getVirtualFile());
                                                        if (resFile != null) {
                                                            PsiResourceFile resourceFile = (PsiResourceFile)resFile;
                                                            resourceFile.removeItem((PsiResourceItem)item);
                                                            resourceFile.addItem(newItem);
                                                        } else assert (false) : item;
                                                    }
                                                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                                    ResourceFolderRepository.this.invalidateParentCaches(ResourceFolderRepository.this.myNamespace, type);
                                                }
                                            }
                                            if (type == ResourceType.ATTR && (parentTag = xmlTag.getParentTag()) != null && parentTag.getName().equals(ResourceType.STYLEABLE.getName()) && (style = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile)) instanceof PsiResourceItem) {
                                                ((PsiResourceItem)style).recomputeValue();
                                            }
                                            return;
                                        }
                                    } else {
                                        XmlTag parentTag = xmlTag.getParentTag();
                                        if (parentTag != null && ResourceType.fromXmlTagName((String)parentTag.getName()) != null) {
                                            if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                                return;
                                            }
                                            ResourceItem resourceItem = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile);
                                            if (resourceItem instanceof PsiResourceItem) {
                                                if (((PsiResourceItem)resourceItem).recomputeValue()) {
                                                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                                                }
                                                return;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        ResourceFolderRepository.this.rescan(psiFile, folderType);
                    } else if (folderType == ResourceFolderType.COLOR) {
                        PsiElement parent4 = event.getParent();
                        if (parent4 instanceof XmlElement) {
                            PsiElement attribute;
                            if (parent4 instanceof XmlComment) {
                                return;
                            }
                            if (parent4 instanceof XmlAttributeValue && (attribute = parent4.getParent()) instanceof XmlProcessingInstruction) {
                                return;
                            }
                            ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                            return;
                        }
                    } else if (folderType != null && (parent = event.getParent()) instanceof XmlElement) {
                        if (parent instanceof XmlComment) {
                            return;
                        }
                        ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                    }
                }
            } else {
                PsiElement parent = event.getParent();
                if (ResourceFolderRepository.this.isResourceFolder(parent)) {
                    PsiFile newFile;
                    PsiFile oldFile;
                    PsiElement oldChild = event.getOldChild();
                    PsiElement newChild = event.getNewChild();
                    if (oldChild instanceof PsiFile && PsiProjectListener.isRelevantFile(oldFile = (PsiFile)oldChild)) {
                        this.removeFile(oldFile);
                    }
                    if (newChild instanceof PsiFile && PsiProjectListener.isRelevantFile(newFile = (PsiFile)newChild)) {
                        this.addFile(newFile);
                    }
                }
            }
            this.myIgnoreChildrenChanged = true;
        }

        private void handleValueXmlTextEdit(@Nullable PsiElement parent, @NotNull PsiFile psiFile) {
            XmlTag style;
            if (psiFile == null) {
                PsiListener.$$$reportNull$$$0(4);
            }
            if (!(parent instanceof XmlTag)) {
                return;
            }
            XmlTag parentTag = (XmlTag)parent;
            String parentTagName = parentTag.getName();
            if (parentTagName.equals("resources")) {
                return;
            }
            if (parentTagName.equals("item") && (style = parentTag.getParentTag()) != null && ResourceType.fromXmlTagName((String)style.getName()) != null) {
                boolean cleared;
                ResourceFolderType folderType = ResourceHelper.getFolderType(psiFile);
                if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                    return;
                }
                ResourceItem item = ResourceFolderRepository.this.findValueResourceItem(style, psiFile);
                if (item instanceof PsiResourceItem && (cleared = ((PsiResourceItem)item).recomputeValue())) {
                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                }
                return;
            }
            while (parentTag != null) {
                if (ResourceFolderRepository.isItemElement(parentTag)) {
                    boolean cleared;
                    ResourceFolderType folderType = ResourceHelper.getFolderType(psiFile);
                    if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                        return;
                    }
                    ResourceItem item = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile);
                    if (!(item instanceof PsiResourceItem) || !(cleared = ((PsiResourceItem)item).recomputeValue())) break;
                    ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                    break;
                }
                parentTag = parentTag.getParentTag();
            }
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                PsiListener.$$$reportNull$$$0(5);
            }
            PsiElement child = event.getChild();
            PsiFile psiFile = event.getFile();
            if (psiFile == null && child instanceof PsiFile) {
                boolean isResourceFolder;
                psiFile = (PsiFile)child;
                if (!PsiProjectListener.isRelevantFile(psiFile)) {
                    return;
                }
                String name = psiFile.getName();
                PsiElement oldParent = event.getOldParent();
                if (!(oldParent instanceof PsiDirectory)) {
                    this.addFile(psiFile);
                    return;
                }
                PsiDirectory oldParentDir = (PsiDirectory)oldParent;
                String oldDirName = oldParentDir.getName();
                ResourceFolderType oldFolderType = ResourceFolderType.getFolderType((String)oldDirName);
                ResourceFolderType newFolderType = ResourceHelper.getFolderType(psiFile);
                boolean wasResourceFolder = oldFolderType != null && ResourceFolderRepository.this.isResourceFolder((PsiElement)oldParentDir);
                boolean bl = isResourceFolder = newFolderType != null && ResourceFolderRepository.this.isResourceFile(psiFile);
                if (wasResourceFolder == isResourceFolder) {
                    if (!isResourceFolder) {
                        return;
                    }
                    ResourceItemSource source = ResourceFolderRepository.this.findSource(oldDirName, name);
                    if (source != null) {
                        if (oldFolderType != newFolderType) {
                            this.removeFile(source);
                            this.addFile(psiFile);
                        } else {
                            VirtualFile vFile = source.getVirtualFile();
                            if (!(source instanceof PsiResourceFile) || vFile == null) {
                                this.removeFile(source);
                                this.addFile(psiFile);
                                return;
                            }
                            ResourceFolderRepository.this.sources.remove(vFile);
                            ResourceFolderRepository.this.sources.put(psiFile.getVirtualFile(), source);
                            PsiResourceFile psiResourceFile = (PsiResourceFile)source;
                            PsiDirectory newParent = psiFile.getParent();
                            assert (newParent != null);
                            String newDirName = newParent.getName();
                            FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)newDirName);
                            if (config == null) {
                                config = new FolderConfiguration();
                            }
                            psiResourceFile.setPsiFile(psiFile, config);
                            ResourceFolderRepository.this.setModificationCount(LocalResourceRepository.ourModificationCounter.incrementAndGet());
                            for (ResourceItem item : psiResourceFile) {
                                if (!(item instanceof PsiResourceItem)) continue;
                                ((PsiResourceItem)item).recomputeValue();
                            }
                            ResourceFolderRepository.this.invalidateParentCaches();
                        }
                    } else {
                        this.addFile(psiFile);
                    }
                } else if (isResourceFolder) {
                    this.addFile(psiFile);
                } else {
                    assert (wasResourceFolder);
                    String dirName = oldParentDir.getName();
                    ResourceItemSource resourceFile = ResourceFolderRepository.this.findSource(dirName, name);
                    if (resourceFile != null) {
                        this.removeFile(resourceFile);
                    }
                }
            }
            this.myIgnoreChildrenChanged = true;
        }

        public final void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                PsiListener.$$$reportNull$$$0(6);
            }
            this.myIgnoreChildrenChanged = false;
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                PsiListener.$$$reportNull$$$0(7);
            }
            PsiElement parent = event.getParent();
            if (this.myIgnoreChildrenChanged ? parent != event.getChild() : event instanceof PsiTreeChangeEventImpl && ((PsiTreeChangeEventImpl)event).isGenericChange()) {
                return;
            }
            if (parent != null && parent.getChildren().length == 1 && parent.getChildren()[0] instanceof PsiWhiteSpace) {
                return;
            }
            PsiFile psiFile = event.getFile();
            if (psiFile != null && PsiProjectListener.isRelevantFile(psiFile)) {
                ResourceFolderType folderType;
                VirtualFile file = psiFile.getVirtualFile();
                if (file != null && (folderType = ResourceHelper.getFolderType(psiFile)) != null && ResourceFolderRepository.this.isResourceFile(psiFile)) {
                    ResourceFolderRepository.this.rescan(psiFile, folderType);
                }
            } else {
                Throwable throwable = new Throwable();
                throwable.fillInStackTrace();
                LOG.debug("Received unexpected childrenChanged event for inter-file operations", throwable);
            }
        }

        public final void beforePropertyChange(@NotNull PsiTreeChangeEvent event) {
            PsiFile psiFile;
            PsiElement child;
            if (event == null) {
                PsiListener.$$$reportNull$$$0(8);
            }
            if ("fileName" == event.getPropertyName() && (child = event.getChild()) instanceof PsiFile && PsiProjectListener.isRelevantFile(psiFile = (PsiFile)child) && ResourceFolderRepository.this.isResourceFolder(event.getParent())) {
                this.removeFile(psiFile);
            }
            this.mySeenPrePropertyChange = true;
        }

        public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
            PsiFile psiFile;
            PsiElement child;
            if (event == null) {
                PsiListener.$$$reportNull$$$0(9);
            }
            if ("fileName" == event.getPropertyName() && ResourceFolderRepository.this.isResourceFolder(event.getParent()) && (child = event.getElement()) instanceof PsiFile && PsiProjectListener.isRelevantFile(psiFile = (PsiFile)child) && ResourceFolderRepository.this.isResourceFolder(event.getParent())) {
                Object oldValue;
                if (!this.mySeenPrePropertyChange && (oldValue = event.getOldValue()) instanceof String) {
                    PsiDirectory parent = psiFile.getParent();
                    String oldName = (String)oldValue;
                    if (parent != null && parent.findFile(oldName) == null) {
                        this.removeFile(ResourceFolderRepository.this.findSource(parent.getName(), oldName));
                    }
                }
                this.addFile(psiFile);
            }
            this.mySeenPrePropertyChange = false;
        }

        private boolean affectsDataBinding(XmlAttribute attribute) {
            return ArrayUtil.contains((String)attribute.getLocalName(), (String[])SdkConstants.ATTRS_DATA_BINDING) && ArrayUtil.contains((String)attribute.getParent().getLocalName(), (String[])SdkConstants.TAGS_DATA_BINDING);
        }

        private boolean affectsDataBinding(XmlTag xmlTag) {
            return ArrayUtil.contains((String)xmlTag.getLocalName(), (String[])SdkConstants.TAGS_DATA_BINDING);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/res/ResourceFolderRepository$PsiListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeFile";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childReplaced";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleValueXmlTextEdit";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childMoved";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeChildrenChange";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childrenChanged";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforePropertyChange";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PsiValueResourceQueueEntry {
        public final VirtualFile file;
        public final String qualifiers;
        public final FolderConfiguration folderConfiguration;

        PsiValueResourceQueueEntry(VirtualFile file, String qualifiers, FolderConfiguration folderConfiguration) {
            this.file = file;
            this.qualifiers = qualifiers;
            this.folderConfiguration = folderConfiguration;
        }
    }

    private static class PsiFileResourceQueueEntry {
        public final VirtualFile file;
        public final String qualifiers;
        public final ResourceFolderType folderType;
        public final FolderConfiguration folderConfiguration;

        PsiFileResourceQueueEntry(VirtualFile file, String qualifiers, ResourceFolderType folderType, FolderConfiguration folderConfiguration) {
            this.file = file;
            this.qualifiers = qualifiers;
            this.folderType = folderType;
            this.folderConfiguration = folderConfiguration;
        }
    }

    static class InitialScanState {
        int numXml;
        int numXmlReparsed;
        final ResourceMerger myResourceMerger;
        final ResourceSet myResourceSet;
        final ILogger myILogger;
        final File myResourceDir;
        final Collection<PsiFileResourceQueueEntry> myPsiFileResourceQueue = new ArrayList<PsiFileResourceQueueEntry>();
        final Collection<PsiValueResourceQueueEntry> myPsiValueResourceQueue = new ArrayList<PsiValueResourceQueueEntry>();

        InitialScanState(ResourceMerger merger, File resourceDir) {
            this.myResourceMerger = merger;
            assert (this.myResourceMerger.getDataSets().size() == 1);
            this.myResourceSet = (ResourceSet)this.myResourceMerger.getDataSets().get(0);
            this.myResourceSet.setShouldParseResourceIds(true);
            this.myResourceSet.setDontNormalizeQualifiers(true);
            this.myResourceSet.setTrackSourcePositions(false);
            this.myILogger = new LogWrapper(LOG).alwaysLogAsDebug(true).allowVerbose(false);
            this.myResourceDir = resourceDir;
        }

        public void countCacheHit() {
            ++this.numXml;
        }

        public void countCacheMiss() {
            ++this.numXml;
            ++this.numXmlReparsed;
        }

        @Nullable
        ResourceFile loadFile(File file) throws MergingException {
            return (ResourceFile)this.myResourceSet.loadFile(this.myResourceDir, file, this.myILogger);
        }

        public void queuePsiFileResourceScan(PsiFileResourceQueueEntry data) {
            this.myPsiFileResourceQueue.add(data);
        }

        public void queuePsiValueResourceScan(PsiValueResourceQueueEntry data) {
            this.myPsiValueResourceQueue.add(data);
        }
    }
}

