/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceClassGenerator;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceClassRegistry
implements ProjectComponent {
    private final Map<ResourceRepository, ResourceClassGenerator> myGeneratorMap = new HashMap<ResourceRepository, ResourceClassGenerator>();
    private Set<String> myPackages;

    public void addLibrary(@NotNull ResourceRepository repo, @NotNull ResourceIdManager idManager, @Nullable String aarPackageName, @NotNull ResourceNamespace namespace) {
        if (repo == null) {
            ResourceClassRegistry.$$$reportNull$$$0(0);
        }
        if (idManager == null) {
            ResourceClassRegistry.$$$reportNull$$$0(1);
        }
        if (namespace == null) {
            ResourceClassRegistry.$$$reportNull$$$0(2);
        }
        if (StringUtil.isNotEmpty((String)aarPackageName)) {
            if (this.myPackages == null) {
                this.myPackages = new HashSet<String>();
            }
            this.myPackages.add(aarPackageName);
            if (!this.myGeneratorMap.containsKey(repo)) {
                ResourceClassGenerator generator = ResourceClassGenerator.create(idManager, repo, namespace);
                this.myGeneratorMap.put(repo, generator);
            }
        }
    }

    @Nullable
    public byte[] findClassDefinition(@NotNull String className, @NotNull ResourceRepositoryManager repositoryManager) {
        int index;
        if (className == null) {
            ResourceClassRegistry.$$$reportNull$$$0(3);
        }
        if (repositoryManager == null) {
            ResourceClassRegistry.$$$reportNull$$$0(4);
        }
        if ((index = className.lastIndexOf(46)) > 1 && className.charAt(index + 1) == 'R' && (index == className.length() - 2 || className.charAt(index + 2) == '$')) {
            ResourceNamespace namespace;
            List<LocalResourceRepository> repositories;
            ResourceClassGenerator generator;
            String pkg = className.substring(0, index);
            if (this.myPackages != null && this.myPackages.contains(pkg) && (generator = this.findClassGenerator(repositories = repositoryManager.getAppResourcesForNamespace(namespace = ResourceNamespace.fromPackageName((String)pkg)), className)) != null) {
                return generator.generate(className);
            }
        }
        return null;
    }

    @Nullable
    private ResourceClassGenerator findClassGenerator(@NotNull List<LocalResourceRepository> repositories, @NotNull String className) {
        if (repositories == null) {
            ResourceClassRegistry.$$$reportNull$$$0(5);
        }
        if (className == null) {
            ResourceClassRegistry.$$$reportNull$$$0(6);
        }
        ResourceClassGenerator foundGenerator = null;
        for (int i2 = 0; i2 < repositories.size(); ++i2) {
            ResourceClassGenerator generator = this.myGeneratorMap.get((Object)repositories.get(i2));
            if (generator == null) continue;
            if (foundGenerator == null) {
                foundGenerator = generator;
                continue;
            }
            throw new NoClassDefFoundError(className + " class could not be loaded because of package name collision between libraries");
        }
        return foundGenerator;
    }

    public void clearCache() {
        this.myGeneratorMap.clear();
    }

    @NotNull
    public static ResourceClassRegistry get(@NotNull Project project) {
        if (project == null) {
            ResourceClassRegistry.$$$reportNull$$$0(7);
        }
        ResourceClassRegistry resourceClassRegistry = (ResourceClassRegistry)project.getComponent(ResourceClassRegistry.class);
        if (resourceClassRegistry == null) {
            ResourceClassRegistry.$$$reportNull$$$0(8);
        }
        return resourceClassRegistry;
    }

    @NotNull
    public String getComponentName() {
        String string = ResourceClassRegistry.class.getName();
        if (string == null) {
            ResourceClassRegistry.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    Collection<String> getPackages() {
        Set<Object> set = this.myPackages == null ? Collections.emptySet() : this.myPackages;
        if (set == null) {
            ResourceClassRegistry.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    Map<ResourceRepository, ResourceClassGenerator> getGeneratorMap() {
        Map<ResourceRepository, ResourceClassGenerator> map2 = this.myGeneratorMap;
        if (map2 == null) {
            ResourceClassRegistry.$$$reportNull$$$0(11);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/ResourceClassRegistry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/ResourceClassRegistry";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackages";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratorMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addLibrary";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findClassDefinition";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findClassGenerator";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

