/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.fileTypes.FontFileType;
import com.android.tools.idea.gradle.project.sync.GradleFiles;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.SampleDataListener;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Consumer;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiProjectListener
extends AbstractProjectComponent
implements PsiTreeChangeListener {
    private final ResourceFolderRegistry myRegistry;
    private SampleDataListener mySampleDataListener;

    @NotNull
    public static PsiProjectListener getInstance(@NotNull Project project) {
        if (project == null) {
            PsiProjectListener.$$$reportNull$$$0(0);
        }
        PsiProjectListener psiProjectListener = (PsiProjectListener)((Object)project.getComponent(PsiProjectListener.class));
        if (psiProjectListener == null) {
            PsiProjectListener.$$$reportNull$$$0(1);
        }
        return psiProjectListener;
    }

    public PsiProjectListener(@NotNull Project project) {
        if (project == null) {
            PsiProjectListener.$$$reportNull$$$0(2);
        }
        super(project);
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)this);
        this.myRegistry = ResourceFolderRegistry.getInstance(project);
    }

    void setSampleDataListener(SampleDataListener sampleDataListener) {
        assert (this.mySampleDataListener == null) : "SampleDataListener already set!";
        this.mySampleDataListener = sampleDataListener;
    }

    static boolean isRelevantFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            PsiProjectListener.$$$reportNull$$$0(3);
        }
        if (fileType == StdFileTypes.JAVA) {
            return false;
        }
        if (fileType == StdFileTypes.XML) {
            return true;
        }
        if (fileType.isBinary()) {
            return fileType == ImageFileTypeManager.getInstance().getImageFileType() || fileType == FontFileType.INSTANCE;
        }
        return false;
    }

    static boolean isRelevantFile(@NotNull VirtualFile file) {
        String parentName;
        FileType fileType;
        if (file == null) {
            PsiProjectListener.$$$reportNull$$$0(4);
        }
        if ((fileType = file.getFileType()) == StdFileTypes.JAVA) {
            return false;
        }
        if (PsiProjectListener.isRelevantFileType(fileType)) {
            return true;
        }
        VirtualFile parent = file.getParent();
        return parent != null && (parentName = parent.getName()).startsWith("raw");
    }

    static boolean isRelevantFile(@NotNull PsiFile file) {
        String parentName;
        FileType fileType;
        if (file == null) {
            PsiProjectListener.$$$reportNull$$$0(5);
        }
        if ((fileType = file.getFileType()) == StdFileTypes.JAVA) {
            return false;
        }
        if (PsiProjectListener.isRelevantFileType(fileType)) {
            return true;
        }
        PsiDirectory parent = file.getParent();
        return parent != null && (parentName = parent.getName()).startsWith("raw");
    }

    private void dispatch(@Nullable VirtualFile file, @NotNull Consumer<PsiTreeChangeListener> invokeCallback) {
        if (invokeCallback == null) {
            PsiProjectListener.$$$reportNull$$$0(6);
        }
        if (file == null) {
            return;
        }
        while (file != null) {
            ResourceFolderRegistry.CachedRepositories cached = this.myRegistry.getCached(file);
            if (cached != null) {
                if (cached.namespaced != null) {
                    invokeCallback.consume((Object)cached.namespaced.getPsiListener());
                }
                if (cached.nonNamespaced != null) {
                    invokeCallback.consume((Object)cached.nonNamespaced.getPsiListener());
                }
                return;
            }
            file = file.getParent();
        }
    }

    public void beforeChildAddition(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(7);
        }
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile;
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(8);
        }
        if ((psiFile = event.getFile()) == null) {
            PsiElement child = event.getChild();
            if (child instanceof PsiFile) {
                VirtualFile file = ((PsiFile)child).getVirtualFile();
                if (file != null && PsiProjectListener.isRelevantFile(file)) {
                    this.dispatchChildAdded(event, file);
                }
            } else if (child instanceof PsiDirectory) {
                PsiDirectory directory = (PsiDirectory)child;
                this.dispatchChildAdded(event, directory.getVirtualFile());
            }
        } else if (PsiProjectListener.isRelevantFile(psiFile)) {
            this.dispatchChildAdded(event, psiFile.getVirtualFile());
        } else if (this.isGradleFileEdit(psiFile)) {
            PsiProjectListener.notifyGradleEdit(psiFile);
        }
        if (this.mySampleDataListener != null) {
            this.mySampleDataListener.childAdded(event);
        }
    }

    private void dispatchChildAdded(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(9);
        }
        this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.childAdded(event)));
    }

    public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(10);
        }
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile;
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(11);
        }
        if ((psiFile = event.getFile()) == null) {
            PsiDirectory directory;
            PsiElement child = event.getChild();
            if (child instanceof PsiFile) {
                VirtualFile file = ((PsiFile)child).getVirtualFile();
                if (file != null && PsiProjectListener.isRelevantFile(file)) {
                    this.dispatchChildRemoved(event, file);
                }
            } else if (child instanceof PsiDirectory && ResourceFolderType.getFolderType((String)(directory = (PsiDirectory)child).getName()) != null) {
                VirtualFile file = directory.getVirtualFile();
                this.dispatchChildRemoved(event, file);
            }
        } else if (PsiProjectListener.isRelevantFile(psiFile)) {
            VirtualFile file = psiFile.getVirtualFile();
            this.dispatchChildRemoved(event, file);
        } else if (this.isGradleFileEdit(psiFile)) {
            PsiProjectListener.notifyGradleEdit(psiFile);
        }
        if (this.mySampleDataListener != null) {
            this.mySampleDataListener.childRemoved(event);
        }
    }

    private void dispatchChildRemoved(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(12);
        }
        this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.childRemoved(event)));
    }

    public void beforeChildReplacement(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(13);
        }
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile;
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(14);
        }
        if ((psiFile = event.getFile()) != null) {
            if (PsiProjectListener.isRelevantFile(psiFile)) {
                this.dispatchChildReplaced(event, psiFile.getVirtualFile());
            } else if (this.isGradleFileEdit(psiFile)) {
                PsiProjectListener.notifyGradleEdit(psiFile);
            }
            if (this.mySampleDataListener != null) {
                this.mySampleDataListener.childReplaced(event);
            }
        } else {
            PsiElement parent = event.getParent();
            if (parent instanceof PsiDirectory) {
                PsiDirectory directory = (PsiDirectory)parent;
                this.dispatchChildReplaced(event, directory.getVirtualFile());
            }
        }
    }

    private void dispatchChildReplaced(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(15);
        }
        this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.childReplaced(event)));
    }

    private boolean isGradleFileEdit(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            PsiProjectListener.$$$reportNull$$$0(16);
        }
        return GradleFiles.getInstance(this.myProject).isGradleFile(psiFile);
    }

    private static void notifyGradleEdit(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            PsiProjectListener.$$$reportNull$$$0(17);
        }
        EditorNotifications.getInstance((Project)psiFile.getProject()).updateAllNotifications();
    }

    public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile;
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(18);
        }
        if ((psiFile = event.getFile()) != null && PsiProjectListener.isRelevantFile(psiFile)) {
            VirtualFile file = psiFile.getVirtualFile();
            this.dispatchBeforeChildrenChange(event, file);
        }
    }

    private void dispatchBeforeChildrenChange(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(19);
        }
        this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.beforeChildrenChange(event)));
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile;
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(20);
        }
        if ((psiFile = event.getFile()) != null) {
            if (PsiProjectListener.isRelevantFile(psiFile)) {
                VirtualFile file = psiFile.getVirtualFile();
                this.dispatchChildrenChanged(event, file);
            }
            if (this.mySampleDataListener != null) {
                this.mySampleDataListener.childrenChanged(event);
            }
        }
    }

    private void dispatchChildrenChanged(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(21);
        }
        this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.childrenChanged(event)));
    }

    public void beforeChildMovement(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(22);
        }
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(23);
        }
        PsiElement child = event.getChild();
        PsiFile psiFile = event.getFile();
        if (psiFile == null) {
            if (child instanceof PsiFile && PsiProjectListener.isRelevantFile((PsiFile)child)) {
                VirtualFile file = ((PsiFile)child).getVirtualFile();
                if (file != null) {
                    this.dispatchChildMoved(event, file);
                    return;
                }
                PsiElement oldParent = event.getOldParent();
                if (oldParent instanceof PsiDirectory) {
                    PsiDirectory directory = (PsiDirectory)oldParent;
                    VirtualFile dir = directory.getVirtualFile();
                    this.dispatchChildMoved(event, dir);
                }
            }
        } else {
            VirtualFile file = psiFile.getVirtualFile();
            if (file != null) {
                if (PsiProjectListener.isRelevantFile(file)) {
                    this.dispatchChildMoved(event, file);
                }
                if (this.mySampleDataListener != null) {
                    this.mySampleDataListener.childMoved(event);
                }
            }
        }
    }

    private void dispatchChildMoved(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        PsiElement oldParent;
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(24);
        }
        this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.childMoved(event)));
        if (event.getFile() == null && (oldParent = event.getOldParent()) instanceof PsiDirectory) {
            PsiDirectory sourceDir = (PsiDirectory)oldParent;
            this.dispatch(sourceDir.getVirtualFile(), (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.childMoved(event)));
        }
    }

    public void beforePropertyChange(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile;
        PsiElement child;
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(25);
        }
        if ("fileName" == event.getPropertyName() && (child = event.getChild()) instanceof PsiFile && PsiProjectListener.isRelevantFile(psiFile = (PsiFile)child)) {
            VirtualFile file = psiFile.getVirtualFile();
            this.dispatchBeforePropertyChange(event, file);
        }
    }

    private void dispatchBeforePropertyChange(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(26);
        }
        this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.beforePropertyChange(event)));
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile;
        PsiElement child;
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(27);
        }
        if ("fileName" == event.getPropertyName() && (child = event.getElement()) instanceof PsiFile && PsiProjectListener.isRelevantFile(psiFile = (PsiFile)child)) {
            VirtualFile file = psiFile.getVirtualFile();
            this.dispatchPropertyChanged(event, file);
        }
    }

    private void dispatchPropertyChanged(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
        if (event == null) {
            PsiProjectListener.$$$reportNull$$$0(28);
        }
        this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.propertyChanged(event)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/PsiProjectListener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invokeCallback";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/PsiProjectListener";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isRelevantFileType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isRelevantFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "dispatch";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "beforeChildAddition";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "childAdded";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "dispatchChildAdded";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "beforeChildRemoval";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "childRemoved";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "dispatchChildRemoved";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "beforeChildReplacement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "childReplaced";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "dispatchChildReplaced";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isGradleFileEdit";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "notifyGradleEdit";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "beforeChildrenChange";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "dispatchBeforeChildrenChange";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "childrenChanged";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "dispatchChildrenChanged";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "beforeChildMovement";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "childMoved";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "dispatchChildMoved";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "beforePropertyChange";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "dispatchBeforePropertyChange";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "propertyChanged";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "dispatchPropertyChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

