/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.resources.DataBindingResourceType;
import com.android.tools.idea.res.DataBindingInfo;
import com.android.tools.idea.res.LayoutDataBindingInfo;
import com.android.tools.idea.res.PsiDataBindingResourceItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MergedDataBindingInfo
implements DataBindingInfo {
    @NotNull
    private final List<LayoutDataBindingInfo> myInfoList;
    @NotNull
    private final LayoutDataBindingInfo myBaseInfo;
    private PsiClass myPsiClass;
    @NotNull
    private final CachedValue<List<DataBindingInfo.ViewWithId>> myViewWithIdsCache;
    @NotNull
    private final CachedValue<Map<DataBindingResourceType, Map<String, PsiDataBindingResourceItem>>> myResourceItemCache;

    MergedDataBindingInfo(@NotNull List<LayoutDataBindingInfo> infoList) {
        if (infoList == null) {
            MergedDataBindingInfo.$$$reportNull$$$0(0);
        }
        this.myInfoList = infoList;
        this.myBaseInfo = this.selectBaseInfo();
        CachedValuesManager cacheManager = CachedValuesManager.getManager((Project)this.myBaseInfo.getProject());
        this.myViewWithIdsCache = cacheManager.createCachedValue(() -> {
            HashSet used = new HashSet();
            ArrayList result2 = new ArrayList();
            for (DataBindingInfo dataBindingInfo : this.myInfoList) {
                dataBindingInfo.getViewsWithIds().forEach(viewWithId -> {
                    if (used.add(viewWithId.name)) {
                        result2.add(viewWithId);
                    }
                });
            }
            return CachedValueProvider.Result.create(result2, this.myInfoList);
        }, false);
        this.myResourceItemCache = cacheManager.createCachedValue(() -> {
            EnumMap<DataBindingResourceType, Map> result2 = new EnumMap<DataBindingResourceType, Map>(DataBindingResourceType.class);
            for (DataBindingInfo dataBindingInfo : this.myInfoList) {
                for (DataBindingResourceType type : DataBindingResourceType.values()) {
                    HashSet used = new HashSet();
                    Map<String, PsiDataBindingResourceItem> itemsByName = dataBindingInfo.getItems(type);
                    for (Map.Entry<String, PsiDataBindingResourceItem> entry : itemsByName.entrySet()) {
                        Map resultItemsByName = result2.computeIfAbsent(type, t -> new HashMap());
                        String name = entry.getKey();
                        PsiDataBindingResourceItem item = entry.getValue();
                        resultItemsByName.putIfAbsent(name, item);
                    }
                }
            }
            return CachedValueProvider.Result.create(result2, this.myInfoList);
        }, false);
    }

    public LayoutDataBindingInfo selectBaseInfo() {
        LayoutDataBindingInfo best = null;
        for (LayoutDataBindingInfo info : this.myInfoList) {
            if (best != null && best.getConfigurationName().length() <= info.getConfigurationName().length()) continue;
            best = info;
        }
        return best;
    }

    @Override
    public AndroidFacet getFacet() {
        return this.myBaseInfo.getFacet();
    }

    @Override
    public String getClassName() {
        return this.myBaseInfo.getNonConfigurationClassName();
    }

    @Override
    public String getPackageName() {
        return this.myBaseInfo.getPackageName();
    }

    @Override
    public Project getProject() {
        return this.myBaseInfo.getProject();
    }

    @Override
    public String getQualifiedName() {
        return this.myBaseInfo.getPackageName() + "." + this.getClassName();
    }

    @Override
    public PsiElement getNavigationElement() {
        return this.myBaseInfo.getNavigationElement();
    }

    @Override
    public PsiFile getPsiFile() {
        return this.myBaseInfo.getPsiFile();
    }

    @Override
    public PsiClass getPsiClass() {
        return this.myPsiClass;
    }

    @Override
    public void setPsiClass(PsiClass psiClass) {
        this.myPsiClass = psiClass;
    }

    @Override
    @NotNull
    public Map<String, PsiDataBindingResourceItem> getItems(@NotNull DataBindingResourceType type) {
        Map itemsByName;
        if (type == null) {
            MergedDataBindingInfo.$$$reportNull$$$0(1);
        }
        Map map2 = (itemsByName = (Map)((Map)this.myResourceItemCache.getValue()).get(type)) == null ? Collections.emptyMap() : itemsByName;
        if (map2 == null) {
            MergedDataBindingInfo.$$$reportNull$$$0(2);
        }
        return map2;
    }

    @Override
    @NotNull
    public List<DataBindingInfo.ViewWithId> getViewsWithIds() {
        List list = (List)this.myViewWithIdsCache.getValue();
        if (list == null) {
            MergedDataBindingInfo.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @Nullable
    public Module getModule() {
        return this.myBaseInfo.getModule();
    }

    @Override
    public long getModificationCount() {
        int total = this.myInfoList.size();
        for (DataBindingInfo dataBindingInfo : this.myInfoList) {
            total = (int)((long)total + dataBindingInfo.getModificationCount());
        }
        return total;
    }

    @Override
    public boolean isMerged() {
        return true;
    }

    @Override
    @Nullable
    public DataBindingInfo getMergedInfo() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/MergedDataBindingInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/MergedDataBindingInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewsWithIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getItems";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

