/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepositoryRootListener;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.SampleDataResourceRepository;
import com.android.tools.idea.res.aar.AarSourceResourceRepository;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.ModuleClassLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AppResourceRepository
extends MultiResourceRepository {
    private static final Logger LOG = Logger.getInstance(AppResourceRepository.class);
    static final Key<Boolean> TEMPORARY_RESOURCE_CACHE = Key.create((String)"TemporaryResourceCache");
    private final AndroidFacet myFacet;
    private Collection<AarSourceResourceRepository> myLibraries;
    private long myIdsModificationCount;
    private ListMultimap<String, ResourceItem> myIds;
    private final Object RESOURCE_MAP_LOCK;
    @Nullable
    private Multimap<String, VirtualFile> myResourceDirMap;

    @NotNull
    static AppResourceRepository create(@NotNull AndroidFacet facet, @NotNull List<AarSourceResourceRepository> libraryRepositories) {
        if (facet == null) {
            AppResourceRepository.$$$reportNull$$$0(0);
        }
        if (libraryRepositories == null) {
            AppResourceRepository.$$$reportNull$$$0(1);
        }
        AppResourceRepository repository = new AppResourceRepository(facet, AppResourceRepository.computeRepositories(facet, libraryRepositories), libraryRepositories);
        ProjectResourceRepositoryRootListener.ensureSubscribed(facet.getModule().getProject());
        AppResourceRepository appResourceRepository = repository;
        if (appResourceRepository == null) {
            AppResourceRepository.$$$reportNull$$$0(2);
        }
        return appResourceRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    Multimap<String, VirtualFile> getAllResourceDirs() {
        Object object = this.RESOURCE_MAP_LOCK;
        // MONITORENTER : object
        if (this.myResourceDirMap == null) {
            this.myResourceDirMap = HashMultimap.create();
            for (LocalResourceRepository resourceRepository : this.getChildren()) {
                VirtualFile resDir;
                this.myResourceDirMap.putAll((Object)resourceRepository.getLibraryName(), resourceRepository.getResourceDirs());
                if (!(resourceRepository instanceof AarSourceResourceRepository) || (resDir = VfsUtil.findFileByIoFile((File)((AarSourceResourceRepository)resourceRepository).getResourceDirectory(), (boolean)true)) == null) continue;
                this.myResourceDirMap.put((Object)resourceRepository.getLibraryName(), (Object)resDir);
            }
        }
        Multimap<String, VirtualFile> multimap = this.myResourceDirMap;
        // MONITOREXIT : object
        if (multimap != null) return multimap;
        AppResourceRepository.$$$reportNull$$$0(3);
        return multimap;
    }

    private static List<LocalResourceRepository> computeRepositories(@NotNull AndroidFacet facet, @NotNull Collection<AarSourceResourceRepository> libraryRepositories) {
        if (facet == null) {
            AppResourceRepository.$$$reportNull$$$0(4);
        }
        if (libraryRepositories == null) {
            AppResourceRepository.$$$reportNull$$$0(5);
        }
        ArrayList<LocalResourceRepository> repositories = new ArrayList<LocalResourceRepository>(libraryRepositories.size() + 2);
        repositories.addAll(libraryRepositories);
        repositories.add(ResourceRepositoryManager.getProjectResources(facet));
        repositories.add(SampleDataResourceRepository.getInstance(facet));
        return repositories;
    }

    protected AppResourceRepository(@NotNull AndroidFacet facet, @NotNull List<? extends LocalResourceRepository> delegates, @NotNull Collection<AarSourceResourceRepository> libraries) {
        if (facet == null) {
            AppResourceRepository.$$$reportNull$$$0(6);
        }
        if (delegates == null) {
            AppResourceRepository.$$$reportNull$$$0(7);
        }
        if (libraries == null) {
            AppResourceRepository.$$$reportNull$$$0(8);
        }
        super(facet.getModule().getName() + " with modules and libraries");
        this.RESOURCE_MAP_LOCK = new Object();
        this.myFacet = facet;
        this.myLibraries = libraries;
        this.setChildren(delegates);
    }

    @NotNull
    private ListMultimap<String, ResourceItem> getAllIds(@NotNull ResourceNamespace namespace) {
        long currentModCount;
        if (namespace == null) {
            AppResourceRepository.$$$reportNull$$$0(9);
        }
        if (this.myIdsModificationCount < (currentModCount = this.getModificationCount())) {
            this.myIdsModificationCount = currentModCount;
            if (this.myIds == null) {
                int size = 0;
                for (AarSourceResourceRepository library : this.myLibraries) {
                    if (library.getAllDeclaredIds() == null) continue;
                    size += library.getAllDeclaredIds().size();
                }
                this.myIds = ArrayListMultimap.create((int)size, (int)1);
            } else {
                this.myIds.clear();
            }
            for (AarSourceResourceRepository library : this.myLibraries) {
                if (library.getAllDeclaredIds() == null) continue;
                for (String name : library.getAllDeclaredIds().keySet()) {
                    this.myIds.put((Object)name, (Object)new IdResourceItem(name));
                }
            }
            this.myIds.putAll((Multimap)super.getResources(namespace, ResourceType.ID));
        }
        ListMultimap<String, ResourceItem> listMultimap = this.myIds;
        if (listMultimap == null) {
            AppResourceRepository.$$$reportNull$$$0(10);
        }
        return listMultimap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public ListMultimap<String, ResourceItem> getResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        if (namespace == null) {
            AppResourceRepository.$$$reportNull$$$0(11);
        }
        if (type == null) {
            AppResourceRepository.$$$reportNull$$$0(12);
        }
        Object object = ITEM_MAP_LOCK;
        // MONITORENTER : object
        ListMultimap<String, ResourceItem> listMultimap = type == ResourceType.ID && namespace == ResourceNamespace.RES_AUTO ? this.getAllIds(namespace) : super.getResources(namespace, type);
        // MONITOREXIT : object
        if (listMultimap != null) return listMultimap;
        AppResourceRepository.$$$reportNull$$$0(13);
        return listMultimap;
    }

    void updateRoots(@NotNull Collection<AarSourceResourceRepository> libraries) {
        if (libraries == null) {
            AppResourceRepository.$$$reportNull$$$0(14);
        }
        List<LocalResourceRepository> repositories = AppResourceRepository.computeRepositories(this.myFacet, libraries);
        this.updateRoots(repositories, libraries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRoots(@NotNull List<LocalResourceRepository> resources, @NotNull Collection<AarSourceResourceRepository> libraries) {
        if (resources == null) {
            AppResourceRepository.$$$reportNull$$$0(15);
        }
        if (libraries == null) {
            AppResourceRepository.$$$reportNull$$$0(16);
        }
        Object object = this.RESOURCE_MAP_LOCK;
        synchronized (object) {
            this.myResourceDirMap = null;
        }
        this.invalidateResourceDirs();
        if (resources.equals(this.getChildren())) {
            return;
        }
        this.myLibraries = libraries;
        this.setChildren(resources);
        ResourceIdManager.get(this.myFacet.getModule()).resetDynamicIds();
        ModuleClassLoader.clearCache(this.myFacet.getModule());
    }

    @NotNull
    static AppResourceRepository createForTest(@NotNull AndroidFacet facet, @NotNull List<LocalResourceRepository> modules, @NotNull Collection<AarSourceResourceRepository> libraries) {
        if (facet == null) {
            AppResourceRepository.$$$reportNull$$$0(17);
        }
        if (modules == null) {
            AppResourceRepository.$$$reportNull$$$0(18);
        }
        if (libraries == null) {
            AppResourceRepository.$$$reportNull$$$0(19);
        }
        assert (modules.containsAll(libraries));
        assert (modules.size() == libraries.size() + 1);
        AppResourceRepository appResourceRepository = new AppResourceRepository(facet, modules, libraries);
        if (appResourceRepository == null) {
            AppResourceRepository.$$$reportNull$$$0(20);
        }
        return appResourceRepository;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryRepositories";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/AppResourceRepository";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegates";
                break;
            }
            case 8: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resources";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/AppResourceRepository";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllResourceDirs";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllIds";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getResources";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createForTest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: 
            case 20: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeRepositories";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAllIds";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getResources";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateRoots";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createForTest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IdResourceItem
    implements ResourceItem {
        private final String myName;

        IdResourceItem(@NotNull String name) {
            if (name == null) {
                IdResourceItem.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                IdResourceItem.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public ResourceType getType() {
            ResourceType resourceType = ResourceType.ID;
            if (resourceType == null) {
                IdResourceItem.$$$reportNull$$$0(2);
            }
            return resourceType;
        }

        @NotNull
        public ResourceNamespace getNamespace() {
            ResourceNamespace resourceNamespace = ResourceNamespace.RES_AUTO;
            if (resourceNamespace == null) {
                IdResourceItem.$$$reportNull$$$0(3);
            }
            return resourceNamespace;
        }

        @Nullable
        public String getLibraryName() {
            return null;
        }

        @NotNull
        public ResourceReference getReferenceToSelf() {
            ResourceReference resourceReference = new ResourceReference(ResourceNamespace.RES_AUTO, ResourceType.ID, this.myName);
            if (resourceReference == null) {
                IdResourceItem.$$$reportNull$$$0(4);
            }
            return resourceReference;
        }

        @NotNull
        public String getKey() {
            String string = this.myName;
            if (string == null) {
                IdResourceItem.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Nullable
        public ResourceValue getResourceValue() {
            return null;
        }

        @Nullable
        public PathString getSource() {
            return null;
        }

        public boolean isFileBased() {
            return false;
        }

        @NotNull
        public FolderConfiguration getConfiguration() {
            FolderConfiguration folderConfiguration = FolderConfiguration.createDefault();
            if (folderConfiguration == null) {
                IdResourceItem.$$$reportNull$$$0(6);
            }
            return folderConfiguration;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/res/AppResourceRepository$IdResourceItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/res/AppResourceRepository$IdResourceItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamespace";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferenceToSelf";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfiguration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

