/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.webp;

import com.android.tools.idea.rendering.webp.WebpConversionSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebpConversionDialog
extends DialogWrapper
implements DocumentListener,
ChangeListener,
ActionListener {
    private JSlider myQualitySlider;
    private JBTextField myQualityField;
    private JBRadioButton myLossyButton;
    private JBRadioButton myLosslessButton;
    private JBLabel myMinSdkVersionLabel;
    private JBCheckBox mySkipLargerCheckBox;
    private JBCheckBox mySkipNinePatchCheckBox;
    private JBCheckBox myPreviewImagesCheckBox;
    private JBLabel myWarningLabel;
    private JPanel myPanel;
    private JBLabel myPercentLabel;
    private JBLabel myLosslessReqLabel;
    private JBLabel myQualityLabel;
    private JBCheckBox mySkipTransparency;
    private JBLabel myMinSdkVersionLabel2;
    private boolean myIgnore;

    public WebpConversionDialog(@NotNull Project project, int minSdkVersion2, @NotNull WebpConversionSettings settings, boolean singleFile) {
        if (project == null) {
            WebpConversionDialog.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            WebpConversionDialog.$$$reportNull$$$0(1);
        }
        super(project);
        this.$$$setupUI$$$();
        this.setTitle("Converting Images to WebP");
        this.fromSettings(settings);
        this.myQualityField.getDocument().addDocumentListener(this);
        this.myQualitySlider.addChangeListener(this);
        this.myLossyButton.addActionListener((ActionListener)this);
        this.myLosslessButton.addActionListener((ActionListener)this);
        this.actionPerformed(null);
        String minSdkVersionString = minSdkVersion2 == Integer.MAX_VALUE ? "unknown" : String.valueOf(minSdkVersion2);
        String minSdkText = "Current minSdkVersion is " + minSdkVersionString;
        this.myMinSdkVersionLabel.setText(minSdkText);
        this.myMinSdkVersionLabel2.setText(minSdkText);
        if (minSdkVersion2 < 14) {
            this.myWarningLabel.setText("WARNING: WebP requires API 14; current minSdkVersion is " + minSdkVersionString);
            this.myWarningLabel.setForeground((Color)JBColor.RED);
            this.myWarningLabel.setVisible(true);
        } else if (minSdkVersion2 < 18) {
            this.mySkipTransparency.setSelected(true);
            if (singleFile) {
                this.myMinSdkVersionLabel.setForeground((Color)JBColor.RED);
                this.myMinSdkVersionLabel2.setForeground((Color)JBColor.RED);
            }
        } else {
            this.myLosslessReqLabel.setVisible(false);
            this.myMinSdkVersionLabel.setVisible(false);
        }
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myPanel.setPreferredSize((Dimension)JBUI.size((int)500, (int)300));
        return this.myPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateQuality(int quality, boolean updateText, boolean updateSlider) {
        boolean old = this.myIgnore;
        try {
            this.myIgnore = true;
            if (updateSlider) {
                this.myQualitySlider.setValue(quality);
            }
            if (updateText) {
                this.myQualityField.setText(Integer.toString(quality));
            }
        }
        finally {
            this.myIgnore = old;
        }
    }

    private int getQualityPercent() {
        String text = this.myQualityField.getText().trim();
        try {
            int parsed = (int)Float.parseFloat(text);
            return Math.max(0, Math.min(100, parsed));
        }
        catch (NumberFormatException ignore) {
            return -1;
        }
    }

    public void toSettings(@NotNull WebpConversionSettings settings) {
        if (settings == null) {
            WebpConversionDialog.$$$reportNull$$$0(2);
        }
        settings.skipLargerImages = this.mySkipLargerCheckBox.isSelected();
        settings.skipNinePatches = this.mySkipNinePatchCheckBox.isSelected();
        settings.previewConversion = this.myPreviewImagesCheckBox.isSelected();
        settings.skipTransparentImages = this.mySkipTransparency.isSelected();
        settings.lossless = this.myLosslessButton.isSelected();
        int quality = this.getQualityPercent();
        if (quality < 0) {
            quality = 75;
        }
        settings.quality = quality;
    }

    public void fromSettings(@Nullable WebpConversionSettings settings) {
        if (settings != null) {
            boolean old = this.myIgnore;
            try {
                this.myIgnore = true;
                this.mySkipLargerCheckBox.setSelected(settings.skipLargerImages);
                this.mySkipNinePatchCheckBox.setSelected(settings.skipNinePatches);
                this.myPreviewImagesCheckBox.setSelected(settings.previewConversion);
                this.mySkipTransparency.setSelected(settings.skipTransparentImages);
                this.myLosslessButton.setSelected(settings.lossless);
                this.myQualitySlider.setValue(settings.quality);
                this.myQualityField.setText(Integer.toString(settings.quality));
            }
            finally {
                this.myIgnore = old;
            }
        }
    }

    private void qualityFieldEdited() {
        int quality;
        if (!this.myIgnore && (quality = this.getQualityPercent()) >= 0) {
            this.updateQuality(quality, false, true);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.qualityFieldEdited();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.qualityFieldEdited();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.qualityFieldEdited();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.myIgnore && e.getSource() == this.myQualitySlider) {
            this.updateQuality(this.myQualitySlider.getValue(), true, false);
        }
    }

    @Override
    public void actionPerformed(@Nullable ActionEvent e) {
        if (!this.myIgnore) {
            boolean lossless = this.myLosslessButton.isSelected();
            this.myQualityLabel.setEnabled(!lossless);
            this.myQualitySlider.setEnabled(!lossless);
            this.myQualityField.setEnabled(!lossless);
            this.myPercentLabel.setEnabled(!lossless);
            this.myPreviewImagesCheckBox.setEnabled(!lossless);
            this.myMinSdkVersionLabel.setEnabled(lossless);
            this.myLosslessReqLabel.setEnabled(lossless);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/rendering/webp/WebpConversionDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "toSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBLabel jBLabel2;
        JBCheckBox jBCheckBox3;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        JBRadioButton jBRadioButton;
        JBLabel jBLabel5;
        JSlider jSlider;
        JBTextField jBTextField;
        JBLabel jBLabel6;
        JBCheckBox jBCheckBox4;
        JBRadioButton jBRadioButton2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(14, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel).setVisible(true);
        this.myLossyButton = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setSelected(true);
        jBRadioButton2.setText("Lossy encoding");
        jPanel.add((Component)jBRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.mySkipLargerCheckBox = jBCheckBox4 = new JBCheckBox();
        jBCheckBox4.setSelected(true);
        jBCheckBox4.setText("Skip files where the encoded result is larger than the original");
        jPanel.add((Component)jBCheckBox4, new GridConstraints(7, 0, 1, 5, 8, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(0, 20), null));
        this.myQualityLabel = jBLabel6 = new JBLabel();
        jBLabel6.setText("Encoding quality:");
        jPanel.add((Component)jBLabel6, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 4));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myQualityField = jBTextField = new JBTextField();
        jBTextField.setColumns(3);
        jPanel.add((Component)jBTextField, new GridConstraints(1, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myQualitySlider = jSlider = new JSlider();
        jSlider.setMajorTickSpacing(10);
        jSlider.setPaintLabels(false);
        jSlider.setPaintTicks(true);
        jSlider.setValue(80);
        jPanel.add((Component)jSlider, new GridConstraints(1, 3, 1, 1, 8, 1, 0, 0, null, new Dimension(150, -1), null));
        this.myPercentLabel = jBLabel5 = new JBLabel();
        jBLabel5.setText("%");
        jPanel.add((Component)jBLabel5, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLosslessButton = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("Use lossless encoding");
        jPanel.add((Component)jBRadioButton, new GridConstraints(3, 0, 1, 5, 8, 0, 3, 3, null, null, null));
        this.myLosslessReqLabel = jBLabel4 = new JBLabel();
        jBLabel4.setText("Warning: Lossless encoding requires Android 4.3 (API 18)");
        jPanel.add((Component)jBLabel4, new GridConstraints(4, 0, 1, 5, 8, 0, 0, 0, null, null, null, 4));
        this.myMinSdkVersionLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("");
        jPanel.add((Component)jBLabel3, new GridConstraints(5, 0, 1, 5, 8, 0, 0, 0, null, null, null, 4));
        this.myPreviewImagesCheckBox = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setSelected(true);
        jBCheckBox3.setText("Preview/inspect each converted image before saving");
        jPanel.add((Component)jBCheckBox3, new GridConstraints(2, 0, 1, 5, 8, 0, 3, 3, null, null, null, 4));
        this.myWarningLabel = jBLabel2 = new JBLabel();
        jBLabel2.setVisible(false);
        jPanel.add((Component)jBLabel2, new GridConstraints(13, 0, 1, 5, 8, 0, 0, 0, null, null, null, 4));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(12, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.mySkipTransparency = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Skip images with transparency/alpha channel");
        jPanel.add((Component)jBCheckBox2, new GridConstraints(9, 0, 1, 5, 8, 0, 3, 3, null, null, null));
        JBLabel jBLabel7 = new JBLabel();
        jBLabel7.setText("Transparency requires Android 4.3 (API 18)");
        jPanel.add((Component)jBLabel7, new GridConstraints(10, 0, 1, 5, 8, 0, 0, 0, null, null, null, 4));
        this.mySkipNinePatchCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setEnabled(false);
        jBCheckBox.setText("Skip nine-patch (.9.png) images");
        jPanel.add((Component)jBCheckBox, new GridConstraints(8, 0, 1, 5, 8, 0, 3, 3, null, null, null));
        this.myMinSdkVersionLabel2 = jBLabel = new JBLabel();
        jBLabel.setText("");
        jPanel.add((Component)jBLabel, new GridConstraints(11, 0, 1, 5, 8, 0, 0, 0, null, null, null, 4));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

