/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.parsers;

import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.ActionBarHandler;
import com.android.tools.idea.rendering.LayoutlibCallbackImpl;
import com.android.tools.idea.rendering.parsers.DomPullParser;
import com.android.tools.idea.rendering.parsers.LayoutPullParsers;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.utils.XmlUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;

class MenuLayoutParserFactory {
    @NotNull
    private static final String FRAME_LAYOUT_XML = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<FrameLayout\n    xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    android:layout_width=\"match_parent\"\n    android:layout_height=\"match_parent\" />\n";

    private MenuLayoutParserFactory() {
    }

    @NotNull
    public static ILayoutPullParser create(@NotNull PsiFile psiFile, @NotNull LayoutlibCallbackImpl layoutlibCallback) {
        ResourceRepositoryManager repositoryManager;
        Document frameLayoutDocument;
        if (psiFile == null) {
            MenuLayoutParserFactory.$$$reportNull$$$0(0);
        }
        if (layoutlibCallback == null) {
            MenuLayoutParserFactory.$$$reportNull$$$0(1);
        }
        if ((frameLayoutDocument = XmlUtils.parseDocumentSilently((String)FRAME_LAYOUT_XML, (boolean)true)) == null) {
            ILayoutPullParser iLayoutPullParser = LayoutPullParsers.createEmptyParser();
            if (iLayoutPullParser == null) {
                MenuLayoutParserFactory.$$$reportNull$$$0(2);
            }
            return iLayoutPullParser;
        }
        ActionBarHandler actionBarHandler = layoutlibCallback.getActionBarHandler();
        if (actionBarHandler != null && (repositoryManager = ResourceRepositoryManager.getInstance((PsiElement)psiFile)) != null) {
            ResourceReference menuResource = new ResourceReference(repositoryManager.getNamespace(), ResourceType.MENU, ResourceHelper.getResourceName(psiFile));
            actionBarHandler.setMenuIds(Collections.singletonList(menuResource));
        }
        ILayoutPullParser iLayoutPullParser = DomPullParser.createFromDocument(frameLayoutDocument, Collections.emptyMap());
        if (iLayoutPullParser == null) {
            MenuLayoutParserFactory.$$$reportNull$$$0(3);
        }
        return iLayoutPullParser;
    }

    @NotNull
    public static ILayoutPullParser createInNavigationView(@NotNull PsiFile file) {
        String xml;
        Document document;
        if (file == null) {
            MenuLayoutParserFactory.$$$reportNull$$$0(4);
        }
        ILayoutPullParser iLayoutPullParser = (document = XmlUtils.parseDocumentSilently((String)(xml = "<android.support.design.widget.NavigationView xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    xmlns:app=\"http://schemas.android.com/apk/res-auto\"\n    android:layout_width=\"wrap_content\"\n    android:layout_height=\"match_parent\"\n    app:menu=\"@menu/" + ResourceHelper.getResourceName(file) + "\" />\n"), (boolean)true)) == null ? LayoutPullParsers.createEmptyParser() : DomPullParser.createFromDocument(document);
        if (iLayoutPullParser == null) {
            MenuLayoutParserFactory.$$$reportNull$$$0(5);
        }
        return iLayoutPullParser;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutlibCallback";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/parsers/MenuLayoutParserFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/parsers/MenuLayoutParserFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createInNavigationView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createInNavigationView";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

