/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.parsers;

import com.android.ide.common.rendering.api.ILayoutLog;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ValueXmlHelper;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.rendering.IRenderLogger;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.parsers.AaptAttrAttributeSnapshot;
import com.android.tools.idea.rendering.parsers.AaptAttrParser;
import com.android.tools.idea.rendering.parsers.AttributeSnapshot;
import com.android.tools.idea.rendering.parsers.LayoutPullParser;
import com.android.tools.idea.rendering.parsers.MenuPsiPullParser;
import com.android.tools.idea.rendering.parsers.PaddingLayoutPsiPullParser;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.android.dom.navigation.NavXmlHelperKt;
import org.jetbrains.annotations.NotNull;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LayoutPsiPullParser
extends LayoutPullParser
implements AaptAttrParser {
    final ResourceResolver myResourceResolver;
    private static final ImmutableSet<String> TAGS_SUPPORTING_SRC_COMPAT = ImmutableSet.of((Object)"ImageButton", (Object)"ImageView");
    private static final TagSnapshot EMPTY_LAYOUT = TagSnapshot.createSyntheticTag(null, "LinearLayout", "android", "http://schemas.android.com/apk/res/android", (List<AttributeSnapshot>)ImmutableList.of((Object)new AttributeSnapshot("http://schemas.android.com/apk/res/android", "android", "layout_width", "match_parent"), (Object)new AttributeSnapshot("http://schemas.android.com/apk/res/android", "android", "layout_height", "match_parent")), (List<TagSnapshot>)ImmutableList.of());
    private static final Consumer<TagSnapshot> TAG_SNAPSHOT_DECORATOR = tagSnapshot -> {
        if ("com.google.android.gms.ads.AdView".equals(tagSnapshot.tagName) || "com.google.android.gms.maps.MapView".equals(tagSnapshot.tagName)) {
            tagSnapshot.setAttribute("minWidth", "http://schemas.android.com/tools", "tools", "50dp", false);
            tagSnapshot.setAttribute("minHeight", "http://schemas.android.com/tools", "tools", "50dp", false);
            tagSnapshot.setAttribute("background", "http://schemas.android.com/tools", "tools", "#AAA", false);
        } else if ((tagSnapshot.tagName.equals("ListView") || tagSnapshot.tagName.equals("ExpandableListView") || tagSnapshot.tagName.equals("GridView") || tagSnapshot.tagName.equals("Spinner")) && tagSnapshot.getAttribute("id", "http://schemas.android.com/apk/res/android") == null) {
            String prefix;
            String string = prefix = tagSnapshot.tag != null ? tagSnapshot.tag.getPrefixByNamespace("http://schemas.android.com/apk/res/android") : null;
            if (prefix != null) {
                tagSnapshot.setAttribute("id", "http://schemas.android.com/apk/res/android", prefix, "@+id/_dynamic");
            }
        }
    };
    @NotNull
    private final ILayoutLog myLogger;
    @NotNull
    private final List<TagSnapshot> myNodeStack;
    protected final TagSnapshot myRoot;
    @NotNull
    protected final ImmutableMap<String, String> myNamespacePrefixes;
    private final ResourceNamespace myLayoutNamespace;
    protected boolean myProvideViewCookies;
    private boolean myUseSrcCompat;
    private final ImmutableMap<String, TagSnapshot> myDeclaredAaptAttrs;

    @NotNull
    public static LayoutPsiPullParser create(@NotNull XmlFile file, @NotNull IRenderLogger logger, boolean honorMergeParentTag) {
        if (file == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(0);
        }
        if (logger == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(1);
        }
        if (ResourceHelper.getFolderType((PsiFile)file) == ResourceFolderType.MENU) {
            MenuPsiPullParser menuPsiPullParser = new MenuPsiPullParser(file, logger);
            if (menuPsiPullParser == null) {
                LayoutPsiPullParser.$$$reportNull$$$0(2);
            }
            return menuPsiPullParser;
        }
        LayoutPsiPullParser layoutPsiPullParser = new LayoutPsiPullParser(file, logger, honorMergeParentTag);
        if (layoutPsiPullParser == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(3);
        }
        return layoutPsiPullParser;
    }

    @NotNull
    public static LayoutPsiPullParser create(@NotNull XmlFile file, @NotNull IRenderLogger logger) {
        if (file == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(4);
        }
        if (logger == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(5);
        }
        LayoutPsiPullParser layoutPsiPullParser = LayoutPsiPullParser.create(file, logger, true);
        if (layoutPsiPullParser == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(6);
        }
        return layoutPsiPullParser;
    }

    @NotNull
    public static LayoutPsiPullParser create(@NotNull XmlFile file, @NotNull IRenderLogger logger, Set<XmlTag> explodeNodes, @NotNull Density density, ResourceResolver resourceResolver) {
        if (file == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(7);
        }
        if (logger == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(8);
        }
        if (density == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(9);
        }
        if (explodeNodes != null && !explodeNodes.isEmpty()) {
            PaddingLayoutPsiPullParser paddingLayoutPsiPullParser = new PaddingLayoutPsiPullParser(file, logger, explodeNodes, density);
            if (paddingLayoutPsiPullParser == null) {
                LayoutPsiPullParser.$$$reportNull$$$0(10);
            }
            return paddingLayoutPsiPullParser;
        }
        LayoutPsiPullParser layoutPsiPullParser = new LayoutPsiPullParser(file, (ILayoutLog)logger, true, resourceResolver);
        if (layoutPsiPullParser == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(11);
        }
        return layoutPsiPullParser;
    }

    @NotNull
    public static LayoutPsiPullParser create(RenderTask.AttributeFilter filter2, @NotNull XmlTag root, @NotNull IRenderLogger logger) {
        if (root == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(12);
        }
        if (logger == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(13);
        }
        AttributeFilteredLayoutParser attributeFilteredLayoutParser = new AttributeFilteredLayoutParser(root, (ILayoutLog)logger, filter2);
        if (attributeFilteredLayoutParser == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(14);
        }
        return attributeFilteredLayoutParser;
    }

    @NotNull
    public static LayoutPsiPullParser create(@NotNull TagSnapshot root, @NotNull ResourceNamespace layoutNamespace, @NotNull ILayoutLog log) {
        if (root == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(15);
        }
        if (layoutNamespace == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(16);
        }
        if (log == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(17);
        }
        LayoutPsiPullParser layoutPsiPullParser = new LayoutPsiPullParser(root, layoutNamespace, log);
        if (layoutPsiPullParser == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(18);
        }
        return layoutPsiPullParser;
    }

    protected LayoutPsiPullParser(@NotNull XmlFile file, @NotNull ILayoutLog logger, boolean honorMergeParentTag) {
        if (file == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(19);
        }
        if (logger == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(20);
        }
        this(AndroidPsiUtils.getRootTagSafely(file), logger, honorMergeParentTag, null);
    }

    protected LayoutPsiPullParser(@NotNull XmlFile file, @NotNull ILayoutLog logger, boolean honorMergeParentTag, ResourceResolver resourceResolver) {
        if (file == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(21);
        }
        if (logger == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(22);
        }
        this(AndroidPsiUtils.getRootTagSafely(file), logger, honorMergeParentTag, resourceResolver);
    }

    @NotNull
    private static ImmutableMap<String, String> buildNamespacesMap(TagSnapshot root) {
        XmlTag rootTag;
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            ImmutableMap immutableMap = (ImmutableMap)ApplicationManager.getApplication().runReadAction(() -> LayoutPsiPullParser.buildNamespacesMap(root));
            if (immutableMap == null) {
                LayoutPsiPullParser.$$$reportNull$$$0(23);
            }
            return immutableMap;
        }
        XmlTag xmlTag = rootTag = root != null ? root.tag : null;
        if (rootTag == null || !rootTag.isValid()) {
            ImmutableMap immutableMap = ImmutableMap.of();
            if (immutableMap == null) {
                LayoutPsiPullParser.$$$reportNull$$$0(24);
            }
            return immutableMap;
        }
        ImmutableMap.Builder prefixesBuilder = ImmutableMap.builder();
        for (String uri : new String[]{"http://schemas.android.com/apk/res/android", "http://schemas.android.com/tools", "http://schemas.android.com/apk/res-auto"}) {
            String prefix = rootTag.getPrefixByNamespace(uri);
            if (prefix == null) continue;
            prefixesBuilder.put((Object)uri, (Object)prefix);
        }
        ImmutableMap immutableMap = prefixesBuilder.build();
        if (immutableMap == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(25);
        }
        return immutableMap;
    }

    protected LayoutPsiPullParser(XmlTag root, @NotNull ILayoutLog logger, boolean honorMergeParentTag, ResourceResolver resourceResolver) {
        if (logger == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(26);
        }
        this.myNodeStack = new ArrayList<TagSnapshot>();
        this.myProvideViewCookies = true;
        this.myResourceResolver = resourceResolver;
        this.myLogger = logger;
        Ref myRootRef = new Ref((Object)EMPTY_LAYOUT);
        Ref myLayoutNamespaceRef = new Ref((Object)ResourceNamespace.RES_AUTO);
        ReadAction.run(() -> {
            if (root != null && root.isValid()) {
                myRootRef.set((Object)LayoutPsiPullParser.createSnapshot(root, honorMergeParentTag));
                ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance((PsiElement)root);
                if (repositoryManager != null) {
                    myLayoutNamespaceRef.set((Object)repositoryManager.getNamespace());
                }
            }
        });
        this.myRoot = (TagSnapshot)myRootRef.get();
        this.myLayoutNamespace = (ResourceNamespace)myLayoutNamespaceRef.get();
        this.myNamespacePrefixes = LayoutPsiPullParser.buildNamespacesMap(this.myRoot);
        this.myDeclaredAaptAttrs = LayoutPsiPullParser.findDeclaredAaptAttrs(this.myRoot);
    }

    protected LayoutPsiPullParser(@NotNull TagSnapshot root, @NotNull ResourceNamespace layoutNamespace, @NotNull ILayoutLog log) {
        if (root == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(27);
        }
        if (layoutNamespace == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(28);
        }
        if (log == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(29);
        }
        this.myNodeStack = new ArrayList<TagSnapshot>();
        this.myProvideViewCookies = true;
        this.myResourceResolver = null;
        this.myLogger = log;
        this.myDeclaredAaptAttrs = ImmutableMap.of();
        this.myRoot = (TagSnapshot)ApplicationManager.getApplication().runReadAction(() -> {
            if (root.tag != null && root.tag.isValid()) {
                return root;
            }
            return null;
        });
        this.myNamespacePrefixes = LayoutPsiPullParser.buildNamespacesMap(this.myRoot);
        this.myLayoutNamespace = layoutNamespace;
    }

    @Override
    @NotNull
    public ImmutableMap<String, TagSnapshot> getAaptDeclaredAttrs() {
        ImmutableMap<String, TagSnapshot> immutableMap = this.myDeclaredAaptAttrs;
        if (immutableMap == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(30);
        }
        return immutableMap;
    }

    public ResourceNamespace getLayoutNamespace() {
        return this.myLayoutNamespace;
    }

    @NotNull
    private static ImmutableMap<String, TagSnapshot> findDeclaredAaptAttrs(TagSnapshot tag) {
        if (tag == null || !tag.hasDeclaredAaptAttrs) {
            ImmutableMap immutableMap = ImmutableMap.of();
            if (immutableMap == null) {
                LayoutPsiPullParser.$$$reportNull$$$0(31);
            }
            return immutableMap;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        tag.attributes.stream().filter(attr -> attr instanceof AaptAttrAttributeSnapshot).map(attr -> (AaptAttrAttributeSnapshot)attr).forEach(attr -> {
            TagSnapshot bundledTag = attr.getBundledTag();
            builder.put((Object)attr.getId(), (Object)bundledTag);
            for (TagSnapshot child : bundledTag.children) {
                builder.putAll(LayoutPsiPullParser.findDeclaredAaptAttrs(child));
            }
        });
        for (TagSnapshot child : tag.children) {
            builder.putAll(LayoutPsiPullParser.findDeclaredAaptAttrs(child));
        }
        ImmutableMap immutableMap = builder.build();
        if (immutableMap == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(32);
        }
        return immutableMap;
    }

    protected final TagSnapshot getCurrentNode() {
        if (!this.myNodeStack.isEmpty()) {
            return this.myNodeStack.get(this.myNodeStack.size() - 1);
        }
        return null;
    }

    protected final TagSnapshot getPreviousNode() {
        if (this.myNodeStack.size() > 1) {
            return this.myNodeStack.get(this.myNodeStack.size() - 2);
        }
        return null;
    }

    protected final AttributeSnapshot getAttribute(int i2) {
        if (this.myParsingState != 2) {
            throw new IndexOutOfBoundsException();
        }
        TagSnapshot uiNode = this.getCurrentNode();
        if (uiNode != null) {
            return uiNode.attributes.get(i2);
        }
        return null;
    }

    protected void push(@NotNull TagSnapshot node) {
        if (node == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(33);
        }
        this.myNodeStack.add(node);
    }

    @NotNull
    protected TagSnapshot pop() {
        TagSnapshot tagSnapshot = this.myNodeStack.remove(this.myNodeStack.size() - 1);
        if (tagSnapshot == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(34);
        }
        return tagSnapshot;
    }

    public Object getViewCookie() {
        if (this.myProvideViewCookies) {
            return this.getCurrentNode();
        }
        return null;
    }

    public String getPositionDescription() {
        return "XML DOM element depth:" + this.myNodeStack.size();
    }

    public int getAttributeCount() {
        TagSnapshot node = this.getCurrentNode();
        if (node != null) {
            return node.attributes.size();
        }
        return 0;
    }

    public String getAttributeName(int i2) {
        AttributeSnapshot attribute = this.getAttribute(i2);
        if (attribute != null) {
            return attribute.name;
        }
        return null;
    }

    public String getAttributeNamespace(int i2) {
        AttributeSnapshot attribute = this.getAttribute(i2);
        if (attribute != null) {
            return attribute.namespace;
        }
        return "";
    }

    public String getAttributePrefix(int i2) {
        AttributeSnapshot attribute = this.getAttribute(i2);
        if (attribute != null) {
            return attribute.prefix;
        }
        return null;
    }

    public String getAttributeValue(int i2) {
        AttributeSnapshot attribute = this.getAttribute(i2);
        if (attribute != null) {
            return attribute.value;
        }
        return null;
    }

    public String getAttributeValue(String namespace, String localName) {
        TagSnapshot tag = this.getCurrentNode();
        if (tag != null) {
            int n;
            String srcCompatValue;
            if ("layout".equals(localName) && "fragment".equals(tag.tagName)) {
                String layout2 = tag.getAttribute("layout", "http://schemas.android.com/tools");
                if (layout2 != null) {
                    return layout2;
                }
                String navGraph = tag.getAttribute("navGraph", "http://schemas.android.com/apk/res-auto");
                if (navGraph != null) {
                    return NavXmlHelperKt.getStartDestLayoutId(navGraph, this.myRoot.tag.getProject(), this.myResourceResolver);
                }
            } else if (this.myUseSrcCompat && "src".equals(localName) && TAGS_SUPPORTING_SRC_COMPAT.contains((Object)tag.tagName) && (srcCompatValue = this.getAttributeValue("http://schemas.android.com/apk/res-auto", "srcCompat")) != null) {
                return srcCompatValue;
            }
            String value2 = null;
            if (namespace == null) {
                value2 = tag.getAttribute(localName);
            } else if (namespace.equals("http://schemas.android.com/apk/res/android") || namespace.equals("http://schemas.android.com/apk/res-auto")) {
                String toolsPrefix = (String)this.myNamespacePrefixes.get((Object)"http://schemas.android.com/tools");
                if (toolsPrefix == null) {
                    return tag.getAttribute(localName, namespace);
                }
                int n2 = tag.attributes.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    AttributeSnapshot attribute = tag.attributes.get(i2);
                    if (!localName.equals(attribute.name)) continue;
                    if (toolsPrefix.equals(attribute.prefix)) {
                        value2 = attribute.value;
                        if (value2 != null && value2.isEmpty()) {
                            value2 = tag.getAttribute(localName, "http://schemas.android.com/apk/res/android") != null ? null : value2;
                        }
                        break;
                    }
                    if (!namespace.equals(attribute.namespace)) continue;
                    value2 = attribute.value;
                }
            } else if (!"http://schemas.android.com/tools".equals(namespace)) {
                n = tag.attributes.size();
                for (int i3 = 0; i3 < n; ++i3) {
                    AttributeSnapshot attribute = tag.attributes.get(i3);
                    if (!localName.equals(attribute.name) || !namespace.equals(attribute.namespace) && !"http://schemas.android.com/apk/res-auto".equals(attribute.namespace)) continue;
                    value2 = attribute.value;
                    break;
                }
            } else {
                value2 = tag.getAttribute(localName, namespace);
            }
            if (value2 != null) {
                if ("match_parent".equals(value2) && ("layout_width".equals(localName) || "layout_height".equals(localName)) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                    return "fill_parent";
                }
                n = value2.length();
                for (int i4 = 0; i4 < n; ++i4) {
                    char c = value2.charAt(i4);
                    if (c != '&' && c != '\\') continue;
                    value2 = ValueXmlHelper.unescapeResourceString((String)value2, (boolean)true, (boolean)false);
                    break;
                }
            }
            return value2;
        }
        return null;
    }

    public int getDepth() {
        return this.myNodeStack.size();
    }

    public String getName() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            TagSnapshot currentNode = this.getCurrentNode();
            assert (currentNode != null);
            String name = currentNode.tagName;
            String viewHandlerTag = currentNode.getAttribute("useHandler", "http://schemas.android.com/tools");
            if (StringUtil.isNotEmpty((String)viewHandlerTag)) {
                name = viewHandlerTag;
            }
            if (name.equals("fragment")) {
                String navGraph;
                String layout2 = currentNode.getAttribute("layout", "http://schemas.android.com/tools");
                if (layout2 == null && (navGraph = currentNode.getAttribute("navGraph", "http://schemas.android.com/apk/res-auto")) != null && this.myResourceResolver != null) {
                    layout2 = NavXmlHelperKt.getStartDestLayoutId(navGraph, this.myRoot.tag.getProject(), this.myResourceResolver);
                }
                if (layout2 != null) {
                    return "include";
                }
                String fragmentId = currentNode.getAttribute("class");
                if ((fragmentId == null || fragmentId.isEmpty()) && ((fragmentId = currentNode.getAttribute("name", "http://schemas.android.com/apk/res/android")) == null || fragmentId.isEmpty())) {
                    fragmentId = currentNode.getAttribute("id", "http://schemas.android.com/apk/res/android");
                }
                this.myLogger.warning("missing.fragment", "Missing fragment association", null, (Object)fragmentId);
            } else if (name.endsWith("Compat") && name.indexOf(46) == -1) {
                return name.substring(0, name.length() - "Compat".length());
            }
            return name;
        }
        return null;
    }

    public String getNamespace() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            TagSnapshot currentNode = this.getCurrentNode();
            assert (currentNode != null);
            return currentNode.namespace;
        }
        return null;
    }

    public String getPrefix() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            TagSnapshot currentNode = this.getCurrentNode();
            assert (currentNode != null);
            return currentNode.prefix;
        }
        return null;
    }

    public String getNamespace(String prefix) {
        for (int i2 = this.myNodeStack.size() - 1; i2 >= 0; --i2) {
            String uri = this.myNodeStack.get((int)i2).namespaceDeclarations.get(prefix);
            if (uri == null) continue;
            return uri;
        }
        return null;
    }

    public boolean isEmptyElementTag() throws XmlPullParserException {
        if (this.myParsingState == 2) {
            TagSnapshot currentNode = this.getCurrentNode();
            assert (currentNode != null);
            return currentNode.children.isEmpty();
        }
        throw new XmlPullParserException("Call to isEmptyElementTag while not in START_TAG", (XmlPullParser)this, null);
    }

    @Override
    protected void onNextFromStartDocument() {
        if (this.myRoot != null) {
            this.push(this.myRoot);
            this.myParsingState = 2;
        } else {
            this.myParsingState = 1;
        }
    }

    @Override
    protected void onNextFromStartTag() {
        TagSnapshot node = this.getCurrentNode();
        assert (node != null);
        List<TagSnapshot> children = node.children;
        if (!children.isEmpty()) {
            this.push(children.get(0));
            this.myParsingState = 2;
        } else {
            this.myParsingState = this.myParsingState == 0 ? 1 : 3;
        }
    }

    @Override
    protected void onNextFromEndTag() {
        TagSnapshot node = this.getCurrentNode();
        assert (node != null);
        TagSnapshot sibling = node.getNextSibling();
        if (sibling != null) {
            node = sibling;
            this.pop();
            this.push(node);
            this.myParsingState = 2;
        } else {
            this.pop();
            this.myParsingState = this.myNodeStack.isEmpty() ? 1 : 3;
        }
    }

    public void setProvideViewCookies(boolean provideViewCookies) {
        this.myProvideViewCookies = provideViewCookies;
    }

    private static int distanceToLayoutTag(@NotNull XmlTag tag) {
        if (tag == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(35);
        }
        int distance = 0;
        while ((tag = tag.getParentTag()) != null) {
            String tagName = tag.getName();
            if (!"merge".equals(tagName)) {
                ++distance;
            }
            if (!"layout".equals(tagName)) continue;
            break;
        }
        return tag != null ? distance : -1;
    }

    private static TagSnapshot createSnapshot(@NotNull XmlTag tag, boolean honorMergeParentTag) {
        String rootTag;
        if (tag == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(36);
        }
        Consumer<TagSnapshot> tagDecorator = TAG_SNAPSHOT_DECORATOR;
        if (tag.getName().equals("layout")) {
            final String layoutRootName = tag.getContainingFile().getVirtualFile().getNameWithoutExtension();
            tagDecorator = tagDecorator.andThen(new Consumer<TagSnapshot>(){
                int counter = 0;

                @Override
                public void accept(TagSnapshot snapshot) {
                    if (snapshot.tag == null) {
                        return;
                    }
                    if (LayoutPsiPullParser.distanceToLayoutTag(snapshot.tag) == 1) {
                        snapshot.setAttribute("tag", "http://schemas.android.com/apk/res/android", "android", "layout/" + layoutRootName + "_" + this.counter++, false);
                    }
                }
            });
        }
        if ((tag = LayoutPsiPullParser.getRootTag(tag)) == null || tag.isEmpty() && tag.getName().isEmpty()) {
            return EMPTY_LAYOUT;
        }
        switch (rootTag = tag.getName()) {
            case "fragment": {
                return LayoutPsiPullParser.createSnapshotForViewFragment(tag);
            }
            case "FrameLayout": {
                return LayoutPsiPullParser.createSnapshotForFrameLayout(tag, tagDecorator);
            }
            case "merge": {
                return LayoutPsiPullParser.createSnapshotForMerge(tag, honorMergeParentTag, tagDecorator);
            }
        }
        return TagSnapshot.createTagSnapshot(tag, tagDecorator);
    }

    @NotNull
    private static TagSnapshot createSnapshotForViewFragment(@NotNull XmlTag rootTag) {
        if (rootTag == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(37);
        }
        XmlAttribute[] psiAttributes = rootTag.getAttributes();
        ArrayList attributes = Lists.newArrayListWithCapacity((int)psiAttributes.length);
        for (XmlAttribute psiAttribute : psiAttributes) {
            AttributeSnapshot attribute = AttributeSnapshot.createAttributeSnapshot(psiAttribute);
            if (attribute == null) continue;
            attributes.add(attribute);
        }
        ArrayList includeAttributes = Lists.newArrayListWithCapacity((int)psiAttributes.length);
        for (XmlAttribute psiAttribute : psiAttributes) {
            AttributeSnapshot attribute;
            String localName;
            String name = psiAttribute.getName();
            if (name.startsWith("xmlns:") || (localName = psiAttribute.getLocalName()).startsWith("layout_margin") || localName.startsWith("padding") || localName.equals("id") || (attribute = AttributeSnapshot.createAttributeSnapshot(psiAttribute)) == null) continue;
            includeAttributes.add(attribute);
        }
        TagSnapshot include = TagSnapshot.createSyntheticTag(null, "fragment", "", "", includeAttributes, Collections.emptyList());
        TagSnapshot tagSnapshot = TagSnapshot.createSyntheticTag(rootTag, "FrameLayout", "", "", attributes, Collections.singletonList(include));
        if (tagSnapshot == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(38);
        }
        return tagSnapshot;
    }

    @NotNull
    private static TagSnapshot createSnapshotForFrameLayout(@NotNull XmlTag rootTag, @NotNull Consumer<TagSnapshot> tagDecorator) {
        String visibleChild;
        String prefix;
        if (rootTag == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(39);
        }
        if (tagDecorator == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(40);
        }
        TagSnapshot root = TagSnapshot.createTagSnapshot(rootTag, tagDecorator);
        String layout2 = rootTag.getAttributeValue("layout", "http://schemas.android.com/tools");
        if (layout2 != null && root.children.isEmpty() && (prefix = rootTag.getPrefixByNamespace("http://schemas.android.com/apk/res/android")) != null) {
            ArrayList children;
            root.children = children = Lists.newArrayList();
            ArrayList attributes = Lists.newArrayListWithExpectedSize((int)3);
            attributes.add(new AttributeSnapshot("", "", "layout", layout2));
            attributes.add(new AttributeSnapshot("http://schemas.android.com/apk/res/android", prefix, "layout_width", "fill_parent"));
            attributes.add(new AttributeSnapshot("http://schemas.android.com/apk/res/android", prefix, "layout_height", "fill_parent"));
            TagSnapshot element = TagSnapshot.createSyntheticTag(null, "include", "", "", attributes, Collections.emptyList());
            children.add(element);
        }
        if ((visibleChild = rootTag.getAttributeValue("visibleChildren", "http://schemas.android.com/tools")) != null) {
            HashSet indices = Sets.newHashSet();
            for (String s : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)visibleChild)) {
                try {
                    indices.add(Integer.parseInt(s));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            String prefix2 = rootTag.getPrefixByNamespace("http://schemas.android.com/apk/res/android");
            if (prefix2 != null) {
                int n = root.children.size();
                for (int i2 = 0; i2 < n; ++i2) {
                    TagSnapshot child = root.children.get(i2);
                    boolean visible = indices.contains(i2);
                    child.setAttribute("visibility", "http://schemas.android.com/apk/res/android", prefix2, visible ? "visible" : "gone");
                }
            }
        }
        TagSnapshot tagSnapshot = root;
        if (tagSnapshot == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(41);
        }
        return tagSnapshot;
    }

    @NotNull
    private static TagSnapshot createSnapshotForMerge(@NotNull XmlTag rootTag, boolean honorMergeParentTag, @NotNull Consumer<TagSnapshot> tagDecorator) {
        String parentTag;
        if (rootTag == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(42);
        }
        if (tagDecorator == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(43);
        }
        TagSnapshot root = TagSnapshot.createTagSnapshot(rootTag, tagDecorator);
        String string = parentTag = honorMergeParentTag ? rootTag.getAttributeValue("parentTag", "http://schemas.android.com/tools") : null;
        if (parentTag == null) {
            TagSnapshot tagSnapshot = root;
            if (tagSnapshot == null) {
                LayoutPsiPullParser.$$$reportNull$$$0(44);
            }
            return tagSnapshot;
        }
        List<AttributeSnapshot> attributes = AttributeSnapshot.createAttributesForTag(rootTag);
        LayoutPsiPullParser.addAttributeIfMissing(rootTag, "layout_width", attributes);
        LayoutPsiPullParser.addAttributeIfMissing(rootTag, "layout_height", attributes);
        TagSnapshot tagSnapshot = TagSnapshot.createSyntheticTag(rootTag, parentTag, "", "", attributes, root.children);
        if (tagSnapshot == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(45);
        }
        return tagSnapshot;
    }

    private static void addAttributeIfMissing(@NotNull XmlTag tag, @NotNull String attrName, @NotNull List<AttributeSnapshot> attributes) {
        String value2;
        if (tag == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(46);
        }
        if (attrName == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(47);
        }
        if (attributes == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(48);
        }
        if ((value2 = tag.getAttributeValue(attrName, "http://schemas.android.com/apk/res/android")) == null) {
            value2 = tag.getAttributeValue(attrName, "http://schemas.android.com/tools");
        }
        if (value2 == null) {
            attributes.add(new AttributeSnapshot("http://schemas.android.com/apk/res/android", tag.getPrefixByNamespace("http://schemas.android.com/apk/res/android"), attrName, "match_parent"));
        }
    }

    public static XmlTag getRootTag(@NotNull XmlTag tag) {
        if (tag == null) {
            LayoutPsiPullParser.$$$reportNull$$$0(49);
        }
        if (tag.getName().equals("layout")) {
            for (XmlTag subTag : tag.getSubTags()) {
                String subTagName = subTag.getName();
                if (subTagName.equals("data")) continue;
                return subTag;
            }
            return null;
        }
        return tag;
    }

    public void setUseSrcCompat(boolean useSrcCompat) {
        this.myUseSrcCompat = useSrcCompat;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 38: 
            case 41: 
            case 44: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 38: 
            case 41: 
            case 44: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 13: 
            case 20: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 38: 
            case 41: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/parsers/LayoutPsiPullParser";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "density";
                break;
            }
            case 12: 
            case 15: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 16: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutNamespace";
                break;
            }
            case 17: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 35: 
            case 36: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 37: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTag";
                break;
            }
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagDecorator";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/parsers/LayoutPsiPullParser";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNamespacesMap";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAaptDeclaredAttrs";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "findDeclaredAaptAttrs";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "pop";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createSnapshotForViewFragment";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createSnapshotForFrameLayout";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createSnapshotForMerge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 38: 
            case 41: 
            case 44: 
            case 45: {
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "push";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "distanceToLayoutTag";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createSnapshot";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createSnapshotForViewFragment";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createSnapshotForFrameLayout";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createSnapshotForMerge";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "addAttributeIfMissing";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getRootTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 38: 
            case 41: 
            case 44: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class AttributeFilteredLayoutParser
    extends LayoutPsiPullParser {
        private final RenderTask.AttributeFilter myFilter;

        public AttributeFilteredLayoutParser(@NotNull XmlTag root, @NotNull ILayoutLog logger, RenderTask.AttributeFilter filter2) {
            if (root == null) {
                AttributeFilteredLayoutParser.$$$reportNull$$$0(0);
            }
            if (logger == null) {
                AttributeFilteredLayoutParser.$$$reportNull$$$0(1);
            }
            super(root, logger, true, null);
            this.myFilter = filter2;
        }

        public AttributeFilteredLayoutParser(@NotNull XmlFile file, @NotNull ILayoutLog logger, RenderTask.AttributeFilter filter2) {
            if (file == null) {
                AttributeFilteredLayoutParser.$$$reportNull$$$0(2);
            }
            if (logger == null) {
                AttributeFilteredLayoutParser.$$$reportNull$$$0(3);
            }
            super(file, logger, true);
            this.myFilter = filter2;
        }

        @Override
        public String getAttributeValue(String namespace, String localName) {
            String value2;
            XmlTag tag;
            TagSnapshot element;
            if (this.myFilter != null && (element = this.getCurrentNode()) != null && (tag = element.tag) != null && (value2 = ApplicationManager.getApplication().isReadAccessAllowed() ? this.myFilter.getAttribute(tag, namespace, localName) : (String)ApplicationManager.getApplication().runReadAction(() -> this.myFilter.getAttribute(tag, namespace, localName))) != null) {
                if (value2.isEmpty()) {
                    return null;
                }
                return value2;
            }
            return super.getAttributeValue(namespace, localName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "logger";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/rendering/parsers/LayoutPsiPullParser$AttributeFilteredLayoutParser";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

