/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.imagepool;

import com.android.tools.idea.rendering.imagepool.ImagePool;
import com.google.common.base.FinalizablePhantomReference;
import com.google.common.base.FinalizableReferenceQueue;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ForwardingQueue;
import com.google.common.collect.Sets;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImagePoolImpl
implements ImagePool {
    private static final boolean DEBUG = false;
    private static final Bucket NULL_BUCKET = new Bucket(0, 0, 0);
    private final int[] myBucketSizes;
    private final HashMap<String, Bucket> myPool;
    private final BiFunction<Integer, Integer, Function<Integer, Integer>> myBucketSizingPolicy;
    private final FinalizableReferenceQueue myFinalizableReferenceQueue;
    private final Set<Reference<?>> myReferences;
    private final LongAdder myTotalAllocatedBytes;
    private final LongAdder myTotalInUseBytes;
    private final ImagePool.Stats myStats;
    private boolean isDisposed;

    ImagePoolImpl(@NotNull int[] bucketSizes, @NotNull BiFunction<Integer, Integer, Function<Integer, Integer>> bucketSizingPolicy) {
        if (bucketSizes == null) {
            ImagePoolImpl.$$$reportNull$$$0(0);
        }
        if (bucketSizingPolicy == null) {
            ImagePoolImpl.$$$reportNull$$$0(1);
        }
        this.myPool = new HashMap();
        this.myFinalizableReferenceQueue = new FinalizableReferenceQueue();
        this.myReferences = Sets.newConcurrentHashSet();
        this.myTotalAllocatedBytes = new LongAdder();
        this.myTotalInUseBytes = new LongAdder();
        this.myStats = new ImagePool.Stats(){

            @Override
            public long totalBytesAllocated() {
                return ImagePoolImpl.this.myTotalAllocatedBytes.sum();
            }

            @Override
            public long totalBytesInUse() {
                return ImagePoolImpl.this.myTotalInUseBytes.sum();
            }
        };
        this.isDisposed = false;
        this.myBucketSizes = bucketSizes;
        Arrays.sort(this.myBucketSizes);
        this.myBucketSizingPolicy = bucketSizingPolicy;
    }

    @NotNull
    private static String getPoolKey(int w, int h, int type) {
        String string = "" + w + 'x' + h + '-' + type;
        if (string == null) {
            ImagePoolImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private Bucket getTypeBucket(int w, int h, int type) {
        if (this.myBucketSizingPolicy.apply(w, h).apply(type) == 0) {
            Bucket bucket = NULL_BUCKET;
            if (bucket == null) {
                ImagePoolImpl.$$$reportNull$$$0(3);
            }
            return bucket;
        }
        int widthBucket = -1;
        int heightBucket = -1;
        for (int bucketMinSize : this.myBucketSizes) {
            if (widthBucket == -1 && w < bucketMinSize) {
                widthBucket = bucketMinSize;
                if (heightBucket != -1) break;
            }
            if (heightBucket != -1 || h >= bucketMinSize) continue;
            heightBucket = bucketMinSize;
            if (widthBucket != -1) break;
        }
        if (widthBucket == -1 || heightBucket == -1) {
            Bucket bucket = NULL_BUCKET;
            if (bucket == null) {
                ImagePoolImpl.$$$reportNull$$$0(4);
            }
            return bucket;
        }
        String poolKey = ImagePoolImpl.getPoolKey(widthBucket, heightBucket, type);
        int finalWidthBucket = widthBucket;
        int finalHeightBucket = heightBucket;
        Bucket bucket = this.myPool.computeIfAbsent(poolKey, k -> {
            int size = this.myBucketSizingPolicy.apply(finalWidthBucket, finalHeightBucket).apply(type);
            if (size == 0) {
                return NULL_BUCKET;
            }
            return new Bucket(finalWidthBucket, finalHeightBucket, size);
        });
        if (bucket == null) {
            ImagePoolImpl.$$$reportNull$$$0(5);
        }
        return bucket;
    }

    @NotNull
    ImageImpl create(final int w, final int h, final int type, final @Nullable Consumer<BufferedImage> freedCallback) {
        BufferedImage image;
        assert (!this.isDisposed) : "ImagePool already disposed";
        final Bucket bucket = this.getTypeBucket(w, h, type);
        try {
            SoftReference imageRef = (SoftReference)bucket.remove();
            while ((image = (BufferedImage)imageRef.get()) == null) {
                imageRef = (SoftReference)bucket.remove();
            }
            long totalSize = image.getWidth() * image.getHeight();
            this.myTotalInUseBytes.add(totalSize * 4L);
            if (image.getRaster().getDataBuffer().getDataType() == 3) {
                Arrays.fill(((DataBufferInt)image.getRaster().getDataBuffer()).getData(), 0);
            } else {
                Graphics2D g = image.createGraphics();
                g.setComposite(AlphaComposite.Clear);
                g.fillRect(0, 0, w, h);
                g.dispose();
            }
        }
        catch (NoSuchElementException e) {
            int newImageWidth = Math.max(bucket.myMinWidth, w);
            int newImageHeight = Math.max(bucket.myMinHeight, h);
            image = new BufferedImage(newImageWidth, newImageHeight, type);
            image.setAccelerationPriority(0.9f);
            long estimatedSize = newImageWidth * newImageHeight * 4;
            this.myTotalAllocatedBytes.add(estimatedSize);
            this.myTotalInUseBytes.add(estimatedSize);
        }
        ImageImpl pooledImage = new ImageImpl(w, h, image);
        final BufferedImage imagePointer = image;
        FinalizablePhantomReference<ImagePool.Image> reference2 = new FinalizablePhantomReference<ImagePool.Image>((ImagePool.Image)pooledImage, this.myFinalizableReferenceQueue){

            public void finalizeReferent() {
                if (ImagePoolImpl.this.myReferences.remove((Object)this)) {
                    boolean accepted = bucket.offer(new SoftReference<BufferedImage>(imagePointer));
                    long estimatedSize = imagePointer.getWidth() * imagePointer.getHeight() * 4;
                    if (!accepted) {
                        ImagePoolImpl.this.myTotalAllocatedBytes.add(-estimatedSize);
                    } else {
                        ImagePoolImpl.this.myTotalInUseBytes.add(-estimatedSize);
                    }
                    if (freedCallback != null) {
                        freedCallback.accept(imagePointer);
                    }
                }
            }
        };
        pooledImage.myOwnReference = (FinalizablePhantomReference)reference2;
        this.myReferences.add((Reference<?>)reference2);
        ImageImpl imageImpl = pooledImage;
        if (imageImpl == null) {
            ImagePoolImpl.$$$reportNull$$$0(6);
        }
        return imageImpl;
    }

    @Override
    @NotNull
    public ImagePool.Image create(int w, int h, int type) {
        ImageImpl imageImpl = this.create(w, h, type, null);
        if (imageImpl == null) {
            ImagePoolImpl.$$$reportNull$$$0(7);
        }
        return imageImpl;
    }

    @Override
    @NotNull
    public ImagePool.Image copyOf(@Nullable BufferedImage origin) {
        if (origin == null) {
            ImagePool.Image image = ImagePool.NULL_POOLED_IMAGE;
            if (image == null) {
                ImagePoolImpl.$$$reportNull$$$0(8);
            }
            return image;
        }
        int w = origin.getWidth();
        int h = origin.getHeight();
        int type = origin.getType();
        ImageImpl image = this.create(w, h, type, null);
        image.drawFrom(origin);
        ImageImpl imageImpl = image;
        if (imageImpl == null) {
            ImagePoolImpl.$$$reportNull$$$0(9);
        }
        return imageImpl;
    }

    @Override
    @Nullable
    public ImagePool.Stats getStats() {
        return this.myStats;
    }

    @Override
    public void dispose() {
        this.isDisposed = true;
        this.myFinalizableReferenceQueue.close();
        this.myReferences.clear();
        this.myPool.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bucketSizes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bucketSizingPolicy";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/imagepool/ImagePoolImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/imagepool/ImagePoolImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPoolKey";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeBucket";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "copyOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ImageImpl
    implements ImagePool.Image {
        private FinalizablePhantomReference<ImagePool.Image> myOwnReference;
        private ReadWriteLock myLock;
        @Nullable
        BufferedImage myBuffer;
        final int myWidth;
        final int myHeight;

        private ImageImpl(int w, int h, @NotNull BufferedImage image) {
            if (image == null) {
                ImageImpl.$$$reportNull$$$0(0);
            }
            this.myOwnReference = null;
            this.myLock = new ReentrantReadWriteLock();
            assert (w <= image.getWidth() && h <= image.getHeight());
            this.myWidth = w;
            this.myHeight = h;
            this.myBuffer = image;
        }

        @Override
        public int getWidth() {
            assert (this.myBuffer != null) : "Image was already disposed";
            return this.myWidth;
        }

        @Override
        public int getHeight() {
            assert (this.myBuffer != null) : "Image was already disposed";
            return this.myHeight;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drawImageTo(@NotNull Graphics g, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
            if (g == null) {
                ImageImpl.$$$reportNull$$$0(1);
            }
            assert (this.myBuffer != null) : "Image was already disposed";
            this.myLock.readLock().lock();
            try {
                g.drawImage(this.myBuffer, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
            }
            finally {
                this.myLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(@NotNull Consumer<Graphics2D> command) {
            if (command == null) {
                ImageImpl.$$$reportNull$$$0(2);
            }
            assert (this.myBuffer != null) : "Image was already disposed";
            this.myLock.readLock().lock();
            try {
                Graphics2D g = this.myBuffer.createGraphics();
                try {
                    command.accept(g);
                }
                finally {
                    g.dispose();
                }
            }
            finally {
                this.myLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public BufferedImage getCopy(@Nullable GraphicsConfiguration gc, int x, int y, int w, int h) {
            assert (this.myBuffer != null) : "Image was already disposed";
            this.myLock.readLock().lock();
            if (x + w > this.myWidth) {
                throw new IndexOutOfBoundsException(String.format("x + y is out bounds (image width is = %d)", h));
            }
            if (y + h > this.myHeight) {
                throw new IndexOutOfBoundsException(String.format("y + h is out bounds (image height is = %d)", h));
            }
            BufferedImage newImage = gc != null ? gc.createCompatibleImage(w, h) : new BufferedImage(w, h, this.myBuffer.getType());
            Graphics2D g = newImage.createGraphics();
            try {
                g.drawImage(this.myBuffer, 0, 0, w, h, x, y, x + w, y + h, null);
            }
            finally {
                g.dispose();
            }
            BufferedImage bufferedImage = newImage;
            BufferedImage bufferedImage2 = bufferedImage;
            if (bufferedImage2 == null) {
                ImageImpl.$$$reportNull$$$0(3);
            }
            return bufferedImage2;
            finally {
                this.myLock.readLock().unlock();
            }
        }

        @Override
        @NotNull
        public BufferedImage getCopy() {
            assert (this.myBuffer != null) : "Image was already disposed";
            this.myLock.readLock().lock();
            WritableRaster raster = this.myBuffer.copyData(this.myBuffer.getRaster().createCompatibleWritableRaster(0, 0, this.myWidth, this.myHeight));
            BufferedImage bufferedImage = new BufferedImage(this.myBuffer.getColorModel(), raster, this.myBuffer.isAlphaPremultiplied(), null);
            BufferedImage bufferedImage2 = bufferedImage;
            if (bufferedImage2 == null) {
                ImageImpl.$$$reportNull$$$0(4);
            }
            return bufferedImage2;
            finally {
                this.myLock.readLock().unlock();
            }
        }

        @Override
        public void dispose() {
            assert (this.myBuffer != null) : "Image was already disposed";
            this.myLock.writeLock().lock();
            try {
                this.myBuffer = null;
                if (this.myOwnReference != null) {
                    this.myOwnReference.finalizeReferent();
                }
            }
            finally {
                this.myLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void drawFrom(@NotNull BufferedImage origin) {
            if (origin == null) {
                ImageImpl.$$$reportNull$$$0(5);
            }
            assert (this.myBuffer != null) : "Image was already disposed";
            this.myLock.readLock().lock();
            try {
                Graphics g = this.myBuffer.getGraphics();
                try {
                    g.drawImage(origin, 0, 0, null);
                }
                finally {
                    g.dispose();
                }
            }
            finally {
                this.myLock.readLock().unlock();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "image";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/rendering/imagepool/ImagePoolImpl$ImageImpl";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "origin";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/rendering/imagepool/ImagePoolImpl$ImageImpl";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCopy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "drawImageTo";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "paint";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "drawFrom";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Bucket
    extends ForwardingQueue<SoftReference<BufferedImage>> {
        private final Queue<SoftReference<BufferedImage>> myDelegate;
        private final AtomicLong myLastAccess = new AtomicLong(System.currentTimeMillis());
        private final int myMinWidth;
        private final int myMinHeight;

        public Bucket(int minWidth, int minHeight, int maxSize) {
            this.myMinWidth = minWidth;
            this.myMinHeight = minHeight;
            this.myDelegate = maxSize == 0 ? EvictingQueue.create((int)0) : new ArrayBlockingQueue(maxSize);
        }

        protected Queue<SoftReference<BufferedImage>> delegate() {
            this.myLastAccess.set(System.currentTimeMillis());
            return this.myDelegate;
        }
    }
}

