/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.api.AssetRepository;
import com.android.ide.common.rendering.api.DrawableParams;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.IImageFactory;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.ide.common.util.PathString;
import com.android.resources.LayoutDirection;
import com.android.resources.ResourceFolderType;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.tools.analytics.crash.CrashReport;
import com.android.tools.analytics.crash.CrashReporter;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.diagnostics.crash.StudioExceptionReport;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.RenderParamsFlags;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.rendering.ActionBarHandler;
import com.android.tools.idea.rendering.CachingImageFactory;
import com.android.tools.idea.rendering.IRenderLogger;
import com.android.tools.idea.rendering.IncludeReference;
import com.android.tools.idea.rendering.LayoutlibCallbackImpl;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.rendering.RenderSecurityManagerFactory;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTaskContext;
import com.android.tools.idea.rendering.imagepool.ImagePool;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.rendering.parsers.ILayoutPullParserFactory;
import com.android.tools.idea.rendering.parsers.LayoutFilePullParser;
import com.android.tools.idea.rendering.parsers.LayoutPsiPullParser;
import com.android.tools.idea.rendering.parsers.LayoutPullParsers;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.idea.res.AssetRepositoryImpl;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderTask {
    private static final Logger LOG = Logger.getInstance(RenderTask.class);
    private static final IImageFactory SIMPLE_IMAGE_FACTORY = new IImageFactory(){

        public BufferedImage getImage(int width, int height) {
            BufferedImage image = new BufferedImage(width, height, 2);
            image.setAccelerationPriority(1.0f);
            return image;
        }
    };
    private static final float MIN_DOWNSCALING_FACTOR = 0.7f;
    private static final int DOWNSCALED_IMAGE_MAX_BYTES = 2500000;
    @NotNull
    private final ImagePool myImagePool;
    @NotNull
    private final RenderTaskContext myContext;
    @NotNull
    private final RenderLogger myLogger;
    @NotNull
    private final LayoutlibCallbackImpl myLayoutlibCallback;
    @NotNull
    private final LayoutLibrary myLayoutLib;
    @NotNull
    private final HardwareConfigHelper myHardwareConfigHelper;
    private final float myDefaultQuality;
    @Nullable
    private IncludeReference myIncludedWithin;
    @NotNull
    private SessionParams.RenderingMode myRenderingMode;
    @Nullable
    private Integer myOverrideBgColor;
    private boolean myShowDecorations;
    @NotNull
    private final AssetRepositoryImpl myAssetRepository;
    private long myTimeout;
    @NotNull
    private final Locale myLocale;
    @NotNull
    private final Object myCredential;
    private boolean myProvideCookiesForIncludedViews;
    @Nullable
    private RenderSession myRenderSession;
    @NotNull
    private IImageFactory myCachingImageFactory;
    @Nullable
    private IImageFactory myImageFactoryDelegate;
    private final boolean isSecurityManagerEnabled;
    @NotNull
    private CrashReporter myCrashReporter;
    private final List<ListenableFuture<?>> myRunningFutures;
    @NotNull
    private final AtomicBoolean isDisposed;
    @Nullable
    private XmlFile myXmlFile;

    RenderTask(@NotNull AndroidFacet facet, @NotNull RenderService renderService, @NotNull Configuration configuration, @NotNull RenderLogger logger, @NotNull LayoutLibrary layoutLib, @NotNull Device device, @NotNull Object credential, @NotNull CrashReporter crashReporter, @NotNull ImagePool imagePool, @Nullable ILayoutPullParserFactory parserFactory, boolean isSecurityManagerEnabled, float quality) {
        if (facet == null) {
            RenderTask.$$$reportNull$$$0(0);
        }
        if (renderService == null) {
            RenderTask.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            RenderTask.$$$reportNull$$$0(2);
        }
        if (logger == null) {
            RenderTask.$$$reportNull$$$0(3);
        }
        if (layoutLib == null) {
            RenderTask.$$$reportNull$$$0(4);
        }
        if (device == null) {
            RenderTask.$$$reportNull$$$0(5);
        }
        if (credential == null) {
            RenderTask.$$$reportNull$$$0(6);
        }
        if (crashReporter == null) {
            RenderTask.$$$reportNull$$$0(7);
        }
        if (imagePool == null) {
            RenderTask.$$$reportNull$$$0(8);
        }
        this.myRenderingMode = SessionParams.RenderingMode.NORMAL;
        this.myShowDecorations = true;
        this.myProvideCookiesForIncludedViews = false;
        this.myRunningFutures = new LinkedList();
        this.isDisposed = new AtomicBoolean(false);
        this.isSecurityManagerEnabled = isSecurityManagerEnabled;
        if (!isSecurityManagerEnabled) {
            LOG.debug("Security manager was disabled");
        }
        this.myLogger = logger;
        this.myCredential = credential;
        this.myCrashReporter = crashReporter;
        this.myImagePool = imagePool;
        this.myAssetRepository = new AssetRepositoryImpl(facet);
        this.myHardwareConfigHelper = new HardwareConfigHelper(device);
        ScreenOrientation orientation = configuration.getFullConfig().getScreenOrientationQualifier() != null ? configuration.getFullConfig().getScreenOrientationQualifier().getValue() : ScreenOrientation.PORTRAIT;
        this.myHardwareConfigHelper.setOrientation(orientation);
        this.myLayoutLib = layoutLib;
        LocalResourceRepository appResources = ResourceRepositoryManager.getAppResources(facet);
        ActionBarHandler actionBarHandler = new ActionBarHandler(this, this.myCredential);
        Module module = facet.getModule();
        this.myLayoutlibCallback = new LayoutlibCallbackImpl(this, this.myLayoutLib, appResources, module, facet, this.myLogger, this.myCredential, actionBarHandler, parserFactory);
        if (ResourceIdManager.get(module).getFinalIdsUsed()) {
            this.myLayoutlibCallback.loadAndParseRClass();
        }
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.getInstance(facet);
        this.myLocale = configuration.getLocale();
        this.myContext = new RenderTaskContext(module.getProject(), module, configuration, moduleInfo, renderService.getPlatform(facet));
        this.myDefaultQuality = quality;
        this.restoreDefaultQuality();
    }

    public void setQuality(float quality) {
        if (quality >= 1.0f) {
            this.myCachingImageFactory = SIMPLE_IMAGE_FACTORY;
            return;
        }
        float actualSamplingFactor = 0.7f + Math.max(Math.min(quality, 1.0f), 0.0f) * 0.3f;
        long maxSize = (long)(2500000.0f * actualSamplingFactor);
        this.myCachingImageFactory = new CachingImageFactory((width, height) -> {
            int downscaleWidth = width;
            int downscaleHeight = height;
            int size = width * height;
            if ((long)size > maxSize) {
                double scale = (double)maxSize / (double)size;
                downscaleWidth = (int)((double)downscaleWidth * scale);
                downscaleHeight = (int)((double)downscaleHeight * scale);
            }
            return SIMPLE_IMAGE_FACTORY.getImage(downscaleWidth, downscaleHeight);
        });
    }

    public void restoreDefaultQuality() {
        this.setQuality(this.myDefaultQuality);
    }

    public void setXmlFile(@NotNull XmlFile file) {
        if (file == null) {
            RenderTask.$$$reportNull$$$0(9);
        }
        this.myXmlFile = file;
        ReadAction.run(() -> this.getContext().setFolderType(ResourceHelper.getFolderType((PsiFile)file)));
    }

    @Nullable
    public XmlFile getXmlFile() {
        return this.myXmlFile;
    }

    @NotNull
    public IRenderLogger getLogger() {
        RenderLogger renderLogger = this.myLogger;
        if (renderLogger == null) {
            RenderTask.$$$reportNull$$$0(10);
        }
        return renderLogger;
    }

    @NotNull
    public HardwareConfigHelper getHardwareConfigHelper() {
        HardwareConfigHelper hardwareConfigHelper = this.myHardwareConfigHelper;
        if (hardwareConfigHelper == null) {
            RenderTask.$$$reportNull$$$0(11);
        }
        return hardwareConfigHelper;
    }

    public boolean getShowDecorations() {
        return this.myShowDecorations;
    }

    public boolean isDisposed() {
        return this.isDisposed.get();
    }

    public Future<?> dispose() {
        if (this.isDisposed.getAndSet(true)) {
            assert (false) : "RenderTask was already disposed";
            return Futures.immediateFailedFuture((Throwable)new IllegalStateException("RenderTask was already disposed"));
        }
        FutureTask<Void> disposeTask = new FutureTask<Void>(() -> {
            try {
                ImmutableList currentRunningFutures;
                List<ListenableFuture<?>> list = this.myRunningFutures;
                synchronized (list) {
                    currentRunningFutures = ImmutableList.copyOf(this.myRunningFutures);
                    this.myRunningFutures.clear();
                }
                Futures.successfulAsList((Iterable)currentRunningFutures).get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.debug((Throwable)e);
            }
            this.myLayoutlibCallback.setLogger(IRenderLogger.NULL_LOGGER);
            this.myLayoutlibCallback.setResourceResolver(null);
            if (this.myRenderSession != null) {
                try {
                    RenderService.runAsyncRenderAction(() -> ((RenderSession)this.myRenderSession).dispose());
                    this.myRenderSession = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.myImageFactoryDelegate = null;
            return null;
        });
        new Thread(disposeTask, "RenderTask dispose thread").start();
        return disposeTask;
    }

    @NotNull
    public RenderTask setOverrideRenderSize(int overrideRenderWidth, int overrideRenderHeight) {
        this.myHardwareConfigHelper.setOverrideRenderSize(overrideRenderWidth, overrideRenderHeight);
        RenderTask renderTask = this;
        if (renderTask == null) {
            RenderTask.$$$reportNull$$$0(12);
        }
        return renderTask;
    }

    @NotNull
    public RenderTask setMaxRenderSize(int maxRenderWidth, int maxRenderHeight) {
        this.myHardwareConfigHelper.setMaxRenderSize(maxRenderWidth, maxRenderHeight);
        RenderTask renderTask = this;
        if (renderTask == null) {
            RenderTask.$$$reportNull$$$0(13);
        }
        return renderTask;
    }

    @NotNull
    public RenderTask setRenderingMode(@NotNull SessionParams.RenderingMode renderingMode) {
        if (renderingMode == null) {
            RenderTask.$$$reportNull$$$0(14);
        }
        this.myRenderingMode = renderingMode;
        RenderTask renderTask = this;
        if (renderTask == null) {
            RenderTask.$$$reportNull$$$0(15);
        }
        return renderTask;
    }

    @NotNull
    public RenderTask setTimeout(long timeout) {
        this.myTimeout = timeout;
        RenderTask renderTask = this;
        if (renderTask == null) {
            RenderTask.$$$reportNull$$$0(16);
        }
        return renderTask;
    }

    @NotNull
    public RenderTask setOverrideBgColor(@Nullable Integer overrideBgColor) {
        this.myOverrideBgColor = overrideBgColor;
        RenderTask renderTask = this;
        if (renderTask == null) {
            RenderTask.$$$reportNull$$$0(17);
        }
        return renderTask;
    }

    @NotNull
    public RenderTask setDecorations(boolean showDecorations) {
        this.myShowDecorations = showDecorations;
        RenderTask renderTask = this;
        if (renderTask == null) {
            RenderTask.$$$reportNull$$$0(18);
        }
        return renderTask;
    }

    public boolean getProvideCookiesForIncludedViews() {
        return this.myProvideCookiesForIncludedViews;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private RenderResult createRenderSession(@NotNull IImageFactory factory) {
        RenderSecurityManager securityManager;
        RenderTaskContext context;
        IAndroidTarget target;
        ILayoutPullParser includingParser;
        XmlFile psiFile;
        if (factory == null) {
            RenderTask.$$$reportNull$$$0(19);
        }
        if ((psiFile = this.getXmlFile()) == null) {
            throw new IllegalStateException("createRenderSession shouldn't be called on RenderTask without PsiFile");
        }
        if (this.isDisposed.get()) {
            return null;
        }
        ResourceResolver resolver = ResourceResolver.copy((ResourceResolver)this.getContext().getConfiguration().getResourceResolver());
        if (resolver == null) {
            return null;
        }
        ILayoutPullParser modelParser = LayoutPullParsers.create(this);
        if (modelParser == null) {
            return null;
        }
        this.myLayoutlibCallback.reset();
        if (modelParser instanceof LayoutPsiPullParser) {
            boolean useSrcCompat = DependencyManagementUtil.dependsOn(this.getContext().getModule(), GoogleMavenArtifactId.APP_COMPAT_V7) || DependencyManagementUtil.dependsOn(this.getContext().getModule(), GoogleMavenArtifactId.ANDROIDX_APP_COMPAT_V7);
            ((LayoutPsiPullParser)modelParser).setUseSrcCompat(useSrcCompat);
            this.myLayoutlibCallback.setAaptDeclaredResources((Map<String, TagSnapshot>)((LayoutPsiPullParser)modelParser).getAaptDeclaredAttrs());
        }
        if ((includingParser = this.getIncludingLayoutParser((RenderResources)resolver, modelParser)) != null) {
            modelParser = includingParser;
        }
        int simulatedPlatform = (target = (context = this.getContext()).getConfiguration().getTarget()) instanceof CompatibilityRenderTarget ? target.getVersion().getApiLevel() : 0;
        Module module = context.getModule();
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        SessionParams params = new SessionParams(modelParser, this.myRenderingMode, (Object)module, hardwareConfig, (RenderResources)resolver, (LayoutlibCallback)this.myLayoutlibCallback, context.getMinSdkVersion().getApiLevel(), context.getTargetSdkVersion().getApiLevel(), (LayoutLog)this.myLogger, simulatedPlatform);
        params.setAssetRepository((AssetRepository)this.myAssetRepository);
        params.setFlag(RenderParamsFlags.FLAG_KEY_ROOT_TAG, (Object)AndroidPsiUtils.getRootTagName((PsiFile)psiFile));
        params.setFlag(RenderParamsFlags.FLAG_KEY_RECYCLER_VIEW_SUPPORT, (Object)true);
        params.setFlag(RenderParamsFlags.FLAG_KEY_DISABLE_BITMAP_CACHING, (Object)true);
        params.setFlag(RenderParamsFlags.FLAG_DO_NOT_RENDER_ON_CREATE, (Object)true);
        params.setFlag(RenderParamsFlags.FLAG_KEY_RESULT_IMAGE_AUTO_SCALE, (Object)true);
        params.setExtendedViewInfoMode(true);
        MergedManifest manifestInfo = MergedManifest.get(module);
        Configuration configuration = context.getConfiguration();
        LayoutDirectionQualifier qualifier = configuration.getFullConfig().getLayoutDirectionQualifier();
        if (qualifier != null && qualifier.getValue() == LayoutDirection.RTL && !this.getLayoutLib().isRtl(this.myLocale.toLocaleId())) {
            params.setLocale("ur");
        } else {
            params.setLocale(this.myLocale.toLocaleId());
        }
        try {
            params.setRtlSupport(manifestInfo.isRtlSupported());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Device device = configuration.getDevice();
        if (!this.myShowDecorations || HardwareConfigHelper.isWear((Device)device)) {
            params.setForceNoDecor();
        } else {
            try {
                ResourceValue appLabel = manifestInfo.getApplicationLabel();
                params.setAppIcon(manifestInfo.getApplicationIcon());
                String activity = configuration.getActivity();
                if (activity != null) {
                    params.setActivityName(activity);
                    MergedManifest.ActivityAttributes attributes = manifestInfo.getActivityAttributes(activity);
                    if (attributes != null) {
                        if (attributes.getLabel() != null) {
                            appLabel = attributes.getLabel();
                        }
                        if (attributes.getIcon() != null) {
                            params.setAppIcon(attributes.getIcon());
                        }
                    }
                }
                params.setAppLabel(params.getResources().resolveResValue(appLabel).getValue());
            }
            catch (Exception appLabel) {
                // empty catch block
            }
        }
        if (this.myOverrideBgColor != null) {
            params.setOverrideBgColor(this.myOverrideBgColor.intValue());
        } else if (this.requiresTransparency()) {
            params.setOverrideBgColor(0);
        }
        params.setImageFactory(factory);
        if (this.myTimeout > 0L) {
            params.setTimeout(this.myTimeout);
        }
        this.myLayoutlibCallback.setLogger(this.myLogger);
        this.myLayoutlibCallback.setResourceResolver(resolver);
        RenderSecurityManager renderSecurityManager = securityManager = this.isSecurityManagerEnabled ? RenderSecurityManagerFactory.create(module, this.getContext().getPlatform()) : null;
        if (securityManager != null) {
            securityManager.setActive(true, this.myCredential);
        }
        try {
            RenderSession session = this.myLayoutLib.createSession(params);
            if (session.getResult().isSuccess()) {
                long now = System.nanoTime();
                session.setSystemBootTimeNanos(now);
                session.setSystemTimeNanos(now);
                session.setElapsedFrameTimeNanos(TimeUnit.MILLISECONDS.toNanos(500L));
            }
            RenderResult result2 = RenderResult.create(this, session, (PsiFile)psiFile, this.myLogger, this.myImagePool.copyOf(session.getImage()));
            this.myRenderSession = session;
            this.addDiagnostics(result2.getRenderResult());
            RenderResult renderResult = result2;
            if (securityManager != null) {
                securityManager.dispose(this.myCredential);
            }
            return renderResult;
        }
        catch (Throwable throwable) {
            try {
                if (securityManager != null) {
                    securityManager.dispose(this.myCredential);
                }
                throw throwable;
            }
            catch (RuntimeException t) {
                this.myLogger.error(null, t.getLocalizedMessage(), t, null, null);
                throw t;
            }
        }
    }

    @Nullable
    private ILayoutPullParser getIncludingLayoutParser(RenderResources resolver, ILayoutPullParser modelParser) {
        XmlFile xmlFile = this.getXmlFile();
        if (xmlFile == null) {
            throw new IllegalStateException("getIncludingLayoutParser shouldn't be called on RenderTask without PsiFile");
        }
        if (this.myIncludedWithin == null) {
            String layout2 = IncludeReference.getIncludingLayout(xmlFile);
            Module module = this.getContext().getModule();
            this.myIncludedWithin = layout2 != null ? IncludeReference.get(module, xmlFile, resolver) : IncludeReference.NONE;
        }
        ILayoutPullParser topParser = null;
        if (this.myIncludedWithin != IncludeReference.NONE) {
            assert (Comparing.equal((Object)this.myIncludedWithin.getToFile(), (Object)xmlFile.getVirtualFile()));
            VirtualFile layoutVirtualFile = this.myIncludedWithin.getFromFile();
            String queryLayoutName = ResourceHelper.getResourceName((PsiFile)xmlFile);
            this.myLayoutlibCallback.setLayoutParser(queryLayoutName, modelParser);
            PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely(this.getContext().getProject(), layoutVirtualFile);
            if (psiFile instanceof XmlFile) {
                LayoutPsiPullParser parser = LayoutPsiPullParser.create((XmlFile)psiFile, this.myLogger);
                parser.setProvideViewCookies(this.myProvideCookiesForIncludedViews);
                topParser = parser;
            } else {
                topParser = LayoutFilePullParser.create(new PathString(this.myIncludedWithin.getFromPath()), ResourceNamespace.TODO());
                if (topParser == null) {
                    this.myLogger.error(null, String.format("Could not read layout file %1$s", this.myIncludedWithin.getFromPath()), null, null, null);
                }
            }
        }
        return topParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    <V> ListenableFuture<V> runAsyncRenderAction(@NotNull Callable<V> callable) {
        if (callable == null) {
            RenderTask.$$$reportNull$$$0(20);
        }
        if (this.isDisposed.get()) {
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)new IllegalStateException("RenderTask was already disposed"));
            if (listenableFuture != null) return listenableFuture;
            RenderTask.$$$reportNull$$$0(21);
            return listenableFuture;
        }
        List<ListenableFuture<?>> list = this.myRunningFutures;
        // MONITORENTER : list
        final ListenableFuture<V> newFuture = RenderService.runAsyncRenderAction(callable);
        Futures.addCallback(newFuture, (FutureCallback)new FutureCallback<V>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(@Nullable V result2) {
                List list = RenderTask.this.myRunningFutures;
                synchronized (list) {
                    RenderTask.this.myRunningFutures.remove(newFuture);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFailure(@Nullable Throwable ignored) {
                List list = RenderTask.this.myRunningFutures;
                synchronized (list) {
                    RenderTask.this.myRunningFutures.remove(newFuture);
                }
            }
        }, (Executor)AppExecutorUtil.getAppExecutorService());
        this.myRunningFutures.add(newFuture);
        ListenableFuture<V> listenableFuture = newFuture;
        // MONITOREXIT : list
        if (listenableFuture != null) return listenableFuture;
        RenderTask.$$$reportNull$$$0(22);
        return listenableFuture;
    }

    @Nullable
    public RenderResult inflate() {
        XmlFile xmlFile = this.getXmlFile();
        if (xmlFile == null) {
            throw new IllegalStateException("inflate shouldn't be called on RenderTask without PsiFile");
        }
        if (xmlFile.getProject().isDisposed()) {
            return null;
        }
        try {
            return (RenderResult)this.runAsyncRenderAction(() -> this.createRenderSession((width, height) -> {
                if (xmlFile.getProject().isDisposed()) {
                    return null;
                }
                if (this.myImageFactoryDelegate != null) {
                    return this.myImageFactoryDelegate.getImage(width, height);
                }
                return new BufferedImage(width, height, 2);
            })).get();
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            this.myLogger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message, this.myLogger.getProject(), this.myLogger.getLinkManager(), e));
            return RenderResult.createSessionInitializationError(this, (PsiFile)xmlFile, this.myLogger, e);
        }
    }

    @NotNull
    public ListenableFuture<RenderResult> layout() {
        ListenableFuture<RenderResult> listenableFuture;
        if (this.myRenderSession == null) {
            ListenableFuture listenableFuture2 = Futures.immediateFuture(null);
            if (listenableFuture2 == null) {
                RenderTask.$$$reportNull$$$0(23);
            }
            return listenableFuture2;
        }
        assert (this.getXmlFile() != null);
        try {
            RenderSession renderSession = this.myRenderSession;
            XmlFile psiFile = this.getXmlFile();
            listenableFuture = this.runAsyncRenderAction(() -> this.lambda$layout$5(renderSession, (PsiFile)psiFile));
        }
        catch (Exception exception) {
            ListenableFuture listenableFuture3 = Futures.immediateFuture(null);
            if (listenableFuture3 == null) {
                RenderTask.$$$reportNull$$$0(25);
            }
            return listenableFuture3;
        }
        if (listenableFuture == null) {
            RenderTask.$$$reportNull$$$0(24);
        }
        return listenableFuture;
    }

    private void reportException(@NotNull Throwable e) {
        if (e == null) {
            RenderTask.$$$reportNull$$$0(26);
        }
        this.myCrashReporter.submit((CrashReport)new StudioExceptionReport.Builder().setThrowable(e).build());
    }

    @NotNull
    private ListenableFuture<RenderResult> renderInner() {
        ListenableFuture<RenderResult> listenableFuture;
        if (this.myRenderSession == null) {
            Result result2;
            RenderResult renderResult = this.inflate();
            Result result3 = result2 = renderResult != null ? renderResult.getRenderResult() : null;
            if (result2 == null || !result2.isSuccess()) {
                if (result2 != null) {
                    if (result2.getException() != null) {
                        this.reportException(result2.getException());
                    }
                    this.myLogger.error(null, result2.getErrorMessage(), result2.getException(), null, null);
                }
                ListenableFuture listenableFuture2 = Futures.immediateFuture((Object)renderResult);
                if (listenableFuture2 == null) {
                    RenderTask.$$$reportNull$$$0(27);
                }
                return listenableFuture2;
            }
        }
        XmlFile psiFile = this.getXmlFile();
        assert (psiFile != null);
        try {
            listenableFuture = this.runAsyncRenderAction(() -> this.lambda$renderInner$6((PsiFile)psiFile));
        }
        catch (Exception e) {
            this.reportException(e);
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            this.myLogger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message, this.myLogger.getProject(), this.myLogger.getLinkManager(), e));
            ListenableFuture listenableFuture3 = Futures.immediateFuture((Object)RenderResult.createSessionInitializationError(this, (PsiFile)psiFile, this.myLogger, e));
            if (listenableFuture3 == null) {
                RenderTask.$$$reportNull$$$0(29);
            }
            return listenableFuture3;
        }
        if (listenableFuture == null) {
            RenderTask.$$$reportNull$$$0(28);
        }
        return listenableFuture;
    }

    @NotNull
    ListenableFuture<RenderResult> render(@NotNull IImageFactory factory) {
        if (factory == null) {
            RenderTask.$$$reportNull$$$0(30);
        }
        this.myImageFactoryDelegate = factory;
        ListenableFuture<RenderResult> listenableFuture = this.renderInner();
        if (listenableFuture == null) {
            RenderTask.$$$reportNull$$$0(31);
        }
        return listenableFuture;
    }

    @NotNull
    public ListenableFuture<RenderResult> render() {
        ListenableFuture<RenderResult> listenableFuture = this.render(this.myCachingImageFactory);
        if (listenableFuture == null) {
            RenderTask.$$$reportNull$$$0(32);
        }
        return listenableFuture;
    }

    public void setElapsedFrameTimeNanos(long nanos) {
        if (this.myRenderSession != null) {
            this.myRenderSession.setElapsedFrameTimeNanos(nanos);
        }
    }

    private void addDiagnostics(@NotNull Result result2) {
        ILayoutPullParser layoutEmbeddedParser;
        if (result2 == null) {
            RenderTask.$$$reportNull$$$0(33);
        }
        if (!this.myLogger.hasProblems() && !result2.isSuccess()) {
            if (result2.getException() != null || result2.getErrorMessage() != null) {
                this.myLogger.error(null, result2.getErrorMessage(), result2.getException(), null, null);
            } else if (result2.getStatus() == Result.Status.ERROR_TIMEOUT) {
                this.myLogger.error(null, "Rendering timed out.", null, null, null);
            } else {
                this.myLogger.error(null, "Unknown render problem: " + result2.getStatus(), null, null, null);
            }
        } else if (this.myIncludedWithin != null && this.myIncludedWithin != IncludeReference.NONE && (layoutEmbeddedParser = this.myLayoutlibCallback.getLayoutEmbeddedParser()) != null) {
            this.myLogger.error(null, String.format("The surrounding layout (%1$s) did not actually include this layout. Remove tools:showIn=... from the root tag.", this.myIncludedWithin.getFromResourceUrl()), null, null, null);
        }
    }

    @NotNull
    public ListenableFuture<BufferedImage> renderDrawable(ResourceValue drawableResourceValue) {
        if (drawableResourceValue == null) {
            ListenableFuture listenableFuture = Futures.immediateFuture(null);
            if (listenableFuture == null) {
                RenderTask.$$$reportNull$$$0(34);
            }
            return listenableFuture;
        }
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        RenderTaskContext context = this.getContext();
        Module module = this.getContext().getModule();
        DrawableParams params = new DrawableParams(drawableResourceValue, (Object)module, hardwareConfig, (RenderResources)context.getConfiguration().getResourceResolver(), (LayoutlibCallback)this.myLayoutlibCallback, context.getMinSdkVersion().getApiLevel(), context.getTargetSdkVersion().getApiLevel(), (LayoutLog)this.myLogger);
        params.setForceNoDecor();
        params.setAssetRepository((AssetRepository)this.myAssetRepository);
        ListenableFuture<Result> futureResult = this.runAsyncRenderAction(() -> this.myLayoutLib.renderDrawable(params));
        ListenableFuture listenableFuture = Futures.transform(futureResult, result2 -> {
            Object data;
            if (result2 != null && result2.isSuccess() && (data = result2.getData()) instanceof BufferedImage) {
                return (BufferedImage)data;
            }
            return null;
        }, (Executor)AppExecutorUtil.getAppExecutorService());
        if (listenableFuture == null) {
            RenderTask.$$$reportNull$$$0(35);
        }
        return listenableFuture;
    }

    @NotNull
    public List<BufferedImage> renderDrawableAllStates(@Nullable ResourceValue drawableResourceValue) {
        block9: {
            List<BufferedImage> list;
            Object data;
            boolean supportsMultipleStates;
            block10: {
                if (drawableResourceValue == null) {
                    List<BufferedImage> list2 = Collections.emptyList();
                    if (list2 == null) {
                        RenderTask.$$$reportNull$$$0(36);
                    }
                    return list2;
                }
                HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
                RenderTaskContext context = this.getContext();
                Module module = context.getModule();
                DrawableParams params = new DrawableParams(drawableResourceValue, (Object)module, hardwareConfig, (RenderResources)context.getConfiguration().getResourceResolver(), (LayoutlibCallback)this.myLayoutlibCallback, context.getMinSdkVersion().getApiLevel(), context.getTargetSdkVersion().getApiLevel(), (LayoutLog)this.myLogger);
                params.setForceNoDecor();
                params.setAssetRepository((AssetRepository)this.myAssetRepository);
                supportsMultipleStates = this.myLayoutLib.supports(15);
                if (supportsMultipleStates) {
                    params.setFlag(RenderParamsFlags.FLAG_KEY_RENDER_ALL_DRAWABLE_STATES, (Object)Boolean.TRUE);
                }
                Result result2 = RenderService.runRenderAction(() -> this.myLayoutLib.renderDrawable(params));
                if (result2 == null || !result2.isSuccess()) break block9;
                data = result2.getData();
                if (!supportsMultipleStates || !(data instanceof List)) break block10;
                List list3 = (List)data;
                if (list3 == null) {
                    RenderTask.$$$reportNull$$$0(37);
                }
                return list3;
            }
            try {
                if (supportsMultipleStates || !(data instanceof BufferedImage)) break block9;
                list = Collections.singletonList((BufferedImage)data);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (list == null) {
                RenderTask.$$$reportNull$$$0(38);
            }
            return list;
        }
        List<BufferedImage> list = Collections.emptyList();
        if (list == null) {
            RenderTask.$$$reportNull$$$0(39);
        }
        return list;
    }

    @NotNull
    private LayoutLibrary getLayoutLib() {
        LayoutLibrary layoutLibrary = this.myLayoutLib;
        if (layoutLibrary == null) {
            RenderTask.$$$reportNull$$$0(40);
        }
        return layoutLibrary;
    }

    @NotNull
    public LayoutlibCallbackImpl getLayoutlibCallback() {
        LayoutlibCallbackImpl layoutlibCallbackImpl = this.myLayoutlibCallback;
        if (layoutlibCallbackImpl == null) {
            RenderTask.$$$reportNull$$$0(41);
        }
        return layoutlibCallbackImpl;
    }

    public boolean supportsCapability(int capability) {
        return this.myLayoutLib.supports(capability);
    }

    private boolean isNonRectangular() {
        ResourceFolderType folderType = this.getContext().getFolderType();
        return folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.MIPMAP;
    }

    private boolean requiresTransparency() {
        return this.isNonRectangular();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Map<XmlTag, ViewInfo> measureChildren(@NotNull XmlTag parent, @Nullable AttributeFilter filter2) {
        if (parent == null) {
            RenderTask.$$$reportNull$$$0(42);
        }
        LayoutPsiPullParser modelParser = LayoutPsiPullParser.create(filter2, parent, this.myLogger);
        HashMap<XmlTag, ViewInfo> map2 = new HashMap<XmlTag, ViewInfo>();
        RenderSession session = null;
        try {
            session = RenderService.runRenderAction(() -> this.measure(modelParser));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (session != null) {
            try {
                Result result2 = session.getResult();
                if (result2 != null && result2.isSuccess()) {
                    assert (session.getRootViews().size() == 1);
                    ViewInfo root = (ViewInfo)session.getRootViews().get(0);
                    List children = root.getChildren();
                    for (ViewInfo info : children) {
                        XmlTag tag = RenderService.getXmlTag(info);
                        if (tag == null) continue;
                        map2.put(tag, info);
                    }
                }
                HashMap<XmlTag, ViewInfo> hashMap = map2;
                return hashMap;
            }
            finally {
                RenderService.runAsyncRenderAction(() -> ((RenderSession)session).dispose());
            }
        }
        return null;
    }

    @Nullable
    public ViewInfo measureChild(@NotNull XmlTag tag, @Nullable AttributeFilter filter2) {
        Map<XmlTag, ViewInfo> map2;
        XmlTag parent;
        if (tag == null) {
            RenderTask.$$$reportNull$$$0(43);
        }
        if ((parent = tag.getParentTag()) != null && (map2 = this.measureChildren(parent, filter2)) != null) {
            for (Map.Entry<XmlTag, ViewInfo> entry : map2.entrySet()) {
                if (entry.getKey() != tag) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    @Nullable
    private RenderSession measure(ILayoutPullParser parser) {
        RenderTaskContext context = this.getContext();
        ResourceResolver resolver = context.getConfiguration().getResourceResolver();
        if (resolver == null) {
            return null;
        }
        this.myLayoutlibCallback.reset();
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        Module module = this.getContext().getModule();
        SessionParams params = new SessionParams(parser, SessionParams.RenderingMode.NORMAL, (Object)module, hardwareConfig, (RenderResources)resolver, (LayoutlibCallback)this.myLayoutlibCallback, context.getMinSdkVersion().getApiLevel(), context.getTargetSdkVersion().getApiLevel(), (LayoutLog)this.myLogger);
        params.setLayoutOnly();
        params.setForceNoDecor();
        params.setExtendedViewInfoMode(true);
        params.setLocale(this.myLocale.toLocaleId());
        params.setAssetRepository((AssetRepository)this.myAssetRepository);
        params.setFlag(RenderParamsFlags.FLAG_KEY_RECYCLER_VIEW_SUPPORT, (Object)true);
        MergedManifest manifestInfo = MergedManifest.get(module);
        try {
            params.setRtlSupport(manifestInfo.isRtlSupported());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.myLayoutlibCallback.setLogger(this.myLogger);
            this.myLayoutlibCallback.setResourceResolver(resolver);
            return this.myLayoutLib.createSession(params);
        }
        catch (RuntimeException t) {
            this.myLogger.error(null, t.getLocalizedMessage(), t, null, null);
            throw t;
        }
    }

    void setCrashReporter(@NotNull CrashReporter crashReporter) {
        if (crashReporter == null) {
            RenderTask.$$$reportNull$$$0(44);
        }
        this.myCrashReporter = crashReporter;
    }

    @NotNull
    public RenderTaskContext getContext() {
        RenderTaskContext renderTaskContext = this.myContext;
        if (renderTaskContext == null) {
            RenderTask.$$$reportNull$$$0(45);
        }
        return renderTaskContext;
    }

    private /* synthetic */ RenderResult lambda$renderInner$6(PsiFile psiFile) throws Exception {
        this.myRenderSession.render();
        RenderResult result2 = RenderResult.create(this, this.myRenderSession, psiFile, this.myLogger, this.myImagePool.copyOf(this.myRenderSession.getImage()));
        Result renderResult = result2.getRenderResult();
        if (renderResult.getException() != null) {
            this.reportException(renderResult.getException());
            this.myLogger.error(null, renderResult.getErrorMessage(), renderResult.getException(), null, null);
        }
        return result2;
    }

    private /* synthetic */ RenderResult lambda$layout$5(RenderSession renderSession, PsiFile psiFile) throws Exception {
        this.myRenderSession.measure();
        return RenderResult.create(this, renderSession, psiFile, this.myLogger, ImagePool.NULL_POOLED_IMAGE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutLib";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credential";
                break;
            }
            case 7: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "crashReporter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imagePool";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/RenderTask";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderingMode";
                break;
            }
            case 19: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/RenderTask";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getHardwareConfigHelper";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "setOverrideRenderSize";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "setMaxRenderSize";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "setRenderingMode";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "setTimeout";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "setOverrideBgColor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "setDecorations";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "runAsyncRenderAction";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "layout";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "renderInner";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "render";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "renderDrawable";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "renderDrawableAllStates";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutLib";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutlibCallback";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setXmlFile";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setRenderingMode";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createRenderSession";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "runAsyncRenderAction";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "reportException";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addDiagnostics";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "measureChildren";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "measureChild";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "setCrashReporter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface AttributeFilter {
        @Nullable
        public String getAttribute(@NotNull XmlTag var1, @Nullable String var2, @NotNull String var3);
    }
}

