/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.imagepool.ImagePool;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderResult {
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final RenderLogger myLogger;
    @NotNull
    private final ImmutableList<ViewInfo> myRootViews;
    @NotNull
    private final ImmutableList<ViewInfo> mySystemRootViews;
    @NotNull
    private final ImagePool.Image myImage;
    @Nullable
    private final RenderTask myRenderTask;
    @NotNull
    private final Result myRenderResult;
    @NotNull
    private final Map<Object, Map<ResourceReference, ResourceValue>> myDefaultProperties;
    @NotNull
    private final Map<Object, String> myDefaultStyles;
    @NotNull
    private final Module myModule;
    private boolean isDisposed;

    protected RenderResult(@NotNull PsiFile file, @NotNull Module module, @NotNull RenderLogger logger, @Nullable RenderTask renderTask, @NotNull Result renderResult, @NotNull ImmutableList<ViewInfo> rootViews, @NotNull ImmutableList<ViewInfo> systemRootViews, @NotNull ImagePool.Image image, @NotNull Map<Object, Map<ResourceReference, ResourceValue>> defaultProperties, @NotNull Map<Object, String> defaultStyles) {
        if (file == null) {
            RenderResult.$$$reportNull$$$0(0);
        }
        if (module == null) {
            RenderResult.$$$reportNull$$$0(1);
        }
        if (logger == null) {
            RenderResult.$$$reportNull$$$0(2);
        }
        if (renderResult == null) {
            RenderResult.$$$reportNull$$$0(3);
        }
        if (rootViews == null) {
            RenderResult.$$$reportNull$$$0(4);
        }
        if (systemRootViews == null) {
            RenderResult.$$$reportNull$$$0(5);
        }
        if (image == null) {
            RenderResult.$$$reportNull$$$0(6);
        }
        if (defaultProperties == null) {
            RenderResult.$$$reportNull$$$0(7);
        }
        if (defaultStyles == null) {
            RenderResult.$$$reportNull$$$0(8);
        }
        this.myRenderTask = renderTask;
        this.myModule = module;
        this.myFile = file;
        this.myLogger = logger;
        this.myRenderResult = renderResult;
        this.myRootViews = rootViews;
        this.mySystemRootViews = systemRootViews;
        this.myImage = image;
        this.myDefaultProperties = defaultProperties;
        this.myDefaultStyles = defaultStyles;
    }

    public void dispose() {
        this.isDisposed = true;
        this.myImage.dispose();
    }

    @NotNull
    public static RenderResult create(@NotNull RenderTask renderTask, @NotNull RenderSession session, @NotNull PsiFile file, @NotNull RenderLogger logger, @NotNull ImagePool.Image image) {
        if (renderTask == null) {
            RenderResult.$$$reportNull$$$0(9);
        }
        if (session == null) {
            RenderResult.$$$reportNull$$$0(10);
        }
        if (file == null) {
            RenderResult.$$$reportNull$$$0(11);
        }
        if (logger == null) {
            RenderResult.$$$reportNull$$$0(12);
        }
        if (image == null) {
            RenderResult.$$$reportNull$$$0(13);
        }
        List rootViews = session.getRootViews();
        List systemRootViews = session.getSystemRootViews();
        Map defaultProperties = session.getDefaultNamespacedProperties();
        Map defaultStyles = session.getDefaultStyles();
        RenderResult renderResult = new RenderResult(file, renderTask.getContext().getModule(), logger, renderTask, session.getResult(), (ImmutableList<ViewInfo>)(rootViews != null ? ImmutableList.copyOf((Collection)rootViews) : ImmutableList.of()), (ImmutableList<ViewInfo>)(systemRootViews != null ? ImmutableList.copyOf((Collection)systemRootViews) : ImmutableList.of()), image, (Map<Object, Map<ResourceReference, ResourceValue>>)(defaultProperties != null ? ImmutableMap.copyOf((Map)defaultProperties) : ImmutableMap.of()), (Map<Object, String>)(defaultStyles != null ? ImmutableMap.copyOf((Map)defaultStyles) : ImmutableMap.of()));
        if (renderResult == null) {
            RenderResult.$$$reportNull$$$0(14);
        }
        return renderResult;
    }

    @NotNull
    public static RenderResult createSessionInitializationError(@NotNull RenderTask renderTask, @NotNull PsiFile file, @NotNull RenderLogger logger, @Nullable Throwable throwable) {
        if (renderTask == null) {
            RenderResult.$$$reportNull$$$0(15);
        }
        if (file == null) {
            RenderResult.$$$reportNull$$$0(16);
        }
        if (logger == null) {
            RenderResult.$$$reportNull$$$0(17);
        }
        Module module = logger.getModule();
        assert (module != null);
        RenderResult renderResult = new RenderResult(file, module, logger, renderTask, Result.Status.ERROR_UNKNOWN.createResult("Failed to initialize session", throwable), (ImmutableList<ViewInfo>)ImmutableList.of(), (ImmutableList<ViewInfo>)ImmutableList.of(), ImagePool.NULL_POOLED_IMAGE, (Map<Object, Map<ResourceReference, ResourceValue>>)ImmutableMap.of(), (Map<Object, String>)ImmutableMap.of());
        if (renderResult == null) {
            RenderResult.$$$reportNull$$$0(18);
        }
        return renderResult;
    }

    @NotNull
    public static RenderResult createBlank(@NotNull PsiFile file) {
        if (file == null) {
            RenderResult.$$$reportNull$$$0(19);
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        assert (module != null);
        RenderResult renderResult = new RenderResult(file, module, new RenderLogger(null, module), null, Result.Status.ERROR_UNKNOWN.createResult(""), (ImmutableList<ViewInfo>)ImmutableList.of(), (ImmutableList<ViewInfo>)ImmutableList.of(), ImagePool.NULL_POOLED_IMAGE, (Map<Object, Map<ResourceReference, ResourceValue>>)ImmutableMap.of(), (Map<Object, String>)ImmutableMap.of());
        if (renderResult == null) {
            RenderResult.$$$reportNull$$$0(20);
        }
        return renderResult;
    }

    @NotNull
    public Result getRenderResult() {
        Result result2 = this.myRenderResult;
        if (result2 == null) {
            RenderResult.$$$reportNull$$$0(21);
        }
        return result2;
    }

    @NotNull
    public RenderLogger getLogger() {
        RenderLogger renderLogger = this.myLogger;
        if (renderLogger == null) {
            RenderResult.$$$reportNull$$$0(22);
        }
        return renderLogger;
    }

    @NotNull
    public ImagePool.Image getRenderedImage() {
        ImagePool.Image image = !this.isDisposed ? this.myImage : ImagePool.NULL_POOLED_IMAGE;
        if (image == null) {
            RenderResult.$$$reportNull$$$0(23);
        }
        return image;
    }

    public boolean hasImage() {
        return !this.isDisposed && this.myImage != ImagePool.NULL_POOLED_IMAGE;
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            RenderResult.$$$reportNull$$$0(24);
        }
        return psiFile;
    }

    @Nullable
    public RenderTask getRenderTask() {
        return this.myRenderTask;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            RenderResult.$$$reportNull$$$0(25);
        }
        return module;
    }

    @NotNull
    public ImmutableList<ViewInfo> getRootViews() {
        ImmutableList<ViewInfo> immutableList = this.myRootViews;
        if (immutableList == null) {
            RenderResult.$$$reportNull$$$0(26);
        }
        return immutableList;
    }

    @NotNull
    public ImmutableList<ViewInfo> getSystemRootViews() {
        ImmutableList<ViewInfo> immutableList = this.mySystemRootViews;
        if (immutableList == null) {
            RenderResult.$$$reportNull$$$0(27);
        }
        return immutableList;
    }

    @NotNull
    public Map<Object, Map<ResourceReference, ResourceValue>> getDefaultProperties() {
        Map<Object, Map<ResourceReference, ResourceValue>> map2 = this.myDefaultProperties;
        if (map2 == null) {
            RenderResult.$$$reportNull$$$0(28);
        }
        return map2;
    }

    @NotNull
    public Map<Object, String> getDefaultStyles() {
        Map<Object, String> map2 = this.myDefaultStyles;
        if (map2 == null) {
            RenderResult.$$$reportNull$$$0(29);
        }
        return map2;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("renderResult", (Object)this.myRenderResult).add("psiFile", (Object)this.myFile).add("rootViews", this.myRootViews).add("systemViews", this.mySystemRootViews).toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderResult";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootViews";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemRootViews";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultProperties";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultStyles";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderTask";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 14: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/RenderResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/RenderResult";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createSessionInitializationError";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createBlank";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderResult";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderedImage";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootViews";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemRootViews";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProperties";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultStyles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 14: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createSessionInitializationError";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createBlank";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

