/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.SdkConstants;
import com.android.builder.model.AaptOptions;
import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.rendering.api.ActionBarCallback;
import com.android.ide.common.rendering.api.AdapterBinding;
import com.android.ide.common.rendering.api.DataBindingItem;
import com.android.ide.common.rendering.api.ILayoutLog;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.support.AndroidxName;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.fonts.DownloadableFontCacheService;
import com.android.tools.idea.fonts.ProjectFonts;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.RenderParamsFlags;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.rendering.ActionBarHandler;
import com.android.tools.idea.rendering.IRenderLogger;
import com.android.tools.idea.rendering.InconvertibleClassError;
import com.android.tools.idea.rendering.LayoutMetadata;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.parsers.AaptAttrParser;
import com.android.tools.idea.rendering.parsers.ILayoutPullParserFactory;
import com.android.tools.idea.rendering.parsers.LayoutFilePullParser;
import com.android.tools.idea.rendering.parsers.LayoutPsiPullParser;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.idea.res.FileResourceReader;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.aar.ProtoXmlPullParser;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.tools.idea.util.FileExtensions;
import com.android.tools.lint.detector.api.Lint;
import com.android.utils.HtmlBuilder;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.ViewLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LayoutlibCallbackImpl
extends LayoutlibCallback {
    private static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.rendering.LayoutlibCallback");
    private static final int MAX_PARSER_INCLUDES = 50;
    private static final AndroidxName CLASS_WINDOR_DECOR_ACTION_BAR = AndroidxName.of((String)"android.support.v7.internal.app.", (String)"WindowDecorActionBar");
    private static final Set<String> NOT_VIEW = ImmutableSet.of((Object)SdkConstants.CLASS_RECYCLER_VIEW_ADAPTER.oldName(), (Object)SdkConstants.CLASS_RECYCLER_VIEW_ADAPTER.newName(), (Object)SdkConstants.CLASS_RECYCLER_VIEW_LAYOUT_MANAGER.oldName(), (Object)SdkConstants.CLASS_RECYCLER_VIEW_LAYOUT_MANAGER.newName(), (Object)CLASS_WINDOR_DECOR_ACTION_BAR.oldName(), (Object)CLASS_WINDOR_DECOR_ACTION_BAR.newName(), (Object[])new String[0]);
    public static final String FD_LAYOUTLIB = "layoutlib";
    public static final String BUILD_CACHE = "build-cache";
    @NotNull
    private final Module myModule;
    @NotNull
    private final ResourceIdManager myIdManager;
    @NotNull
    private final LayoutLibrary myLayoutLib;
    @Nullable
    private final Object myCredential;
    private final boolean myHasLegacyAppCompat;
    private final boolean myHasAndroidXAppCompat;
    private final AaptOptions.Namespacing myNamespacing;
    @NotNull
    private String myNamespace;
    @NotNull
    private IRenderLogger myLogger;
    @NotNull
    private final ViewLoader myClassLoader;
    @Nullable
    private String myLayoutName;
    @Nullable
    private ILayoutPullParser myLayoutEmbeddedParser;
    @Nullable
    private ResourceResolver myResourceResolver;
    @Nullable
    private final ActionBarHandler myActionBarHandler;
    @Nullable
    private final RenderTask myRenderTask;
    @NotNull
    private final DownloadableFontCacheService myFontCacheService;
    private boolean myUsed;
    private Set<PathString> myParserFiles;
    private int myParserCount;
    @NotNull
    public ImmutableMap<String, TagSnapshot> myAaptDeclaredResources;
    private final Map<String, ResourceValue> myFontFamilies;
    private ProjectFonts myProjectFonts;
    private String myAdaptiveIconMaskPath;
    @Nullable
    private final ILayoutPullParserFactory myLayoutPullParserFactory;
    @NotNull
    private final ResourceNamespace.Resolver myImplicitNamespaces;

    public LayoutlibCallbackImpl(@Nullable RenderTask renderTask, @NotNull LayoutLibrary layoutLib, @NotNull LocalResourceRepository projectRes, @NotNull Module module, @NotNull AndroidFacet facet, @NotNull IRenderLogger logger, @Nullable Object credential, @Nullable ActionBarHandler actionBarHandler, @Nullable ILayoutPullParserFactory parserFactory) {
        if (layoutLib == null) {
            LayoutlibCallbackImpl.$$$reportNull$$$0(0);
        }
        if (projectRes == null) {
            LayoutlibCallbackImpl.$$$reportNull$$$0(1);
        }
        if (module == null) {
            LayoutlibCallbackImpl.$$$reportNull$$$0(2);
        }
        if (facet == null) {
            LayoutlibCallbackImpl.$$$reportNull$$$0(3);
        }
        if (logger == null) {
            LayoutlibCallbackImpl.$$$reportNull$$$0(4);
        }
        this.myAaptDeclaredResources = ImmutableMap.of();
        this.myRenderTask = renderTask;
        this.myLayoutLib = layoutLib;
        this.myIdManager = ResourceIdManager.get(module);
        this.myModule = module;
        this.myLogger = logger;
        this.myCredential = credential;
        this.myClassLoader = new ViewLoader(this.myLayoutLib, facet, logger, credential);
        this.myActionBarHandler = actionBarHandler;
        this.myLayoutPullParserFactory = parserFactory;
        this.myHasLegacyAppCompat = DependencyManagementUtil.dependsOn(module, GoogleMavenArtifactId.APP_COMPAT_V7);
        this.myHasAndroidXAppCompat = DependencyManagementUtil.dependsOn(module, GoogleMavenArtifactId.ANDROIDX_APP_COMPAT_V7);
        String javaPackage = MergedManifest.get(this.myModule).getPackage();
        this.myNamespace = javaPackage != null && !javaPackage.isEmpty() ? "http://schemas.android.com/apk/res/" + javaPackage : "http://schemas.android.com/apk/res-auto";
        this.myNamespacing = ResourceRepositoryManager.getOrCreateInstance(facet).getNamespacing();
        this.myImplicitNamespaces = this.myNamespacing == AaptOptions.Namespacing.DISABLED ? ResourceNamespace.Resolver.TOOLS_ONLY : ResourceNamespace.Resolver.EMPTY_RESOLVER;
        this.myFontCacheService = DownloadableFontCacheService.getInstance();
        final ImmutableMap.Builder fontBuilder = ImmutableMap.builder();
        projectRes.accept(new ResourceVisitor(){

            @NotNull
            public ResourceVisitor.VisitResult visit(@NotNull ResourceItem resourceItem) {
                String rawXml;
                ResourceValue resourceValue2;
                if (resourceItem == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((resourceValue2 = resourceItem.getResourceValue()) != null && (rawXml = resourceValue2.getRawXmlValue()) != null && rawXml.endsWith(".xml")) {
                    fontBuilder.put((Object)rawXml, (Object)resourceValue2);
                }
                ResourceVisitor.VisitResult visitResult = ResourceVisitor.VisitResult.CONTINUE;
                if (visitResult == null) {
                    1.$$$reportNull$$$0(1);
                }
                return visitResult;
            }

            public boolean shouldVisitResourceType(@NotNull ResourceType resourceType) {
                if (resourceType == null) {
                    1.$$$reportNull$$$0(2);
                }
                return resourceType == ResourceType.FONT;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "resourceItem";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/idea/rendering/LayoutlibCallbackImpl$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "resourceType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/idea/rendering/LayoutlibCallbackImpl$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visit";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visit";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "shouldVisitResourceType";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        this.myFontFamilies = fontBuilder.build();
    }

    void reset() {
        this.myParserCount = 0;
        this.myParserFiles = null;
        this.myLayoutName = null;
        this.myLayoutEmbeddedParser = null;
        this.myAaptDeclaredResources = ImmutableMap.of();
    }

    public void setLogger(@NotNull IRenderLogger logger) {
        if (logger == null) {
            LayoutlibCallbackImpl.$$$reportNull$$$0(5);
        }
        this.myLogger = logger;
        this.myClassLoader.setLogger(logger);
    }

    @NotNull
    public ILayoutLog getLogger() {
        IRenderLogger iRenderLogger = this.myLogger;
        if (iRenderLogger == null) {
            LayoutlibCallbackImpl.$$$reportNull$$$0(6);
        }
        return iRenderLogger;
    }

    @Nullable
    public Object loadView(@NotNull String className, @NotNull Class[] constructorSignature, @NotNull Object[] constructorParameters) throws ClassNotFoundException {
        if (className == null) {
            LayoutlibCallbackImpl.$$$reportNull$$$0(7);
        }
        if (constructorSignature == null) {
            LayoutlibCallbackImpl.$$$reportNull$$$0(8);
        }
        if (constructorParameters == null) {
            LayoutlibCallbackImpl.$$$reportNull$$$0(9);
        }
        this.myUsed = true;
        if (NOT_VIEW.contains(className)) {
            return this.myClassLoader.loadClass(className, constructorSignature, constructorParameters);
        }
        return this.myClassLoader.loadView(className, constructorSignature, constructorParameters);
    }

    public Object loadClass(@NotNull String name, @Nullable Class[] constructorSignature, @Nullable Object[] constructorArgs) throws ClassNotFoundException {
        if (name == null) {
            LayoutlibCallbackImpl.$$$reportNull$$$0(10);
        }
        this.myUsed = true;
        return this.myClassLoader.loadClass(name, constructorSignature, constructorArgs);
    }

    public boolean supports(int ideFeature) {
        return ideFeature <= 19;
    }

    @NotNull
    public String getNamespace() {
        String string = this.myNamespace;
        if (string == null) {
            LayoutlibCallbackImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public ResourceReference resolveResourceId(int id) {
        return this.myIdManager.findById(id);
    }

    public int getOrGenerateResourceId(@NotNull ResourceReference resource) {
        if (resource == null) {
            LayoutlibCallbackImpl.$$$reportNull$$$0(12);
        }
        return this.myIdManager.getOrGenerateId(resource);
    }

    public boolean isUsed() {
        return this.myUsed;
    }

    @Nullable
    private static XmlPullParser getParserFromText(String fileName, @NotNull String text) {
        if (text == null) {
            LayoutlibCallbackImpl.$$$reportNull$$$0(13);
        }
        try {
            NamedXmlParser parser = new NamedXmlParser(fileName);
            parser.setInput(new StringReader(text));
            return parser;
        }
        catch (XmlPullParserException e) {
            LOG.warn("Could not create parser for " + fileName);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public XmlPullParser createXmlParserForPsiFile(@NotNull String fileName) {
        if (fileName == null) {
            LayoutlibCallbackImpl.$$$reportNull$$$0(14);
        }
        if (fileName.contains("exploded-aar") || fileName.contains(FD_LAYOUTLIB) || fileName.contains(BUILD_CACHE)) {
            return null;
        }
        boolean token = RenderSecurityManager.enterSafeRegion(this.myCredential);
        try {
            PsiFile psiFile;
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(fileName);
            if (virtualFile != null && (psiFile = AndroidPsiUtils.getPsiFileSafely(this.myModule.getProject(), virtualFile)) != null) {
                ResourceValue resourceValue2 = this.myFontFamilies.get(fileName);
                if (resourceValue2 != null) {
                    if (this.myProjectFonts == null && this.myResourceResolver != null) {
                        this.myProjectFonts = new ProjectFonts(this.myResourceResolver);
                    }
                    if (this.myProjectFonts != null) {
                        FontFamily family = this.myProjectFonts.getFont(resourceValue2.getResourceUrl().toString());
                        String fontFamilyXml = this.myFontCacheService.toXml(family);
                        if (fontFamilyXml == null) {
                            this.myFontCacheService.download(family);
                            XmlPullParser xmlPullParser = null;
                            return xmlPullParser;
                        }
                        XmlPullParser xmlPullParser = LayoutlibCallbackImpl.getParserFromText(fileName, fontFamilyXml);
                        return xmlPullParser;
                    }
                }
                String psiText = ApplicationManager.getApplication().isReadAccessAllowed() ? psiFile.getText() : (String)ApplicationManager.getApplication().runReadAction(() -> ((PsiFile)psiFile).getText());
                XmlPullParser xmlPullParser = LayoutlibCallbackImpl.getParserFromText(fileName, psiText);
                return xmlPullParser;
            }
            XmlPullParser xmlPullParser = null;
            return xmlPullParser;
        }
        finally {
            RenderSecurityManager.exitSafeRegion(token);
        }
    }

    @Nullable
    public XmlPullParser createXmlParserForFile(@NotNull String fileName) {
        if (fileName == null) {
            LayoutlibCallbackImpl.$$$reportNull$$$0(15);
        }
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(FileResourceReader.readBytes(fileName));
            Object parser = XmlUtils.isProtoXml((InputStream)stream) ? new NamedProtoXmlParser(fileName) : new NamedXmlParser(fileName);
            parser.setInput(stream, null);
            return parser;
        }
        catch (IOException | XmlPullParserException e) {
            return null;
        }
    }

    @NotNull
    public XmlPullParser createXmlParser() {
        NamedXmlParser namedXmlParser = new NamedXmlParser(null);
        if (namedXmlParser == null) {
            LayoutlibCallbackImpl.$$$reportNull$$$0(16);
        }
        return namedXmlParser;
    }

    public void setLayoutParser(@Nullable String layoutName, @Nullable ILayoutPullParser layoutParser) {
        this.myLayoutName = layoutName;
        this.myLayoutEmbeddedParser = layoutParser;
    }

    public void setAaptDeclaredResources(@NotNull Map<String, TagSnapshot> resources) {
        if (resources == null) {
            LayoutlibCallbackImpl.$$$reportNull$$$0(17);
        }
        this.myAaptDeclaredResources = ImmutableMap.copyOf(resources);
    }

    @Nullable
    public ILayoutPullParser getLayoutEmbeddedParser() {
        return this.myLayoutEmbeddedParser;
    }

    @Nullable
    public ILayoutPullParser getParser(@NotNull ResourceValue layoutResource) {
        ImmutableMap<String, TagSnapshot> declared;
        ILayoutPullParser parser;
        String value2;
        if (layoutResource == null) {
            LayoutlibCallbackImpl.$$$reportNull$$$0(18);
        }
        if ((value2 = layoutResource.getValue()) == null) {
            return null;
        }
        if (!this.myAaptDeclaredResources.isEmpty() && layoutResource.getResourceType() == ResourceType.AAPT) {
            TagSnapshot aaptResource = (TagSnapshot)this.myAaptDeclaredResources.get((Object)layoutResource.getValue());
            parser = LayoutPsiPullParser.create(aaptResource, ResourceNamespace.TODO(), (ILayoutLog)this.myLogger);
        } else {
            PathString pathString = ResourceHelper.toFileResourcePathString(value2);
            if (pathString == null) {
                return null;
            }
            parser = this.getParser(layoutResource.getName(), layoutResource.getNamespace(), pathString);
        }
        if (parser instanceof AaptAttrParser && !(declared = ((AaptAttrParser)parser).getAaptDeclaredAttrs()).isEmpty()) {
            this.myAaptDeclaredResources = ImmutableMap.builder().putAll(((AaptAttrParser)parser).getAaptDeclaredAttrs()).putAll(this.myAaptDeclaredResources).build();
        }
        return parser;
    }

    @Nullable
    private ILayoutPullParser getParser(@NotNull String layoutName, @NotNull ResourceNamespace namespace, @NotNull PathString xml) {
        ILayoutPullParser parser;
        if (layoutName == null) {
            LayoutlibCallbackImpl.$$$reportNull$$$0(19);
        }
        if (namespace == null) {
            LayoutlibCallbackImpl.$$$reportNull$$$0(20);
        }
        if (xml == null) {
            LayoutlibCallbackImpl.$$$reportNull$$$0(21);
        }
        if (this.myParserFiles != null && this.myParserFiles.contains(xml)) {
            if (this.myParserCount > 50) {
                if (this.findCycles()) {
                    throw new RuntimeException("Aborting rendering");
                }
                this.myParserCount = 0;
            }
        } else {
            if (this.myParserFiles == null) {
                this.myParserFiles = new HashSet<PathString>();
            }
            this.myParserFiles.add(xml);
        }
        ++this.myParserCount;
        if (this.myLayoutPullParserFactory != null && (parser = this.myLayoutPullParserFactory.create(xml, this)) != null) {
            return parser;
        }
        if (layoutName.equals(this.myLayoutName) && namespace != ResourceNamespace.ANDROID) {
            parser = this.myLayoutEmbeddedParser;
            this.myLayoutEmbeddedParser = null;
            return parser;
        }
        if (xml.getFilesystemUri().getScheme().equals("file")) {
            PsiFile psiFile;
            VirtualFile file;
            String parentName = xml.getParentFileName();
            String path = xml.getRawPath();
            if (parentName != null && !path.contains("exploded-aar") && !path.contains(FD_LAYOUTLIB) && !path.contains(BUILD_CACHE) && (parentName.startsWith("layout") || parentName.startsWith("drawable") || parentName.startsWith("menu")) && (file = FileExtensions.toVirtualFile(xml)) != null && (psiFile = AndroidPsiUtils.getPsiFileSafely(this.myModule.getProject(), file)) instanceof XmlFile) {
                LayoutPsiPullParser parser2 = LayoutPsiPullParser.create((XmlFile)psiFile, this.myLogger, false);
                parser2.setUseSrcCompat(this.myHasLegacyAppCompat || this.myHasAndroidXAppCompat);
                if (parentName.startsWith("layout")) {
                    parser2.setProvideViewCookies(this.myRenderTask != null && this.myRenderTask.getProvideCookiesForIncludedViews());
                }
                return parser2;
            }
        }
        return LayoutFilePullParser.create(xml, namespace);
    }

    private boolean findCycles() {
        HashMap<String, File> layoutToFile = new HashMap<String, File>();
        ArrayListMultimap includeMap = ArrayListMultimap.create();
        for (PathString path : this.myParserFiles) {
            File file = path.toFile();
            if (file == null || !file.exists()) continue;
            String layoutName = Lint.getLayoutName((File)file);
            layoutToFile.put(layoutName, file);
            try {
                String xml = Files.toString((File)file, (Charset)Charsets.UTF_8);
                Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
                if (document == null) continue;
                NodeList includeNodeList = document.getElementsByTagName("include");
                int n = includeNodeList.getLength();
                for (int i2 = 0; i2 < n; ++i2) {
                    Element include = (Element)includeNodeList.item(i2);
                    String included = include.getAttribute("layout");
                    if (!included.startsWith("@layout/")) continue;
                    String resource = included.substring("@layout/".length());
                    includeMap.put((Object)layoutName, (Object)resource);
                }
                NodeList fragmentNodeList = document.getElementsByTagName("fragment");
                int n2 = fragmentNodeList.getLength();
                for (int i3 = 0; i3 < n2; ++i3) {
                    Element fragment = (Element)fragmentNodeList.item(i3);
                    String included = fragment.getAttributeNS("http://schemas.android.com/tools", "layout");
                    if (!included.startsWith("@layout/")) continue;
                    String resource = included.substring("@layout/".length());
                    includeMap.put((Object)layoutName, (Object)resource);
                }
            }
            catch (IOException e) {
                LOG.warn("Could not check file " + file + " for cyclic dependencies", (Throwable)e);
            }
        }
        if (!includeMap.isEmpty()) {
            for (String from : includeMap.keySet()) {
                HashSet visiting;
                List<String> chain = LayoutlibCallbackImpl.dfs(from, visiting = Sets.newHashSetWithExpectedSize((int)includeMap.size()), (Multimap<String, String>)includeMap);
                if (chain == null) continue;
                RenderProblem.Html problem = RenderProblem.create(HighlightSeverity.WARNING);
                HtmlBuilder builder = problem.getHtmlBuilder();
                builder.add("Found cyclical <include> chain: ");
                boolean first = true;
                Collections.reverse(chain);
                for (String layout2 : chain) {
                    if (first) {
                        first = false;
                    } else {
                        builder.add(" includes ");
                    }
                    File file = (File)layoutToFile.get(layout2);
                    if (file != null) {
                        try {
                            String url = SdkUtils.fileToUrlString((File)file);
                            builder.addLink(layout2, url);
                        }
                        catch (MalformedURLException e) {
                            builder.add(layout2);
                        }
                        continue;
                    }
                    builder.add(layout2);
                }
                this.myLogger.addMessage(problem);
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static List<String> dfs(String from, Set<String> visiting, Multimap<String, String> includeMap) {
        visiting.add(from);
        Collection includes = includeMap.get((Object)from);
        if (includes != null && !includes.isEmpty()) {
            for (String include : includes) {
                if (visiting.contains(include)) {
                    LinkedList list = Lists.newLinkedList();
                    list.add(include);
                    list.add(from);
                    return list;
                }
                List<String> chain = LayoutlibCallbackImpl.dfs(include, visiting, includeMap);
                if (chain == null) continue;
                chain.add(from);
                return chain;
            }
        }
        visiting.remove(from);
        return null;
    }

    @Nullable
    public Object getAdapterItemValue(ResourceReference adapterView, Object adapterCookie, ResourceReference itemRef, int fullPosition, int typePosition, int fullChildPosition, int typeChildPosition, ResourceReference viewRef, LayoutlibCallback.ViewAttribute viewAttribute, Object defaultValue) {
        if (viewAttribute == LayoutlibCallback.ViewAttribute.TEXT && adapterView.getName().startsWith("android_widget_")) {
            String name = adapterView.getName();
            if (viewRef.getName().equals("text2")) {
                return "Sub Item";
            }
            if (fullPosition == 0) {
                String viewName = name.substring("android_widget_".length());
                if (viewName.equals("ExpandableListView")) {
                    return "ExpandableList";
                }
                return viewName;
            }
            return "Next Item";
        }
        if (itemRef.getNamespace() == ResourceNamespace.ANDROID && viewRef.getName().equals("text2")) {
            return "Sub Item " + (fullPosition + 1);
        }
        if (viewAttribute == LayoutlibCallback.ViewAttribute.TEXT && ((String)defaultValue).isEmpty()) {
            return "Item " + (fullPosition + 1);
        }
        return null;
    }

    @Nullable
    public static String getListAdapterViewFqcn(@NotNull Class<?> clz) {
        String fqcn;
        if (clz == null) {
            LayoutlibCallbackImpl.$$$reportNull$$$0(22);
        }
        if ((fqcn = clz.getName()).endsWith("ListView") || fqcn.equals("android.widget.GridView") || fqcn.equals("android.widget.Spinner")) {
            return fqcn;
        }
        if (fqcn.startsWith("android.")) {
            return null;
        }
        Class<?> superClass = clz.getSuperclass();
        if (superClass != null) {
            return LayoutlibCallbackImpl.getListAdapterViewFqcn(superClass);
        }
        return null;
    }

    private boolean isWithinIllegalParent(@NotNull Object viewObject, int depth) {
        Object parent;
        Result result2;
        String fqcn;
        if (viewObject == null) {
            LayoutlibCallbackImpl.$$$reportNull$$$0(23);
        }
        if ((fqcn = viewObject.getClass().getName()).endsWith("CalendarView") || !fqcn.startsWith("android.") && !fqcn.startsWith("com.android.internal.widget.")) {
            return true;
        }
        if (depth > 0 && (result2 = this.myLayoutLib.getViewParent(viewObject)).isSuccess() && (parent = result2.getData()) != null) {
            return this.isWithinIllegalParent(parent, depth - 1);
        }
        return false;
    }

    @Nullable
    public AdapterBinding getAdapterBinding(ResourceReference adapterView, Object adapterCookie, Object viewObject) {
        Map map2;
        AdapterBinding binding;
        AdapterBinding binding2;
        if (adapterCookie instanceof TagSnapshot) {
            binding2 = LayoutMetadata.getNodeBinding(viewObject, (TagSnapshot)adapterCookie);
            if (binding2 != null) {
                return binding2;
            }
        } else if (adapterCookie instanceof XmlTag) {
            binding2 = LayoutMetadata.getNodeBinding(viewObject, TagSnapshot.createTagSnapshotWithoutChildren((XmlTag)adapterCookie));
            if (binding2 != null) {
                return binding2;
            }
        } else if (adapterCookie instanceof Map && (binding = LayoutMetadata.getNodeBinding(viewObject, map2 = (Map)adapterCookie)) != null) {
            return binding;
        }
        if (viewObject == null) {
            return null;
        }
        String listFqcn = LayoutlibCallbackImpl.getListAdapterViewFqcn(viewObject.getClass());
        if (listFqcn == null) {
            return null;
        }
        if (this.isWithinIllegalParent(viewObject, 2)) {
            return null;
        }
        int count = listFqcn.endsWith("GridView") ? 24 : 12;
        AdapterBinding binding3 = new AdapterBinding(count);
        if (listFqcn.endsWith("ExpandableListView")) {
            binding3.addItem(new DataBindingItem("simple_expandable_list_item_2", true, 1));
        } else if (listFqcn.equals("android.widget.Spinner")) {
            binding3.addItem(new DataBindingItem("simple_spinner_item", true, 1));
        } else {
            binding3.addItem(new DataBindingItem("simple_list_item_2", true, 1));
        }
        return binding3;
    }

    public void setResourceResolver(@Nullable ResourceResolver resolver) {
        this.myResourceResolver = resolver;
    }

    public void loadAndParseRClass() {
        this.myClassLoader.loadAndParseRClassSilently();
    }

    public ActionBarCallback getActionBarCallback() {
        return this.myActionBarHandler;
    }

    @Nullable
    public ActionBarHandler getActionBarHandler() {
        return this.myActionBarHandler;
    }

    @Nullable
    public <T> T getFlag(@NotNull SessionParams.Key<T> key) {
        if (key == null) {
            LayoutlibCallbackImpl.$$$reportNull$$$0(24);
        }
        if (key.equals((Object)RenderParamsFlags.FLAG_KEY_APPLICATION_PACKAGE)) {
            return (T)this.getPackage();
        }
        if (key.equals((Object)RenderParamsFlags.FLAG_KEY_RECYCLER_VIEW_SUPPORT)) {
            return (T)Boolean.TRUE;
        }
        if (key.equals((Object)RenderParamsFlags.FLAG_KEY_XML_FILE_PARSER_SUPPORT)) {
            return (T)Boolean.TRUE;
        }
        if (key.equals((Object)RenderParamsFlags.FLAG_KEY_ADAPTIVE_ICON_MASK_PATH)) {
            return (T)this.myAdaptiveIconMaskPath;
        }
        if (key.equals((Object)RenderParamsFlags.FLAG_KEY_RENDER_HIGH_QUALITY_SHADOW)) {
            return StudioFlags.NELE_RENDER_HIGH_QUALITY_SHADOW.get();
        }
        if (key.equals((Object)RenderParamsFlags.FLAG_KEY_ENABLE_SHADOW)) {
            return StudioFlags.NELE_ENABLE_SHADOW.get();
        }
        return null;
    }

    @Nullable
    private String getPackage() {
        AndroidModuleInfo info = AndroidModuleInfo.getInstance(this.myModule);
        return info == null ? null : info.getPackage();
    }

    @NotNull
    public Class<?> findClass(@NotNull String name) throws ClassNotFoundException {
        block5: {
            Class<?> clazz;
            if (name == null) {
                LayoutlibCallbackImpl.$$$reportNull$$$0(25);
            }
            try {
                Class<?> aClass = this.myClassLoader.loadClass(name, false);
                if (aClass == null) break block5;
                clazz = aClass;
            }
            catch (InconvertibleClassError e) {
                throw new ClassNotFoundException(name + " not found.", e);
            }
            if (clazz == null) {
                LayoutlibCallbackImpl.$$$reportNull$$$0(26);
            }
            return clazz;
        }
        throw new ClassNotFoundException(name + " not found.");
    }

    @NotNull
    public ResourceNamespace.Resolver getImplicitNamespaces() {
        ResourceNamespace.Resolver resolver = this.myImplicitNamespaces;
        if (resolver == null) {
            LayoutlibCallbackImpl.$$$reportNull$$$0(27);
        }
        return resolver;
    }

    public void setAdaptiveIconMaskPath(@NotNull String adaptiveIconMaskPath) {
        if (adaptiveIconMaskPath == null) {
            LayoutlibCallbackImpl.$$$reportNull$$$0(28);
        }
        this.myAdaptiveIconMaskPath = adaptiveIconMaskPath;
    }

    public boolean hasLegacyAppCompat() {
        return this.myHasLegacyAppCompat;
    }

    public boolean hasAndroidXAppCompat() {
        return this.myHasAndroidXAppCompat;
    }

    public boolean isResourceNamespacingRequired() {
        return this.myNamespacing == AaptOptions.Namespacing.REQUIRED;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: 
            case 16: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: 
            case 16: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutLib";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 6: 
            case 11: 
            case 16: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/LayoutlibCallbackImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorSignature";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorParameters";
                break;
            }
            case 10: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resources";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutResource";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xml";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clz";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewObject";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adaptiveIconMaskPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/LayoutlibCallbackImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createXmlParser";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findClass";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitNamespaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setLogger";
                break;
            }
            case 6: 
            case 11: 
            case 16: 
            case 26: 
            case 27: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadView";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadClass";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getOrGenerateResourceId";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getParserFromText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createXmlParserForPsiFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createXmlParserForFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setAaptDeclaredResources";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getParser";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getListAdapterViewFqcn";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isWithinIllegalParent";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getFlag";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setAdaptiveIconMaskPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: 
            case 16: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NamedProtoXmlParser
    extends ProtoXmlPullParser {
        @Nullable
        private final String myName;
        private boolean hasToolsNamespace;

        public NamedProtoXmlParser(@Nullable String name) {
            this.myName = name;
            try {
                this.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            }
            catch (XmlPullParserException e) {
                throw new Error(e);
            }
        }

        @Override
        public int next() throws XmlPullParserException, IOException {
            int tagType = super.next();
            if (!this.hasToolsNamespace && tagType == 2 || this.hasToolsNamespace && tagType == 3) {
                this.hasToolsNamespace = this.getNamespace("tools") != null;
            }
            return tagType;
        }

        @Override
        public String getAttributeValue(@Nullable String namespace, @NotNull String name) {
            String toolsValue;
            if (name == null) {
                NamedProtoXmlParser.$$$reportNull$$$0(0);
            }
            if (this.hasToolsNamespace && "http://schemas.android.com/apk/res/android".equals(namespace) && (toolsValue = super.getAttributeValue("http://schemas.android.com/tools", name)) != null) {
                return toolsValue;
            }
            return super.getAttributeValue(namespace, name);
        }

        public String toString() {
            return this.myName != null ? this.myName : super.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/rendering/LayoutlibCallbackImpl$NamedProtoXmlParser", "getAttributeValue"));
        }
    }

    private static class NamedXmlParser
    extends KXmlParser {
        @Nullable
        private final String myName;
        private boolean hasToolsNamespace;

        public NamedXmlParser(@Nullable String name) {
            this.myName = name;
            try {
                this.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            }
            catch (XmlPullParserException e) {
                throw new Error("Internal error", e);
            }
        }

        public int next() throws XmlPullParserException, IOException {
            int tagType = super.next();
            if (!this.hasToolsNamespace && tagType == 2 || this.hasToolsNamespace && tagType == 3) {
                this.hasToolsNamespace = this.getNamespace("tools") != null;
            }
            return tagType;
        }

        public String getAttributeValue(@Nullable String namespace, @NotNull String name) {
            String toolsValue;
            if (name == null) {
                NamedXmlParser.$$$reportNull$$$0(0);
            }
            if (this.hasToolsNamespace && "http://schemas.android.com/apk/res/android".equals(namespace) && (toolsValue = super.getAttributeValue("http://schemas.android.com/tools", name)) != null) {
                return toolsValue;
            }
            return super.getAttributeValue(namespace, name);
        }

        public String toString() {
            return this.myName != null ? this.myName : super.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/rendering/LayoutlibCallbackImpl$NamedXmlParser", "getAttributeValue"));
        }
    }
}

