/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.google.common.collect.Maps;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.util.Function;
import icons.AndroidArtworkIcons;
import icons.AndroidIcons;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class FlagManager {
    private static final FlagManager ourInstance = new FlagManager();
    @NotNull
    private final Map<String, Icon> myImageMap = Maps.newHashMap();
    private static boolean ourFlagSettingAvailable = true;
    private static Method ourLanguageFlagMethod;

    @NotNull
    public static FlagManager get() {
        FlagManager flagManager = ourInstance;
        if (flagManager == null) {
            FlagManager.$$$reportNull$$$0(0);
        }
        return flagManager;
    }

    private FlagManager() {
    }

    public Icon getFlag(String language, String region) {
        assert (region != null || language != null);
        if (region == null || region.isEmpty()) {
            assert (language != null);
            if (!FlagManager.showFlagsForLanguages()) {
                return null;
            }
            if (language.equals("ca")) {
                return this.getIcon("catalonia");
            }
            if (language.equals("gd")) {
                return this.getIcon("scotland");
            }
            if (language.equals("cy")) {
                return this.getIcon("wales");
            }
            region = LocaleManager.getLanguageRegion((String)language);
        }
        if (region == null || region.isEmpty() || region.length() == 3) {
            return null;
        }
        return this.getIcon(region);
    }

    public static boolean showFlagsForLanguages() {
        if (ourFlagSettingAvailable) {
            try {
                if (ourLanguageFlagMethod == null) {
                    ourLanguageFlagMethod = UISettings.class.getDeclaredMethod("getLanguageFlags", new Class[0]);
                }
                return (Boolean)ourLanguageFlagMethod.invoke((Object)UISettings.getInstance(), new Object[0]);
            }
            catch (Throwable t) {
                ourFlagSettingAvailable = false;
                return false;
            }
        }
        return true;
    }

    public Icon getFlag(FolderConfiguration configuration) {
        return this.getFlag(configuration.getLocaleQualifier());
    }

    public Icon getFlag(LocaleQualifier locale) {
        if (locale == null) {
            return null;
        }
        String languageCode = locale.getLanguage();
        String regionCode = locale.getRegion();
        if ("__".equals(languageCode)) {
            languageCode = null;
        }
        return this.getFlag(languageCode, regionCode);
    }

    public Icon getFlagForFolderName(@NotNull String folder) {
        FolderConfiguration configuration;
        if (folder == null) {
            FlagManager.$$$reportNull$$$0(1);
        }
        if ((configuration = FolderConfiguration.getConfigForFolder((String)folder)) != null) {
            return FlagManager.get().getFlag(configuration);
        }
        return null;
    }

    public Icon getFlag(@NotNull String region) {
        if (region == null) {
            FlagManager.$$$reportNull$$$0(2);
        }
        assert (region.length() == 2 && Character.isUpperCase(region.charAt(0)) && Character.isUpperCase(region.charAt(1))) : region;
        return this.getIcon(region);
    }

    private Icon getIcon(@NotNull String base) {
        Icon flagImage;
        if (base == null) {
            FlagManager.$$$reportNull$$$0(3);
        }
        if ((flagImage = this.myImageMap.get(base)) == null) {
            if (this.myImageMap.containsKey(base)) {
                return null;
            }
            String flagFileName = base.toLowerCase(Locale.US) + ".png";
            try {
                flagImage = IconLoader.findIcon((String)("/icons/flags/" + flagFileName), AndroidIcons.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (flagImage == null) {
                flagImage = AndroidArtworkIcons.Icons.Flags.Flag_empty;
            }
            this.myImageMap.put(base, flagImage);
        }
        return flagImage;
    }

    @NotNull
    public ListCellRenderer getLanguageCodeCellRenderer() {
        final Function<Object, String> nameMapper = FlagManager.getLanguageNameMapper();
        ColoredListCellRenderer coloredListCellRenderer = new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value2, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.append((String)nameMapper.fun(value2));
                this.setIcon(FlagManager.this.getFlag((String)value2, null));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/rendering/FlagManager$1", "customizeCellRenderer"));
            }
        };
        if (coloredListCellRenderer == null) {
            FlagManager.$$$reportNull$$$0(4);
        }
        return coloredListCellRenderer;
    }

    @NotNull
    public ListCellRenderer getRegionCodeCellRenderer() {
        final Function<Object, String> nameMapper = FlagManager.getRegionNameMapper();
        ColoredListCellRenderer coloredListCellRenderer = new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value2, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.append((String)nameMapper.fun(value2));
                this.setIcon(FlagManager.this.getFlag(null, (String)value2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/rendering/FlagManager$2", "customizeCellRenderer"));
            }
        };
        if (coloredListCellRenderer == null) {
            FlagManager.$$$reportNull$$$0(5);
        }
        return coloredListCellRenderer;
    }

    @NotNull
    public static Function<Object, String> getLanguageNameMapper() {
        Function<Object, String> function = new Function<Object, String>(){

            public String fun(Object value2) {
                String languageCode = (String)value2;
                if (languageCode.equals("__")) {
                    return "Any Language";
                }
                String languageName = LocaleManager.getLanguageName((String)languageCode);
                if (languageName != null && languageName.length() > 30) {
                    languageName = languageName.substring(0, 27) + "...";
                }
                return String.format("%1$s: %2$s", languageCode, languageName);
            }
        };
        if (function == null) {
            FlagManager.$$$reportNull$$$0(6);
        }
        return function;
    }

    @NotNull
    public static Function<Object, String> getRegionNameMapper() {
        Function<Object, String> function = new Function<Object, String>(){

            public String fun(Object value2) {
                String regionCode = (String)value2;
                if (regionCode.equals("__")) {
                    return "Any Region";
                }
                String regionName = LocaleManager.getRegionName((String)regionCode);
                if (regionName != null && regionName.length() > 30) {
                    regionName = regionName.substring(0, 27) + "...";
                }
                return String.format("%1$s: %2$s", regionCode, regionName);
            }
        };
        if (function == null) {
            FlagManager.$$$reportNull$$$0(7);
        }
        return function;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/FlagManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/FlagManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageCodeCellRenderer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegionCodeCellRenderer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageNameMapper";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegionNameMapper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFlagForFolderName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFlag";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

