/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.LayoutLog;
import com.android.tools.idea.rendering.InconvertibleClassError;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Shorts;
import com.intellij.openapi.util.SystemInfo;
import java.lang.reflect.Method;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public class ClassConverter {
    private static final String ORIGINAL_SUFFIX = "_Original";
    private static final String ERROR_METHOD_DESCRIPTION;

    @NotNull
    public static byte[] rewriteClass(@NotNull byte[] classData) {
        if (classData == null) {
            ClassConverter.$$$reportNull$$$0(0);
        }
        int current = ClassConverter.getCurrentClassVersion();
        byte[] byArray = ClassConverter.rewriteClass(classData, current, 0);
        if (byArray == null) {
            ClassConverter.$$$reportNull$$$0(1);
        }
        return byArray;
    }

    @VisibleForTesting
    @NotNull
    static byte[] rewriteClass(@NotNull byte[] classData, final int maxVersion, final int minVersion) {
        if (classData == null) {
            ClassConverter.$$$reportNull$$$0(2);
        }
        assert (maxVersion >= minVersion);
        ClassWriter classWriter = new ClassWriter(0);
        ClassVisitor classVisitor = new ClassVisitor(327680, (ClassVisitor)classWriter){
            private String myClassName;

            public void visit(int version2, int access, String name, String signature, String superName, String[] interfaces) {
                this.myClassName = name;
                if (version2 > maxVersion) {
                    version2 = maxVersion;
                }
                if (version2 < minVersion) {
                    version2 = minVersion;
                }
                super.visit(version2, access, name, signature, superName, interfaces);
            }

            private void wrapMethod(int access, String name, String desc, String signature, String[] exceptions) {
                assert (Type.getReturnType((String)desc) == Type.VOID_TYPE) : "Non void return methods are not supported";
                MethodVisitor mw = super.visitMethod(access, name, desc, signature, exceptions);
                Label tryStart = new Label();
                Label tryEnd = new Label();
                Label tryHandler = new Label();
                mw.visitTryCatchBlock(tryStart, tryEnd, tryHandler, "java/lang/Throwable");
                mw.visitLabel(tryStart);
                mw.visitVarInsn(25, 0);
                Type[] argumentTypes = Type.getMethodType((String)desc).getArgumentTypes();
                int nLocals = 1;
                for (Type argType : argumentTypes) {
                    mw.visitVarInsn(argType.getOpcode(21), nLocals++);
                }
                mw.visitMethodInsn(182, this.myClassName, name + ClassConverter.ORIGINAL_SUFFIX, desc, false);
                mw.visitLabel(tryEnd);
                Label exit = new Label();
                mw.visitJumpInsn(167, exit);
                mw.visitLabel(tryHandler);
                mw.visitFrame(4, 0, null, 1, new Object[]{"java/lang/Throwable"});
                int throwableIndex = nLocals++;
                mw.visitVarInsn(58, throwableIndex);
                mw.visitMethodInsn(184, "com/android/layoutlib/bridge/Bridge", "getLog", "()Lcom/android/ide/common/rendering/api/LayoutLog;", false);
                mw.visitLdcInsn((Object)"broken");
                mw.visitLdcInsn((Object)(name + " error"));
                mw.visitVarInsn(25, throwableIndex);
                mw.visitInsn(1);
                mw.visitMethodInsn(182, "com/android/ide/common/rendering/api/LayoutLog", "error", ERROR_METHOD_DESCRIPTION, false);
                if ("onMeasure".equals(name)) {
                    mw.visitVarInsn(25, 0);
                    mw.visitInsn(3);
                    mw.visitInsn(3);
                    mw.visitMethodInsn(182, this.myClassName, "setMeasuredDimension", desc, false);
                }
                mw.visitLabel(exit);
                mw.visitFrame(3, 0, null, 0, null);
                mw.visitInsn(177);
                mw.visitMaxs(Math.max(argumentTypes.length + 1, 5), nLocals);
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (("onLayout".equals(name) && "(ZIIII)V".equals(desc) || "onMeasure".equals(name) && "(II)V".equals(desc) || "onDraw".equals(name) && "(Landroid/graphics/Canvas;)V".equals(desc)) && (access & 5) != 0) {
                    this.wrapMethod(access, name, desc, signature, exceptions);
                    int modifiedAccess = access & 0xFFFFFFFE & 0xFFFFFFFB | 2;
                    return super.visitMethod(modifiedAccess, name + ClassConverter.ORIGINAL_SUFFIX, desc, signature, exceptions);
                }
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
        };
        ClassReader reader = new ClassReader(classData);
        reader.accept(classVisitor, 0);
        byte[] byArray = classWriter.toByteArray();
        if (byArray == null) {
            ClassConverter.$$$reportNull$$$0(3);
        }
        return byArray;
    }

    public static int jdkToClassVersion(@NotNull String version2) {
        int dot;
        if (version2 == null) {
            ClassConverter.$$$reportNull$$$0(4);
        }
        if ((dot = version2.indexOf(46)) != -1) {
            int major;
            int end = version2.length();
            for (int i2 = ++dot; i2 < end; ++i2) {
                if (Character.isDigit(version2.charAt(i2))) continue;
                end = i2;
                break;
            }
            if (end > dot && (major = Integer.valueOf(version2.substring(dot, end)).intValue()) > 0) {
                return major + 44;
            }
        }
        return -1;
    }

    public static String classVersionToJdk(int version2) {
        return "1." + Integer.toString(version2 - 44);
    }

    public static int findHighestMajorVersion(Collection<Throwable> list) {
        int result2 = 0;
        for (Throwable t : list) {
            if (!(t instanceof InconvertibleClassError)) continue;
            InconvertibleClassError error = (InconvertibleClassError)t;
            result2 = Math.max(result2, error.getMajor());
        }
        return result2;
    }

    public static String getCurrentJdkVersion() {
        String version2 = SystemInfo.JAVA_VERSION;
        int suffix = version2.indexOf(95);
        if (suffix != -1) {
            version2 = version2.substring(0, suffix);
        }
        return version2;
    }

    public static int getCurrentClassVersion() {
        return ClassConverter.jdkToClassVersion(SystemInfo.JAVA_VERSION);
    }

    public static boolean isValidClassFile(@NotNull byte[] classData) {
        if (classData == null) {
            ClassConverter.$$$reportNull$$$0(5);
        }
        return classData.length >= 7 && ClassConverter.getMagic(classData) == -889275714;
    }

    public static int getMagic(@NotNull byte[] classData) {
        if (classData == null) {
            ClassConverter.$$$reportNull$$$0(6);
        }
        return Ints.fromBytes((byte)classData[0], (byte)classData[1], (byte)classData[2], (byte)classData[3]);
    }

    public static short getMajorVersion(byte[] classData) {
        return Shorts.fromBytes((byte)classData[6], (byte)classData[7]);
    }

    public static short getMinorVersion(byte[] classData) {
        return Shorts.fromBytes((byte)classData[4], (byte)classData[5]);
    }

    static {
        String desc;
        block2: {
            try {
                desc = Type.getMethodDescriptor((Method)LayoutLog.class.getMethod("error", String.class, String.class, Throwable.class, Object.class));
            }
            catch (NoSuchMethodException e) {
                desc = "";
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        ERROR_METHOD_DESCRIPTION = desc;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classData";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/ClassConverter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/ClassConverter";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "rewriteClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "rewriteClass";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "jdkToClassVersion";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValidClassFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMagic";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

