/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.refactoring.rtl;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.refactoring.rtl.RtlRefactoringUsageInfo;
import com.android.tools.idea.refactoring.rtl.RtlSupportProperties;
import com.android.tools.idea.refactoring.rtl.RtlSupportUsageViewDescriptor;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.dom.layout.LayoutDomFileDescription;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RtlSupportProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.refactoring.AddRTLSupportProcessor");
    private static final String REFACTORING_NAME = AndroidBundle.message("android.refactoring.rtl.addsupport.title", new Object[0]);
    public static final String RES_V_QUALIFIER = "-v";
    public static final String RES_V17_QUALIFIER = "-v17";
    private final RtlSupportProperties myProperties;
    private final Project myProject;
    public static final int RTL_TARGET_SDK_START = 17;
    private static Map<String, String> ourMapMirroredAttributeName = new ImmutableMap.Builder().put((Object)"paddingLeft", (Object)"paddingStart").put((Object)"paddingRight", (Object)"paddingEnd").put((Object)"layout_marginLeft", (Object)"layout_marginStart").put((Object)"layout_marginRight", (Object)"layout_marginEnd").put((Object)"drawableLeft", (Object)"drawableStart").put((Object)"drawableRight", (Object)"drawableEnd").put((Object)"layout_toLeftOf", (Object)"layout_toStartOf").put((Object)"layout_toRightOf", (Object)"layout_toEndOf").put((Object)"layout_alignLeft", (Object)"layout_alignStart").put((Object)"layout_alignRight", (Object)"layout_alignEnd").put((Object)"layout_alignParentLeft", (Object)"layout_alignParentStart").put((Object)"layout_alignParentRight", (Object)"layout_alignParentEnd").put((Object)"layout_constraintRight_toRightOf", (Object)"layout_constraintEnd_toEndOf").put((Object)"layout_constraintRight_toLeftOf", (Object)"layout_constraintEnd_toStartOf").put((Object)"layout_constraintLeft_toLeftOf", (Object)"layout_constraintStart_toStartOf").put((Object)"layout_constraintLeft_toRightOf", (Object)"layout_constraintStart_toEndOf").build();

    protected RtlSupportProcessor(Project project, @NotNull RtlSupportProperties properties) {
        if (properties == null) {
            RtlSupportProcessor.$$$reportNull$$$0(0);
        }
        super(project);
        this.myProject = project;
        this.myProperties = properties;
        this.setPreviewUsages(true);
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            RtlSupportProcessor.$$$reportNull$$$0(1);
        }
        RtlSupportUsageViewDescriptor rtlSupportUsageViewDescriptor = new RtlSupportUsageViewDescriptor();
        if (rtlSupportUsageViewDescriptor == null) {
            RtlSupportProcessor.$$$reportNull$$$0(2);
        }
        return rtlSupportUsageViewDescriptor;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        if (!this.myProperties.hasSomethingToDo()) {
            if (UsageInfo.EMPTY_ARRAY == null) {
                RtlSupportProcessor.$$$reportNull$$$0(3);
            }
            return UsageInfo.EMPTY_ARRAY;
        }
        ArrayList<UsageInfo> list = new ArrayList<UsageInfo>();
        if (this.myProperties.updateAndroidManifest) {
            this.addManifestRefactoring(list);
        }
        if (this.myProperties.updateLayouts) {
            this.addLayoutRefactoring(list);
        }
        int size = list.size();
        UsageInfo[] usageInfoArray = list.toArray(new UsageInfo[size]);
        if (usageInfoArray == null) {
            RtlSupportProcessor.$$$reportNull$$$0(4);
        }
        return usageInfoArray;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            RtlSupportProcessor.$$$reportNull$$$0(5);
        }
        block6: for (UsageInfo usageInfo : usages) {
            RtlRefactoringUsageInfo refactoring = (RtlRefactoringUsageInfo)usageInfo;
            switch (refactoring.getType()) {
                case MANIFEST_SUPPORTS_RTL: {
                    RtlSupportProcessor.performRefactoringForAndroidManifestApplicationTag(refactoring);
                    continue block6;
                }
                case MANIFEST_TARGET_SDK: {
                    RtlSupportProcessor.performRefactoringForAndroidManifestTargetSdk(refactoring);
                    continue block6;
                }
                case LAYOUT_FILE_ATTRIBUTE: {
                    this.performRefactoringForLayoutFile(refactoring);
                    continue block6;
                }
                case UNDEFINED: {
                    continue block6;
                }
                default: {
                    assert (false) : refactoring.getType();
                    continue block6;
                }
            }
        }
    }

    protected void performPsiSpoilingRefactoring() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
    }

    private void addManifestRefactoring(List<UsageInfo> list) {
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null || ((AndroidFacetConfiguration)facet.getConfiguration()).isLibraryProject()) continue;
            for (VirtualFile manifestFile : IdeaSourceProvider.getManifestFiles(facet)) {
                XmlFile manifestPsiFile = (XmlFile)PsiManager.getInstance((Project)this.myProject).findFile(manifestFile);
                try {
                    int targetSdk;
                    XmlTag[] usesSdkNodes;
                    XmlTag root;
                    if (manifestPsiFile == null || (root = manifestPsiFile.getRootTag()) == null) continue;
                    XmlTag[] applicationNodes = root.findSubTags("application");
                    if (applicationNodes.length > 0) {
                        assert (applicationNodes.length == 1);
                        XmlTag applicationTag = applicationNodes[0];
                        XmlAttribute supportsRtlAttribute = applicationTag.getAttribute("supportsRtl", "http://schemas.android.com/apk/res/android");
                        if (supportsRtlAttribute == null || "false".equals(supportsRtlAttribute.getValue())) {
                            int endOffset;
                            int startOffset;
                            if (supportsRtlAttribute == null) {
                                XmlAttribute[] applicationTagAttributes = applicationTag.getAttributes();
                                XmlAttribute lastAttribute = applicationTagAttributes[applicationTagAttributes.length - 1];
                                PsiElement nextSibling = lastAttribute.getNextSibling();
                                assert (nextSibling != null);
                                endOffset = startOffset = nextSibling.getStartOffsetInParent() + nextSibling.getTextLength();
                            } else {
                                startOffset = supportsRtlAttribute.getStartOffsetInParent();
                                endOffset = startOffset + supportsRtlAttribute.getTextLength();
                            }
                            RtlRefactoringUsageInfo usageInfo = new RtlRefactoringUsageInfo((PsiElement)applicationTag, startOffset, endOffset);
                            usageInfo.setType(RtlRefactoringUsageInfo.RtlRefactoringType.MANIFEST_SUPPORTS_RTL);
                            list.add(usageInfo);
                        }
                    }
                    if ((usesSdkNodes = root.findSubTags("uses-sdk")).length <= 0) continue;
                    assert (usesSdkNodes.length == 1);
                    XmlTag usesSdkTag = usesSdkNodes[0];
                    XmlAttribute targetSdkAttribute = usesSdkTag.getAttribute("targetSdkVersion", "http://schemas.android.com/apk/res/android");
                    int n = targetSdk = targetSdkAttribute != null ? Integer.parseInt(targetSdkAttribute.getValue()) : 0;
                    if (targetSdk != 0 && targetSdk >= 17) continue;
                    int startOffset = targetSdkAttribute != null ? targetSdkAttribute.getStartOffsetInParent() : usesSdkTag.getStartOffsetInParent();
                    int endOffset = startOffset + (targetSdkAttribute != null ? targetSdkAttribute.getTextLength() : usesSdkTag.getTextLength());
                    RtlRefactoringUsageInfo usageInfo = new RtlRefactoringUsageInfo((PsiElement)usesSdkTag, startOffset, endOffset);
                    usageInfo.setType(RtlRefactoringUsageInfo.RtlRefactoringType.MANIFEST_TARGET_SDK);
                    list.add(usageInfo);
                }
                catch (Exception e) {
                    LOG.error("Could not read Manifest data", (Throwable)e);
                }
            }
        }
    }

    private static String quote(String str) {
        return "'" + str + "'";
    }

    @Nullable
    private VirtualFile getLayoutV17(VirtualFile oneLayoutRes, boolean bCreateIfNeeded) {
        String resName = oneLayoutRes.getName();
        if (resName.contains(RES_V_QUALIFIER)) {
            return null;
        }
        String resNameWithV17 = resName + RES_V17_QUALIFIER;
        VirtualFile parent = oneLayoutRes.getParent();
        assert (parent != null);
        VirtualFile layoutV17Dir = parent.findChild(resNameWithV17);
        if ((layoutV17Dir == null || !layoutV17Dir.exists()) && bCreateIfNeeded) {
            try {
                layoutV17Dir = parent.createChildDirectory((Object)this, resNameWithV17);
            }
            catch (IOException e) {
                LOG.error("Cannot create " + RtlSupportProcessor.quote(resNameWithV17) + " directory in resource directory: " + parent.getName());
            }
        }
        if (layoutV17Dir != null) assert (layoutV17Dir.isDirectory()) : layoutV17Dir;
        return layoutV17Dir;
    }

    private List<UsageInfo> getLayoutRefactoringForOneDir(@NotNull VirtualFile layoutDir, boolean createV17, int minSdk) {
        VirtualFile[] layoutChildren;
        if (layoutDir == null) {
            RtlSupportProcessor.$$$reportNull$$$0(6);
        }
        ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>();
        for (VirtualFile oneLayoutFile : layoutChildren = layoutDir.getChildren()) {
            result2.addAll(this.getLayoutRefactoringForOneFile(oneLayoutFile, createV17, minSdk));
        }
        return result2;
    }

    private List<UsageInfo> getLayoutRefactoringForOneFile(@NotNull VirtualFile layoutFile, boolean createV17, int minSdk) {
        if (layoutFile == null) {
            RtlSupportProcessor.$$$reportNull$$$0(7);
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(layoutFile);
        assert (psiFile != null);
        return this.getLayoutRefactoringForFile(psiFile, createV17, minSdk);
    }

    private void addLayoutRefactoring(List<UsageInfo> list) {
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null || !((AndroidFacetConfiguration)facet.getConfiguration()).isAppProject()) continue;
            int minSdk = AndroidModuleInfo.getInstance(facet).getMinSdkVersion().getApiLevel();
            if (this.myProperties.generateV17resourcesOption) {
                List<VirtualFile> allRes = ResourceFolderManager.getInstance(facet).getFolders();
                ArrayList<VirtualFile> allLayoutDir = new ArrayList<VirtualFile>();
                for (VirtualFile oneRes : allRes) {
                    VirtualFile[] children;
                    if (ResourceFolderManager.isLibraryResourceRoot(oneRes)) continue;
                    for (VirtualFile oneChild : children = oneRes.getChildren()) {
                        String childName = oneChild.getName();
                        if (!childName.startsWith("layout") || childName.contains(RES_V_QUALIFIER)) continue;
                        allLayoutDir.add(oneChild);
                    }
                }
                for (VirtualFile layoutDir : allLayoutDir) {
                    VirtualFile layoutV17Dir = this.getLayoutV17(layoutDir, false);
                    if (layoutV17Dir != null) {
                        if (layoutV17Dir.getChildren().length != 0) {
                            list.addAll(this.getLayoutRefactoringForOneDir(layoutV17Dir, false, minSdk));
                            continue;
                        }
                        list.addAll(this.getLayoutRefactoringForOneDir(layoutDir, true, minSdk));
                        continue;
                    }
                    list.addAll(this.getLayoutRefactoringForOneDir(layoutDir, true, minSdk));
                }
                continue;
            }
            LocalResourceManager resourceManager = ModuleResourceManagers.getInstance(facet).getLocalResourceManager();
            List<PsiFile> files2 = resourceManager.findResourceFiles(ResourceFolderType.LAYOUT);
            for (PsiFile psiFile : files2) {
                if (ResourceFolderManager.isLibraryResourceFile(psiFile.getVirtualFile())) continue;
                list.addAll(this.getLayoutRefactoringForFile(psiFile, false, minSdk));
            }
        }
    }

    private List<UsageInfo> getLayoutRefactoringForFile(@NotNull PsiFile layoutFile, final boolean createV17, final int minSdk) {
        if (layoutFile == null) {
            RtlSupportProcessor.$$$reportNull$$$0(8);
        }
        final ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>();
        if (layoutFile instanceof XmlFile && DomManager.getDomManager((Project)this.myProject).getDomFileDescription((XmlFile)layoutFile) instanceof LayoutDomFileDescription) {
            layoutFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                public void visitXmlTag(XmlTag tag) {
                    super.visitXmlTag(tag);
                    List usageInfos = RtlSupportProcessor.this.getLayoutRefactoringForTag(tag, createV17, minSdk);
                    if (usageInfos.isEmpty()) {
                        return;
                    }
                    result2.addAll(usageInfos);
                }
            });
        }
        return result2;
    }

    private List<UsageInfo> getLayoutRefactoringForTag(@NotNull XmlTag tag, boolean createV17, int minSdk) {
        XmlAttribute[] attributes;
        DomElement domElement;
        if (tag == null) {
            RtlSupportProcessor.$$$reportNull$$$0(9);
        }
        if (!((domElement = DomManager.getDomManager((Project)this.myProject).getDomElement(tag)) instanceof LayoutViewElement)) {
            return Collections.emptyList();
        }
        ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>();
        for (XmlAttribute attributeToMirror : attributes = tag.getAttributes()) {
            String value2;
            RtlRefactoringUsageInfo usageInfoForAttribute;
            int endOffset;
            boolean startOffset;
            String localName = attributeToMirror.getLocalName();
            String namespacePrefix = attributeToMirror.getNamespacePrefix();
            String mirroredLocalName = ourMapMirroredAttributeName.get(localName);
            if (mirroredLocalName != null) {
                XmlAttribute attributeMirrored = tag.getAttribute(namespacePrefix + ":" + mirroredLocalName);
                if (attributeMirrored != null) continue;
                startOffset = false;
                endOffset = attributeToMirror.getTextLength();
                usageInfoForAttribute = new RtlRefactoringUsageInfo((PsiElement)attributeToMirror, 0, endOffset);
                usageInfoForAttribute.setType(RtlRefactoringUsageInfo.RtlRefactoringType.LAYOUT_FILE_ATTRIBUTE);
                usageInfoForAttribute.setCreateV17(createV17);
                usageInfoForAttribute.setAndroidManifestMinSdkVersion(minSdk);
                result2.add(usageInfoForAttribute);
                continue;
            }
            if (!localName.equals("gravity") && !localName.equals("layout_gravity") || (value2 = attributeToMirror.getValue()) == null || !value2.contains("left") && !value2.contains("right")) continue;
            startOffset = false;
            endOffset = attributeToMirror.getTextLength();
            usageInfoForAttribute = new RtlRefactoringUsageInfo((PsiElement)attributeToMirror, 0, endOffset);
            usageInfoForAttribute.setType(RtlRefactoringUsageInfo.RtlRefactoringType.LAYOUT_FILE_ATTRIBUTE);
            usageInfoForAttribute.setCreateV17(createV17);
            result2.add(usageInfoForAttribute);
        }
        return result2;
    }

    private static void performRefactoringForAndroidManifestApplicationTag(@NotNull UsageInfo usageInfo) {
        if (usageInfo == null) {
            RtlSupportProcessor.$$$reportNull$$$0(10);
        }
        PsiElement element = usageInfo.getElement();
        assert (element != null);
        XmlTag applicationTag = (XmlTag)element;
        XmlAttribute supportsRtlAttribute = applicationTag.getAttribute("supportsRtl", "http://schemas.android.com/apk/res/android");
        if (supportsRtlAttribute != null) {
            supportsRtlAttribute.setValue("true");
        } else {
            applicationTag.setAttribute("supportsRtl", "http://schemas.android.com/apk/res/android", "true");
        }
    }

    private static void performRefactoringForAndroidManifestTargetSdk(@NotNull UsageInfo usageInfo) {
        if (usageInfo == null) {
            RtlSupportProcessor.$$$reportNull$$$0(11);
        }
        PsiElement element = usageInfo.getElement();
        assert (element != null);
        XmlTag usesSdkTag = (XmlTag)element;
        XmlAttribute targetSdkAttribute = usesSdkTag.getAttribute("targetSdkVersion", "http://schemas.android.com/apk/res/android");
        if (targetSdkAttribute != null) {
            targetSdkAttribute.setValue(Integer.toString(17));
        } else {
            usesSdkTag.setAttribute("targetSdkVersion", "http://schemas.android.com/apk/res/android", Integer.toString(17));
        }
    }

    private void performRefactoringForLayoutFile(@NotNull RtlRefactoringUsageInfo usageInfo) {
        if (usageInfo == null) {
            RtlSupportProcessor.$$$reportNull$$$0(12);
        }
        final PsiElement element = usageInfo.getElement();
        assert (element != null);
        XmlAttribute attribute = (XmlAttribute)element;
        final int minSdk = usageInfo.getAndroidManifestMinSdkVersion();
        if (!usageInfo.isCreateV17()) {
            this.updateAttributeForElement(attribute, minSdk);
        } else {
            PsiFile psiFile = element.getContainingFile();
            final VirtualFile layoutFile = psiFile.getVirtualFile();
            assert (layoutFile != null);
            final VirtualFile layoutDir = layoutFile.getParent();
            assert (layoutDir != null);
            final VirtualFile layoutV17Dir = this.getLayoutV17(layoutDir, true);
            assert (layoutV17Dir != null);
            final String layoutFileName = layoutFile.getName();
            if (layoutV17Dir.findChild(layoutFileName) == null) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            layoutFile.copy((Object)this, layoutV17Dir, layoutFileName);
                        }
                        catch (IOException e) {
                            LOG.error("Cannot copy layout file " + RtlSupportProcessor.quote(layoutFileName) + " from " + RtlSupportProcessor.quote(layoutDir.getName()) + " directory to " + RtlSupportProcessor.quote(layoutV17Dir.getName()) + " directory");
                        }
                    }
                });
            }
            VirtualFile layoutV17File = layoutV17Dir.findChild(layoutFileName);
            assert (layoutV17File != null);
            XmlFile xmlV17File = (XmlFile)PsiManager.getInstance((Project)this.myProject).findFile(layoutV17File);
            assert (xmlV17File != null);
            LOG.info("Processing refactoring for attribute: " + attribute.getName() + " into file: " + layoutV17File.getPath());
            if (DomManager.getDomManager((Project)this.myProject).getDomFileDescription(xmlV17File) instanceof LayoutDomFileDescription) {
                xmlV17File.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                    public void visitXmlTag(XmlTag tag) {
                        super.visitXmlTag(tag);
                        XmlAttribute attribute = tag.getAttribute(((XmlAttribute)element).getName());
                        if (attribute == null) {
                            return;
                        }
                        RtlSupportProcessor.this.updateAttributeForElement(attribute, minSdk);
                    }
                });
            }
            layoutV17File.refresh(true, false);
        }
    }

    private void updateAttributeForElement(@NotNull XmlAttribute attribute, int minSdk) {
        if (attribute == null) {
            RtlSupportProcessor.$$$reportNull$$$0(13);
        }
        String attributeLocalName = attribute.getLocalName();
        LOG.info("Updating attribute name: " + attributeLocalName + " value: " + attribute.getValue());
        if (attributeLocalName.equals("gravity") || attributeLocalName.equals("layout_gravity")) {
            String value2 = StringUtil.notNullize((String)attribute.getValue());
            String newValue = value2.replace("left", "start").replace("right", "end");
            attribute.setValue(newValue);
            LOG.info("Changing gravity from: " + value2 + " to: " + newValue);
        } else {
            XmlAttribute attributeForUpdatingValue;
            String mirroredAttributeLocalName = ourMapMirroredAttributeName.get(attributeLocalName);
            if (mirroredAttributeLocalName == null) {
                LOG.warn("Cannot mirror attribute: " + attribute.toString());
                return;
            }
            String mirroredAttributeName = attribute.getNamespacePrefix() + ":" + mirroredAttributeLocalName;
            if (this.myProperties.replaceLeftRightPropertiesOption) {
                attribute.setName(mirroredAttributeName);
                LOG.info("Replacing attribute name from: " + attributeLocalName + " to: " + mirroredAttributeLocalName);
                attributeForUpdatingValue = attribute;
            } else {
                XmlTag parent = attribute.getParent();
                attributeForUpdatingValue = parent.setAttribute(mirroredAttributeName, StringUtil.notNullize((String)attribute.getValue()));
                LOG.info("Adding attribute name: " + mirroredAttributeName + " value: " + attribute.getValue());
            }
            RtlSupportProcessor.updateAttributeValueIfNeeded(attributeForUpdatingValue, minSdk);
        }
    }

    private static void updateAttributeValueIfNeeded(@NotNull XmlAttribute attribute, int minSdk) {
        if (attribute == null) {
            RtlSupportProcessor.$$$reportNull$$$0(14);
        }
        String attributeLocalName = attribute.getLocalName();
        String value2 = StringUtil.notNullize((String)attribute.getValue());
        if ((attributeLocalName.equals("paddingLeft") || attributeLocalName.equals("paddingRight") || attributeLocalName.equals("paddingStart") || attributeLocalName.equals("paddingEnd")) && minSdk >= 17 && (value2.contains("listPreferredItemPaddingLeft") || value2.contains("listPreferredItemPaddingRight"))) {
            String newValue = value2.replace("listPreferredItemPaddingLeft", "listPreferredItemPaddingStart").replace("listPreferredItemPaddingRight", "listPreferredItemPaddingEnd");
            attribute.setValue(newValue);
            LOG.info("Changing attribute value from: " + value2 + " to: " + newValue);
        }
    }

    @NotNull
    protected String getCommandName() {
        String string = REFACTORING_NAME;
        if (string == null) {
            RtlSupportProcessor.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/refactoring/rtl/RtlSupportProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutDir";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfo";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/refactoring/rtl/RtlSupportProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLayoutRefactoringForOneDir";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLayoutRefactoringForOneFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLayoutRefactoringForFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLayoutRefactoringForTag";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoringForAndroidManifestApplicationTag";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoringForAndroidManifestTargetSdk";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoringForLayoutFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateAttributeForElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateAttributeValueIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

