/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.projectsystem.gradle;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.ModuleBasedClassFileFinder;
import com.android.tools.idea.projectsystem.ClassFileFinderUtil;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleClassFileFinder
extends ModuleBasedClassFileFinder {
    public GradleClassFileFinder(@NotNull Module module) {
        if (module == null) {
            GradleClassFileFinder.$$$reportNull$$$0(0);
        }
        super(module);
    }

    @Override
    @Nullable
    protected VirtualFile findClassFileInModule(@NotNull Module module, @NotNull String className) {
        VirtualFile file;
        if (module == null) {
            GradleClassFileFinder.$$$reportNull$$$0(1);
        }
        if (className == null) {
            GradleClassFileFinder.$$$reportNull$$$0(2);
        }
        if ((file = super.findClassFileInModule(module, className)) != null) {
            return file;
        }
        AndroidModuleModel model = AndroidModuleModel.get(module);
        if (model == null) {
            return null;
        }
        for (VirtualFile outputDir : GradleClassFileFinder.getCompilerOutputRoots(model)) {
            file = ClassFileFinderUtil.findClassFileInOutputRoot(outputDir, className);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    @NotNull
    private static Collection<VirtualFile> getCompilerOutputRoots(@NotNull AndroidModuleModel model) {
        File outFolder;
        File file;
        if (model == null) {
            GradleClassFileFinder.$$$reportNull$$$0(3);
        }
        IdeVariant variant = model.getSelectedVariant();
        String variantName = variant.getName();
        IdeAndroidArtifact mainArtifactInfo = model.getMainArtifact();
        File classesFolder = mainArtifactInfo.getClassesFolder();
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        if (classesFolder == null) {
            AndroidArtifactOutput output = GradleUtil.getOutput((AndroidArtifact)mainArtifactInfo);
            file = output.getMainOutputFile().getOutputFile();
            File buildFolder = file.getParentFile().getParentFile();
            classesFolder = new File(buildFolder, "classes");
        }
        if ((outFolder = new File(classesFolder, variantName.replace('-', File.separatorChar))).exists() && (file = VfsUtil.findFileByIoFile((File)outFolder, (boolean)true)) != null) {
            listBuilder.add((Object)file);
        }
        for (File additionalFolder : mainArtifactInfo.getAdditionalClassesFolders()) {
            VirtualFile file2 = VfsUtil.findFileByIoFile((File)additionalFolder, (boolean)true);
            if (file2 == null) continue;
            listBuilder.add((Object)file2);
        }
        ImmutableList immutableList = listBuilder.build();
        if (immutableList == null) {
            GradleClassFileFinder.$$$reportNull$$$0(4);
        }
        return immutableList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/projectsystem/gradle/GradleClassFileFinder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/projectsystem/gradle/GradleClassFileFinder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerOutputRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findClassFileInModule";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerOutputRoots";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

