/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.ui.CustomNotificationListener;
import com.google.common.base.Objects;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidNotification {
    public static final NotificationGroup BALLOON_GROUP = NotificationGroup.balloonGroup((String)"Android Notification Group");
    public static final NotificationGroup LOG_ONLY_GROUP = NotificationGroup.logOnlyGroup((String)"Android Notification Log-Only Group");
    @Nullable
    private Notification myNotification;
    @NotNull
    private final Project myProject;

    @NotNull
    public static AndroidNotification getInstance(@NotNull Project project) {
        if (project == null) {
            AndroidNotification.$$$reportNull$$$0(0);
        }
        AndroidNotification androidNotification = (AndroidNotification)ServiceManager.getService((Project)project, AndroidNotification.class);
        if (androidNotification == null) {
            AndroidNotification.$$$reportNull$$$0(1);
        }
        return androidNotification;
    }

    public AndroidNotification(@NotNull Project project) {
        if (project == null) {
            AndroidNotification.$$$reportNull$$$0(2);
        }
        this.myProject = project;
    }

    public void addLogEvent(@NotNull String title, @NotNull String text, @NotNull NotificationType type) {
        if (title == null) {
            AndroidNotification.$$$reportNull$$$0(3);
        }
        if (text == null) {
            AndroidNotification.$$$reportNull$$$0(4);
        }
        if (type == null) {
            AndroidNotification.$$$reportNull$$$0(5);
        }
        this.showNotification(title, text, type, LOG_ONLY_GROUP, null);
    }

    public void showBalloon(@NotNull String title, @NotNull String text, @NotNull NotificationType type) {
        if (title == null) {
            AndroidNotification.$$$reportNull$$$0(6);
        }
        if (text == null) {
            AndroidNotification.$$$reportNull$$$0(7);
        }
        if (type == null) {
            AndroidNotification.$$$reportNull$$$0(8);
        }
        this.showBalloon(title, text, type, (NotificationListener)null);
    }

    public void showBalloon(@NotNull String title, @NotNull String text, @NotNull NotificationType type, NotificationHyperlink ... hyperlinks) {
        if (title == null) {
            AndroidNotification.$$$reportNull$$$0(9);
        }
        if (text == null) {
            AndroidNotification.$$$reportNull$$$0(10);
        }
        if (type == null) {
            AndroidNotification.$$$reportNull$$$0(11);
        }
        if (hyperlinks == null) {
            AndroidNotification.$$$reportNull$$$0(12);
        }
        this.showBalloon(title, text, type, BALLOON_GROUP, hyperlinks);
    }

    public void showBalloon(@NotNull String title, @NotNull String text, @NotNull NotificationType type, @NotNull NotificationGroup group, NotificationHyperlink ... hyperlinks) {
        if (title == null) {
            AndroidNotification.$$$reportNull$$$0(13);
        }
        if (text == null) {
            AndroidNotification.$$$reportNull$$$0(14);
        }
        if (type == null) {
            AndroidNotification.$$$reportNull$$$0(15);
        }
        if (group == null) {
            AndroidNotification.$$$reportNull$$$0(16);
        }
        if (hyperlinks == null) {
            AndroidNotification.$$$reportNull$$$0(17);
        }
        this.showBalloon(title, text, type, group, true, hyperlinks);
    }

    public void showBalloon(@NotNull String title, @NotNull String text, @NotNull NotificationType type, @NotNull NotificationGroup group, boolean newLineForLinkText, NotificationHyperlink ... hyperlinks) {
        if (title == null) {
            AndroidNotification.$$$reportNull$$$0(18);
        }
        if (text == null) {
            AndroidNotification.$$$reportNull$$$0(19);
        }
        if (type == null) {
            AndroidNotification.$$$reportNull$$$0(20);
        }
        if (group == null) {
            AndroidNotification.$$$reportNull$$$0(21);
        }
        if (hyperlinks == null) {
            AndroidNotification.$$$reportNull$$$0(22);
        }
        CustomNotificationListener notificationListener = new CustomNotificationListener(this.myProject, hyperlinks);
        String newText = AndroidNotification.addHyperlinksToText(text, newLineForLinkText, hyperlinks);
        this.showNotification(title, newText, type, group, (NotificationListener)notificationListener);
    }

    @NotNull
    private static String addHyperlinksToText(@NotNull String text, boolean newLineForLinkText, NotificationHyperlink ... hyperlinks) {
        if (text == null) {
            AndroidNotification.$$$reportNull$$$0(23);
        }
        if (hyperlinks == null) {
            AndroidNotification.$$$reportNull$$$0(24);
        }
        if (hyperlinks.length == 0) {
            String string = text;
            if (string == null) {
                AndroidNotification.$$$reportNull$$$0(25);
            }
            return string;
        }
        StringBuilder b = new StringBuilder();
        b.append(text);
        for (NotificationHyperlink hyperlink : hyperlinks) {
            if (newLineForLinkText) {
                b.append("<br>\n");
            }
            b.append(hyperlink.toHtml());
        }
        String string = b.toString();
        if (string == null) {
            AndroidNotification.$$$reportNull$$$0(26);
        }
        return string;
    }

    public void showBalloon(@NotNull String title, @NotNull String text, @NotNull NotificationType type, @Nullable NotificationListener listener2) {
        if (title == null) {
            AndroidNotification.$$$reportNull$$$0(27);
        }
        if (text == null) {
            AndroidNotification.$$$reportNull$$$0(28);
        }
        if (type == null) {
            AndroidNotification.$$$reportNull$$$0(29);
        }
        this.showNotification(title, text, type, BALLOON_GROUP, listener2);
    }

    private void showNotification(@NotNull String title, @NotNull String text, @NotNull NotificationType type, @NotNull NotificationGroup group, @Nullable NotificationListener listener2) {
        if (title == null) {
            AndroidNotification.$$$reportNull$$$0(30);
        }
        if (text == null) {
            AndroidNotification.$$$reportNull$$$0(31);
        }
        if (type == null) {
            AndroidNotification.$$$reportNull$$$0(32);
        }
        if (group == null) {
            AndroidNotification.$$$reportNull$$$0(33);
        }
        Notification notification = group.createNotification(title, text, type, listener2);
        Runnable notificationTask = () -> {
            if (!this.myProject.isDisposed() && this.myProject.isOpen()) {
                boolean similar;
                Notification old = this.myNotification;
                if (old != null && (similar = Objects.equal((Object)notification.getContent(), (Object)old.getContent()))) {
                    old.expire();
                }
                this.myNotification = notification;
                notification.notify(this.myProject);
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            notificationTask.run();
        } else {
            application.invokeLater(notificationTask);
        }
    }

    @Nullable
    public Notification getNotification() {
        return this.myNotification;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/project/AndroidNotification";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 13: 
            case 18: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 19: 
            case 23: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 15: 
            case 20: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: 
            case 17: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinks";
                break;
            }
            case 16: 
            case 21: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/project/AndroidNotification";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "addHyperlinksToText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 25: 
            case 26: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addLogEvent";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "showBalloon";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addHyperlinksToText";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

