/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profiling.view;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.profiling.view.CapturePanel;
import com.android.tools.perflib.analyzer.AnalysisReport;
import com.android.tools.perflib.analyzer.AnalysisResultEntry;
import com.android.tools.perflib.analyzer.AnalyzerTask;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.MatteBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AnalysisContentsDelegate
extends ColoredTreeCellRenderer
implements Disposable {
    @NotNull
    protected CapturePanel myCapturePanel;
    @NotNull
    private ThreeComponentsSplitter mySplitter;
    @NotNull
    private JPanel myTaskPanel;
    @NotNull
    protected Tree myResultsTree;
    @NotNull
    private JTextPane myResultExplanationArea;
    @NotNull
    private Set<AnalyzerTask> myEnabledTasks;
    @NotNull
    private Map<String, DefaultMutableTreeNode> myCategoryNodes;
    private boolean myCanRunAnalysis;

    public AnalysisContentsDelegate(@NotNull CapturePanel capturePanel) {
        if (capturePanel == null) {
            AnalysisContentsDelegate.$$$reportNull$$$0(0);
        }
        this.myEnabledTasks = new HashSet();
        this.myCategoryNodes = new HashMap();
        this.myCanRunAnalysis = false;
        this.myCapturePanel = capturePanel;
        this.mySplitter = new ThreeComponentsSplitter(true);
        this.mySplitter.setDividerWidth(10);
        Disposer.register((Disposable)this, (Disposable)this.mySplitter);
        this.myTaskPanel = new JPanel(new LayoutManager(){

            @Override
            public void addLayoutComponent(String s, Component component) {
            }

            @Override
            public void removeLayoutComponent(Component component) {
            }

            @Override
            public Dimension preferredLayoutSize(Container container) {
                return this.minimumLayoutSize(container);
            }

            @Override
            public Dimension minimumLayoutSize(Container container) {
                int width = 0;
                int height = 0;
                for (Component component : container.getComponents()) {
                    Dimension componentSize = component.getPreferredSize();
                    width = Math.max(componentSize.width, width);
                    height += componentSize.height;
                }
                Insets insets = container.getInsets();
                return new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
            }

            @Override
            public void layoutContainer(Container container) {
                Insets insets = container.getInsets();
                int width = container.getWidth() - insets.left - insets.right;
                int startY = insets.top;
                for (Component component : container.getComponents()) {
                    int componentHeight = component.getPreferredSize().height;
                    component.setBounds(0, startY, width, componentHeight);
                    startY += componentHeight;
                }
            }
        });
        this.myTaskPanel.setBackground(UIUtil.getListBackground());
        JScrollPane topScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTaskPanel, (int)20, (int)30);
        topScrollPane.setBorder(new MatteBorder(0, 0, 1, 0, JBColor.border()));
        JLabel resultsTitle = new JLabel(AndroidBundle.message("android.captures.analysis.results.title", new Object[0]), 2);
        resultsTitle.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        resultsTitle.setBorder(BorderFactory.createEmptyBorder(2, 5, 5, 10));
        this.myResultsTree = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode(null)));
        this.myResultsTree.setRootVisible(false);
        this.myResultsTree.setShowsRootHandles(true);
        this.myResultsTree.setRowHeight(19);
        JScrollPane middleScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myResultsTree, (int)20, (int)30);
        middleScrollPane.setBorder(new MatteBorder(1, 0, 1, 0, JBColor.border()));
        JPanel middlePanel = new JPanel(new BorderLayout());
        middlePanel.add((Component)resultsTitle, "North");
        middlePanel.add((Component)middleScrollPane, "Center");
        JLabel explanationTitle = new JLabel(AndroidBundle.message("android.captures.analysis.explanation.title", new Object[0]), 2);
        explanationTitle.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        explanationTitle.setBorder(BorderFactory.createEmptyBorder(2, 5, 5, 10));
        this.myResultExplanationArea = new JTextPane();
        this.myResultExplanationArea.setBorder(new MatteBorder(1, 0, 0, 0, JBColor.border()));
        JScrollPane bottomScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myResultExplanationArea, (int)20, (int)31);
        bottomScrollPane.setBorder(BorderFactory.createEmptyBorder());
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)explanationTitle, "North");
        bottomPanel.add((Component)bottomScrollPane, "Center");
        this.mySplitter.setFirstComponent((JComponent)topScrollPane);
        this.mySplitter.setInnerComponent((JComponent)middlePanel);
        this.mySplitter.setLastComponent((JComponent)bottomPanel);
        this.mySplitter.setFirstSize(128);
        this.mySplitter.setLastSize(128);
        this.myResultsTree.setCellRenderer((TreeCellRenderer)((Object)this));
        this.myCanRunAnalysis = this.myCapturePanel.getAnalyzerTasks().length > 0;
        for (final AnalyzerTask task : this.myCapturePanel.getAnalyzerTasks()) {
            JBCheckBox taskCheckbox = new JBCheckBox(task.getTaskName(), true);
            taskCheckbox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        AnalysisContentsDelegate.this.myEnabledTasks.add(task);
                        AnalysisContentsDelegate.this.myCanRunAnalysis = true;
                    } else if (itemEvent.getStateChange() == 2) {
                        AnalysisContentsDelegate.this.myEnabledTasks.remove(task);
                    }
                }
            });
            this.myTaskPanel.add((Component)taskCheckbox);
            this.myEnabledTasks.add(task);
        }
    }

    @NotNull
    public abstract Icon getToolIcon();

    @NotNull
    public JComponent getComponent() {
        ThreeComponentsSplitter threeComponentsSplitter = this.mySplitter;
        if (threeComponentsSplitter == null) {
            AnalysisContentsDelegate.$$$reportNull$$$0(1);
        }
        return threeComponentsSplitter;
    }

    @NotNull
    public JComponent getFocusComponent() {
        JPanel jPanel = this.myTaskPanel;
        if (jPanel == null) {
            AnalysisContentsDelegate.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    public void dispose() {
    }

    public boolean canRunAnalysis() {
        return !this.myEnabledTasks.isEmpty() && this.myCanRunAnalysis;
    }

    public void performAnalysis() {
        this.myCanRunAnalysis = false;
        UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.PROFILING).setKind(AndroidStudioEvent.EventKind.PROFILING_ANALYSIS_RUN));
        final DefaultTreeModel model = (DefaultTreeModel)this.myResultsTree.getModel();
        final DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        root.removeAllChildren();
        this.myCategoryNodes.clear();
        Set<AnalysisReport.Listener> singletonListener = Collections.singleton(new AnalysisReport.Listener(){

            public void onResultsAdded(final List<AnalysisResultEntry<?>> entries) {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        boolean rootChanged = false;
                        HashSet changedCategories = new HashSet();
                        for (AnalysisResultEntry entry : entries) {
                            DefaultMutableTreeNode node;
                            DefaultMutableTreeNode categoryNode;
                            String category = entry.getCategory();
                            if (!AnalysisContentsDelegate.this.myCategoryNodes.containsKey(category)) {
                                categoryNode = new DefaultMutableTreeNode(new String(category));
                                AnalysisContentsDelegate.this.myCategoryNodes.put(category, categoryNode);
                                root.add(categoryNode);
                                rootChanged = true;
                            } else {
                                categoryNode = (DefaultMutableTreeNode)AnalysisContentsDelegate.this.myCategoryNodes.get(category);
                            }
                            if ((node = AnalysisContentsDelegate.this.myCapturePanel.getContentsDelegate().getNodeForEntry(categoryNode.getChildCount(), entry)) == null) continue;
                            changedCategories.add(categoryNode);
                            categoryNode.add(node);
                        }
                        if (rootChanged) {
                            model.nodeStructureChanged(root);
                        } else {
                            for (DefaultMutableTreeNode categoryNode : changedCategories) {
                                model.nodeStructureChanged(categoryNode);
                            }
                        }
                    }
                });
            }

            public void onAnalysisComplete() {
            }

            public void onAnalysisCancelled() {
            }
        });
        this.myCapturePanel.performAnalysis(this.myEnabledTasks, singletonListener);
    }

    @Nullable
    public abstract DefaultMutableTreeNode getNodeForEntry(int var1, @NotNull AnalysisResultEntry<?> var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capturePanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/profiling/view/AnalysisContentsDelegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/profiling/view/AnalysisContentsDelegate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

