/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.profilingconfig;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.profiler.CpuProfilerConfig;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuProfilingConfigPanel {
    private static final int MIN_SAMPLING_INTERVAL_US = 100;
    private static final int MAX_SAMPLING_INTERVAL_US = 100000;
    private static final int ONE_GB_IN_MB = 1024;
    private static final int SAMPLING_SPINNER_STEP_SIZE = 100;
    static final int MIN_FILE_SIZE_LIMIT_MB = 4;
    static final String SAMPLING_INTERVAL = "Sampling interval:";
    static final String SAMPLING_INTERVAL_UNIT = "microseconds (\u00b5s)";
    static final String FILE_SIZE_LIMIT = "File size limit:";
    static final String DISABLE_LIVE_ALLOCATION = "Suspend Memory Allocation Tracking";
    static final String DISABLE_LIVE_ALLOCATION_DESCRIPTION = "<html>To minimize performance overhead during CPU recording, suspend memory allocation tracking.</html>";
    static final String ART_SAMPLED_DESCRIPTION = "Samples Java code using Android Runtime.";
    static final String ART_INSTRUMENTED_DESCRIPTION = "Instruments Java code using Android Runtime.";
    static final String SIMPLEPERF_DESCRIPTION = "<html>Samples native code using simpleperf. Available for Android 8.0 (API level 26) and higher.</html>";
    static final String ATRACE_DESCRIPTION = "<html>Traces Java and native code at the Android platform level. Available for Android 8.0 (API level 26) and higher.</html>";
    static final String FILE_SIZE_LIMIT_DESCRIPTION = "<html>Maximum recording output file size. On Android 8.0 (API level 26) and higher, this value is ignored.</html>";
    private int myMaxFileSizeLimitMb;
    private JPanel myConfigPanel;
    private JTextField myConfigName;
    private JSpinner mySamplingInterval;
    private final JLabel mySamplingIntervalText = new JLabel("Sampling interval:");
    private final JLabel mySamplingIntervalUnit = new JLabel("microseconds (\u00b5s)");
    private JSlider myFileSize;
    private JLabel myFileSizeLimit;
    private final JLabel myFileSizeLimitText = new JLabel("File size limit:");
    private final JLabel myFileSizeLimitDescriptionText = new JLabel("<html>Maximum recording output file size. On Android 8.0 (API level 26) and higher, this value is ignored.</html>");
    private final JCheckBox myDisableLiveAllocation = new JCheckBox("Suspend Memory Allocation Tracking");
    private final JLabel myDisableLiveAllocationDescriptionText = new JLabel("<html>To minimize performance overhead during CPU recording, suspend memory allocation tracking.</html>");
    private JRadioButton myArtSampledButton;
    private JRadioButton myArtInstrumentedButton;
    private JRadioButton mySimpleperfButton;
    private JRadioButton myATraceButton;
    private final JLabel myArtSampledDescriptionText = new JLabel("Samples Java code using Android Runtime.");
    private final JLabel myArtInstrumentedDescriptionText = new JLabel("Instruments Java code using Android Runtime.");
    private final JLabel mySimpleperfDescriptionText = new JLabel("<html>Samples native code using simpleperf. Available for Android 8.0 (API level 26) and higher.</html>");
    private final JLabel myATraceDescriptionText = new JLabel("<html>Traces Java and native code at the Android platform level. Available for Android 8.0 (API level 26) and higher.</html>");
    @Nullable
    private ProfilingConfiguration myConfiguration;
    private boolean myIsDeviceAtLeastO;

    CpuProfilingConfigPanel(int deviceApiLevel) {
        this.myIsDeviceAtLeastO = deviceApiLevel >= 26;
        this.myMaxFileSizeLimitMb = 4096;
        this.createUiComponents();
    }

    int getMaxFileSizeLimitMb() {
        return this.myMaxFileSizeLimitMb;
    }

    private static Logger getLogger() {
        return Logger.getInstance(CpuProfilingConfigPanel.class);
    }

    JComponent getComponent() {
        return this.myConfigPanel;
    }

    JComponent getPreferredFocusComponent() {
        return this.myConfigName;
    }

    private static String getFileSizeLimitText(int fileSizeLimitInMB) {
        if (fileSizeLimitInMB < 1024) {
            return String.format("%d MB", fileSizeLimitInMB);
        }
        return String.format("%.2f GB", (double)fileSizeLimitInMB / 1024.0);
    }

    void setConfiguration(@Nullable ProfilingConfiguration configuration, boolean isDefaultConfiguration) {
        this.myConfiguration = configuration;
        if (configuration == null) {
            this.clearFields();
        } else {
            this.myConfigName.setText(configuration.getName());
            this.myConfigName.setEnabled(true);
            this.myConfigName.selectAll();
            this.setEnabledTraceTechnologyPanel(true);
            this.setRadioButtons(configuration);
            this.setEnabledFileSizeLimit(!this.myIsDeviceAtLeastO);
            boolean isSamplingEnabled = configuration.getMode() == CpuProfiler.CpuProfilerMode.SAMPLED;
            this.setEnabledSamplingIntervalPanel(isSamplingEnabled);
            this.myFileSize.setValue(configuration.getProfilingBufferSizeInMb());
            this.mySamplingInterval.getModel().setValue(configuration.getProfilingSamplingIntervalUs());
            this.myDisableLiveAllocation.setSelected(configuration.isDisableLiveAllocation());
            this.setEnabledDisableLiveAllocation(true);
        }
        if (isDefaultConfiguration) {
            this.disableFields();
        }
    }

    private void setRadioButtons(@NotNull ProfilingConfiguration configuration) {
        if (configuration == null) {
            CpuProfilingConfigPanel.$$$reportNull$$$0(0);
        }
        if (configuration.getProfilerType() == CpuProfiler.CpuProfilerType.ART) {
            if (configuration.getMode() == CpuProfiler.CpuProfilerMode.SAMPLED) {
                this.myArtSampledButton.setSelected(true);
            } else if (configuration.getMode() == CpuProfiler.CpuProfilerMode.INSTRUMENTED) {
                this.myArtInstrumentedButton.setSelected(true);
            } else {
                CpuProfilingConfigPanel.getLogger().warn("Invalid trace technology detected.");
            }
        } else if (configuration.getProfilerType() == CpuProfiler.CpuProfilerType.SIMPLEPERF) {
            assert (configuration.getMode() == CpuProfiler.CpuProfilerMode.SAMPLED);
            this.mySimpleperfButton.setSelected(true);
        } else if (configuration.getProfilerType() == CpuProfiler.CpuProfilerType.ATRACE) {
            this.myATraceButton.setSelected(true);
        } else {
            CpuProfilingConfigPanel.getLogger().warn("Invalid trace technology detected.");
        }
    }

    private void clearFields() {
        this.myConfigName.setText("");
        this.myArtSampledButton.setSelected(false);
        this.myArtInstrumentedButton.setSelected(false);
        this.mySimpleperfButton.setSelected(false);
        this.mySamplingInterval.getModel().setValue(1000);
        this.myFileSize.setValue(8);
        this.myFileSizeLimit.setText("");
        this.myDisableLiveAllocation.setSelected(false);
    }

    private void disableFields() {
        this.myConfigName.setEnabled(false);
        this.setEnabledTraceTechnologyPanel(false);
        this.setEnabledSamplingIntervalPanel(false);
        this.setEnabledFileSizeLimit(false);
        this.setEnabledDisableLiveAllocation(false);
    }

    private void createUiComponents() {
        this.myConfigPanel = new JPanel();
        this.myConfigPanel.setLayout((LayoutManager)new VerticalFlowLayout());
        this.createConfigNamePanel();
        this.createSectionHeaderPanel("Trace type");
        this.createTraceTechnologyPanel();
        this.createSamplingIntervalPanel();
        this.createFileLimitPanel();
        if (this.myIsDeviceAtLeastO && ((Boolean)StudioFlags.PROFILER_SAMPLE_LIVE_ALLOCATIONS.get()).booleanValue()) {
            this.createSectionHeaderPanel("Performance");
            this.createDisableLiveAllocationPanel();
        }
        this.disableFields();
    }

    private void createConfigNamePanel() {
        JPanel namePanel = new JPanel((LayoutManager)new TabularLayout("Fit-,200px", "25px"));
        namePanel.setBorder((Border)JBUI.Borders.emptyBottom((int)4));
        JLabel nameLabel = new JLabel("Name:");
        nameLabel.setBorder((Border)JBUI.Borders.emptyRight((int)5));
        namePanel.add((Component)nameLabel, new TabularLayout.Constraint(0, 0));
        this.myConfigName = new JTextField();
        this.myConfigName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (CpuProfilingConfigPanel.this.myConfiguration != null) {
                    CpuProfilingConfigPanel.this.myConfiguration.setName(CpuProfilingConfigPanel.this.myConfigName.getText());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/profilers/profilingconfig/CpuProfilingConfigPanel$1", "textChanged"));
            }
        });
        namePanel.add((Component)this.myConfigName, new TabularLayout.Constraint(0, 1));
        this.myConfigPanel.add(namePanel);
    }

    private void createSectionHeaderPanel(String sectionName) {
        JPanel sectionHeaderPanel = new JPanel((LayoutManager)new TabularLayout("Fit,10px,*"));
        sectionHeaderPanel.setBorder((Border)JBUI.Borders.emptyTop((int)12));
        JPanel separatorColumnPanel = new JPanel((LayoutManager)new TabularLayout("*", "*,*"));
        separatorColumnPanel.add((Component)new JSeparator(), new TabularLayout.Constraint(1, 0));
        sectionHeaderPanel.add((Component)new JLabel(sectionName), new TabularLayout.Constraint(0, 0));
        sectionHeaderPanel.add((Component)separatorColumnPanel, new TabularLayout.Constraint(0, 2));
        this.myConfigPanel.add(sectionHeaderPanel);
    }

    private void createTraceTechnologyPanel() {
        ButtonGroup profilersType = new ButtonGroup();
        this.myArtSampledButton = new JRadioButton(CpuProfilerConfig.Technology.SAMPLED_JAVA.getName());
        this.createRadioButtonUi(this.myArtSampledButton, this.myArtSampledDescriptionText, TraceTechnology.ART_SAMPLED, profilersType);
        this.myArtInstrumentedButton = new JRadioButton(CpuProfilerConfig.Technology.INSTRUMENTED_JAVA.getName());
        this.createRadioButtonUi(this.myArtInstrumentedButton, this.myArtInstrumentedDescriptionText, TraceTechnology.ART_INSTRUMENTED, profilersType);
        this.mySimpleperfButton = new JRadioButton(CpuProfilerConfig.Technology.SAMPLED_NATIVE.getName());
        this.createRadioButtonUi(this.mySimpleperfButton, this.mySimpleperfDescriptionText, TraceTechnology.SIMPLEPERF, profilersType);
        this.myATraceButton = new JRadioButton(CpuProfilerConfig.Technology.ATRACE.getName());
        this.createRadioButtonUi(this.myATraceButton, this.myATraceDescriptionText, TraceTechnology.ATRACE, profilersType);
    }

    private void setEnabledTraceTechnologyPanel(boolean isEnabled) {
        this.myArtSampledButton.setEnabled(isEnabled);
        this.myArtInstrumentedButton.setEnabled(isEnabled);
        this.mySimpleperfButton.setEnabled(isEnabled);
        this.myATraceButton.setEnabled(isEnabled);
        this.myArtSampledDescriptionText.setEnabled(isEnabled);
        this.myArtInstrumentedDescriptionText.setEnabled(isEnabled);
        this.mySimpleperfDescriptionText.setEnabled(isEnabled);
        this.myATraceDescriptionText.setEnabled(isEnabled);
    }

    private void updateConfigurationProfilerAndMode(TraceTechnology technology) {
        assert (this.myConfiguration != null);
        switch (technology) {
            case ART_SAMPLED: {
                this.myConfiguration.setProfilerType(CpuProfiler.CpuProfilerType.ART);
                this.myConfiguration.setMode(CpuProfiler.CpuProfilerMode.SAMPLED);
                this.setEnabledSamplingIntervalPanel(true);
                break;
            }
            case ART_INSTRUMENTED: {
                this.myConfiguration.setProfilerType(CpuProfiler.CpuProfilerType.ART);
                this.myConfiguration.setMode(CpuProfiler.CpuProfilerMode.INSTRUMENTED);
                this.setEnabledSamplingIntervalPanel(false);
                break;
            }
            case SIMPLEPERF: {
                this.myConfiguration.setProfilerType(CpuProfiler.CpuProfilerType.SIMPLEPERF);
                this.myConfiguration.setMode(CpuProfiler.CpuProfilerMode.SAMPLED);
                this.setEnabledSamplingIntervalPanel(true);
                break;
            }
            case ATRACE: {
                this.myConfiguration.setProfilerType(CpuProfiler.CpuProfilerType.ATRACE);
                this.myConfiguration.setMode(CpuProfiler.CpuProfilerMode.INSTRUMENTED);
                this.setEnabledSamplingIntervalPanel(false);
            }
        }
    }

    private void createRadioButtonUi(JRadioButton button, JLabel descriptionLabel, TraceTechnology technology, ButtonGroup group) {
        button.addActionListener(e -> {
            JRadioButton bt;
            if (e.getSource() == button && (bt = (JRadioButton)e.getSource()).isSelected()) {
                this.updateConfigurationProfilerAndMode(technology);
            }
        });
        group.add(button);
        this.myConfigPanel.add(button);
        descriptionLabel.setFont(descriptionLabel.getFont().deriveFont(12.0f));
        descriptionLabel.setForeground(ProfilerColors.CPU_RECORDING_CONFIGURATION_DESCRIPTION);
        descriptionLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)30));
        this.myConfigPanel.add(descriptionLabel);
    }

    private void setEnabledSamplingIntervalPanel(boolean isEnabled) {
        this.mySamplingInterval.setEnabled(isEnabled);
        this.mySamplingIntervalText.setEnabled(isEnabled);
        this.mySamplingIntervalUnit.setEnabled(isEnabled);
    }

    private void createSamplingIntervalPanel() {
        JPanel samplingIntervalPanel = new JPanel((LayoutManager)new TabularLayout("120px,Fit,Fit-,*", "Fit"));
        samplingIntervalPanel.setBorder((Border)JBUI.Borders.emptyTop((int)12));
        samplingIntervalPanel.add((Component)this.mySamplingIntervalText, new TabularLayout.Constraint(0, 0));
        SpinnerNumberModel model = new SpinnerNumberModel(1000, 100, 100000, 100);
        this.mySamplingInterval = new JSpinner(model);
        this.mySamplingInterval.addChangeListener(e -> {
            if (this.myConfiguration != null) {
                JSpinner source = (JSpinner)e.getSource();
                this.myConfiguration.setProfilingSamplingIntervalUs(((Integer)source.getValue()).intValue());
            }
        });
        samplingIntervalPanel.add((Component)this.mySamplingInterval, new TabularLayout.Constraint(0, 1));
        this.mySamplingIntervalUnit.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        samplingIntervalPanel.add((Component)this.mySamplingIntervalUnit, new TabularLayout.Constraint(0, 2));
        this.myConfigPanel.add(samplingIntervalPanel);
    }

    private void setEnabledFileSizeLimit(boolean isEnabled) {
        this.myFileSize.setEnabled(isEnabled);
        this.myFileSizeLimit.setEnabled(isEnabled);
        this.myFileSizeLimitText.setEnabled(isEnabled);
        this.myFileSizeLimitDescriptionText.setEnabled(isEnabled);
    }

    private void createFileLimitPanel() {
        this.myFileSize = new JSlider(4, this.myMaxFileSizeLimitMb, 8);
        this.myFileSize.setMajorTickSpacing((this.myMaxFileSizeLimitMb - 4) / 10);
        this.myFileSize.setPaintTicks(true);
        this.myFileSize.addChangeListener(e -> {
            if (this.myConfiguration != null) {
                JSlider source = (JSlider)e.getSource();
                this.myFileSizeLimit.setText(CpuProfilingConfigPanel.getFileSizeLimitText(source.getValue()));
                this.myConfiguration.setProfilingBufferSizeInMb(source.getValue());
            }
        });
        this.myFileSizeLimit = new JLabel(CpuProfilingConfigPanel.getFileSizeLimitText(8));
        JPanel fileSizeLimitPanel = new JPanel((LayoutManager)new TabularLayout("120px,*,75px", "Fit"));
        fileSizeLimitPanel.setBorder((Border)JBUI.Borders.emptyTop((int)8));
        fileSizeLimitPanel.add((Component)this.myFileSizeLimitText, new TabularLayout.Constraint(0, 0));
        fileSizeLimitPanel.add((Component)this.myFileSize, new TabularLayout.Constraint(0, 1));
        fileSizeLimitPanel.add((Component)this.myFileSizeLimit, new TabularLayout.Constraint(0, 2));
        this.myConfigPanel.add(fileSizeLimitPanel);
        this.myConfigPanel.add(Box.createVerticalStrut(JBUI.scale((int)6)));
        this.myFileSizeLimitDescriptionText.setBorder((Border)JBUI.Borders.emptyTop((int)8));
        this.myFileSizeLimitDescriptionText.setForeground(ProfilerColors.CPU_RECORDING_CONFIGURATION_DESCRIPTION);
        this.myFileSizeLimitDescriptionText.setFont(this.myFileSizeLimitDescriptionText.getFont().deriveFont(12.0f));
        this.myConfigPanel.add(this.myFileSizeLimitDescriptionText);
    }

    private void createDisableLiveAllocationPanel() {
        this.myDisableLiveAllocation.addItemListener(e -> {
            if (this.myConfiguration != null) {
                this.myConfiguration.setDisableLiveAllocation(e.getStateChange() == 1);
            }
        });
        this.myDisableLiveAllocation.setBorder((Border)JBUI.Borders.emptyTop((int)8));
        this.myConfigPanel.add(this.myDisableLiveAllocation);
        this.myDisableLiveAllocationDescriptionText.setBorder((Border)JBUI.Borders.empty((int)4, (int)30, (int)0, (int)0));
        this.myDisableLiveAllocationDescriptionText.setForeground(ProfilerColors.CPU_RECORDING_CONFIGURATION_DESCRIPTION);
        this.myDisableLiveAllocationDescriptionText.setFont(this.myFileSizeLimitDescriptionText.getFont().deriveFont(12.0f));
        this.myConfigPanel.add(this.myDisableLiveAllocationDescriptionText);
    }

    private void setEnabledDisableLiveAllocation(boolean isEnabled) {
        this.myDisableLiveAllocation.setEnabled(isEnabled);
        this.myDisableLiveAllocationDescriptionText.setEnabled(isEnabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/profilers/profilingconfig/CpuProfilingConfigPanel", "setRadioButtons"));
    }

    private static enum TraceTechnology {
        ART_SAMPLED,
        ART_INSTRUMENTED,
        SIMPLEPERF,
        ATRACE;

    }
}

