/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.profilingconfig;

import com.android.tools.idea.run.profiler.CpuProfilerConfig;
import com.android.tools.profiler.proto.CpuProfiler;
import java.util.List;
import java.util.stream.Collectors;

public class CpuProfilerConfigConverter {
    private CpuProfilerConfigConverter() {
    }

    public static List<CpuProfiler.CpuProfilerConfiguration> toProto(List<CpuProfilerConfig> configs) {
        return configs.stream().map(CpuProfilerConfigConverter::toProto).collect(Collectors.toList());
    }

    public static CpuProfiler.CpuProfilerConfiguration toProto(CpuProfilerConfig config) {
        CpuProfiler.CpuProfilerConfiguration.Builder protoBuilder = CpuProfiler.CpuProfilerConfiguration.newBuilder().setName(config.getName()).setBufferSizeInMb(config.getBufferSizeMb()).setSamplingIntervalUs(config.getSamplingIntervalUs()).setDisableLiveAllocation(config.isDisableLiveAllocation());
        switch (config.getTechnology()) {
            case SAMPLED_JAVA: {
                protoBuilder.setProfilerType(CpuProfiler.CpuProfilerType.ART);
                protoBuilder.setProfilerMode(CpuProfiler.CpuProfilerMode.SAMPLED);
                break;
            }
            case INSTRUMENTED_JAVA: {
                protoBuilder.setProfilerType(CpuProfiler.CpuProfilerType.ART);
                protoBuilder.setProfilerMode(CpuProfiler.CpuProfilerMode.INSTRUMENTED);
                break;
            }
            case SAMPLED_NATIVE: {
                protoBuilder.setProfilerType(CpuProfiler.CpuProfilerType.SIMPLEPERF);
                protoBuilder.setProfilerMode(CpuProfiler.CpuProfilerMode.SAMPLED);
                break;
            }
            case ATRACE: {
                protoBuilder.setProfilerType(CpuProfiler.CpuProfilerType.ATRACE);
                protoBuilder.setProfilerMode(CpuProfiler.CpuProfilerMode.SAMPLED);
            }
        }
        return protoBuilder.build();
    }

    public static CpuProfilerConfig fromProto(CpuProfiler.CpuProfilerConfiguration proto) {
        CpuProfilerConfig config = new CpuProfilerConfig().setName(proto.getName()).setSamplingIntervalUs(proto.getSamplingIntervalUs()).setBufferSizeMb(proto.getBufferSizeInMb()).setDisableLiveAllocation(proto.getDisableLiveAllocation());
        switch (proto.getProfilerType()) {
            case ART: {
                if (proto.getProfilerMode() == CpuProfiler.CpuProfilerMode.SAMPLED) {
                    config.setTechnology(CpuProfilerConfig.Technology.SAMPLED_JAVA);
                    break;
                }
                config.setTechnology(CpuProfilerConfig.Technology.INSTRUMENTED_JAVA);
                break;
            }
            case SIMPLEPERF: {
                config.setTechnology(CpuProfilerConfig.Technology.SAMPLED_NATIVE);
                break;
            }
            case ATRACE: {
                config.setTechnology(CpuProfilerConfig.Technology.ATRACE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported trace type: " + proto.getProfilerType());
            }
        }
        return config;
    }
}

