/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.dataviewer;

import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.dataviewer.DataViewer;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntellijDataViewer
implements DataViewer {
    @NotNull
    private final JComponent myComponent;
    @NotNull
    private final DataViewer.Style myStyle;

    public static IntellijDataViewer createRawTextViewer(@NotNull byte[] content) {
        if (content == null) {
            IntellijDataViewer.$$$reportNull$$$0(0);
        }
        JTextArea textArea = new JTextArea(new String(content));
        textArea.setLineWrap(true);
        textArea.setFont(ProfilerFonts.H4_FONT);
        textArea.setEditable(false);
        textArea.setBackground(null);
        return new IntellijDataViewer(textArea, DataViewer.Style.RAW);
    }

    @NotNull
    public static IntellijDataViewer createPrettyViewerIfPossible(@NotNull Project project, @NotNull byte[] content, @Nullable FileType fileType) {
        IntellijDataViewer intellijDataViewer;
        block9: {
            if (project == null) {
                IntellijDataViewer.$$$reportNull$$$0(1);
            }
            if (content == null) {
                IntellijDataViewer.$$$reportNull$$$0(2);
            }
            try {
                PsiFile psiFile;
                Language language;
                final EditorFactory editorFactory = EditorFactory.getInstance();
                String contentStr = new String(content).replace("\r\n", "\n");
                DataViewer.Style style = DataViewer.Style.RAW;
                Document document = null;
                if (fileType instanceof LanguageFileType && !(language = ((LanguageFileType)fileType).getLanguage()).is((Language)PlainTextLanguage.INSTANCE) && (psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText(language, (CharSequence)contentStr)) != null) {
                    ReformatCodeProcessor processor = new ReformatCodeProcessor(psiFile, false);
                    processor.run();
                    document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
                    if (document != null) {
                        style = DataViewer.Style.PRETTY;
                    }
                }
                if (document == null) {
                    document = editorFactory.createDocument(contentStr.toCharArray());
                }
                final EditorEx editor2 = (EditorEx)editorFactory.createViewer(document);
                editor2.setCaretVisible(false);
                EditorSettings settings = editor2.getSettings();
                settings.setLineNumbersShown(false);
                settings.setLineMarkerAreaShown(false);
                settings.setUseSoftWraps(true);
                settings.setSoftMargins(Collections.emptyList());
                settings.setRightMarginShown(false);
                settings.setFoldingOutlineShown(true);
                CodeFoldingManager.getInstance((Project)project).updateFoldRegions((Editor)editor2);
                if (fileType != null) {
                    editor2.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(project, fileType));
                }
                Disposer.register((Disposable)project, (Disposable)new Disposable(){

                    public void dispose() {
                        editorFactory.releaseEditor((Editor)editor2);
                    }
                });
                intellijDataViewer = new IntellijDataViewer(editor2.getComponent(), style);
                if (intellijDataViewer != null) break block9;
            }
            catch (AssertionError | Exception e) {
                IntellijDataViewer intellijDataViewer2 = IntellijDataViewer.createInvalidViewer();
                if (intellijDataViewer2 == null) {
                    IntellijDataViewer.$$$reportNull$$$0(4);
                }
                return intellijDataViewer2;
            }
            IntellijDataViewer.$$$reportNull$$$0(3);
        }
        return intellijDataViewer;
    }

    @NotNull
    public static IntellijDataViewer createInvalidViewer() {
        JLabel component = new JLabel("No preview available", 0);
        component.setFont(component.getFont().deriveFont(14.0f));
        IntellijDataViewer intellijDataViewer = new IntellijDataViewer(component, DataViewer.Style.INVALID);
        if (intellijDataViewer == null) {
            IntellijDataViewer.$$$reportNull$$$0(5);
        }
        return intellijDataViewer;
    }

    private IntellijDataViewer(@NotNull JComponent component, @NotNull DataViewer.Style style) {
        if (component == null) {
            IntellijDataViewer.$$$reportNull$$$0(6);
        }
        if (style == null) {
            IntellijDataViewer.$$$reportNull$$$0(7);
        }
        this.myComponent = component;
        this.myStyle = style;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            IntellijDataViewer.$$$reportNull$$$0(8);
        }
        return jComponent;
    }

    @NotNull
    public DataViewer.Style getStyle() {
        DataViewer.Style style = this.myStyle;
        if (style == null) {
            IntellijDataViewer.$$$reportNull$$$0(9);
        }
        return style;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/profilers/dataviewer/IntellijDataViewer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/profilers/dataviewer/IntellijDataViewer";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPrettyViewerIfPossible";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createInvalidViewer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createRawTextViewer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createPrettyViewerIfPossible";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

