/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.analytics;

import com.android.sdklib.AndroidVersion;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.EnergyProfiler;
import com.android.tools.profilers.NullMonitorStage;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioMonitorStage;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.analytics.energy.EnergyEventMetadata;
import com.android.tools.profilers.cpu.CpuCaptureSessionArtifact;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import com.android.tools.profilers.energy.EnergyDuration;
import com.android.tools.profilers.energy.EnergyProfilerStage;
import com.android.tools.profilers.memory.HprofSessionArtifact;
import com.android.tools.profilers.memory.LegacyAllocationsSessionArtifact;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.network.NetworkProfilerStage;
import com.android.tools.profilers.sessions.SessionArtifact;
import com.android.tools.profilers.sessions.SessionItem;
import com.android.tools.profilers.sessions.SessionsManager;
import com.google.common.collect.ImmutableMap;
import com.google.wireless.android.sdk.stats.AndroidProfilerEvent;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.CpuApiTracingMetadata;
import com.google.wireless.android.sdk.stats.CpuCaptureMetadata;
import com.google.wireless.android.sdk.stats.CpuImportTraceMetadata;
import com.google.wireless.android.sdk.stats.CpuProfilingConfig;
import com.google.wireless.android.sdk.stats.CpuStartupProfilingMetadata;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.google.wireless.android.sdk.stats.EnergyEvent;
import com.google.wireless.android.sdk.stats.EnergyEventCount;
import com.google.wireless.android.sdk.stats.EnergyEventMetadata;
import com.google.wireless.android.sdk.stats.EnergyRangeMetadata;
import com.google.wireless.android.sdk.stats.FilterMetadata;
import com.google.wireless.android.sdk.stats.ProfilerSessionCreationMetaData;
import com.google.wireless.android.sdk.stats.ProfilerSessionSelectionMetaData;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StudioFeatureTracker
implements FeatureTracker {
    @Nullable
    private Common.Device myActiveDevice;
    @Nullable
    private Common.Process myActiveProcess;
    @NotNull
    private Project myTrackingProject;
    private final ImmutableMap<Class<? extends Stage>, AndroidProfilerEvent.Stage> STAGE_MAP;
    private final ImmutableMap<Common.SessionMetaData.SessionType, ProfilerSessionCreationMetaData.SessionType> SESSION_TYPE_MAP;
    private final ImmutableMap<SessionsManager.SessionCreationSource, ProfilerSessionCreationMetaData.CreationSource> SESSION_CREATION_SOURCE_MAP;
    private final ImmutableMap<Class<? extends SessionArtifact>, ProfilerSessionSelectionMetaData.ArtifactType> SESSION_ARTIFACT_MAP;
    @NotNull
    private AndroidProfilerEvent.Stage myCurrStage;

    public StudioFeatureTracker(@NotNull Project trackingProject) {
        if (trackingProject == null) {
            StudioFeatureTracker.$$$reportNull$$$0(0);
        }
        this.STAGE_MAP = ImmutableMap.builder().put(NullMonitorStage.class, (Object)AndroidProfilerEvent.Stage.NULL_STAGE).put(StudioMonitorStage.class, (Object)AndroidProfilerEvent.Stage.OVERVIEW_STAGE).put(CpuProfilerStage.class, (Object)AndroidProfilerEvent.Stage.CPU_STAGE).put(MemoryProfilerStage.class, (Object)AndroidProfilerEvent.Stage.MEMORY_STAGE).put(NetworkProfilerStage.class, (Object)AndroidProfilerEvent.Stage.NETWORK_STAGE).put(EnergyProfilerStage.class, (Object)AndroidProfilerEvent.Stage.ENERGY_STAGE).build();
        this.SESSION_TYPE_MAP = ImmutableMap.of((Object)Common.SessionMetaData.SessionType.FULL, (Object)ProfilerSessionCreationMetaData.SessionType.FULL_SESSION, (Object)Common.SessionMetaData.SessionType.MEMORY_CAPTURE, (Object)ProfilerSessionCreationMetaData.SessionType.MEMORY_CAPTURE, (Object)Common.SessionMetaData.SessionType.CPU_CAPTURE, (Object)ProfilerSessionCreationMetaData.SessionType.CPU_CAPTURE);
        this.SESSION_CREATION_SOURCE_MAP = ImmutableMap.of((Object)SessionsManager.SessionCreationSource.MANUAL, (Object)ProfilerSessionCreationMetaData.CreationSource.MANUAL);
        this.SESSION_ARTIFACT_MAP = ImmutableMap.of(SessionItem.class, (Object)ProfilerSessionSelectionMetaData.ArtifactType.ARTIFACT_SESSION, HprofSessionArtifact.class, (Object)ProfilerSessionSelectionMetaData.ArtifactType.ARTIFACT_HPROF, CpuCaptureSessionArtifact.class, (Object)ProfilerSessionSelectionMetaData.ArtifactType.ARTIFACT_CPU_CAPTURE, LegacyAllocationsSessionArtifact.class, (Object)ProfilerSessionSelectionMetaData.ArtifactType.ARTIFACT_LEGACY_ALLOCATIONS);
        this.myCurrStage = AndroidProfilerEvent.Stage.UNKNOWN_STAGE;
        this.myTrackingProject = trackingProject;
    }

    public void trackEnterStage(@NotNull Class<? extends Stage> stage) {
        if (stage == null) {
            StudioFeatureTracker.$$$reportNull$$$0(1);
        }
        this.myCurrStage = (AndroidProfilerEvent.Stage)this.STAGE_MAP.getOrDefault(stage, (Object)AndroidProfilerEvent.Stage.UNKNOWN_STAGE);
        this.track(AndroidProfilerEvent.Type.STAGE_ENTERED);
    }

    public void trackRunWithProfiling() {
        this.track(AndroidProfilerEvent.Type.RUN_WITH_PROFILING);
    }

    public void trackProfilingStarted() {
        this.newTracker(AndroidProfilerEvent.Type.PROFILING_STARTED).setDevice(this.myActiveDevice).track();
    }

    public void trackAdvancedProfilingStarted() {
        this.newTracker(AndroidProfilerEvent.Type.ADVANCED_PROFILING_STARTED).setDevice(this.myActiveDevice).track();
    }

    public void trackChangeDevice(@Nullable Common.Device device) {
        if (this.myActiveDevice != device) {
            this.myActiveDevice = device;
            this.newTracker(AndroidProfilerEvent.Type.CHANGE_DEVICE).setDevice(this.myActiveDevice).track();
        }
    }

    public void trackChangeProcess(@Nullable Common.Process process) {
        if (this.myActiveProcess != process) {
            this.myActiveProcess = process;
            this.newTracker(AndroidProfilerEvent.Type.CHANGE_PROCESS).setDevice(this.myActiveDevice).track();
        }
    }

    public void trackCreateSession(Common.SessionMetaData.SessionType sessionType, SessionsManager.SessionCreationSource sourceType) {
        ProfilerSessionCreationMetaData.Builder builder = ProfilerSessionCreationMetaData.newBuilder().setCreatedType((ProfilerSessionCreationMetaData.SessionType)this.SESSION_TYPE_MAP.getOrDefault((Object)sessionType, (Object)ProfilerSessionCreationMetaData.SessionType.UNKNOWN_SESSION)).setCreationSource((ProfilerSessionCreationMetaData.CreationSource)this.SESSION_CREATION_SOURCE_MAP.getOrDefault((Object)sourceType, (Object)ProfilerSessionCreationMetaData.CreationSource.UNKNOWN_SOURCE));
        this.newTracker(AndroidProfilerEvent.Type.SESSION_CREATED).setSessionCreationMetadata(builder.build()).track();
    }

    public void trackStopSession() {
        this.track(AndroidProfilerEvent.Type.SESSION_STOPPED);
    }

    public void trackSessionsPanelStateChanged(boolean isExpanded) {
        this.track(isExpanded ? AndroidProfilerEvent.Type.SESSION_UI_EXPANDED : AndroidProfilerEvent.Type.SESSION_UI_COLLAPSED);
    }

    public void trackSessionsPanelResized() {
        this.track(AndroidProfilerEvent.Type.SESSION_UI_RESIZED);
    }

    public void trackSessionArtifactSelected(@NotNull SessionArtifact artifact, boolean isSessionLive) {
        if (artifact == null) {
            StudioFeatureTracker.$$$reportNull$$$0(2);
        }
        ProfilerSessionSelectionMetaData.Builder builder = ProfilerSessionSelectionMetaData.newBuilder().setSelectedType((ProfilerSessionSelectionMetaData.ArtifactType)this.SESSION_ARTIFACT_MAP.getOrDefault(artifact.getClass(), (Object)ProfilerSessionSelectionMetaData.ArtifactType.UNKNOWN_ARTIFACT_TYPE)).setIsSessionAlive(isSessionLive);
        this.newTracker(AndroidProfilerEvent.Type.SESSION_ARTIFACT_SELECTED).setSessionSelectionMetadata(builder.build()).track();
    }

    public void trackGoBack() {
        this.track(AndroidProfilerEvent.Type.GO_BACK);
    }

    public void trackSelectMonitor() {
        this.track(AndroidProfilerEvent.Type.SELECT_MONITOR);
    }

    public void trackZoomIn() {
        this.track(AndroidProfilerEvent.Type.ZOOM_IN);
    }

    public void trackZoomOut() {
        this.track(AndroidProfilerEvent.Type.ZOOM_OUT);
    }

    public void trackResetZoom() {
        this.track(AndroidProfilerEvent.Type.ZOOM_RESET);
    }

    public void trackToggleStreaming() {
        this.track(AndroidProfilerEvent.Type.GO_LIVE);
    }

    public void trackNavigateToCode() {
        this.track(AndroidProfilerEvent.Type.NAVIGATE_TO_CODE);
    }

    public void trackSelectCpuKernelElement() {
        this.track(AndroidProfilerEvent.Type.KERNEL_VIEW_CLICKED);
    }

    public void trackToggleCpuKernelHideablePanel() {
        this.track(AndroidProfilerEvent.Type.KERNEL_VIEW_TOGGLED);
    }

    public void trackToggleCpuThreadsHideablePanel() {
        this.track(AndroidProfilerEvent.Type.THREADS_VIEW_TOGGLED);
    }

    public void trackSelectRange() {
        this.newTracker(AndroidProfilerEvent.Type.SELECT_RANGE).setDevice(this.myActiveDevice).track();
    }

    public void trackCaptureTrace(@NotNull com.android.tools.profilers.cpu.CpuCaptureMetadata cpuCaptureMetadata) {
        if (cpuCaptureMetadata == null) {
            StudioFeatureTracker.$$$reportNull$$$0(3);
        }
        this.newTracker(AndroidProfilerEvent.Type.CAPTURE_TRACE).setDevice(this.myActiveDevice).setCpuCaptureMetadata(cpuCaptureMetadata).track();
    }

    public void trackImportTrace(@NotNull CpuProfiler.CpuProfilerType profilerType, boolean success) {
        if (profilerType == null) {
            StudioFeatureTracker.$$$reportNull$$$0(4);
        }
        CpuImportTraceMetadata.Builder metadata = CpuImportTraceMetadata.newBuilder();
        metadata.setImportStatus(success ? CpuImportTraceMetadata.ImportStatus.IMPORT_TRACE_SUCCESS : CpuImportTraceMetadata.ImportStatus.IMPORT_TRACE_FAILURE);
        switch (profilerType) {
            case ART: {
                metadata.setTechnology(CpuImportTraceMetadata.Technology.ART_TECHNOLOGY);
                break;
            }
            case SIMPLEPERF: {
                metadata.setTechnology(CpuImportTraceMetadata.Technology.SIMPLEPERF_TECHNOLOGY);
                break;
            }
            case ATRACE: {
                metadata.setTechnology(CpuImportTraceMetadata.Technology.ATRACE_TECHNOLOGY);
                break;
            }
            default: {
                metadata.setTechnology(CpuImportTraceMetadata.Technology.UNKNOWN_TECHNOLOGY);
            }
        }
        this.newTracker(AndroidProfilerEvent.Type.CPU_IMPORT_TRACE).setDevice(this.myActiveDevice).setCpuImportTraceMetadata(metadata.build()).track();
    }

    public void trackCpuStartupProfiling(@NotNull ProfilingConfiguration configuration) {
        if (configuration == null) {
            StudioFeatureTracker.$$$reportNull$$$0(5);
        }
        this.newTracker(AndroidProfilerEvent.Type.CPU_STARTUP_PROFILING).setDevice(this.myActiveDevice).setCpuStartupProfilingConfiguration(configuration).track();
    }

    public void trackCpuApiTracing(boolean sampling, boolean pathProvided, int bufferSize, int flags, int intervalUs) {
        CpuApiTracingMetadata metadata = CpuApiTracingMetadata.newBuilder().setUseSampling(sampling).setArgTracePath(pathProvided).setArgBufferSize(bufferSize).setArgFlags(flags).setArgIntervalUs(intervalUs).build();
        this.newTracker(AndroidProfilerEvent.Type.CPU_API_TRACING).setDevice(this.myActiveDevice).setCpuApiTracingMetadata(metadata).track();
    }

    public void trackSelectThread() {
        this.track(AndroidProfilerEvent.Type.SELECT_THREAD);
    }

    public void trackSelectCaptureTopDown() {
        this.track(AndroidProfilerEvent.Type.SELECT_TOP_DOWN);
    }

    public void trackSelectCaptureBottomUp() {
        this.track(AndroidProfilerEvent.Type.SELECT_BOTTOM_UP);
    }

    public void trackSelectCaptureFlameChart() {
        this.track(AndroidProfilerEvent.Type.SELECT_FLAME_CHART);
    }

    public void trackSelectCaptureCallChart() {
        this.track(AndroidProfilerEvent.Type.SELECT_CALL_CHART);
    }

    public void trackForceGc() {
        this.track(AndroidProfilerEvent.Type.FORCE_GC);
    }

    public void trackDumpHeap() {
        this.track(AndroidProfilerEvent.Type.SNAPSHOT_HPROF);
    }

    public void trackRecordAllocations() {
        this.track(AndroidProfilerEvent.Type.CAPTURE_ALLOCATIONS);
    }

    public void trackExportHeap() {
        this.track(AndroidProfilerEvent.Type.EXPORT_HPROF);
    }

    public void trackExportAllocation() {
        this.track(AndroidProfilerEvent.Type.EXPORT_ALLOCATION);
    }

    public void trackChangeClassArrangment() {
        this.track(AndroidProfilerEvent.Type.ARRANGE_CLASSES);
    }

    public void trackSelectMemoryStack() {
        this.track(AndroidProfilerEvent.Type.SELECT_MEMORY_STACK);
    }

    public void trackSelectMemoryReferences() {
        this.track(AndroidProfilerEvent.Type.SELECT_MEMORY_REFERENCES);
    }

    public void trackSelectMemoryHeap(@NotNull String heapName) {
        AndroidProfilerEvent.MemoryHeap heapType;
        if (heapName == null) {
            StudioFeatureTracker.$$$reportNull$$$0(6);
        }
        switch (heapName) {
            case "default": {
                heapType = AndroidProfilerEvent.MemoryHeap.DEFAULT_HEAP;
                break;
            }
            case "app": {
                heapType = AndroidProfilerEvent.MemoryHeap.APP_HEAP;
                break;
            }
            case "image": {
                heapType = AndroidProfilerEvent.MemoryHeap.IMAGE_HEAP;
                break;
            }
            case "zygote": {
                heapType = AndroidProfilerEvent.MemoryHeap.ZYGOTE_HEAP;
                break;
            }
            case "JNI": {
                heapType = AndroidProfilerEvent.MemoryHeap.JNI_HEAP;
                break;
            }
            default: {
                StudioFeatureTracker.getLogger().error("Attempt to report selection of unknown heap name: " + heapName);
                return;
            }
        }
        this.newTracker(AndroidProfilerEvent.Type.SELECT_MEMORY_HEAP).setMemoryHeapId(heapType).track();
    }

    public void trackSelectNetworkRequest() {
        this.track(AndroidProfilerEvent.Type.SELECT_CONNECTION);
    }

    public void trackSelectNetworkDetailsOverview() {
        this.track(AndroidProfilerEvent.Type.SELECT_DETAILS_OVERVIEW);
    }

    public void trackSelectNetworkDetailsHeaders() {
        this.track(AndroidProfilerEvent.Type.SELECT_DETAILS_HEADERS);
    }

    public void trackSelectNetworkDetailsResponse() {
        this.track(AndroidProfilerEvent.Type.SELECT_DETAILS_RESPONSE);
    }

    public void trackSelectNetworkDetailsRequest() {
        this.track(AndroidProfilerEvent.Type.SELECT_DETAILS_REQUEST);
    }

    public void trackSelectNetworkDetailsStack() {
        this.track(AndroidProfilerEvent.Type.SELECT_DETAILS_STACK);
    }

    public void trackSelectNetworkDetailsError() {
        this.track(AndroidProfilerEvent.Type.SELECT_DETAILS_ERROR);
    }

    public void trackSelectNetworkConnectionsView() {
        this.track(AndroidProfilerEvent.Type.SELECT_CONNECTIONS_CONNECTION_VIEW);
    }

    public void trackSelectNetworkThreadsView() {
        this.track(AndroidProfilerEvent.Type.SELECT_CONNECTIONS_THREADS_VIEW);
    }

    public void trackOpenProfilingConfigDialog() {
        this.track(AndroidProfilerEvent.Type.OPEN_CPU_CONFIG_DIALOG);
    }

    public void trackCreateCustomProfilingConfig() {
        this.track(AndroidProfilerEvent.Type.CREATE_CPU_CONFIG);
    }

    public void trackSelectEnergyRange(@NotNull com.android.tools.profilers.analytics.energy.EnergyRangeMetadata rangeMetadata) {
        if (rangeMetadata == null) {
            StudioFeatureTracker.$$$reportNull$$$0(7);
        }
        this.newTracker(AndroidProfilerEvent.Type.SELECT_ENERGY_RANGE).setEnergyRangeMetadata(rangeMetadata).track();
    }

    public void trackSelectEnergyEvent(@NotNull EnergyEventMetadata eventMetadata) {
        if (eventMetadata == null) {
            StudioFeatureTracker.$$$reportNull$$$0(8);
        }
        this.newTracker(AndroidProfilerEvent.Type.SELECT_ENERGY_EVENT).setEnergyEventMetadata(eventMetadata).track();
    }

    public void trackFilterMetadata(@NotNull com.android.tools.profilers.analytics.FilterMetadata filterMetadata) {
        if (filterMetadata == null) {
            StudioFeatureTracker.$$$reportNull$$$0(9);
        }
        this.newTracker(AndroidProfilerEvent.Type.FILTER).setFilterMetadata(filterMetadata).track();
    }

    @NotNull
    private Tracker newTracker(AndroidProfilerEvent.Type eventType) {
        Tracker tracker = new Tracker(this.myTrackingProject, eventType, this.myCurrStage);
        if (tracker == null) {
            StudioFeatureTracker.$$$reportNull$$$0(10);
        }
        return tracker;
    }

    private void track(AndroidProfilerEvent.Type eventType) {
        this.newTracker(eventType).track();
    }

    private static final Logger getLogger() {
        return Logger.getInstance(StudioFeatureTracker.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trackingProject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cpuCaptureMetadata";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilerType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heapName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeMetadata";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventMetadata";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterMetadata";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/profilers/analytics/StudioFeatureTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/profilers/analytics/StudioFeatureTracker";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "newTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "trackEnterStage";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "trackSessionArtifactSelected";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "trackCaptureTrace";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "trackImportTrace";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "trackCpuStartupProfiling";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "trackSelectMemoryHeap";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "trackSelectEnergyRange";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "trackSelectEnergyEvent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "trackFilterMetadata";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Tracker {
        @NotNull
        private final AndroidProfilerEvent.Type myEventType;
        @NotNull
        private final AndroidProfilerEvent.Stage myCurrStage;
        @NotNull
        private final Project myTrackingProject;
        @Nullable
        private Common.Device myDevice;
        @Nullable
        private com.android.tools.profilers.cpu.CpuCaptureMetadata myCpuCaptureMetadata;
        @Nullable
        private CpuImportTraceMetadata myCpuImportTraceMetadata;
        @Nullable
        private com.android.tools.profilers.analytics.FilterMetadata myFeatureMetadata;
        @Nullable
        private CpuApiTracingMetadata myCpuApiTracingMetadata;
        @Nullable
        private com.android.tools.profilers.analytics.energy.EnergyRangeMetadata myEnergyRangeMetadata;
        @Nullable
        private EnergyEventMetadata myEnergyEventMetadata;
        @Nullable
        private ProfilerSessionCreationMetaData mySessionCreationMetadata;
        @Nullable
        private ProfilerSessionSelectionMetaData mySessionArtifactMetadata;
        @Nullable
        private ProfilingConfiguration myCpuStartupProfilingConfiguration;
        private AndroidProfilerEvent.MemoryHeap myMemoryHeap;

        public Tracker(@NotNull Project trackingProject, @NotNull AndroidProfilerEvent.Type eventType, @NotNull AndroidProfilerEvent.Stage stage) {
            if (trackingProject == null) {
                Tracker.$$$reportNull$$$0(0);
            }
            if (eventType == null) {
                Tracker.$$$reportNull$$$0(1);
            }
            if (stage == null) {
                Tracker.$$$reportNull$$$0(2);
            }
            this.myMemoryHeap = AndroidProfilerEvent.MemoryHeap.UNKNOWN_HEAP;
            this.myEventType = eventType;
            this.myCurrStage = stage;
            this.myTrackingProject = trackingProject;
        }

        @NotNull
        public Tracker setDevice(@Nullable Common.Device device) {
            this.myDevice = device;
            Tracker tracker = this;
            if (tracker == null) {
                Tracker.$$$reportNull$$$0(3);
            }
            return tracker;
        }

        @NotNull
        public Tracker setCpuCaptureMetadata(@Nullable com.android.tools.profilers.cpu.CpuCaptureMetadata cpuCaptureMetadata) {
            this.myCpuCaptureMetadata = cpuCaptureMetadata;
            Tracker tracker = this;
            if (tracker == null) {
                Tracker.$$$reportNull$$$0(4);
            }
            return tracker;
        }

        @NotNull
        public Tracker setCpuImportTraceMetadata(CpuImportTraceMetadata cpuImportTraceMetadata) {
            this.myCpuImportTraceMetadata = cpuImportTraceMetadata;
            Tracker tracker = this;
            if (tracker == null) {
                Tracker.$$$reportNull$$$0(5);
            }
            return tracker;
        }

        @NotNull
        public Tracker setCpuStartupProfilingConfiguration(@Nullable ProfilingConfiguration configuration) {
            this.myCpuStartupProfilingConfiguration = configuration;
            Tracker tracker = this;
            if (tracker == null) {
                Tracker.$$$reportNull$$$0(6);
            }
            return tracker;
        }

        @NotNull
        public Tracker setCpuApiTracingMetadata(@Nullable CpuApiTracingMetadata metadata) {
            this.myCpuApiTracingMetadata = metadata;
            Tracker tracker = this;
            if (tracker == null) {
                Tracker.$$$reportNull$$$0(7);
            }
            return tracker;
        }

        @NotNull
        public Tracker setFilterMetadata(@Nullable com.android.tools.profilers.analytics.FilterMetadata filterMetadata) {
            this.myFeatureMetadata = filterMetadata;
            Tracker tracker = this;
            if (tracker == null) {
                Tracker.$$$reportNull$$$0(8);
            }
            return tracker;
        }

        @NotNull
        public Tracker setEnergyRangeMetadata(@Nullable com.android.tools.profilers.analytics.energy.EnergyRangeMetadata energyRangeMetadata) {
            this.myEnergyRangeMetadata = energyRangeMetadata;
            Tracker tracker = this;
            if (tracker == null) {
                Tracker.$$$reportNull$$$0(9);
            }
            return tracker;
        }

        @NotNull
        public Tracker setEnergyEventMetadata(@Nullable EnergyEventMetadata energyEventMetadata) {
            this.myEnergyEventMetadata = energyEventMetadata;
            Tracker tracker = this;
            if (tracker == null) {
                Tracker.$$$reportNull$$$0(10);
            }
            return tracker;
        }

        @NotNull
        public Tracker setMemoryHeapId(AndroidProfilerEvent.MemoryHeap heap) {
            this.myMemoryHeap = heap;
            Tracker tracker = this;
            if (tracker == null) {
                Tracker.$$$reportNull$$$0(11);
            }
            return tracker;
        }

        @NotNull
        public Tracker setSessionCreationMetadata(ProfilerSessionCreationMetaData metadata) {
            this.mySessionCreationMetadata = metadata;
            Tracker tracker = this;
            if (tracker == null) {
                Tracker.$$$reportNull$$$0(12);
            }
            return tracker;
        }

        @NotNull
        public Tracker setSessionSelectionMetadata(ProfilerSessionSelectionMetaData metadata) {
            this.mySessionArtifactMetadata = metadata;
            Tracker tracker = this;
            if (tracker == null) {
                Tracker.$$$reportNull$$$0(13);
            }
            return tracker;
        }

        public void track() {
            AndroidProfilerEvent.Builder profilerEvent = AndroidProfilerEvent.newBuilder().setStage(this.myCurrStage).setType(this.myEventType);
            this.populateCpuCaptureMetadata(profilerEvent);
            this.populateFilterMetadata(profilerEvent);
            this.populateEnergyRangeMetadata(profilerEvent);
            this.populateEnergyEventMetadata(profilerEvent);
            switch (this.myEventType) {
                case SELECT_MEMORY_HEAP: {
                    profilerEvent.setMemoryHeap(this.myMemoryHeap);
                    break;
                }
                case SESSION_CREATED: {
                    profilerEvent.setSessionStartMetadata(this.mySessionCreationMetadata);
                    break;
                }
                case SESSION_ARTIFACT_SELECTED: {
                    profilerEvent.setSessionArtifactMetadata(this.mySessionArtifactMetadata);
                    break;
                }
                case CPU_API_TRACING: {
                    profilerEvent.setCpuApiTracingMetadata(this.myCpuApiTracingMetadata);
                    break;
                }
                case CPU_STARTUP_PROFILING: {
                    profilerEvent.setCpuStartupProfilingMetadata(CpuStartupProfilingMetadata.newBuilder().setProfilingConfig(this.toStatsCpuProfilingConfig(this.myCpuStartupProfilingConfiguration)));
                    break;
                }
                case CPU_IMPORT_TRACE: {
                    assert (this.myCpuImportTraceMetadata != null);
                    profilerEvent.setCpuImportTraceMetadata(this.myCpuImportTraceMetadata);
                    break;
                }
            }
            AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.ANDROID_PROFILER).setAndroidProfilerEvent(profilerEvent);
            if (this.myDevice != null) {
                event.setDeviceInfo(DeviceInfo.newBuilder().setManufacturer(this.myDevice.getManufacturer()).setModel(this.myDevice.getModel()).setBuildVersionRelease(this.myDevice.getVersion()).setBuildApiLevelFull(new AndroidVersion(this.myDevice.getApiLevel(), this.myDevice.getCodename()).getApiString()).setDeviceType(this.myDevice.getIsEmulator() ? DeviceInfo.DeviceType.LOCAL_EMULATOR : DeviceInfo.DeviceType.LOCAL_PHYSICAL).build());
            }
            UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(event, this.myTrackingProject));
        }

        private void populateEnergyRangeMetadata(@NotNull AndroidProfilerEvent.Builder profilerEvent) {
            if (profilerEvent == null) {
                Tracker.$$$reportNull$$$0(14);
            }
            if (this.myEnergyRangeMetadata == null) {
                return;
            }
            EnergyRangeMetadata.Builder builder = EnergyRangeMetadata.newBuilder();
            this.myEnergyRangeMetadata.getEventCounts().forEach(eventCount -> builder.addEventCounts(EnergyEventCount.newBuilder().setType(this.toEnergyType(eventCount.getKind())).setCount(eventCount.getCount()).build()));
            profilerEvent.setEnergyRangeMetadata(builder.build());
        }

        private void populateEnergyEventMetadata(@NotNull AndroidProfilerEvent.Builder profilerEvent) {
            if (profilerEvent == null) {
                Tracker.$$$reportNull$$$0(15);
            }
            if (this.myEnergyEventMetadata == null || this.myEnergyEventMetadata.getSubevents().isEmpty()) {
                return;
            }
            EnergyEventMetadata.Builder builder = com.google.wireless.android.sdk.stats.EnergyEventMetadata.newBuilder();
            List subevents = this.myEnergyEventMetadata.getSubevents();
            EnergyProfiler.EnergyEvent firstEvent = (EnergyProfiler.EnergyEvent)subevents.get(0);
            builder.setType(this.toEnergyType(firstEvent));
            EnergyEvent.Subtype eventSubtype = this.toEnergySubtype(firstEvent);
            if (eventSubtype != null) {
                builder.setSubtype(eventSubtype);
            }
            for (EnergyProfiler.EnergyEvent event : subevents) {
                builder.addSubevents(this.toEnergySubevent(event));
            }
            profilerEvent.setEnergyEventMetadata(builder);
        }

        private void populateFilterMetadata(AndroidProfilerEvent.Builder profilerEvent) {
            if (this.myFeatureMetadata != null) {
                FilterMetadata.Builder filterMetadata = FilterMetadata.newBuilder();
                filterMetadata.setFeaturesUsed((long)this.myFeatureMetadata.getFeaturesUsed());
                filterMetadata.setMatchedElements(this.myFeatureMetadata.getMatchedElementCount());
                filterMetadata.setTotalElements(this.myFeatureMetadata.getTotalElementCount());
                filterMetadata.setSearchLength(this.myFeatureMetadata.getFilterTextLength());
                switch (this.myFeatureMetadata.getView()) {
                    case UNKNOWN_FILTER_VIEW: {
                        filterMetadata.setActiveView(FilterMetadata.View.UNKNOWN_FILTER_VIEW);
                        break;
                    }
                    case CPU_TOP_DOWN: {
                        filterMetadata.setActiveView(FilterMetadata.View.CPU_TOP_DOWN);
                        break;
                    }
                    case CPU_BOTTOM_UP: {
                        filterMetadata.setActiveView(FilterMetadata.View.CPU_BOTTOM_UP);
                        break;
                    }
                    case CPU_FLAME_CHART: {
                        filterMetadata.setActiveView(FilterMetadata.View.CPU_FLAME_CHART);
                        break;
                    }
                    case CPU_CALL_CHART: {
                        filterMetadata.setActiveView(FilterMetadata.View.CPU_CALL_CHART);
                        break;
                    }
                    case MEMORY_CALLSTACK: {
                        filterMetadata.setActiveView(FilterMetadata.View.MEMORY_CALLSTACK);
                        break;
                    }
                    case MEMORY_PACKAGE: {
                        filterMetadata.setActiveView(FilterMetadata.View.MEMORY_PACKAGE);
                        break;
                    }
                    case MEMORY_CLASS: {
                        filterMetadata.setActiveView(FilterMetadata.View.MEMORY_CLASS);
                        break;
                    }
                    case NETWORK_CONNECTIONS: {
                        filterMetadata.setActiveView(FilterMetadata.View.NETWORK_CONNECTIONS);
                        break;
                    }
                    case NETWORK_THREADS: {
                        filterMetadata.setActiveView(FilterMetadata.View.NETWORK_THREADS);
                    }
                }
                profilerEvent.setFilterMetadata(filterMetadata);
            }
        }

        private void populateCpuCaptureMetadata(AndroidProfilerEvent.Builder profilerEvent) {
            if (this.myCpuCaptureMetadata != null) {
                CpuCaptureMetadata.Builder captureMetadata = CpuCaptureMetadata.newBuilder().setCaptureDurationMs(this.myCpuCaptureMetadata.getCaptureDurationMs()).setRecordDurationMs(this.myCpuCaptureMetadata.getRecordDurationMs()).setTraceFileSizeBytes(this.myCpuCaptureMetadata.getTraceFileSizeBytes()).setParsingTimeMs(this.myCpuCaptureMetadata.getParsingTimeMs());
                switch (this.myCpuCaptureMetadata.getStatus()) {
                    case SUCCESS: {
                        captureMetadata.setCaptureStatus(CpuCaptureMetadata.CaptureStatus.SUCCESS);
                        break;
                    }
                    case PARSING_FAILURE: {
                        captureMetadata.setCaptureStatus(CpuCaptureMetadata.CaptureStatus.PARSING_FAILURE);
                        break;
                    }
                    case STOP_CAPTURING_FAILURE: {
                        captureMetadata.setCaptureStatus(CpuCaptureMetadata.CaptureStatus.STOP_CAPTURING_FAILURE);
                        break;
                    }
                    case USER_ABORTED_PARSING: {
                        captureMetadata.setCaptureStatus(CpuCaptureMetadata.CaptureStatus.USER_ABORTED_PARSING);
                    }
                }
                captureMetadata.setProfilingConfig(this.toStatsCpuProfilingConfig(this.myCpuCaptureMetadata.getProfilingConfiguration()));
                if (this.myCpuCaptureMetadata.getProfilingConfiguration().getProfilerType() == CpuProfiler.CpuProfilerType.ART) {
                    captureMetadata.setArtStopTimeoutSec(CpuProfilerStage.CPU_ART_STOP_TIMEOUT_SEC);
                }
                profilerEvent.setCpuCaptureMetadata(captureMetadata);
            }
        }

        @NotNull
        private CpuProfilingConfig toStatsCpuProfilingConfig(@NotNull ProfilingConfiguration config) {
            if (config == null) {
                Tracker.$$$reportNull$$$0(16);
            }
            CpuProfilingConfig.Builder cpuConfigInfo = CpuProfilingConfig.newBuilder().setSampleInterval(config.getProfilingSamplingIntervalUs()).setSizeLimit(config.getProfilingBufferSizeInMb());
            switch (config.getProfilerType()) {
                case ART: {
                    cpuConfigInfo.setType(CpuProfilingConfig.Type.ART);
                    break;
                }
                case SIMPLEPERF: {
                    cpuConfigInfo.setType(CpuProfilingConfig.Type.SIMPLE_PERF);
                    break;
                }
                case ATRACE: {
                    cpuConfigInfo.setType(CpuProfilingConfig.Type.ATRACE);
                    break;
                }
            }
            switch (config.getMode()) {
                case SAMPLED: {
                    cpuConfigInfo.setMode(CpuProfilingConfig.Mode.SAMPLED);
                    break;
                }
                case INSTRUMENTED: {
                    cpuConfigInfo.setMode(CpuProfilingConfig.Mode.INSTRUMENTED);
                    break;
                }
            }
            CpuProfilingConfig cpuProfilingConfig = cpuConfigInfo.build();
            if (cpuProfilingConfig == null) {
                Tracker.$$$reportNull$$$0(17);
            }
            return cpuProfilingConfig;
        }

        @NotNull
        private EnergyEvent.Type toEnergyType(@NotNull EnergyProfiler.EnergyEvent energyEvent) {
            if (energyEvent == null) {
                Tracker.$$$reportNull$$$0(18);
            }
            EnergyEvent.Type type = this.toEnergyType(EnergyDuration.Kind.from((EnergyProfiler.EnergyEvent)energyEvent));
            if (type == null) {
                Tracker.$$$reportNull$$$0(19);
            }
            return type;
        }

        @NotNull
        private EnergyEvent.Type toEnergyType(@NotNull EnergyDuration.Kind energyKind) {
            if (energyKind == null) {
                Tracker.$$$reportNull$$$0(20);
            }
            switch (energyKind) {
                case WAKE_LOCK: {
                    EnergyEvent.Type type = EnergyEvent.Type.WAKE_LOCK;
                    if (type == null) {
                        Tracker.$$$reportNull$$$0(21);
                    }
                    return type;
                }
                case ALARM: {
                    EnergyEvent.Type type = EnergyEvent.Type.ALARM;
                    if (type == null) {
                        Tracker.$$$reportNull$$$0(22);
                    }
                    return type;
                }
                case JOB: {
                    EnergyEvent.Type type = EnergyEvent.Type.JOB;
                    if (type == null) {
                        Tracker.$$$reportNull$$$0(23);
                    }
                    return type;
                }
                case LOCATION: {
                    EnergyEvent.Type type = EnergyEvent.Type.LOCATION;
                    if (type == null) {
                        Tracker.$$$reportNull$$$0(24);
                    }
                    return type;
                }
            }
            EnergyEvent.Type type = EnergyEvent.Type.UNKNOWN_EVENT_TYPE;
            if (type == null) {
                Tracker.$$$reportNull$$$0(25);
            }
            return type;
        }

        @Nullable
        private EnergyEvent.Subtype toEnergySubtype(@NotNull EnergyProfiler.EnergyEvent energyEvent) {
            if (energyEvent == null) {
                Tracker.$$$reportNull$$$0(26);
            }
            if (energyEvent.getMetadataCase() == EnergyProfiler.EnergyEvent.MetadataCase.WAKE_LOCK_ACQUIRED) {
                EnergyProfiler.WakeLockAcquired wakeLockAcquired = energyEvent.getWakeLockAcquired();
                switch (wakeLockAcquired.getLevel()) {
                    case PARTIAL_WAKE_LOCK: {
                        return EnergyEvent.Subtype.WAKE_LOCK_PARTIAL;
                    }
                    case SCREEN_DIM_WAKE_LOCK: {
                        return EnergyEvent.Subtype.WAKE_LOCK_SCREEN_DIM;
                    }
                    case SCREEN_BRIGHT_WAKE_LOCK: {
                        return EnergyEvent.Subtype.WAKE_LOCK_SCREEN_BRIGHT;
                    }
                    case FULL_WAKE_LOCK: {
                        return EnergyEvent.Subtype.WAKE_LOCK_FULL;
                    }
                    case PROXIMITY_SCREEN_OFF_WAKE_LOCK: {
                        return EnergyEvent.Subtype.WAKE_LOCK_PROXIMITY_SCREEN_OFF;
                    }
                }
                return EnergyEvent.Subtype.UNKNOWN_EVENT_SUBTYPE;
            }
            if (energyEvent.getMetadataCase() == EnergyProfiler.EnergyEvent.MetadataCase.ALARM_SET) {
                EnergyProfiler.AlarmSet alarmSet = energyEvent.getAlarmSet();
                switch (alarmSet.getType()) {
                    case RTC: {
                        return EnergyEvent.Subtype.ALARM_RTC;
                    }
                    case RTC_WAKEUP: {
                        return EnergyEvent.Subtype.ALARM_RTC_WAKEUP;
                    }
                    case ELAPSED_REALTIME: {
                        return EnergyEvent.Subtype.ALARM_ELAPSED_REALTIME;
                    }
                    case ELAPSED_REALTIME_WAKEUP: {
                        return EnergyEvent.Subtype.ALARM_ELAPSED_REALTIME_WAKEUP;
                    }
                }
                return EnergyEvent.Subtype.UNKNOWN_EVENT_SUBTYPE;
            }
            return null;
        }

        @NotNull
        private EnergyEvent.Subevent toEnergySubevent(@NotNull EnergyProfiler.EnergyEvent energyEvent) {
            if (energyEvent == null) {
                Tracker.$$$reportNull$$$0(27);
            }
            switch (energyEvent.getMetadataCase()) {
                case WAKE_LOCK_ACQUIRED: {
                    EnergyEvent.Subevent subevent = EnergyEvent.Subevent.WAKE_LOCK_ACQUIRED;
                    if (subevent == null) {
                        Tracker.$$$reportNull$$$0(28);
                    }
                    return subevent;
                }
                case WAKE_LOCK_RELEASED: {
                    EnergyEvent.Subevent subevent = EnergyEvent.Subevent.WAKE_LOCK_RELEASED;
                    if (subevent == null) {
                        Tracker.$$$reportNull$$$0(29);
                    }
                    return subevent;
                }
                case ALARM_SET: {
                    EnergyEvent.Subevent subevent = EnergyEvent.Subevent.ALARM_SET;
                    if (subevent == null) {
                        Tracker.$$$reportNull$$$0(30);
                    }
                    return subevent;
                }
                case ALARM_CANCELLED: {
                    EnergyEvent.Subevent subevent = EnergyEvent.Subevent.ALARM_CANCELLED;
                    if (subevent == null) {
                        Tracker.$$$reportNull$$$0(31);
                    }
                    return subevent;
                }
                case ALARM_FIRED: {
                    EnergyEvent.Subevent subevent = EnergyEvent.Subevent.ALARM_FIRED;
                    if (subevent == null) {
                        Tracker.$$$reportNull$$$0(32);
                    }
                    return subevent;
                }
                case JOB_SCHEDULED: {
                    EnergyEvent.Subevent subevent = EnergyEvent.Subevent.JOB_SCHEDULED;
                    if (subevent == null) {
                        Tracker.$$$reportNull$$$0(33);
                    }
                    return subevent;
                }
                case JOB_STARTED: {
                    EnergyEvent.Subevent subevent = EnergyEvent.Subevent.JOB_STARTED;
                    if (subevent == null) {
                        Tracker.$$$reportNull$$$0(34);
                    }
                    return subevent;
                }
                case JOB_STOPPED: {
                    EnergyEvent.Subevent subevent = EnergyEvent.Subevent.JOB_STOPPED;
                    if (subevent == null) {
                        Tracker.$$$reportNull$$$0(35);
                    }
                    return subevent;
                }
                case JOB_FINISHED: {
                    EnergyEvent.Subevent subevent = EnergyEvent.Subevent.JOB_FINISHED;
                    if (subevent == null) {
                        Tracker.$$$reportNull$$$0(36);
                    }
                    return subevent;
                }
                case LOCATION_UPDATE_REQUESTED: {
                    EnergyEvent.Subevent subevent = EnergyEvent.Subevent.LOCATION_UPDATE_REQUESTED;
                    if (subevent == null) {
                        Tracker.$$$reportNull$$$0(37);
                    }
                    return subevent;
                }
                case LOCATION_UPDATE_REMOVED: {
                    EnergyEvent.Subevent subevent = EnergyEvent.Subevent.LOCATION_UPDATE_REMOVED;
                    if (subevent == null) {
                        Tracker.$$$reportNull$$$0(38);
                    }
                    return subevent;
                }
                case LOCATION_CHANGED: {
                    EnergyEvent.Subevent subevent = EnergyEvent.Subevent.LOCATION_CHANGED;
                    if (subevent == null) {
                        Tracker.$$$reportNull$$$0(39);
                    }
                    return subevent;
                }
            }
            EnergyEvent.Subevent subevent = EnergyEvent.Subevent.UNKNOWN_ENERGY_SUBEVENT;
            if (subevent == null) {
                Tracker.$$$reportNull$$$0(40);
            }
            return subevent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 17: 
                case 19: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 17: 
                case 19: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trackingProject";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eventType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stage";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 17: 
                case 19: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/profilers/analytics/StudioFeatureTracker$Tracker";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profilerEvent";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 18: 
                case 26: 
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "energyEvent";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "energyKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/profilers/analytics/StudioFeatureTracker$Tracker";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setDevice";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setCpuCaptureMetadata";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setCpuImportTraceMetadata";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setCpuStartupProfilingConfiguration";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setCpuApiTracingMetadata";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setFilterMetadata";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setEnergyRangeMetadata";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setEnergyEventMetadata";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setMemoryHeapId";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setSessionCreationMetadata";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setSessionSelectionMetadata";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toStatsCpuProfilingConfig";
                    break;
                }
                case 19: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toEnergyType";
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toEnergySubevent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 17: 
                case 19: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "populateEnergyRangeMetadata";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "populateEnergyEventMetadata";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "toStatsCpuProfilingConfig";
                    break;
                }
                case 18: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "toEnergyType";
                    break;
                }
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "toEnergySubtype";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "toEnergySubevent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 17: 
                case 19: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

