/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template.components;

import com.android.tools.idea.npw.template.components.ParameterComponentProvider;
import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.ui.ApiComboBoxItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class EnumComboProvider
extends ParameterComponentProvider<JComboBox> {
    public EnumComboProvider(@NotNull Parameter parameter) {
        if (parameter == null) {
            EnumComboProvider.$$$reportNull$$$0(0);
        }
        super(parameter);
    }

    private static ApiComboBoxItem<String> createItemForOption(@NotNull Parameter parameter, @NotNull Element option) {
        if (parameter == null) {
            EnumComboProvider.$$$reportNull$$$0(1);
        }
        if (option == null) {
            EnumComboProvider.$$$reportNull$$$0(2);
        }
        String optionId = option.getAttribute("id");
        assert (optionId != null && !optionId.isEmpty()) : "id";
        NodeList childNodes2 = option.getChildNodes();
        assert (childNodes2.getLength() == 1 && childNodes2.item(0).getNodeType() == 3);
        String optionLabel = childNodes2.item(0).getNodeValue().trim();
        int minSdk = EnumComboProvider.getIntegerOptionValue(option, "minApi", parameter.name, 1);
        int minBuildApi = EnumComboProvider.getIntegerOptionValue(option, "minBuildApi", parameter.name, 1);
        return new ApiComboBoxItem<String>(optionId, optionLabel, minSdk, minBuildApi);
    }

    private static int getIntegerOptionValue(@NotNull Element option, String attribute, @Nullable String parameterName, int defaultValue) {
        if (option == null) {
            EnumComboProvider.$$$reportNull$$$0(3);
        }
        String stringValue = option.getAttribute(attribute);
        try {
            return StringUtil.isEmpty((String)stringValue) ? defaultValue : Integer.parseInt(stringValue);
        }
        catch (Exception e) {
            EnumComboProvider.getLog().warn(String.format("Invalid %1$s value (%2$s) for option %3$s in parameter %4$s", attribute, stringValue, option.getAttribute("id"), parameterName), (Throwable)e);
            return defaultValue;
        }
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(EnumComboProvider.class);
        if (logger == null) {
            EnumComboProvider.$$$reportNull$$$0(4);
        }
        return logger;
    }

    @Override
    @NotNull
    protected JComboBox createComponent(@NotNull Parameter parameter) {
        if (parameter == null) {
            EnumComboProvider.$$$reportNull$$$0(5);
        }
        List<Element> options = parameter.getOptions();
        DefaultComboBoxModel<ApiComboBoxItem<String>> comboBoxModel = new DefaultComboBoxModel<ApiComboBoxItem<String>>();
        assert (!options.isEmpty());
        for (Element option : options) {
            comboBoxModel.addElement(EnumComboProvider.createItemForOption(parameter, option));
        }
        JComboBox jComboBox = new JComboBox(comboBoxModel);
        if (jComboBox == null) {
            EnumComboProvider.$$$reportNull$$$0(6);
        }
        return jComboBox;
    }

    @Override
    @Nullable
    public AbstractProperty<?> createProperty(@NotNull JComboBox comboBox) {
        if (comboBox == null) {
            EnumComboProvider.$$$reportNull$$$0(7);
        }
        return new ApiComboBoxTextProperty(comboBox);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/template/components/EnumComboProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/template/components/EnumComboProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createItemForOption";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIntegerOptionValue";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createComponent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ApiComboBoxTextProperty
    extends AbstractProperty<String>
    implements ActionListener {
        @NotNull
        private final JComboBox myComboBox;

        ApiComboBoxTextProperty(@NotNull JComboBox comboBox) {
            if (comboBox == null) {
                ApiComboBoxTextProperty.$$$reportNull$$$0(0);
            }
            this.myComboBox = comboBox;
            this.myComboBox.addActionListener(this);
        }

        @Override
        protected void setDirectly(@NotNull String value2) {
            if (value2 == null) {
                ApiComboBoxTextProperty.$$$reportNull$$$0(1);
            }
            int index = -1;
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.myComboBox.getModel();
            for (int i2 = 0; i2 < model.getSize(); ++i2) {
                ApiComboBoxItem item = (ApiComboBoxItem)model.getElementAt(i2);
                if (!value2.equals(item.getData())) continue;
                index = i2;
                break;
            }
            this.myComboBox.setSelectedIndex(index);
        }

        @Override
        @NotNull
        public String get() {
            ApiComboBoxItem item = (ApiComboBoxItem)this.myComboBox.getSelectedItem();
            String string = item != null ? (String)item.getData() : "";
            if (string == null) {
                ApiComboBoxTextProperty.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.notifyInvalidated();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comboBox";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/npw/template/components/EnumComboProvider$ApiComboBoxTextProperty";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/npw/template/components/EnumComboProvider$ApiComboBoxTextProperty";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setDirectly";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

