/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project.deprecated;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.UpdatablePackage;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.gradle.npw.project.GradleAndroidModuleTemplate;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.instantapp.ConfigureInstantModuleStep;
import com.android.tools.idea.npw.model.NewModuleModel;
import com.android.tools.idea.npw.model.NewProjectModel;
import com.android.tools.idea.npw.model.RenderTemplateModel;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.npw.project.deprecated.FormFactorSdkControls;
import com.android.tools.idea.npw.template.ChooseActivityTypeStep;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.wizard.InstallSelectedPackagesStep;
import com.android.tools.idea.sdk.wizard.LicenseAgreementModel;
import com.android.tools.idea.sdk.wizard.LicenseAgreementStep;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.ui.wizard.StudioWizardStepPanel;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureFormFactorStep
extends ModelWizardStep<NewProjectModel> {
    private final AndroidVersionsInfo myAndroidVersionsInfo;
    private final List<UpdatablePackage> myInstallRequests;
    private final List<RemotePackage> myInstallLicenseRequests;
    private final BindingsManager myBindings;
    private final ListenerManager myListeners;
    private final ObjectValueProperty<Integer> myEnabledFormFactors;
    private final Map<FormFactor, FormFactorInfo> myFormFactors;
    private final JBScrollPane myRootPanel;
    private final ValidatorPanel myValidatorPanel;
    private final StringProperty myInvalidParameterMessage;
    private JPanel myPanel;
    private JPanel myFormFactorPanel;
    private JPanel myLoadingPanel;

    public ConfigureFormFactorStep(@NotNull NewProjectModel model) {
        if (model == null) {
            ConfigureFormFactorStep.$$$reportNull$$$0(0);
        }
        super(model, AndroidBundle.message("android.wizard.project.target", new Object[0]));
        this.$$$setupUI$$$();
        this.myAndroidVersionsInfo = new AndroidVersionsInfo();
        this.myInstallRequests = new ArrayList<UpdatablePackage>();
        this.myInstallLicenseRequests = new ArrayList<RemotePackage>();
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.myEnabledFormFactors = new ObjectValueProperty<Integer>(0);
        this.myFormFactors = Maps.newTreeMap();
        this.myInvalidParameterMessage = new StringValueProperty();
        this.populateAdditionalFormFactors();
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myPanel);
        this.myValidatorPanel.registerMessageSource((ObservableValue)this.myInvalidParameterMessage);
        this.myRootPanel = StudioWizardStepPanel.wrappedWithVScroll((JPanel)this.myValidatorPanel);
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myRootPanel);
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        JBScrollPane jBScrollPane = this.myRootPanel;
        if (jBScrollPane == null) {
            ConfigureFormFactorStep.$$$reportNull$$$0(1);
        }
        return jBScrollPane;
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myFormFactorPanel;
    }

    @Override
    @NotNull
    protected Collection<? extends ModelWizardStep> createDependentSteps() {
        ArrayList allSteps = Lists.newArrayList();
        Set<FormFactor> formFactors = this.myFormFactors.keySet();
        for (FormFactor formFactor : formFactors) {
            FormFactorInfo formFactorInfo = this.myFormFactors.get((Object)formFactor);
            NamedModuleTemplate dummyTemplate = GradleAndroidModuleTemplate.createDummyTemplate();
            NewModuleModel moduleModel = new NewModuleModel((NewProjectModel)this.getModel(), formFactorInfo.templateFile);
            RenderTemplateModel renderModel = new RenderTemplateModel(moduleModel, null, dummyTemplate, AndroidBundle.message("android.wizard.activity.add", formFactor.id));
            moduleModel.getRenderTemplateValues().setValue(renderModel.getTemplateValues());
            formFactorInfo.newModuleModel = moduleModel;
            formFactorInfo.newRenderModel = renderModel;
            if (formFactorInfo.controls.getInstantAppCheckbox().isVisible()) {
                allSteps.add(new ConfigureInstantModuleStep(moduleModel, ((NewProjectModel)this.getModel()).projectLocation()));
                this.myListeners.receive(moduleModel.instantApp(), value2 -> this.checkValidity());
            }
            formFactorInfo.step = new ChooseActivityTypeStep(moduleModel, renderModel, formFactor, Lists.newArrayList());
            allSteps.add(formFactorInfo.step);
            FormFactorSdkControls controls = formFactorInfo.controls;
            this.myBindings.bindTwoWay(new SelectedProperty(controls.getInstantAppCheckbox()), moduleModel.instantApp());
            this.myListeners.receive(renderModel.androidSdkInfo(), value2 -> this.checkValidity());
            this.myBindings.bindTwoWay(renderModel.androidSdkInfo(), new SelectedItemProperty(controls.getMinSdkCombobox()));
            this.myListeners.listenAll(this.myEnabledFormFactors, moduleModel.instantApp()).withAndFire(() -> {
                String moduleName = this.myEnabledFormFactors.get() <= 1 ? "app" : ConfigureFormFactorStep.getModuleName(formFactor);
                moduleModel.moduleName().set(moduleName);
            });
            this.myListeners.listenAll(((NewProjectModel)this.getModel()).projectLocation(), moduleModel.moduleName()).withAndFire(() -> {
                File moduleRoot = new File((String)((NewProjectModel)this.getModel()).projectLocation().get(), (String)moduleModel.moduleName().get());
                renderModel.getTemplate().set(GradleAndroidModuleTemplate.createDefaultTemplateAt(moduleRoot));
            });
        }
        allSteps.add(new LicenseAgreementStep(new LicenseAgreementModel(AndroidVersionsInfo.getSdkManagerLocalPath()), this.myInstallLicenseRequests));
        allSteps.add(new InstallSelectedPackagesStep(this.myInstallRequests, new HashSet<LocalPackage>(), AndroidSdks.getInstance().tryToChooseSdkHandler(), false));
        ArrayList arrayList = allSteps;
        if (arrayList == null) {
            ConfigureFormFactorStep.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    protected void onProceeding() {
        Map<String, Object> projectTemplateValues = ((NewProjectModel)this.getModel()).getTemplateValues();
        projectTemplateValues.put("NumberOfEnabledFormFactors", this.myEnabledFormFactors.get());
        this.myFormFactors.forEach((formFactor, formFactorInfo) -> {
            projectTemplateValues.put(formFactor.id + "included", formFactorInfo.controls.getInclusionCheckBox().isSelected());
            projectTemplateValues.put(formFactor.id + "projectName", formFactorInfo.newModuleModel.moduleName().get());
        });
        Set<NewModuleModel> newModuleModels = ((NewProjectModel)this.getModel()).getNewModuleModels();
        newModuleModels.clear();
        ArrayList<AndroidVersionsInfo.VersionItem> installItems = new ArrayList<AndroidVersionsInfo.VersionItem>();
        for (FormFactorInfo formFactorInfo2 : this.myFormFactors.values()) {
            if (!formFactorInfo2.controls.getInclusionCheckBox().isSelected()) continue;
            newModuleModels.add(formFactorInfo2.newModuleModel);
            installItems.add(formFactorInfo2.getAndroidSdkInfo());
        }
        assert (!newModuleModels.isEmpty());
        this.myInstallRequests.clear();
        this.myInstallLicenseRequests.clear();
        this.myInstallRequests.addAll(this.myAndroidVersionsInfo.loadInstallPackageList(installItems));
        this.myInstallLicenseRequests.addAll(this.myInstallRequests.stream().map(UpdatablePackage::getRemote).collect(Collectors.toList()));
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            ConfigureFormFactorStep.$$$reportNull$$$0(3);
        }
        for (FormFactorInfo formFactorInfo : this.myFormFactors.values()) {
            this.myListeners.receiveAndFire(new SelectedProperty(formFactorInfo.controls.getInclusionCheckBox()), value2 -> this.updateStepVisibility(wizard, formFactorInfo.step, (boolean)value2));
        }
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        ObservableBool observableBool = this.myValidatorPanel.hasErrors().not();
        if (observableBool == null) {
            ConfigureFormFactorStep.$$$reportNull$$$0(4);
        }
        return observableBool;
    }

    private void updateStepVisibility(@NotNull ModelWizard.Facade wizardFacade, @NotNull ChooseActivityTypeStep step, boolean isVisible) {
        if (wizardFacade == null) {
            ConfigureFormFactorStep.$$$reportNull$$$0(5);
        }
        if (step == null) {
            ConfigureFormFactorStep.$$$reportNull$$$0(6);
        }
        step.setShouldShow(isVisible);
        int enabledFormFactors = 0;
        for (FormFactorInfo formFactorInfo : this.myFormFactors.values()) {
            if (!formFactorInfo.controls.getInclusionCheckBox().isSelected()) continue;
            ++enabledFormFactors;
        }
        this.myEnabledFormFactors.set(enabledFormFactors);
        this.checkValidity();
        wizardFacade.updateNavigationProperties();
    }

    private void checkValidity() {
        String message = "";
        if (this.myEnabledFormFactors.get() == 0) {
            message = AndroidBundle.message("android.wizard.project.no.selected.form", new Object[0]);
        } else {
            for (FormFactor formFactor : this.myFormFactors.keySet()) {
                FormFactorInfo formFactorInfo = this.myFormFactors.get((Object)formFactor);
                if (!formFactorInfo.controls.getInclusionCheckBox().isSelected()) continue;
                int minTargetSdk = formFactorInfo.getMinTargetSdk();
                FormFactor baseFormFactor = formFactor.baseFormFactor;
                if (baseFormFactor == null) continue;
                FormFactorInfo baseFormFactorInfo = this.myFormFactors.get((Object)baseFormFactor);
                if (baseFormFactorInfo == null || !baseFormFactorInfo.controls.getInclusionCheckBox().isSelected()) {
                    message = AndroidBundle.message("android.wizard.project.missing.form.factor", new Object[]{formFactor, baseFormFactor});
                    break;
                }
                if (minTargetSdk <= baseFormFactorInfo.getMinTargetSdk()) continue;
                message = AndroidBundle.message("android.wizard.project.invalid.base.min.sdk", new Object[]{minTargetSdk, baseFormFactor, formFactor});
                break;
            }
        }
        this.myInvalidParameterMessage.set(message);
    }

    private void createUIComponents() {
        this.myLoadingPanel = new JPanel(new FlowLayout(0));
        AsyncProcessIcon refreshIcon = new AsyncProcessIcon(AndroidBundle.message("android.wizard.module.help.loading", new Object[0]));
        JLabel refreshingLabel = new JLabel(AndroidBundle.message("android.wizard.project.loading.sdks", new Object[0]));
        refreshingLabel.setForeground((Color)JBColor.GRAY);
        this.myLoadingPanel.add((Component)refreshIcon);
        this.myLoadingPanel.add(refreshingLabel);
    }

    private void populateAdditionalFormFactors() {
        TemplateManager manager = TemplateManager.getInstance();
        List<File> applicationTemplates = manager.getTemplatesInCategory("Application");
        for (File templateFile : applicationTemplates) {
            FormFactor formFactor;
            TemplateMetadata metadata = manager.getTemplateMetadata(templateFile);
            if (metadata == null || metadata.getFormFactor() == null || (formFactor = FormFactor.get(metadata.getFormFactor())) == FormFactor.GLASS && !AndroidSdkUtils.isGlassInstalled()) continue;
            FormFactorInfo prevFormFactorInfo = this.myFormFactors.get((Object)formFactor);
            int templateMinSdk = metadata.getMinSdk();
            if (prevFormFactorInfo == null) {
                this.myFormFactors.put(formFactor, new FormFactorInfo(templateFile, Math.max(templateMinSdk, formFactor.getMinOfflineApiLevel())));
                continue;
            }
            if (templateMinSdk <= prevFormFactorInfo.minSdk) continue;
            prevFormFactorInfo.minSdk = templateMinSdk;
            prevFormFactorInfo.templateFile = templateFile;
        }
        this.myFormFactorPanel.setLayout((LayoutManager)new TabularLayout("*").setVGap(5));
        this.myAndroidVersionsInfo.load();
        Set<FormFactor> formFactors = this.myFormFactors.keySet();
        AtomicInteger loadingCounter = new AtomicInteger(formFactors.size());
        int row = 0;
        for (FormFactor formFactor : formFactors) {
            FormFactorSdkControls controls;
            FormFactorInfo formFactorInfo = this.myFormFactors.get((Object)formFactor);
            formFactorInfo.controls = controls = new FormFactorSdkControls(this, formFactor);
            this.myFormFactorPanel.add((Component)controls.getComponent(), new TabularLayout.Constraint(row, 0));
            ++row;
            this.myAndroidVersionsInfo.loadTargetVersions(formFactor, formFactorInfo.minSdk, items2 -> {
                controls.init(items2);
                Object selectedMinSdkItem = controls.getMinSdkCombobox().getSelectedItem();
                controls.getInclusionCheckBox().setSelected(selectedMinSdkItem != null && FormFactor.MOBILE.equals((Object)formFactor));
                if (loadingCounter.decrementAndGet() == 0) {
                    this.myLoadingPanel.setVisible(false);
                }
            });
        }
    }

    @NotNull
    private static String getModuleName(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            ConfigureFormFactorStep.$$$reportNull$$$0(7);
        }
        if (formFactor.baseFormFactor != null) {
            formFactor = formFactor.baseFormFactor;
        }
        String name = formFactor.id;
        String string = name.replaceAll("\\s", "_").toLowerCase(Locale.US);
        if (string == null) {
            ConfigureFormFactorStep.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/project/deprecated/ConfigureFormFactorStep";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizardFacade";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formFactor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/project/deprecated/ConfigureFormFactorStep";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDependentSteps";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "canGoForward";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onWizardStarting";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateStepVisibility";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getModuleName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        Font font = this.$$$getFont$$$(null, 1, 18, jBLabel.getFont());
        if (font != null) {
            jBLabel.setFont(font);
        }
        jBLabel.setText("Select the form factors and minimum SDK");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(88, 15), null));
        JBLabel jBLabel2 = new JBLabel();
        Font font2 = this.$$$getFont$$$(null, -1, -1, jBLabel2.getFont());
        if (font2 != null) {
            jBLabel2.setFont(font2);
        }
        jBLabel2.setText("<html>Some devices require additional SDKs. Low API levels target more devices, but offer fewer API features.</html>");
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 7, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 1, 0, 1, 0, new Dimension(-1, 14), new Dimension(-1, 14), null));
        this.myFormFactorPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(750, -1), null));
        JPanel jPanel3 = this.myLoadingPanel;
        jPanel2.add((Component)jPanel3, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, new Dimension(88, 14), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }

    private static class FormFactorInfo {
        File templateFile;
        int minSdk;
        FormFactorSdkControls controls;
        NewModuleModel newModuleModel;
        RenderTemplateModel newRenderModel;
        ChooseActivityTypeStep step;

        FormFactorInfo(File templateFile, int minSdk) {
            this.templateFile = templateFile;
            this.minSdk = minSdk;
        }

        int getMinTargetSdk() {
            AndroidVersionsInfo.VersionItem androidVersion = this.newRenderModel.androidSdkInfo().getValueOrNull();
            return androidVersion == null ? 0 : androidVersion.getMinApiLevel();
        }

        @NotNull
        AndroidVersionsInfo.VersionItem getAndroidSdkInfo() {
            AndroidVersionsInfo.VersionItem versionItem = this.newRenderModel.androidSdkInfo().getValue();
            if (versionItem == null) {
                FormFactorInfo.$$$reportNull$$$0(0);
            }
            return versionItem;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/project/deprecated/ConfigureFormFactorStep$FormFactorInfo", "getAndroidSdkInfo"));
        }
    }
}

