/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.module;

import com.android.tools.adtui.ASGallery;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.idea.npw.model.NewModuleModel;
import com.android.tools.idea.npw.model.ProjectSyncInvoker;
import com.android.tools.idea.npw.module.ModuleDescriptionProvider;
import com.android.tools.idea.npw.module.ModuleGalleryEntry;
import com.android.tools.idea.npw.module.ModuleTemplateGalleryEntry;
import com.android.tools.idea.npw.ui.WizardGallery;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.ListModel;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseModuleTypeStep
extends ModelWizardStep.WithoutModel {
    public static final String ANDROID_WEAR_MODULE_NAME = "Wear OS Module";
    public static final String ANDROID_TV_MODULE_NAME = "Android TV Module";
    public static final String ANDROID_THINGS_MODULE_NAME = "Android Things Module";
    public static final String JAVA_LIBRARY_MODULE_NAME = "Java Library";
    public static final String GOOGLE_CLOUD_MODULE_NAME = "Google Cloud Module";
    private final List<ModuleGalleryEntry> myModuleGalleryEntryList;
    private final ProjectSyncInvoker myProjectSyncInvoker;
    private final JComponent myRootPanel;
    private final Project myProject;
    private ASGallery<ModuleGalleryEntry> myFormFactorGallery;
    private Map<ModuleGalleryEntry, SkippableWizardStep> myModuleDescriptionToStepMap;

    public ChooseModuleTypeStep(@NotNull Project project, @NotNull List<ModuleGalleryEntry> moduleGalleryEntries, @NotNull ProjectSyncInvoker projectSyncInvoker) {
        if (project == null) {
            ChooseModuleTypeStep.$$$reportNull$$$0(0);
        }
        if (moduleGalleryEntries == null) {
            ChooseModuleTypeStep.$$$reportNull$$$0(1);
        }
        if (projectSyncInvoker == null) {
            ChooseModuleTypeStep.$$$reportNull$$$0(2);
        }
        super(AndroidBundle.message("android.wizard.module.new.module.header", new Object[0]));
        this.myProject = project;
        this.myModuleGalleryEntryList = ChooseModuleTypeStep.sortModuleEntries(moduleGalleryEntries);
        this.myProjectSyncInvoker = projectSyncInvoker;
        this.myRootPanel = this.createGallery();
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myRootPanel);
    }

    @NotNull
    public static ChooseModuleTypeStep createWithDefaultGallery(Project project, ProjectSyncInvoker projectSyncInvoker) {
        ArrayList<ModuleGalleryEntry> moduleDescriptions = new ArrayList<ModuleGalleryEntry>();
        for (ModuleDescriptionProvider provider : (ModuleDescriptionProvider[])ModuleDescriptionProvider.EP_NAME.getExtensions()) {
            moduleDescriptions.addAll(provider.getDescriptions(project));
        }
        ChooseModuleTypeStep chooseModuleTypeStep2 = new ChooseModuleTypeStep(project, moduleDescriptions, projectSyncInvoker);
        if (chooseModuleTypeStep2 == null) {
            ChooseModuleTypeStep.$$$reportNull$$$0(3);
        }
        return chooseModuleTypeStep2;
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        JComponent jComponent = this.myRootPanel;
        if (jComponent == null) {
            ChooseModuleTypeStep.$$$reportNull$$$0(4);
        }
        return jComponent;
    }

    @Override
    @NotNull
    public Collection<? extends ModelWizardStep> createDependentSteps() {
        ArrayList allSteps = Lists.newArrayList();
        this.myModuleDescriptionToStepMap = new HashMap<ModuleGalleryEntry, SkippableWizardStep>();
        for (ModuleGalleryEntry moduleGalleryEntry : this.myModuleGalleryEntryList) {
            NewModuleModel model = new NewModuleModel(this.myProject, this.myProjectSyncInvoker);
            if (moduleGalleryEntry instanceof ModuleTemplateGalleryEntry) {
                ModuleTemplateGalleryEntry templateEntry = (ModuleTemplateGalleryEntry)moduleGalleryEntry;
                model.isLibrary().set(templateEntry.isLibrary());
                model.instantApp().set(templateEntry.isInstantApp());
                model.templateFile().setValue(templateEntry.getTemplateFile());
            }
            SkippableWizardStep step = moduleGalleryEntry.createStep(model);
            allSteps.add(step);
            this.myModuleDescriptionToStepMap.put(moduleGalleryEntry, step);
        }
        ArrayList arrayList = allSteps;
        if (arrayList == null) {
            ChooseModuleTypeStep.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private JComponent createGallery() {
        this.myFormFactorGallery = new WizardGallery<ModuleGalleryEntry>(this.getTitle(), galEntry -> galEntry.getIcon() == null ? null : galEntry.getIcon(), galEntry -> galEntry == null ? AndroidBundle.message("android.wizard.gallery.item.none", new Object[0]) : galEntry.getName());
        JBScrollPane jBScrollPane = new JBScrollPane(this.myFormFactorGallery);
        if (jBScrollPane == null) {
            ChooseModuleTypeStep.$$$reportNull$$$0(6);
        }
        return jBScrollPane;
    }

    @Override
    protected void onWizardStarting(final @NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            ChooseModuleTypeStep.$$$reportNull$$$0(7);
        }
        this.myFormFactorGallery.setModel((ListModel)JBList.createDefaultListModel((Object[])this.myModuleGalleryEntryList.toArray()));
        this.myFormFactorGallery.setDefaultAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                wizard.goForward();
            }
        });
        this.myFormFactorGallery.setSelectedIndex(0);
    }

    @Override
    protected void onProceeding() {
        ModuleGalleryEntry selectedEntry = (ModuleGalleryEntry)this.myFormFactorGallery.getSelectedElement();
        this.myModuleDescriptionToStepMap.forEach((galleryEntry, step) -> step.setShouldShow(galleryEntry == selectedEntry));
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myFormFactorGallery;
    }

    @VisibleForTesting
    @NotNull
    static List<ModuleGalleryEntry> sortModuleEntries(@NotNull List<ModuleGalleryEntry> moduleTypesProviders) {
        if (moduleTypesProviders == null) {
            ChooseModuleTypeStep.$$$reportNull$$$0(8);
        }
        String[] orderedNames = new String[]{AndroidBundle.message("android.wizard.module.new.mobile", new Object[0]), AndroidBundle.message("android.wizard.module.new.library", new Object[0]), AndroidBundle.message("android.wizard.module.new.dynamic.module", new Object[0]), AndroidBundle.message("android.wizard.module.new.dynamic.module.instant", new Object[0]), AndroidBundle.message("android.wizard.module.new.instant.app", new Object[0]), AndroidBundle.message("android.wizard.module.new.feature.module", new Object[0]), ANDROID_WEAR_MODULE_NAME, ANDROID_TV_MODULE_NAME, ANDROID_THINGS_MODULE_NAME, AndroidBundle.message("android.wizard.module.import.gradle.title", new Object[0]), AndroidBundle.message("android.wizard.module.import.eclipse.title", new Object[0]), AndroidBundle.message("android.wizard.module.import.title", new Object[0]), JAVA_LIBRARY_MODULE_NAME, GOOGLE_CLOUD_MODULE_NAME};
        Map<String, ModuleGalleryEntry> entryMap = moduleTypesProviders.stream().collect(Collectors.toMap(ModuleGalleryEntry::getName, c -> c));
        ArrayList<ModuleGalleryEntry> result2 = new ArrayList<ModuleGalleryEntry>();
        for (String name : orderedNames) {
            ModuleGalleryEntry entry = entryMap.remove(name);
            if (entry == null) continue;
            result2.add(entry);
        }
        ArrayList<ModuleGalleryEntry> secondHalf = new ArrayList<ModuleGalleryEntry>(entryMap.values());
        Collections.sort(secondHalf, Comparator.comparing(ModuleGalleryEntry::getName));
        result2.addAll(secondHalf);
        ArrayList<ModuleGalleryEntry> arrayList = result2;
        if (arrayList == null) {
            ChooseModuleTypeStep.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleGalleryEntries";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSyncInvoker";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/module/ChooseModuleTypeStep";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleTypesProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/module/ChooseModuleTypeStep";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createWithDefaultGallery";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createDependentSteps";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createGallery";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "sortModuleEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onWizardStarting";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sortModuleEntries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

