/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.model;

import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.npw.model.MultiTemplateRenderer;
import com.android.tools.idea.npw.model.NewProjectModel;
import com.android.tools.idea.npw.model.ProjectSyncInvoker;
import com.android.tools.idea.npw.model.RenderTemplateModel;
import com.android.tools.idea.npw.template.TemplateValueInjector;
import com.android.tools.idea.observable.BatchInvoker;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableString;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.observable.expressions.string.StringExpression;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NewModuleModel
extends WizardModel {
    private final BindingsManager myBindings;
    @NotNull
    private final StringProperty myModuleName;
    @NotNull
    private final StringProperty mySplitName;
    @NotNull
    private final BoolProperty myIsLibrary;
    @NotNull
    private final OptionalProperty<File> myTemplateFile;
    @NotNull
    private final OptionalProperty<Map<String, Object>> myRenderTemplateValues;
    @NotNull
    private final Map<String, Object> myTemplateValues;
    @NotNull
    private final StringProperty myApplicationName;
    @NotNull
    private final StringProperty myPackageName;
    @NotNull
    private final StringProperty myProjectPackageName;
    @NotNull
    private final BoolProperty myIsInstantApp;
    @NotNull
    private final BoolProperty myEnableCppSupport;
    @NotNull
    private final OptionalProperty<Project> myProject;
    @NotNull
    private final ProjectSyncInvoker myProjectSyncInvoker;
    @NotNull
    private final MultiTemplateRenderer myMultiTemplateRenderer;
    private final boolean myCreateInExistingProject;

    public NewModuleModel(@NotNull Project project, @NotNull ProjectSyncInvoker projectSyncInvoker) {
        if (project == null) {
            NewModuleModel.$$$reportNull$$$0(0);
        }
        if (projectSyncInvoker == null) {
            NewModuleModel.$$$reportNull$$$0(1);
        }
        this.myBindings = new BindingsManager(BatchInvoker.INVOKE_IMMEDIATELY_STRATEGY);
        this.myModuleName = new StringValueProperty();
        this.mySplitName = new StringValueProperty("feature");
        this.myIsLibrary = new BoolValueProperty();
        this.myTemplateFile = new OptionalValueProperty<File>();
        this.myRenderTemplateValues = new OptionalValueProperty<Map<String, Object>>();
        this.myTemplateValues = Maps.newHashMap();
        this.myPackageName = new StringValueProperty();
        this.myIsInstantApp = new BoolValueProperty();
        this.myModuleName.addConstraint(String::trim);
        this.mySplitName.addConstraint(String::trim);
        this.myProject = new OptionalValueProperty<Project>(project);
        this.myProjectSyncInvoker = projectSyncInvoker;
        this.myProjectPackageName = this.myPackageName;
        this.myCreateInExistingProject = true;
        this.myEnableCppSupport = new BoolValueProperty();
        this.myApplicationName = new StringValueProperty(AndroidBundle.message("android.wizard.module.config.new.application", new Object[0]));
        this.myApplicationName.addConstraint(String::trim);
        this.myIsLibrary.addListener(sender -> this.updateApplicationName());
        this.myIsInstantApp.addListener(sender -> this.updateApplicationName());
        this.myMultiTemplateRenderer = new MultiTemplateRenderer(project, projectSyncInvoker);
    }

    public NewModuleModel(@NotNull NewProjectModel projectModel, @NotNull File templateFile) {
        if (projectModel == null) {
            NewModuleModel.$$$reportNull$$$0(2);
        }
        if (templateFile == null) {
            NewModuleModel.$$$reportNull$$$0(3);
        }
        this.myBindings = new BindingsManager(BatchInvoker.INVOKE_IMMEDIATELY_STRATEGY);
        this.myModuleName = new StringValueProperty();
        this.mySplitName = new StringValueProperty("feature");
        this.myIsLibrary = new BoolValueProperty();
        this.myTemplateFile = new OptionalValueProperty<File>();
        this.myRenderTemplateValues = new OptionalValueProperty<Map<String, Object>>();
        this.myTemplateValues = Maps.newHashMap();
        this.myPackageName = new StringValueProperty();
        this.myIsInstantApp = new BoolValueProperty();
        this.myModuleName.addConstraint(String::trim);
        this.mySplitName.addConstraint(String::trim);
        this.myProject = projectModel.project();
        this.myProjectPackageName = projectModel.packageName();
        this.myProjectSyncInvoker = projectModel.getProjectSyncInvoker();
        this.myCreateInExistingProject = false;
        this.myEnableCppSupport = projectModel.enableCppSupport();
        this.myApplicationName = projectModel.applicationName();
        this.myTemplateFile.setValue(templateFile);
        this.myMultiTemplateRenderer = projectModel.getMultiTemplateRenderer();
        this.myMultiTemplateRenderer.incrementRenders();
        this.myBindings.bind(this.myPackageName, this.myProjectPackageName, this.myIsInstantApp.not());
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myBindings.releaseAll();
    }

    @NotNull
    public OptionalProperty<Project> getProject() {
        OptionalProperty<Project> optionalProperty = this.myProject;
        if (optionalProperty == null) {
            NewModuleModel.$$$reportNull$$$0(4);
        }
        return optionalProperty;
    }

    @NotNull
    public ProjectSyncInvoker getProjectSyncInvoker() {
        ProjectSyncInvoker projectSyncInvoker = this.myProjectSyncInvoker;
        if (projectSyncInvoker == null) {
            NewModuleModel.$$$reportNull$$$0(5);
        }
        return projectSyncInvoker;
    }

    @NotNull
    public StringProperty applicationName() {
        StringProperty stringProperty = this.myApplicationName;
        if (stringProperty == null) {
            NewModuleModel.$$$reportNull$$$0(6);
        }
        return stringProperty;
    }

    @NotNull
    public StringProperty moduleName() {
        StringProperty stringProperty = this.myModuleName;
        if (stringProperty == null) {
            NewModuleModel.$$$reportNull$$$0(7);
        }
        return stringProperty;
    }

    @NotNull
    public StringProperty splitName() {
        StringProperty stringProperty = this.mySplitName;
        if (stringProperty == null) {
            NewModuleModel.$$$reportNull$$$0(8);
        }
        return stringProperty;
    }

    @NotNull
    public StringProperty packageName() {
        StringProperty stringProperty = this.myPackageName;
        if (stringProperty == null) {
            NewModuleModel.$$$reportNull$$$0(9);
        }
        return stringProperty;
    }

    @NotNull
    public BoolProperty isLibrary() {
        BoolProperty boolProperty = this.myIsLibrary;
        if (boolProperty == null) {
            NewModuleModel.$$$reportNull$$$0(10);
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty instantApp() {
        BoolProperty boolProperty = this.myIsInstantApp;
        if (boolProperty == null) {
            NewModuleModel.$$$reportNull$$$0(11);
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty enableCppSupport() {
        BoolProperty boolProperty = this.myEnableCppSupport;
        if (boolProperty == null) {
            NewModuleModel.$$$reportNull$$$0(12);
        }
        return boolProperty;
    }

    @NotNull
    public OptionalProperty<File> templateFile() {
        OptionalProperty<File> optionalProperty = this.myTemplateFile;
        if (optionalProperty == null) {
            NewModuleModel.$$$reportNull$$$0(13);
        }
        return optionalProperty;
    }

    @NotNull
    public Map<String, Object> getTemplateValues() {
        Map<String, Object> map2 = this.myTemplateValues;
        if (map2 == null) {
            NewModuleModel.$$$reportNull$$$0(14);
        }
        return map2;
    }

    @NotNull
    public OptionalProperty<Map<String, Object>> getRenderTemplateValues() {
        OptionalProperty<Map<String, Object>> optionalProperty = this.myRenderTemplateValues;
        if (optionalProperty == null) {
            NewModuleModel.$$$reportNull$$$0(15);
        }
        return optionalProperty;
    }

    @NotNull
    public MultiTemplateRenderer getMultiTemplateRenderer() {
        MultiTemplateRenderer multiTemplateRenderer = this.myMultiTemplateRenderer;
        if (multiTemplateRenderer == null) {
            NewModuleModel.$$$reportNull$$$0(16);
        }
        return multiTemplateRenderer;
    }

    @NotNull
    public ObservableString computedFeatureModulePackageName() {
        StringExpression stringExpression = new StringExpression(new ObservableValue[]{this.myProjectPackageName, this.mySplitName}){

            @Override
            @NotNull
            public String get() {
                String string = (String)NewModuleModel.this.myProjectPackageName.get() + "." + (String)NewModuleModel.this.mySplitName.get();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/model/NewModuleModel$1", "get"));
            }
        };
        if (stringExpression == null) {
            NewModuleModel.$$$reportNull$$$0(17);
        }
        return stringExpression;
    }

    public void setDefaultRenderTemplateValues(@NotNull RenderTemplateModel renderModel, @Nullable Project project) {
        if (renderModel == null) {
            NewModuleModel.$$$reportNull$$$0(18);
        }
        HashMap renderTemplateValues = Maps.newHashMap();
        new TemplateValueInjector(renderTemplateValues).setBuildVersion(renderModel.androidSdkInfo().getValue(), project).setModuleRoots(((NamedModuleTemplate)renderModel.getTemplate().get()).getPaths(), (String)this.packageName().get());
        this.getRenderTemplateValues().setValue(renderTemplateValues);
    }

    @Override
    protected void handleFinished() {
        this.myMultiTemplateRenderer.requestRender(new ModuleTemplateRenderer());
    }

    @Override
    protected void handleSkipped() {
        this.myMultiTemplateRenderer.skipRender();
    }

    private void updateApplicationName() {
        String msgId;
        if (((Boolean)this.myIsInstantApp.get()).booleanValue()) {
            boolean isNewBaseFeature = ((Optional)this.myProject.get()).isPresent() && InstantApps.findBaseFeature(this.myProject.getValue()) == null;
            msgId = isNewBaseFeature ? "android.wizard.module.config.new.base.feature" : "android.wizard.module.config.new.feature";
        } else {
            msgId = (Boolean)this.myIsLibrary.get() != false ? "android.wizard.module.config.new.library" : "android.wizard.module.config.new.application";
        }
        this.myApplicationName.set(AndroidBundle.message(msgId, new Object[0]));
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(NewModuleModel.class);
        if (logger == null) {
            NewModuleModel.$$$reportNull$$$0(19);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSyncInvoker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/model/NewModuleModel";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/model/NewModuleModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSyncInvoker";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "applicationName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "splitName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "packageName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "isLibrary";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "instantApp";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "enableCppSupport";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "templateFile";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateValues";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderTemplateValues";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getMultiTemplateRenderer";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "computedFeatureModulePackageName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultRenderTemplateValues";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ModuleTemplateRenderer
    implements MultiTemplateRenderer.TemplateRenderer {
        Map<String, Object> myTemplateValues;

        private ModuleTemplateRenderer() {
        }

        @Override
        public boolean doDryRun() {
            if (NewModuleModel.this.myTemplateFile.getValueOrNull() == null) {
                return false;
            }
            if (!((Optional)NewModuleModel.this.myProject.get()).isPresent()) {
                NewModuleModel.getLog().error("NewModuleModel did not collect expected information and will not complete. Please report this error.");
                return false;
            }
            Map renderTemplateValues = (Map)NewModuleModel.this.myRenderTemplateValues.getValueOrNull();
            this.myTemplateValues = new HashMap<String, Object>(NewModuleModel.this.myTemplateValues);
            this.myTemplateValues.put("isLibraryProject", NewModuleModel.this.myIsLibrary.get());
            Project project = (Project)NewModuleModel.this.myProject.getValue();
            if (((Boolean)NewModuleModel.this.myIsInstantApp.get()).booleanValue()) {
                this.myTemplateValues.put("instantAppPackageName", NewModuleModel.this.myProjectPackageName.get());
                if (renderTemplateValues != null) {
                    new TemplateValueInjector(renderTemplateValues).setInstantAppSupport(NewModuleModel.this.myCreateInExistingProject, project, (String)NewModuleModel.this.myModuleName.get());
                }
                if (NewModuleModel.this.myCreateInExistingProject) {
                    boolean hasInstantAppWrapper = (Boolean)NewModuleModel.this.myIsInstantApp.get() != false && InstantApps.findBaseFeature(project) == null;
                    this.myTemplateValues.put("hasMonolithicAppWrapper", false);
                    this.myTemplateValues.put("hasInstantAppWrapper", hasInstantAppWrapper);
                }
            }
            if (renderTemplateValues != null) {
                this.myTemplateValues.putAll(renderTemplateValues);
            }
            return this.renderModule(true, this.myTemplateValues, project, (String)NewModuleModel.this.myModuleName.get());
        }

        @Override
        public void render() {
            final Project project = (Project)NewModuleModel.this.myProject.getValue();
            boolean success = (Boolean)new WriteCommandAction<Boolean>(project, "New Module", new PsiFile[0]){

                protected void run(@NotNull Result<Boolean> result2) {
                    if (result2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    result2.setResult((Object)ModuleTemplateRenderer.this.renderModule(false, ModuleTemplateRenderer.this.myTemplateValues, project, (String)NewModuleModel.this.myModuleName.get()));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/npw/model/NewModuleModel$ModuleTemplateRenderer$1", "run"));
                }
            }.execute().getResultObject();
            if (!success) {
                NewModuleModel.getLog().warn("A problem occurred while creating a new Module. Please check the log file for possible errors.");
            }
        }

        private boolean renderModule(boolean dryRun, @NotNull Map<String, Object> templateState, @NotNull Project project, @NotNull String moduleName) {
            if (templateState == null) {
                ModuleTemplateRenderer.$$$reportNull$$$0(0);
            }
            if (project == null) {
                ModuleTemplateRenderer.$$$reportNull$$$0(1);
            }
            if (moduleName == null) {
                ModuleTemplateRenderer.$$$reportNull$$$0(2);
            }
            File projectRoot = new File(project.getBasePath());
            File moduleRoot = new File(projectRoot, moduleName);
            Template template = Template.createFromPath((File)NewModuleModel.this.myTemplateFile.getValue());
            ArrayList<File> filesToOpen = new ArrayList<File>();
            RenderingContext context = RenderingContext.Builder.newContext(template, project).withCommandName("New Module").withDryRun(dryRun).withShowErrors(true).withOutputRoot(projectRoot).withModuleRoot(moduleRoot).intoOpenFiles(filesToOpen).withParams(templateState).build();
            boolean renderResult = template.render(context, dryRun);
            if (renderResult && !dryRun) {
                DumbService.getInstance((Project)project).smartInvokeLater(() -> TemplateUtils.openEditors(project, filesToOpen, false));
            }
            return renderResult;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "templateState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "moduleName";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/npw/model/NewModuleModel$ModuleTemplateRenderer";
            objectArray[2] = "renderModule";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

