/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.importing;

import com.android.tools.idea.npw.importing.ArchiveToGradleModuleModel;
import com.android.tools.idea.npw.importing.ArchiveToGradleModuleStep;
import com.android.tools.idea.npw.importing.SourceToGradleModuleModel;
import com.android.tools.idea.npw.importing.SourceToGradleModuleStep;
import com.android.tools.idea.npw.model.NewModuleModel;
import com.android.tools.idea.npw.module.ModuleDescriptionProvider;
import com.android.tools.idea.npw.module.ModuleGalleryEntry;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.npw.ui.ActivityGallery;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import java.awt.Image;
import java.io.File;
import java.util.Collection;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportModuleGalleryEntryProvider
implements ModuleDescriptionProvider {
    public Collection<ModuleGalleryEntry> getDescriptions(Project project) {
        return ImmutableList.of((Object)new SourceImportModuleGalleryEntry(AndroidBundle.message("android.wizard.module.import.eclipse.title", new Object[0])), (Object)new SourceImportModuleGalleryEntry(AndroidBundle.message("android.wizard.module.import.gradle.title", new Object[0])), (Object)new ArchiveImportModuleGalleryEntry());
    }

    private static class ArchiveImportModuleGalleryEntry
    implements ModuleGalleryEntry {
        private ArchiveImportModuleGalleryEntry() {
        }

        @Override
        @Nullable
        public Image getIcon() {
            File androidModuleTemplate = TemplateManager.getInstance().getTemplateFile("Application", "Android Project");
            return ActivityGallery.getTemplateImage(new TemplateHandle(androidModuleTemplate), false);
        }

        @Override
        @NotNull
        public String getName() {
            String string = AndroidBundle.message("android.wizard.module.import.title", new Object[0]);
            if (string == null) {
                ArchiveImportModuleGalleryEntry.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nullable
        public String getDescription() {
            return AndroidBundle.message("android.wizard.module.import.description", new Object[0]);
        }

        @Override
        @NotNull
        public SkippableWizardStep createStep(@NotNull NewModuleModel model) {
            if (model == null) {
                ArchiveImportModuleGalleryEntry.$$$reportNull$$$0(1);
            }
            ArchiveToGradleModuleStep archiveToGradleModuleStep = new ArchiveToGradleModuleStep(new ArchiveToGradleModuleModel(model.getProject().getValue(), model.getProjectSyncInvoker()));
            if (archiveToGradleModuleStep == null) {
                ArchiveImportModuleGalleryEntry.$$$reportNull$$$0(2);
            }
            return archiveToGradleModuleStep;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/npw/importing/ImportModuleGalleryEntryProvider$ArchiveImportModuleGalleryEntry";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/npw/importing/ImportModuleGalleryEntryProvider$ArchiveImportModuleGalleryEntry";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createStep";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createStep";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SourceImportModuleGalleryEntry
    implements ModuleGalleryEntry {
        @NotNull
        private final TemplateHandle myTemplateHandle;

        SourceImportModuleGalleryEntry(String templateName) {
            this.myTemplateHandle = new TemplateHandle(TemplateManager.getInstance().getTemplateFile("Application", templateName));
        }

        @Override
        @Nullable
        public Image getIcon() {
            return ActivityGallery.getTemplateImage(this.myTemplateHandle, false);
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myTemplateHandle.getMetadata().getTitle();
            if (string == null) {
                SourceImportModuleGalleryEntry.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.myTemplateHandle.getMetadata().getDescription();
        }

        @Override
        @NotNull
        public SkippableWizardStep createStep(@NotNull NewModuleModel model) {
            if (model == null) {
                SourceImportModuleGalleryEntry.$$$reportNull$$$0(1);
            }
            SourceToGradleModuleStep sourceToGradleModuleStep = new SourceToGradleModuleStep(new SourceToGradleModuleModel(model.getProject().getValue(), model.getProjectSyncInvoker()));
            if (sourceToGradleModuleStep == null) {
                SourceImportModuleGalleryEntry.$$$reportNull$$$0(2);
            }
            return sourceToGradleModuleStep;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/npw/importing/ImportModuleGalleryEntryProvider$SourceImportModuleGalleryEntry";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/npw/importing/ImportModuleGalleryEntryProvider$SourceImportModuleGalleryEntry";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createStep";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createStep";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

