/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.ideahost;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.npw.ideahost.IdeaWizardAdapter;
import com.android.tools.idea.npw.model.NewProjectModel;
import com.android.tools.idea.npw.model.ProjectSyncInvoker;
import com.android.tools.idea.npw.module.ChooseModuleTypeStep;
import com.android.tools.idea.npw.project.ChooseAndroidProjectStep;
import com.android.tools.idea.npw.project.ConfigureAndroidSdkStep;
import com.android.tools.idea.npw.project.deprecated.ConfigureAndroidProjectStep;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.google.common.base.Preconditions;
import com.intellij.ide.util.newProjectWizard.WizardDelegate;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import icons.AndroidArtworkIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidModuleBuilder
extends ModuleBuilder
implements WizardDelegate {
    private static final String MODULE_NAME = "Android";
    private static final String MODULE_DESCRIPTION = "Android modules are used for developing apps to run on the <b>Android</b> operating system. An <b>Android</b> module consists of one or more <b>Activities</b> and may support a number of form-factors including <b>Phone and Tablet</b>, <b>Wear</b> and <b>Android Auto</b>.";
    @Nullable
    private IdeaWizardAdapter myWizardAdapter;

    public void setupRootModel(ModifiableRootModel modifiableRootModel) {
    }

    public String getBuilderId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getPresentableName() {
        return MODULE_NAME;
    }

    public String getDescription() {
        return MODULE_DESCRIPTION;
    }

    public Icon getNodeIcon() {
        return AndroidArtworkIcons.Icons.Android;
    }

    public String getParentGroup() {
        return "Java";
    }

    @NotNull
    public ModuleType getModuleType() {
        ModuleType moduleType = JavaModuleType.getModuleType();
        if (moduleType == null) {
            AndroidModuleBuilder.$$$reportNull$$$0(0);
        }
        return moduleType;
    }

    public ModuleWizardStep modifyProjectTypeStep(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            AndroidModuleBuilder.$$$reportNull$$$0(1);
        }
        return null;
    }

    @Nullable
    public ModuleWizardStep getCustomOptionsStep(WizardContext ctx, Disposable parentDisposable) {
        if (this.myWizardAdapter == null) {
            this.createWizardAdaptor(ctx.getWizard(), ctx.isCreatingNewProject() ? WizardType.PROJECT : WizardType.MODULE, ctx.getProject());
        }
        assert (this.myWizardAdapter != null);
        return this.myWizardAdapter.getProxyStep();
    }

    public void doNextAction() {
        assert (this.myWizardAdapter != null);
        this.myWizardAdapter.doNextAction();
    }

    public void doPreviousAction() {
        assert (this.myWizardAdapter != null);
        this.myWizardAdapter.doPreviousAction();
    }

    public void doFinishAction() {
        assert (this.myWizardAdapter != null);
        this.myWizardAdapter.doFinishAction();
    }

    public boolean canProceed() {
        assert (this.myWizardAdapter != null);
        return this.myWizardAdapter.canProceed();
    }

    private void createWizardAdaptor(@NotNull AbstractWizard hostWizard, @NotNull WizardType type, Project project) {
        if (hostWizard == null) {
            AndroidModuleBuilder.$$$reportNull$$$0(2);
        }
        if (type == null) {
            AndroidModuleBuilder.$$$reportNull$$$0(3);
        }
        Preconditions.checkState((this.myWizardAdapter == null ? 1 : 0) != 0, (Object)"Attempting to create a Wizard Adaptor when one already exists.");
        ModelWizard.Builder builder = new ModelWizard.Builder(new ModelWizardStep[0]);
        if (IdeSdks.getInstance().getAndroidSdkPath() == null) {
            builder.addStep(new ConfigureAndroidSdkStep());
        }
        if (type == WizardType.PROJECT) {
            if (((Boolean)StudioFlags.NPW_DYNAMIC_APPS.get()).booleanValue()) {
                builder.addStep(new ChooseAndroidProjectStep(new NewProjectModel()));
            } else {
                builder.addStep(new ConfigureAndroidProjectStep(new NewProjectModel()));
            }
        } else {
            ChooseModuleTypeStep chooseModuleTypeStep2 = ChooseModuleTypeStep.createWithDefaultGallery(project, new ProjectSyncInvoker.DefaultProjectSyncInvoker());
            builder.addStep(chooseModuleTypeStep2);
        }
        this.myWizardAdapter = new IdeaWizardAdapter(hostWizard, builder.build());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/ideahost/AndroidModuleBuilder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsStep";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostWizard";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleType";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/ideahost/AndroidModuleBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "modifyProjectTypeStep";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createWizardAdaptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum WizardType {
        PROJECT,
        MODULE;

    }
}

