/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.dynamicapp;

import com.android.tools.idea.gradle.npw.project.GradleAndroidModuleTemplate;
import com.android.tools.idea.npw.model.NewProjectModel;
import com.android.tools.idea.npw.model.ProjectSyncInvoker;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.npw.template.TemplateValueInjector;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class DynamicFeatureModel
extends WizardModel {
    @NotNull
    private final Project myProject;
    @NotNull
    private final TemplateHandle myTemplateHandle;
    @NotNull
    private final ProjectSyncInvoker myProjectSyncInvoker;
    @NotNull
    private final StringProperty myModuleName;
    @NotNull
    private final StringProperty myFeatureTitle;
    @NotNull
    private final StringProperty myPackageName;
    @NotNull
    private final OptionalProperty<AndroidVersionsInfo.VersionItem> myAndroidSdkInfo;
    @NotNull
    private final OptionalProperty<Module> myBaseApplication;
    @NotNull
    private final BoolProperty myFeatureOnDemand;
    @NotNull
    private final BoolProperty myFeatureFusing;
    @NotNull
    private final BoolProperty myInstantModule;

    public DynamicFeatureModel(@NotNull Project project, @NotNull TemplateHandle templateHandle, @NotNull ProjectSyncInvoker projectSyncInvoker) {
        if (project == null) {
            DynamicFeatureModel.$$$reportNull$$$0(0);
        }
        if (templateHandle == null) {
            DynamicFeatureModel.$$$reportNull$$$0(1);
        }
        if (projectSyncInvoker == null) {
            DynamicFeatureModel.$$$reportNull$$$0(2);
        }
        this.myModuleName = new StringValueProperty("dynamic_feature");
        this.myFeatureTitle = new StringValueProperty("Module Title");
        this.myPackageName = new StringValueProperty();
        this.myAndroidSdkInfo = new OptionalValueProperty<AndroidVersionsInfo.VersionItem>();
        this.myBaseApplication = new OptionalValueProperty<Module>();
        this.myFeatureOnDemand = new BoolValueProperty(true);
        this.myFeatureFusing = new BoolValueProperty(true);
        this.myInstantModule = new BoolValueProperty(false);
        this.myProject = project;
        this.myTemplateHandle = templateHandle;
        this.myProjectSyncInvoker = projectSyncInvoker;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DynamicFeatureModel.$$$reportNull$$$0(3);
        }
        return project;
    }

    @NotNull
    public TemplateHandle getTemplateHandle() {
        TemplateHandle templateHandle = this.myTemplateHandle;
        if (templateHandle == null) {
            DynamicFeatureModel.$$$reportNull$$$0(4);
        }
        return templateHandle;
    }

    @NotNull
    public StringProperty moduleName() {
        StringProperty stringProperty = this.myModuleName;
        if (stringProperty == null) {
            DynamicFeatureModel.$$$reportNull$$$0(5);
        }
        return stringProperty;
    }

    @NotNull
    public StringProperty featureTitle() {
        StringProperty stringProperty = this.myFeatureTitle;
        if (stringProperty == null) {
            DynamicFeatureModel.$$$reportNull$$$0(6);
        }
        return stringProperty;
    }

    @NotNull
    public StringProperty packageName() {
        StringProperty stringProperty = this.myPackageName;
        if (stringProperty == null) {
            DynamicFeatureModel.$$$reportNull$$$0(7);
        }
        return stringProperty;
    }

    public OptionalProperty<Module> baseApplication() {
        return this.myBaseApplication;
    }

    public OptionalProperty<AndroidVersionsInfo.VersionItem> androidSdkInfo() {
        return this.myAndroidSdkInfo;
    }

    public BoolProperty featureOnDemand() {
        return this.myFeatureOnDemand;
    }

    public BoolProperty featureFusing() {
        return this.myFeatureFusing;
    }

    public BoolProperty instantModule() {
        return this.myInstantModule;
    }

    @Override
    protected void handleFinished() {
        File moduleRoot = new File(this.myProject.getBasePath(), (String)this.moduleName().get());
        HashMap myTemplateValues = Maps.newHashMap();
        new TemplateValueInjector(myTemplateValues).setModuleRoots(GradleAndroidModuleTemplate.createDefaultTemplateAt(moduleRoot).getPaths(), (String)this.packageName().get()).setBuildVersion(this.androidSdkInfo().getValue(), this.myProject).setBaseFeature(this.baseApplication().getValue());
        myTemplateValues.put("isDynamicFeature", true);
        myTemplateValues.put("projectSimpleName", NewProjectModel.toPackagePart((String)this.moduleName().get()));
        myTemplateValues.put("dynamicFeatureTitle", this.featureTitle().get());
        myTemplateValues.put("dynamicFeatureOnDemand", this.featureOnDemand().get());
        myTemplateValues.put("dynamicFeatureFusing", this.featureFusing().get());
        myTemplateValues.put("makeIgnore", true);
        myTemplateValues.put("isNewProject", true);
        myTemplateValues.put("isLibraryProject", false);
        myTemplateValues.put("isInstantModule", this.instantModule().get());
        if (this.doDryRun(moduleRoot, myTemplateValues)) {
            this.render(moduleRoot, myTemplateValues);
        }
    }

    private boolean doDryRun(@NotNull File moduleRoot, @NotNull Map<String, Object> templateValues) {
        if (moduleRoot == null) {
            DynamicFeatureModel.$$$reportNull$$$0(8);
        }
        if (templateValues == null) {
            DynamicFeatureModel.$$$reportNull$$$0(9);
        }
        return this.renderTemplate(true, this.myProject, moduleRoot, templateValues);
    }

    private void render(@NotNull File moduleRoot, @NotNull Map<String, Object> templateValues) {
        if (moduleRoot == null) {
            DynamicFeatureModel.$$$reportNull$$$0(10);
        }
        if (templateValues == null) {
            DynamicFeatureModel.$$$reportNull$$$0(11);
        }
        this.renderTemplate(false, this.myProject, moduleRoot, templateValues);
        this.myProjectSyncInvoker.syncProject(this.myProject);
    }

    private boolean renderTemplate(boolean dryRun, @NotNull Project project, @NotNull File moduleRoot, @NotNull Map<String, Object> templateValues) {
        if (project == null) {
            DynamicFeatureModel.$$$reportNull$$$0(12);
        }
        if (moduleRoot == null) {
            DynamicFeatureModel.$$$reportNull$$$0(13);
        }
        if (templateValues == null) {
            DynamicFeatureModel.$$$reportNull$$$0(14);
        }
        Template template = this.myTemplateHandle.getTemplate();
        RenderingContext context = RenderingContext.Builder.newContext(template, project).withCommandName(AndroidBundle.message("android.wizard.module.new.module.menu.description", new Object[0])).withDryRun(dryRun).withShowErrors(true).withModuleRoot(moduleRoot).withParams(templateValues).build();
        return template.render(context, dryRun);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateHandle";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSyncInvoker";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/dynamicapp/DynamicFeatureModel";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRoot";
                break;
            }
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/dynamicapp/DynamicFeatureModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateHandle";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "featureTitle";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "packageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doDryRun";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "renderTemplate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

