/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.ide.common.vectordrawable.VdIcon;
import com.android.tools.idea.npw.assetstudio.MaterialDesignIcons;
import com.google.common.base.Joiner;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IconPickerDialog
extends DialogWrapper {
    @NotNull
    private static final String[] ICON_CATEGORIES = IconPickerDialog.initIconCategories();
    private static final String ALL_CATEGORY = ICON_CATEGORIES[0];
    private static final int COLUMN_NUMBER = 6;
    private static final int ICON_ROW_HEIGHT = JBUI.scale((int)64);
    private final Multimap<String, VdIcon> myCategoryIcons;
    private final List<VdIcon> myIconList;
    private final List<VdIcon> myFilteredIconList;
    private final AbstractTableModel myModel;
    private final JBTable myIconTable;
    private JPanel myContentPanel;
    private JPanel myCategoriesPanel;
    private JPanel myIconsPanel;
    private JPanel myLicensePanel;
    private HyperlinkLabel myLicenseLabel;
    private SearchTextField mySearchField;
    @Nullable
    private VdIcon mySelectedIcon;

    private static String[] initIconCategories() {
        Collection<String> categories = MaterialDesignIcons.getCategories();
        ArrayList<String> allAndCategories = new ArrayList<String>(categories.size() + 1);
        allAndCategories.add("All");
        allAndCategories.addAll(categories);
        return allAndCategories.toArray(ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public IconPickerDialog(@Nullable VdIcon selectedIcon) {
        super(false);
        this.$$$setupUI$$$();
        this.myCategoryIcons = TreeMultimap.create();
        this.myIconList = new ArrayList<VdIcon>(1000);
        this.myFilteredIconList = new ArrayList<VdIcon>(1000);
        this.myModel = new AbstractTableModel(){

            @Override
            public String getColumnName(int column) {
                return null;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return VdIcon.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                int index = rowIndex * 6 + columnIndex;
                if (index < 0) {
                    return null;
                }
                return IconPickerDialog.this.myFilteredIconList.size() > index ? IconPickerDialog.this.myFilteredIconList.get(index) : null;
            }

            @Override
            public int getRowCount() {
                return IconPickerDialog.this.myFilteredIconList.size() / 6 + (IconPickerDialog.this.myFilteredIconList.size() % 6 == 0 ? 0 : 1);
            }

            @Override
            public int getColumnCount() {
                return 6;
            }
        };
        this.myIconTable = new JBTable((TableModel)this.myModel);
        this.setTitle("Select Icon");
        this.initializeIconMap();
        Object[] categories = IconPickerDialog.getCategoryNames();
        JBList categoryList = new JBList(categories);
        JBScrollPane categoryPane = new JBScrollPane((Component)categoryList);
        this.myCategoriesPanel.add((Component)categoryPane);
        Color iconBackgroundColor = UIUtil.getListBackground();
        DefaultTableCellRenderer tableRenderer = new DefaultTableCellRenderer(){

            @Override
            public void setValue(@Nullable Object value2) {
                VdIcon icon = (VdIcon)value2;
                this.setText("");
                this.setIcon((Icon)icon);
                String displayName = icon != null ? icon.getDisplayName() : "";
                AccessibleContextUtil.setName((Component)this, (String)displayName);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                if (table2.getValueAt(row, column) == null) {
                    Component cell = super.getTableCellRendererComponent(table2, value2, false, false, row, column);
                    cell.setFocusable(false);
                    return cell;
                }
                JComponent component = (JComponent)super.getTableCellRendererComponent(table2, value2, isSelected, hasFocus, row, column);
                component.setFont((Font)JBUI.Fonts.miniFont());
                if (!isSelected) {
                    component.setBackground((Color)JBColor.WHITE);
                }
                component.setForeground(isSelected ? table2.getSelectionForeground() : JBColor.GRAY);
                return component;
            }
        };
        this.myIconTable.setBackground(iconBackgroundColor);
        this.myIconTable.setDefaultRenderer(VdIcon.class, (TableCellRenderer)tableRenderer);
        this.myIconTable.setRowHeight(ICON_ROW_HEIGHT);
        this.myIconTable.setSelectionMode(0);
        this.myIconTable.setCellSelectionEnabled(true);
        this.myIconsPanel.add((Component)new JBScrollPane((Component)this.myIconTable));
        this.myIconTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char keyChar = e.getKeyChar();
                if (Character.isLetter(keyChar) || Character.isDigit(keyChar)) {
                    IconPickerDialog.this.mySearchField.setText(Character.toString(keyChar));
                    IconPickerDialog.this.mySearchField.requestFocus();
                }
                super.keyPressed(e);
            }
        });
        this.myLicenseLabel.setHyperlinkText("These icons are available under the ", "Apache License Version 2.0", "");
        this.myLicenseLabel.setHyperlinkTarget("http://www.apache.org/licenses/LICENSE-2.0.txt");
        ListSelectionModel selModel = this.myIconTable.getSelectionModel();
        this.myIconTable.getColumnModel().setColumnSelectionAllowed(true);
        this.myIconTable.setGridColor(iconBackgroundColor);
        this.myIconTable.setIntercellSpacing((Dimension)JBUI.size((int)3, (int)3));
        this.myIconTable.setRowMargin(0);
        ListSelectionListener listener2 = e -> {
            VdIcon icon;
            if (e.getValueIsAdjusting()) {
                return;
            }
            int row = this.myIconTable.getSelectedRow();
            int col = this.myIconTable.getSelectedColumn();
            this.mySelectedIcon = icon = row != -1 && col != -1 ? (VdIcon)this.myIconTable.getValueAt(row, col) : null;
            this.setOKActionEnabled(icon != null);
        };
        selModel.addListSelectionListener(listener2);
        ListSelectionModel colSelModel = this.myIconTable.getColumnModel().getSelectionModel();
        colSelModel.addListSelectionListener(listener2);
        categoryList.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int selectedIndex = categoryList.getSelectedIndex();
            if (selectedIndex >= 0) {
                String category = ICON_CATEGORIES[selectedIndex];
                this.updateIconList(category);
            }
        });
        categoryList.setSelectedIndex(0);
        selModel.setSelectionMode(0);
        selModel.setSelectionInterval(0, 0);
        this.myIconTable.setColumnSelectionInterval(0, 0);
        this.myIconTable.requestFocusInWindow();
        if (selectedIcon != null) {
            this.initializeSelection(selectedIcon);
        }
        this.init();
    }

    @NotNull
    static String[] getCategoryNames() {
        String[] stringArray = Arrays.stream(ICON_CATEGORIES).map(category -> category.equals("av") ? "Audio/Video" : StringUtil.capitalize((String)category)).collect(Collectors.toList()).toArray(ArrayUtil.EMPTY_STRING_ARRAY);
        if (stringArray == null) {
            IconPickerDialog.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    private void createUIComponents() {
        this.mySearchField = new SearchTextField(false);
        this.mySearchField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                IconPickerDialog.this.updateFilter();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/npw/assetstudio/ui/IconPickerDialog$4", "textChanged"));
            }
        });
    }

    private void updateFilter() {
        String text = this.mySearchField.getText().trim();
        this.myFilteredIconList.clear();
        for (VdIcon icon : this.myIconList) {
            if (!text.isEmpty() && !StringUtil.containsIgnoreCase((String)icon.getDisplayName(), (String)text)) continue;
            this.myFilteredIconList.add(icon);
        }
        this.myModel.fireTableDataChanged();
    }

    private void initializeSelection(@NotNull VdIcon selectedIcon) {
        if (selectedIcon == null) {
            IconPickerDialog.$$$reportNull$$$0(1);
        }
        for (int r = 0; r < this.myIconTable.getRowCount(); ++r) {
            for (int c = 0; c < this.myIconTable.getColumnCount(); ++c) {
                VdIcon icon = (VdIcon)this.myIconTable.getValueAt(r, c);
                if (icon == null || !icon.getURL().equals(selectedIcon.getURL())) continue;
                this.myIconTable.changeSelection(r, c, false, false);
                return;
            }
        }
    }

    private void initializeIconMap() {
        for (int i2 = 1; i2 < ICON_CATEGORIES.length; ++i2) {
            String categoryName = ICON_CATEGORIES[i2];
            for (String iconName : MaterialDesignIcons.getIconNames(categoryName)) {
                URL url = MaterialDesignIcons.getIcon(iconName, categoryName);
                try {
                    VdIcon icon = new VdIcon(url);
                    icon.setShowName(true);
                    this.myCategoryIcons.put((Object)categoryName, (Object)icon);
                }
                catch (IOException iOException) {}
            }
        }
        this.myCategoryIcons.putAll((Object)ALL_CATEGORY, (Iterable)this.myCategoryIcons.values());
    }

    @Nullable
    public VdIcon getSelectedIcon() {
        return this.mySelectedIcon;
    }

    JTable getTable() {
        return this.myIconTable;
    }

    void setFilter(String text) {
        this.mySearchField.setText(text);
    }

    private void updateIconList(@NotNull String categoryName) {
        if (categoryName == null) {
            IconPickerDialog.$$$reportNull$$$0(2);
        }
        this.myIconList.clear();
        assert (this.myCategoryIcons.containsKey((Object)categoryName)) : String.format("Category '%1$s' is not populated. List of populated categories: %2$s", categoryName, Joiner.on((String)",").join((Iterable)this.myCategoryIcons.keySet()));
        this.myIconList.addAll(this.myCategoryIcons.get((Object)categoryName));
        this.myIconTable.getColumnModel().setColumnSelectionAllowed(true);
        this.updateFilter();
        this.myIconTable.setColumnSelectionInterval(0, 0);
        this.myIconTable.getSelectionModel().setSelectionInterval(0, 0);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel jPanel = this.myContentPanel;
        if (jPanel == null) {
            IconPickerDialog.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/ui/IconPickerDialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedIcon";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "categoryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCategoryNames";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/ui/IconPickerDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initializeSelection";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateIconList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        HyperlinkLabel hyperlinkLabel;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.createUIComponents();
        this.myContentPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(20, 20));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel5, "West");
        this.myCategoriesPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel3, "Center");
        SearchTextField searchTextField = this.mySearchField;
        jPanel5.add((Component)searchTextField, "North");
        this.myIconsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, "Center");
        this.myLicensePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, "South");
        this.myLicenseLabel = hyperlinkLabel = new HyperlinkLabel();
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

