/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.resources.Density;
import com.android.sdklib.AndroidVersion;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.DrawableRenderer;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.LauncherIconGenerator;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconType;
import com.android.tools.idea.npw.assetstudio.ui.AssetComponent;
import com.android.tools.idea.npw.assetstudio.ui.ClipartIconButton;
import com.android.tools.idea.npw.assetstudio.ui.ConfigureIconView;
import com.android.tools.idea.npw.assetstudio.ui.ImageAssetBrowser;
import com.android.tools.idea.npw.assetstudio.ui.TextAssetEditor;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentState;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentStateUtil;
import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.SettableValue;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.IntProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.expressions.bool.BooleanExpression;
import com.android.tools.idea.observable.expressions.optional.AsOptionalExpression;
import com.android.tools.idea.observable.expressions.string.FormatExpression;
import com.android.tools.idea.observable.ui.ColorProperty;
import com.android.tools.idea.observable.ui.EnabledProperty;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.SelectedRadioButtonProperty;
import com.android.tools.idea.observable.ui.SliderValueProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.observable.ui.VisibleProperty;
import com.android.tools.idea.templates.TemplateManager;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureLauncherIconPanel
extends JPanel
implements Disposable,
ConfigureIconView,
PersistentStateComponent<PersistentState> {
    private static final boolean HIDE_INAPPLICABLE_CONTROLS = false;
    private static final File DEFAULT_FOREGROUND_IMAGE = ConfigureLauncherIconPanel.getTemplateImage("drawable-v24", "ic_launcher_foreground.xml");
    private static final File DEFAULT_BACKGROUND_IMAGE = ConfigureLauncherIconPanel.getTemplateImage("drawable", "ic_launcher_background.xml");
    private static final ForegroundAssetType DEFAULT_FOREGROUND_ASSET_TYPE = ForegroundAssetType.IMAGE;
    private static final BackgroundAssetType DEFAULT_BACKGROUND_ASSET_TYPE = BackgroundAssetType.IMAGE;
    private static final Density DEFAULT_PREVIEW_DENSITY = Density.XHIGH;
    private static final String DEFAULT_OUTPUT_NAME = AndroidIconType.LAUNCHER.toOutputName("");
    private static final IconGenerator.Shape DEFAULT_ICON_SHAPE = IconGenerator.Shape.SQUARE;
    private static final String FOREGROUND_ASSET_TYPE_PROPERTY = "foregroundAssetType";
    private static final String BACKGROUND_ASSET_TYPE_PROPERTY = "backgroundAssetType";
    private static final String BACKGROUND_COLOR_PROPERTY = "backgroundColor";
    private static final String GENERATE_LEGACY_ICON_PROPERTY = "generateLegacyIcon";
    private static final String GENERATE_ROUND_ICON_PROPERTY = "generateRoundIcon";
    private static final String GENERATE_WEB_ICON_PROPERTY = "generateWebIcon";
    private static final String LEGACY_ICON_SHAPE_PROPERTY = "legacyIconShape";
    private static final String WEB_ICON_SHAPE_PROPERTY = "webIconShape";
    private static final String SHOW_GRID_PROPERTY = "showGrid";
    private static final String SHOW_SAFE_ZONE_PROPERTY = "showSafeZone";
    private static final String PREVIEW_DENSITY_PROPERTY = "previewDensity";
    private static final String OUTPUT_NAME_PROPERTY = "outputName";
    private static final String FOREGROUND_LAYER_NAME_PROPERTY = "foregroundLayerName";
    private static final String BACKGROUND_LAYER_NAME_PROPERTY = "backgroundLayerName";
    private static final String FOREGROUND_IMAGE_PROPERTY = "foregroundImage";
    private static final String BACKGROUND_IMAGE_PROPERTY = "backgroundImage";
    private static final String FOREGROUND_CLIPART_ASSET_PROPERTY = "foregroundClipartAsset";
    private static final String FOREGROUND_TEXT_ASSET_PROPERTY = "foregroundTextAsset";
    private JPanel myRootPanel;
    private JBLabel myOutputNameLabel;
    private JTextField myOutputNameTextField;
    private JPanel myForegroundAllOptionsPanel;
    private JRadioButton myForegroundClipartRadioButton;
    private JRadioButton myForegroundTextRadioButton;
    private JRadioButton myForegroundImageRadioButton;
    private JRadioButton myForegroundTrimYesRadioButton;
    private JRadioButton myForegroundTrimNoRadioButton;
    private JPanel myForegroundTrimOptionsPanel;
    private JSlider myForegroundResizeSlider;
    private JLabel myForegroundResizeValueLabel;
    private JPanel myForegroundAssetRadioButtonsPanel;
    private JPanel myForegroundResizeSliderPanel;
    private JTextField myForegroundLayerNameTextField;
    private JPanel myForegroundColorRowPanel;
    private ColorPanel myForegroundColorPanel;
    private JPanel mGenerateLegacyIconRadioButtonsPanel;
    private JRadioButton myGenerateLegacyIconYesRadioButton;
    private JBScrollPane myForegroundScrollPane;
    private JPanel myForegroundImageAssetRowPanel;
    private JPanel myForegroundClipartAssetRowPanel;
    private JPanel myForegroundTextAssetRowPanel;
    private ImageAssetBrowser myForegroundImageAssetBrowser;
    private ClipartIconButton myForegroundClipartAssetButton;
    private TextAssetEditor myForegroundTextAssetEditor;
    private JBLabel myForegroundLayerNameLabel;
    private JLabel myForegroundAssetTypeLabel;
    private JBLabel myForegroundImagePathLabel;
    private JBLabel myForegroundClipartLabel;
    private JBLabel myForegroundTextLabel;
    private JBLabel myForegroundTrimLabel;
    private JBLabel myForegroundResizeLabel;
    private JBLabel myForegroundColorLabel;
    private JBLabel myGenerateLegacyIconLabel;
    private JPanel myBackgroundAllOptionsPanel;
    private JRadioButton myBackgroundImageRadioButton;
    private JRadioButton myBackgroundColorRadioButton;
    private JRadioButton myBackgroundTrimYesRadioButton;
    private JPanel myBackgroundTrimOptionsPanel;
    private JSlider myBackgroundResizeSlider;
    private JLabel myBackgroundResizeValueLabel;
    private JPanel myBackgroundAssetRadioButtonsPanel;
    private JPanel myBackgroundResizeSliderPanel;
    private JTextField myBackgroundLayerNameTextField;
    private JPanel myBackgroundTrimRowPanel;
    private JPanel myBackgroundResizeRowPanel;
    private JPanel myBackgroundColorRowPanel;
    private ColorPanel myBackgroundColorPanel;
    private JPanel myGenerateRoundIconRowPanel;
    private JPanel myGenerateRoundIconRadioButtonsPanel;
    private JRadioButton myGenerateRoundIconYesRadioButton;
    private JBScrollPane myBackgroundScrollPane;
    private JComboBox<IconGenerator.Shape> myLegacyIconShapeComboBox;
    private JPanel myBackgroundImageAssetRowPanel;
    private ImageAssetBrowser myBackgroundImageAssetBrowser;
    private JBLabel myBackgroundLayerNameLabel;
    private JLabel myBackgroundAssetTypeLabel;
    private JBLabel myBackgroundImagePathLabel;
    private JBLabel myBackgroundTrimLabel;
    private JBLabel myBackgroundResizeLabel;
    private JBLabel myGenerateRoundIconLabel;
    private JBLabel myBackgroundColorLabel;
    private JBLabel myLegacyIconShapeLabel;
    private JBScrollPane myOtherIconsScrollPane;
    private JPanel myOtherIconsAllOptionsPanel;
    private JPanel myForegroundAssetTypePanel;
    private JPanel myForegroundLayerNamePanel;
    private JPanel myForegroundAssetTypeSourcePanel;
    private JPanel myForegroundImageOptionsPanel;
    private JPanel myBackgroundLayerNamePanel;
    private JPanel myBackgroundAssetTypePanel;
    private JPanel myBackgroundAssetTypeSourcePanel;
    private JPanel myBackgroundImageOptionsPanel;
    private JPanel myLegacyIconShapePanelRow;
    private JPanel myOutputNamePanelRow;
    private TitledSeparator myForegroundScalingTitleSeparator;
    private TitledSeparator mySourceAssetTitleSeparator;
    private JPanel myForegroundResizePanel;
    private TitledSeparator myBackgroundScalingTitleSeparator;
    private TitledSeparator myBackgroundSourceAssetTitleSeparator;
    private JPanel myGenerateLegacyIconRowPanel;
    private JPanel myForegroundTrimPanel;
    private JPanel myLegacyIconShapePanel;
    private JPanel myGenerateWebIconRowPanel;
    private JBLabel myGenerateWebIconLabel;
    private JPanel myGenerateWebIconRadioButtonsPanel;
    private JRadioButton myGenerateWebIconYesRadioButton;
    private JRadioButton myBackgroundTrimNoRadioButton;
    private JBLabel myWebIconShapeLabel;
    private JComboBox<IconGenerator.Shape> myWebIconShapeComboBox;
    private JPanel myWebIconShapePanel;
    private JPanel myWebIconShapePanelRow;
    private final Map<IconGenerator.Shape, String> myShapeNames;
    @NotNull
    private final AndroidVersion myBuildSdkVersion;
    @NotNull
    private final LauncherIconGenerator myIconGenerator;
    @NotNull
    private final ValidatorPanel myValidatorPanel;
    @NotNull
    private final BindingsManager myGeneralBindings;
    @NotNull
    private final BindingsManager myForegroundActiveAssetBindings;
    @NotNull
    private final BindingsManager myBackgroundActiveAssetBindings;
    @NotNull
    private final ListenerManager myListeners;
    @NotNull
    private final List<ActionListener> myAssetListeners;
    @NotNull
    private final ImmutableMap<ForegroundAssetType, AssetComponent> myForegroundAssetPanelMap;
    @NotNull
    private final StringProperty myOutputName;
    @NotNull
    private final StringProperty myForegroundLayerName;
    @NotNull
    private final StringProperty myBackgroundLayerName;
    @NotNull
    private final ObjectProperty<BaseAsset> myForegroundActiveAsset;
    @NotNull
    private final OptionalProperty<ImageAsset> myBackgroundImageAsset;
    @NotNull
    private final ObjectProperty<Validator.Result> myForegroundAssetValidityState;
    @NotNull
    private final ObjectProperty<Validator.Result> myBackgroundAssetValidityState;
    @NotNull
    private final AbstractProperty<ForegroundAssetType> myForegroundAssetType;
    @NotNull
    private final AbstractProperty<BackgroundAssetType> myBackgroundAssetType;
    @NotNull
    private final BoolProperty myShowGrid;
    @NotNull
    private final BoolProperty myShowSafeZone;
    @NotNull
    private final AbstractProperty<Density> myPreviewDensity;
    private BoolProperty myIgnoreForegroundColor;
    private AbstractProperty<Color> myForegroundColor;
    private AbstractProperty<Color> myBackgroundColor;
    private BoolProperty myForegroundTrimmed;
    private BoolProperty myBackgroundTrimmed;
    private IntProperty myForegroundResizePercent;
    private IntProperty myBackgroundResizePercent;
    private BoolProperty myGenerateLegacyIcon;
    private BoolProperty myGenerateRoundIcon;
    private BoolProperty myGenerateWebIcon;
    private AbstractProperty<IconGenerator.Shape> myLegacyIconShape;
    private AbstractProperty<IconGenerator.Shape> myWebIconShape;

    public ConfigureLauncherIconPanel(@NotNull Disposable disposableParent, @NotNull AndroidFacet facet, @NotNull BoolProperty showGrid, @NotNull BoolProperty showSafeZone, @NotNull AbstractProperty<Density> previewDensity, @NotNull ValidatorPanel validatorPanel, @Nullable DrawableRenderer renderer) {
        if (disposableParent == null) {
            ConfigureLauncherIconPanel.$$$reportNull$$$0(0);
        }
        if (facet == null) {
            ConfigureLauncherIconPanel.$$$reportNull$$$0(1);
        }
        if (showGrid == null) {
            ConfigureLauncherIconPanel.$$$reportNull$$$0(2);
        }
        if (showSafeZone == null) {
            ConfigureLauncherIconPanel.$$$reportNull$$$0(3);
        }
        if (previewDensity == null) {
            ConfigureLauncherIconPanel.$$$reportNull$$$0(4);
        }
        if (validatorPanel == null) {
            ConfigureLauncherIconPanel.$$$reportNull$$$0(5);
        }
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myShapeNames = ImmutableMap.of((Object)((Object)IconGenerator.Shape.NONE), (Object)"None", (Object)((Object)IconGenerator.Shape.CIRCLE), (Object)"Circle", (Object)((Object)IconGenerator.Shape.SQUARE), (Object)"Square", (Object)((Object)IconGenerator.Shape.VRECT), (Object)"Vertical", (Object)((Object)IconGenerator.Shape.HRECT), (Object)"Horizontal");
        this.myGeneralBindings = new BindingsManager();
        this.myForegroundActiveAssetBindings = new BindingsManager();
        this.myBackgroundActiveAssetBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.myAssetListeners = new ArrayList<ActionListener>(1);
        this.myForegroundAssetValidityState = new ObjectValueProperty<Validator.Result>(Validator.Result.OK);
        this.myBackgroundAssetValidityState = new ObjectValueProperty<Validator.Result>(Validator.Result.OK);
        AndroidModuleInfo androidModuleInfo = AndroidModuleInfo.getInstance(facet);
        AndroidVersion buildSdkVersion = androidModuleInfo.getBuildSdkVersion();
        this.myBuildSdkVersion = buildSdkVersion != null ? buildSdkVersion : new AndroidVersion(26);
        this.myShowGrid = showGrid;
        this.myShowSafeZone = showSafeZone;
        this.myPreviewDensity = previewDensity;
        this.myIconGenerator = new LauncherIconGenerator(facet.getModule().getProject(), androidModuleInfo.getMinSdkVersion().getApiLevel(), renderer);
        this.myValidatorPanel = validatorPanel;
        DefaultComboBoxModel<IconGenerator.Shape> legacyShapesModel = new DefaultComboBoxModel<IconGenerator.Shape>();
        for (IconGenerator.Shape shape : this.myShapeNames.keySet()) {
            legacyShapesModel.addElement(shape);
        }
        this.myLegacyIconShapeComboBox.setRenderer((ListCellRenderer<IconGenerator.Shape>)new ListCellRendererWrapper<IconGenerator.Shape>(){

            public void customize(JList list, IconGenerator.Shape shape, int index, boolean selected, boolean hasFocus) {
                this.setText((String)ConfigureLauncherIconPanel.this.myShapeNames.get((Object)shape));
            }
        });
        this.myLegacyIconShapeComboBox.setModel(legacyShapesModel);
        this.myLegacyIconShapeComboBox.setSelectedItem((Object)IconGenerator.Shape.SQUARE);
        DefaultComboBoxModel<IconGenerator.Shape> webShapesModel = new DefaultComboBoxModel<IconGenerator.Shape>();
        for (IconGenerator.Shape shape : this.myShapeNames.keySet()) {
            webShapesModel.addElement(shape);
        }
        this.myWebIconShapeComboBox.setRenderer((ListCellRenderer<IconGenerator.Shape>)new ListCellRendererWrapper<IconGenerator.Shape>(){

            public void customize(JList list, IconGenerator.Shape shape, int index, boolean selected, boolean hasFocus) {
                this.setText((String)ConfigureLauncherIconPanel.this.myShapeNames.get((Object)shape));
            }
        });
        this.myWebIconShapeComboBox.setModel(webShapesModel);
        this.myWebIconShapeComboBox.setSelectedItem((Object)IconGenerator.Shape.SQUARE);
        this.myForegroundScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.myForegroundScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myBackgroundScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.myBackgroundScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myOtherIconsScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.myOtherIconsScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myOutputName = new TextProperty(this.myOutputNameTextField);
        this.myForegroundLayerName = new TextProperty(this.myForegroundLayerNameTextField);
        this.myBackgroundLayerName = new TextProperty(this.myBackgroundLayerNameTextField);
        this.myForegroundAssetPanelMap = ImmutableMap.of((Object)((Object)ForegroundAssetType.IMAGE), (Object)this.myForegroundImageAssetBrowser, (Object)((Object)ForegroundAssetType.CLIP_ART), (Object)this.myForegroundClipartAssetButton, (Object)((Object)ForegroundAssetType.TEXT), (Object)this.myForegroundTextAssetEditor);
        this.myForegroundImageAssetBrowser.getAsset().imagePath().setValue(DEFAULT_FOREGROUND_IMAGE);
        this.myBackgroundImageAssetBrowser.getAsset().imagePath().setValue(DEFAULT_BACKGROUND_IMAGE);
        this.myOutputNameLabel.setLabelFor((Component)this.myOutputNameTextField);
        this.myForegroundLayerNameLabel.setLabelFor((Component)this.myForegroundLayerNameTextField);
        this.myForegroundAssetTypeLabel.setLabelFor(this.myForegroundAssetRadioButtonsPanel);
        this.myForegroundImagePathLabel.setLabelFor((Component)((Object)this.myForegroundImageAssetBrowser));
        this.myForegroundClipartLabel.setLabelFor((Component)this.myForegroundClipartAssetButton);
        this.myForegroundTextLabel.setLabelFor((Component)this.myForegroundTextAssetEditor);
        this.myForegroundTrimLabel.setLabelFor((Component)this.myForegroundTrimOptionsPanel);
        this.myForegroundResizeLabel.setLabelFor((Component)this.myForegroundResizeSliderPanel);
        this.myForegroundColorLabel.setLabelFor((Component)this.myForegroundColorPanel);
        this.myGenerateLegacyIconLabel.setLabelFor((Component)this.mGenerateLegacyIconRadioButtonsPanel);
        this.myBackgroundLayerNameLabel.setLabelFor((Component)this.myBackgroundLayerNameTextField);
        this.myBackgroundAssetTypeLabel.setLabelFor(this.myBackgroundAssetRadioButtonsPanel);
        this.myBackgroundImagePathLabel.setLabelFor((Component)((Object)this.myBackgroundImageAssetBrowser));
        this.myBackgroundTrimLabel.setLabelFor((Component)this.myBackgroundTrimOptionsPanel);
        this.myBackgroundResizeLabel.setLabelFor((Component)this.myBackgroundResizeSliderPanel);
        this.myBackgroundColorLabel.setLabelFor((Component)this.myBackgroundColorPanel);
        this.myGenerateRoundIconLabel.setLabelFor((Component)this.myGenerateRoundIconRadioButtonsPanel);
        this.myLegacyIconShapeLabel.setLabelFor(this.myLegacyIconShapeComboBox);
        this.myWebIconShapeLabel.setLabelFor(this.myWebIconShapeComboBox);
        ImageAsset imageAsset = this.myForegroundClipartAssetButton.getAsset();
        this.myForegroundAssetType = new SelectedRadioButtonProperty<ForegroundAssetType>(DEFAULT_FOREGROUND_ASSET_TYPE, (T[])ForegroundAssetType.values(), this.myForegroundImageRadioButton, this.myForegroundClipartRadioButton, this.myForegroundTextRadioButton);
        this.myForegroundActiveAsset = new ObjectValueProperty<ImageAsset>(this.myForegroundImageAssetBrowser.getAsset());
        this.myForegroundImageAssetBrowser.getAsset().setRole("a foreground image file");
        this.myForegroundColorPanel.setSelectedColor((Color)this.myIconGenerator.foregroundColor().get());
        this.myBackgroundAssetType = new SelectedRadioButtonProperty<BackgroundAssetType>(DEFAULT_BACKGROUND_ASSET_TYPE, (T[])BackgroundAssetType.values(), this.myBackgroundImageRadioButton, this.myBackgroundColorRadioButton);
        this.myBackgroundImageAsset = new OptionalValueProperty<ImageAsset>(this.myBackgroundImageAssetBrowser.getAsset());
        this.myBackgroundImageAssetBrowser.getAsset().setRole("a background image file");
        this.myBackgroundColorPanel.setSelectedColor((Color)this.myIconGenerator.backgroundColor().get());
        this.initializeListenersAndBindings();
        this.initializeValidators();
        Disposer.register((Disposable)disposableParent, (Disposable)this);
        for (AssetComponent assetComponent : this.myForegroundAssetPanelMap.values()) {
            Disposer.register((Disposable)this, (Disposable)assetComponent);
        }
        Disposer.register((Disposable)this, (Disposable)this.myBackgroundImageAssetBrowser);
        Disposer.register((Disposable)this, (Disposable)this.myIconGenerator);
        this.add(this.myRootPanel);
    }

    @NotNull
    public PersistentState getState() {
        PersistentState state = new PersistentState();
        state.set(FOREGROUND_ASSET_TYPE_PROPERTY, (Enum)this.myForegroundAssetType.get(), DEFAULT_FOREGROUND_ASSET_TYPE);
        state.set(BACKGROUND_ASSET_TYPE_PROPERTY, (Enum)this.myBackgroundAssetType.get(), DEFAULT_BACKGROUND_ASSET_TYPE);
        for (Map.Entry entry : this.myForegroundAssetPanelMap.entrySet()) {
            state.setChild("foreground" + AssetStudioUtils.toUpperCamelCase((Enum)entry.getKey()), ((BaseAsset)((AssetComponent)entry.getValue()).getAsset()).getState());
        }
        state.setChild("background" + AssetStudioUtils.toUpperCamelCase(BackgroundAssetType.IMAGE), this.myBackgroundImageAssetBrowser.getAsset().getState());
        state.set(BACKGROUND_COLOR_PROPERTY, (Color)this.myBackgroundColor.get(), LauncherIconGenerator.DEFAULT_BACKGROUND_COLOR);
        state.set(GENERATE_LEGACY_ICON_PROPERTY, (Boolean)this.myGenerateLegacyIcon.get(), true);
        state.set(GENERATE_ROUND_ICON_PROPERTY, (Boolean)this.myGenerateRoundIcon.get(), true);
        state.set(GENERATE_WEB_ICON_PROPERTY, (Boolean)this.myGenerateWebIcon.get(), true);
        state.set(LEGACY_ICON_SHAPE_PROPERTY, (Enum)this.myLegacyIconShape.get(), DEFAULT_ICON_SHAPE);
        state.set(WEB_ICON_SHAPE_PROPERTY, (Enum)this.myWebIconShape.get(), DEFAULT_ICON_SHAPE);
        state.set(SHOW_GRID_PROPERTY, (Boolean)this.myShowGrid.get(), false);
        state.set(SHOW_SAFE_ZONE_PROPERTY, (Boolean)this.myShowSafeZone.get(), true);
        state.set(PREVIEW_DENSITY_PROPERTY, (Enum)this.myPreviewDensity.get(), DEFAULT_PREVIEW_DENSITY);
        state.set(OUTPUT_NAME_PROPERTY, (String)this.myOutputName.get(), DEFAULT_OUTPUT_NAME);
        state.set(FOREGROUND_LAYER_NAME_PROPERTY, (String)this.myForegroundLayerName.get(), this.defaultForegroundLayerName());
        state.set(BACKGROUND_LAYER_NAME_PROPERTY, (String)this.myBackgroundLayerName.get(), this.defaultBackgroundLayerName());
        state.set(FOREGROUND_IMAGE_PROPERTY, (File)this.myForegroundImageAssetBrowser.getAsset().imagePath().getValueOrNull(), DEFAULT_FOREGROUND_IMAGE);
        state.set(BACKGROUND_IMAGE_PROPERTY, (File)this.myBackgroundImageAssetBrowser.getAsset().imagePath().getValueOrNull(), DEFAULT_BACKGROUND_IMAGE);
        state.setChild(FOREGROUND_CLIPART_ASSET_PROPERTY, this.myForegroundClipartAssetButton.getState());
        state.setChild(FOREGROUND_TEXT_ASSET_PROPERTY, this.myForegroundTextAssetEditor.getState());
        PersistentState persistentState = state;
        if (persistentState == null) {
            ConfigureLauncherIconPanel.$$$reportNull$$$0(6);
        }
        return persistentState;
    }

    public void loadState(@NotNull PersistentState state) {
        if (state == null) {
            ConfigureLauncherIconPanel.$$$reportNull$$$0(7);
        }
        this.myForegroundAssetType.set(state.get(FOREGROUND_ASSET_TYPE_PROPERTY, DEFAULT_FOREGROUND_ASSET_TYPE));
        this.myBackgroundAssetType.set(state.get(BACKGROUND_ASSET_TYPE_PROPERTY, DEFAULT_BACKGROUND_ASSET_TYPE));
        for (Map.Entry entry : this.myForegroundAssetPanelMap.entrySet()) {
            PersistentStateUtil.load(((AssetComponent)entry.getValue()).getAsset(), state.getChild("foreground" + AssetStudioUtils.toUpperCamelCase((Enum)entry.getKey())));
        }
        PersistentStateUtil.load(this.myBackgroundImageAssetBrowser.getAsset(), state.getChild("background" + AssetStudioUtils.toUpperCamelCase(BackgroundAssetType.IMAGE)));
        this.myBackgroundColor.set(state.get(BACKGROUND_COLOR_PROPERTY, LauncherIconGenerator.DEFAULT_BACKGROUND_COLOR));
        this.myGenerateLegacyIcon.set(state.get(GENERATE_LEGACY_ICON_PROPERTY, true));
        this.myGenerateRoundIcon.set(state.get(GENERATE_ROUND_ICON_PROPERTY, true));
        this.myGenerateWebIcon.set(state.get(GENERATE_WEB_ICON_PROPERTY, true));
        this.myLegacyIconShape.set(state.get(LEGACY_ICON_SHAPE_PROPERTY, DEFAULT_ICON_SHAPE));
        this.myWebIconShape.set(state.get(WEB_ICON_SHAPE_PROPERTY, DEFAULT_ICON_SHAPE));
        this.myShowGrid.set(state.get(SHOW_GRID_PROPERTY, false));
        this.myShowSafeZone.set(state.get(SHOW_SAFE_ZONE_PROPERTY, true));
        this.myPreviewDensity.set(state.get(PREVIEW_DENSITY_PROPERTY, DEFAULT_PREVIEW_DENSITY));
        this.myOutputName.set(state.get(OUTPUT_NAME_PROPERTY, DEFAULT_OUTPUT_NAME));
        this.myForegroundLayerName.set(state.get(FOREGROUND_LAYER_NAME_PROPERTY, this.defaultForegroundLayerName()));
        this.myBackgroundLayerName.set(state.get(BACKGROUND_LAYER_NAME_PROPERTY, this.defaultBackgroundLayerName()));
        this.myForegroundImageAssetBrowser.getAsset().imagePath().setValue(state.get(FOREGROUND_IMAGE_PROPERTY, DEFAULT_FOREGROUND_IMAGE));
        this.myBackgroundImageAssetBrowser.getAsset().imagePath().setValue(state.get(BACKGROUND_IMAGE_PROPERTY, DEFAULT_BACKGROUND_IMAGE));
        PersistentStateUtil.load(this.myForegroundClipartAssetButton, state.getChild(FOREGROUND_CLIPART_ASSET_PROPERTY));
        PersistentStateUtil.load(this.myForegroundTextAssetEditor, state.getChild(FOREGROUND_TEXT_ASSET_PROPERTY));
    }

    @NotNull
    private static File getTemplateImage(@NotNull String resourceDir, @NotNull String fileName) {
        if (resourceDir == null) {
            ConfigureLauncherIconPanel.$$$reportNull$$$0(8);
        }
        if (fileName == null) {
            ConfigureLauncherIconPanel.$$$reportNull$$$0(9);
        }
        String path = FileUtil.join((String[])new String[]{"gradle-projects", "NewAndroidModule", "root", "res", resourceDir, fileName});
        File file = new File(TemplateManager.getTemplateRootFolder(), path);
        if (file == null) {
            ConfigureLauncherIconPanel.$$$reportNull$$$0(10);
        }
        return file;
    }

    private void initializeListenersAndBindings() {
        this.myForegroundTrimmed = new SelectedProperty(this.myForegroundTrimYesRadioButton);
        this.myBackgroundTrimmed = new SelectedProperty(this.myBackgroundTrimYesRadioButton);
        this.myForegroundResizePercent = new SliderValueProperty(this.myForegroundResizeSlider);
        TextProperty foregroundResizeValueString = new TextProperty(this.myForegroundResizeValueLabel);
        this.myGeneralBindings.bind(foregroundResizeValueString, new FormatExpression("%d %%", this.myForegroundResizePercent));
        this.myBackgroundResizePercent = new SliderValueProperty(this.myBackgroundResizeSlider);
        TextProperty backgroundResizeValueString = new TextProperty(this.myBackgroundResizeValueLabel);
        this.myGeneralBindings.bind(backgroundResizeValueString, new FormatExpression("%d %%", this.myBackgroundResizePercent));
        this.myIgnoreForegroundColor = new SelectedProperty(this.myForegroundImageRadioButton);
        this.myForegroundColor = ObjectProperty.wrap(new ColorProperty(this.myForegroundColorPanel));
        this.myBackgroundColor = ObjectProperty.wrap(new ColorProperty(this.myBackgroundColorPanel));
        this.myGenerateLegacyIcon = new SelectedProperty(this.myGenerateLegacyIconYesRadioButton);
        this.myGenerateRoundIcon = new SelectedProperty(this.myGenerateRoundIconYesRadioButton);
        this.myGenerateWebIcon = new SelectedProperty(this.myGenerateWebIconYesRadioButton);
        this.myLegacyIconShape = ObjectProperty.wrap(new SelectedItemProperty(this.myLegacyIconShapeComboBox));
        this.myWebIconShape = ObjectProperty.wrap(new SelectedItemProperty(this.myWebIconShapeComboBox));
        this.updateBindingsAndUiForActiveIconType();
        this.myForegroundAssetType.addListener(sender -> {
            AssetComponent assetComponent = (AssetComponent)this.myForegroundAssetPanelMap.get(this.myForegroundAssetType.get());
            this.myForegroundActiveAsset.set((BaseAsset)assetComponent.getAsset());
        });
        this.myBackgroundAssetType.addListener(sender -> {
            if (this.myBackgroundAssetType.get() == BackgroundAssetType.IMAGE) {
                this.myBackgroundImageAsset.setValue(this.myBackgroundImageAssetBrowser.getAsset());
            } else {
                this.myBackgroundImageAsset.clear();
            }
        });
        ActionListener assetPanelListener = e -> this.fireAssetListeners();
        for (AssetComponent assetComponent : this.myForegroundAssetPanelMap.values()) {
            assetComponent.addAssetListener(assetPanelListener);
        }
        this.myBackgroundImageAssetBrowser.addAssetListener(assetPanelListener);
        Runnable onAssetModified = this::fireAssetListeners;
        this.myListeners.listenAll(this.myForegroundTrimmed, this.myForegroundResizePercent, this.myForegroundColor, this.myBackgroundTrimmed, this.myBackgroundResizePercent, this.myBackgroundColor, this.myGenerateLegacyIcon, this.myLegacyIconShape, this.myGenerateRoundIcon, this.myGenerateWebIcon, this.myWebIconShape).with(onAssetModified);
        BoolValueProperty foregroundIsResizable = new BoolValueProperty();
        this.myListeners.listenAndFire(this.myForegroundActiveAsset, sender -> {
            this.myForegroundActiveAssetBindings.releaseAll();
            BaseAsset asset = (BaseAsset)this.myForegroundActiveAsset.get();
            this.myForegroundActiveAssetBindings.bindTwoWay(this.myForegroundTrimmed, asset.trimmed());
            this.myForegroundActiveAssetBindings.bindTwoWay(this.myForegroundResizePercent, asset.scalingPercent());
            OptionalValueProperty<Color> assetColor = asset.color();
            if (assetColor.getValueOrNull() == null) {
                assetColor.setValue((Color)this.myForegroundColor.get());
            }
            this.myForegroundActiveAssetBindings.bindTwoWay(this.myForegroundColor, ObjectProperty.wrap(assetColor));
            this.myForegroundActiveAssetBindings.bind(foregroundIsResizable, asset.isResizable());
            if (asset instanceof ImageAsset) {
                this.myForegroundActiveAssetBindings.bind(this.myForegroundAssetValidityState, ((ImageAsset)asset).getValidityState());
            } else {
                this.myForegroundAssetValidityState.set(Validator.Result.OK);
            }
            this.getIconGenerator().sourceAsset().setValue(asset);
            onAssetModified.run();
        });
        BoolValueProperty backgroundIsResizable = new BoolValueProperty();
        Runnable onBackgroundAssetModified = () -> {
            this.myBackgroundActiveAssetBindings.releaseAll();
            ImageAsset asset = this.myBackgroundImageAsset.getValueOrNull();
            if (asset != null) {
                this.myBackgroundActiveAssetBindings.bindTwoWay(this.myBackgroundTrimmed, asset.trimmed());
                this.myBackgroundActiveAssetBindings.bindTwoWay(this.myBackgroundResizePercent, asset.scalingPercent());
                this.myBackgroundActiveAssetBindings.bind(backgroundIsResizable, asset.isResizable());
                this.myBackgroundActiveAssetBindings.bind(this.myBackgroundAssetValidityState, asset.getValidityState());
            } else {
                backgroundIsResizable.set(false);
                this.myBackgroundAssetValidityState.set(Validator.Result.OK);
            }
            this.getIconGenerator().backgroundImageAsset().setNullableValue(asset);
            onAssetModified.run();
        };
        this.myListeners.listenAndFire(this.myBackgroundImageAsset, sender -> onBackgroundAssetModified.run());
        ImmutableMap.Builder layoutPropertiesBuilder = ImmutableMap.builder();
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myForegroundImageAssetRowPanel), (Object)new SelectedProperty(this.myForegroundImageRadioButton));
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myForegroundClipartAssetRowPanel), (Object)new SelectedProperty(this.myForegroundClipartRadioButton));
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myForegroundTextAssetRowPanel), (Object)new SelectedProperty(this.myForegroundTextRadioButton));
        BooleanExpression isForegroundIsNotImage = BooleanExpression.create(() -> this.myForegroundAssetType.get() != ForegroundAssetType.IMAGE, this.myForegroundAssetType);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myForegroundColorRowPanel), (Object)isForegroundIsNotImage);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myForegroundTrimYesRadioButton), (Object)foregroundIsResizable);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myForegroundTrimNoRadioButton), (Object)foregroundIsResizable);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myForegroundResizeSlider), (Object)foregroundIsResizable);
        SelectedProperty backgroundIsImage = new SelectedProperty(this.myBackgroundImageRadioButton);
        SelectedProperty backgroundIsColor = new SelectedProperty(this.myBackgroundColorRadioButton);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myBackgroundImageAssetRowPanel), (Object)backgroundIsImage);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myBackgroundColorRowPanel), (Object)backgroundIsColor);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myBackgroundTrimYesRadioButton), (Object)backgroundIsResizable);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myBackgroundTrimNoRadioButton), (Object)backgroundIsResizable);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myBackgroundResizeSlider), (Object)backgroundIsResizable);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myLegacyIconShapeComboBox), (Object)new SelectedProperty(this.myGenerateLegacyIconYesRadioButton));
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myWebIconShapeComboBox), (Object)new SelectedProperty(this.myGenerateWebIconYesRadioButton));
        ImmutableMap layoutProperties = layoutPropertiesBuilder.build();
        for (Map.Entry entry : layoutProperties.entrySet()) {
            ((BoolProperty)entry.getKey()).set(false);
            this.myGeneralBindings.bind((SettableValue)entry.getKey(), (ObservableValue)entry.getValue());
        }
        this.myListeners.listenAll((Collection<? extends ObservableValue<?>>)layoutProperties.keySet()).with(() -> {
            SwingUtilities.updateComponentTreeUI(this.myForegroundAllOptionsPanel);
            SwingUtilities.updateComponentTreeUI(this.myBackgroundAllOptionsPanel);
        });
    }

    private void initializeValidators() {
        VisibleProperty isActive = new VisibleProperty(this);
        this.myValidatorPanel.registerTest((ObservableValue)BooleanExpression.create(() -> isActive.get() == false || this.myBuildSdkVersion.getFeatureLevel() >= 26, isActive), "Project must be built with SDK 26 or later to use adaptive icons");
        this.myValidatorPanel.registerTest((ObservableValue)ConfigureLauncherIconPanel.nameIsNotEmptyExpression(isActive, this.myForegroundLayerName), "Foreground layer name must be set");
        this.myValidatorPanel.registerTest((ObservableValue)ConfigureLauncherIconPanel.nameIsNotEmptyExpression(isActive, this.myBackgroundLayerName), "Background layer name must be set");
        this.myValidatorPanel.registerTest((ObservableValue)ConfigureLauncherIconPanel.namesAreDistinctExpression(isActive, this.myOutputName, this.myForegroundLayerName), "Foreground layer must have a name distinct from the icon name");
        this.myValidatorPanel.registerTest((ObservableValue)ConfigureLauncherIconPanel.namesAreDistinctExpression(isActive, this.myOutputName, this.myBackgroundLayerName), "Background layer must have a name distinct from the icon name");
        this.myValidatorPanel.registerTest((ObservableValue)ConfigureLauncherIconPanel.namesAreDistinctExpression(isActive, this.myForegroundLayerName, this.myBackgroundLayerName), "Background and foreground layers must have distinct names");
        this.myValidatorPanel.registerValidator(this.myForegroundAssetValidityState, validity -> validity);
        this.myValidatorPanel.registerValidator(this.myBackgroundAssetValidityState, validity -> validity);
    }

    @NotNull
    private static BooleanExpression nameIsNotEmptyExpression(@NotNull VisibleProperty isActive, @NotNull StringProperty name) {
        if (isActive == null) {
            ConfigureLauncherIconPanel.$$$reportNull$$$0(11);
        }
        if (name == null) {
            ConfigureLauncherIconPanel.$$$reportNull$$$0(12);
        }
        BooleanExpression booleanExpression = BooleanExpression.create(() -> isActive.get() == false || !StringUtil.isEmptyOrSpaces((String)((String)name.get())), isActive, name);
        if (booleanExpression == null) {
            ConfigureLauncherIconPanel.$$$reportNull$$$0(13);
        }
        return booleanExpression;
    }

    @NotNull
    private static BooleanExpression namesAreDistinctExpression(@NotNull VisibleProperty isActive, @NotNull StringProperty name1, @NotNull StringProperty name2) {
        if (isActive == null) {
            ConfigureLauncherIconPanel.$$$reportNull$$$0(14);
        }
        if (name1 == null) {
            ConfigureLauncherIconPanel.$$$reportNull$$$0(15);
        }
        if (name2 == null) {
            ConfigureLauncherIconPanel.$$$reportNull$$$0(16);
        }
        BooleanExpression booleanExpression = BooleanExpression.create(() -> isActive.get() == false || !StringUtil.equalsTrimWhitespaces((CharSequence)((CharSequence)name1.get()), (CharSequence)((CharSequence)name2.get())), isActive, name1, name2);
        if (booleanExpression == null) {
            ConfigureLauncherIconPanel.$$$reportNull$$$0(17);
        }
        return booleanExpression;
    }

    @Override
    @NotNull
    public LauncherIconGenerator getIconGenerator() {
        LauncherIconGenerator launcherIconGenerator = this.myIconGenerator;
        if (launcherIconGenerator == null) {
            ConfigureLauncherIconPanel.$$$reportNull$$$0(18);
        }
        return launcherIconGenerator;
    }

    @Override
    @NotNull
    public JComponent getRootComponent() {
        ConfigureLauncherIconPanel configureLauncherIconPanel = this;
        if (configureLauncherIconPanel == null) {
            ConfigureLauncherIconPanel.$$$reportNull$$$0(19);
        }
        return configureLauncherIconPanel;
    }

    @Override
    public void addAssetListener(@NotNull ActionListener listener2) {
        if (listener2 == null) {
            ConfigureLauncherIconPanel.$$$reportNull$$$0(20);
        }
        this.myAssetListeners.add(listener2);
    }

    @Override
    @NotNull
    public StringProperty outputName() {
        StringProperty stringProperty = this.myOutputName;
        if (stringProperty == null) {
            ConfigureLauncherIconPanel.$$$reportNull$$$0(21);
        }
        return stringProperty;
    }

    private void fireAssetListeners() {
        ActionEvent e = new ActionEvent(this, 1001, null);
        for (ActionListener assetListener : this.myAssetListeners) {
            assetListener.actionPerformed(e);
        }
    }

    private void updateBindingsAndUiForActiveIconType() {
        this.myOutputName.set(DEFAULT_OUTPUT_NAME);
        this.myForegroundLayerName.set(this.defaultForegroundLayerName());
        this.myBackgroundLayerName.set(this.defaultBackgroundLayerName());
        this.myGeneralBindings.bind(this.myIconGenerator.sourceAsset(), new AsOptionalExpression<BaseAsset>(this.myForegroundActiveAsset));
        this.myGeneralBindings.bind(this.myIconGenerator.outputName(), this.myOutputName);
        this.myGeneralBindings.bindTwoWay(this.myIconGenerator.backgroundImageAsset(), this.myBackgroundImageAsset);
        this.myGeneralBindings.bind(this.myIconGenerator.useForegroundColor(), this.myIgnoreForegroundColor.not());
        this.myGeneralBindings.bindTwoWay(this.myForegroundColor, this.myIconGenerator.foregroundColor());
        this.myGeneralBindings.bindTwoWay(this.myBackgroundColor, this.myIconGenerator.backgroundColor());
        this.myGeneralBindings.bindTwoWay(this.myGenerateLegacyIcon, this.myIconGenerator.generateLegacyIcon());
        this.myGeneralBindings.bindTwoWay(this.myGenerateRoundIcon, this.myIconGenerator.generateRoundIcon());
        this.myGeneralBindings.bindTwoWay(this.myGenerateWebIcon, this.myIconGenerator.generateWebIcon());
        this.myGeneralBindings.bindTwoWay(this.myLegacyIconShape, this.myIconGenerator.legacyIconShape());
        this.myGeneralBindings.bindTwoWay(this.myWebIconShape, this.myIconGenerator.webIconShape());
        this.myGeneralBindings.bindTwoWay(this.myShowGrid, this.myIconGenerator.showGrid());
        this.myGeneralBindings.bindTwoWay(this.myShowSafeZone, this.myIconGenerator.showSafeZone());
        this.myGeneralBindings.bindTwoWay(this.myPreviewDensity, this.myIconGenerator.previewDensity());
        this.myGeneralBindings.bindTwoWay(this.myIconGenerator.foregroundLayerName(), this.myForegroundLayerName);
        this.myGeneralBindings.bindTwoWay(this.myIconGenerator.backgroundLayerName(), this.myBackgroundLayerName);
    }

    public void dispose() {
        this.myGeneralBindings.releaseAll();
        this.myForegroundActiveAssetBindings.releaseAll();
        this.myBackgroundActiveAssetBindings.releaseAll();
        this.myListeners.releaseAll();
        this.myAssetListeners.clear();
    }

    @NotNull
    private String defaultForegroundLayerName() {
        String string = (String)this.myOutputName.get() + "_foreground";
        if (string == null) {
            ConfigureLauncherIconPanel.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    private String defaultBackgroundLayerName() {
        String string = (String)this.myOutputName.get() + "_background";
        if (string == null) {
            ConfigureLauncherIconPanel.$$$reportNull$$$0(23);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = SHOW_GRID_PROPERTY;
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = SHOW_SAFE_ZONE_PROPERTY;
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = PREVIEW_DENSITY_PROPERTY;
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validatorPanel";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/ui/ConfigureLauncherIconPanel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceDir";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isActive";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name1";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name2";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/ui/ConfigureLauncherIconPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateImage";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "nameIsNotEmptyExpression";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "namesAreDistinctExpression";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconGenerator";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootComponent";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = OUTPUT_NAME_PROPERTY;
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultForegroundLayerName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultBackgroundLayerName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateImage";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "nameIsNotEmptyExpression";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "namesAreDistinctExpression";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addAssetListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBLabel jBLabel;
        JPanel jPanel2;
        JRadioButton jRadioButton;
        JPanel jPanel3;
        JBLabel jBLabel2;
        JPanel jPanel4;
        JRadioButton jRadioButton2;
        JPanel jPanel5;
        JBLabel jBLabel3;
        JPanel jPanel6;
        JPanel jPanel7;
        JBLabel jBLabel4;
        JPanel jPanel8;
        JRadioButton jRadioButton3;
        JPanel jPanel9;
        JBLabel jBLabel5;
        JPanel jPanel10;
        JPanel jPanel11;
        JBScrollPane jBScrollPane;
        JLabel jLabel;
        JSlider jSlider;
        JPanel jPanel12;
        JBLabel jBLabel6;
        JPanel jPanel13;
        JRadioButton jRadioButton4;
        JRadioButton jRadioButton5;
        JPanel jPanel14;
        JBLabel jBLabel7;
        JPanel jPanel15;
        JPanel jPanel16;
        TitledSeparator titledSeparator;
        ColorPanel colorPanel;
        JBLabel jBLabel8;
        JPanel jPanel17;
        ImageAssetBrowser imageAssetBrowser;
        JBLabel jBLabel9;
        JPanel jPanel18;
        JPanel jPanel19;
        JRadioButton jRadioButton6;
        JRadioButton jRadioButton7;
        JPanel jPanel20;
        JLabel jLabel2;
        JPanel jPanel21;
        TitledSeparator titledSeparator2;
        JTextField jTextField;
        JBLabel jBLabel10;
        JPanel jPanel22;
        JPanel jPanel23;
        JBScrollPane jBScrollPane2;
        JLabel jLabel3;
        JSlider jSlider2;
        JPanel jPanel24;
        JBLabel jBLabel11;
        JPanel jPanel25;
        JRadioButton jRadioButton8;
        JRadioButton jRadioButton9;
        JPanel jPanel26;
        JBLabel jBLabel12;
        JPanel jPanel27;
        TitledSeparator titledSeparator3;
        JPanel jPanel28;
        ColorPanel colorPanel2;
        JBLabel jBLabel13;
        JPanel jPanel29;
        TextAssetEditor textAssetEditor;
        JBLabel jBLabel14;
        JPanel jPanel30;
        ClipartIconButton clipartIconButton;
        JBLabel jBLabel15;
        JPanel jPanel31;
        ImageAssetBrowser imageAssetBrowser2;
        JBLabel jBLabel16;
        JPanel jPanel32;
        JPanel jPanel33;
        JRadioButton jRadioButton10;
        JRadioButton jRadioButton11;
        JRadioButton jRadioButton12;
        JPanel jPanel34;
        JLabel jLabel4;
        JPanel jPanel35;
        TitledSeparator titledSeparator4;
        JTextField jTextField2;
        JBLabel jBLabel17;
        JPanel jPanel36;
        JPanel jPanel37;
        JBScrollPane jBScrollPane3;
        JTextField jTextField3;
        JBLabel jBLabel18;
        JPanel jPanel38;
        JPanel jPanel39;
        this.myRootPanel = jPanel39 = new JPanel();
        jPanel39.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myOutputNamePanelRow = jPanel38 = new JPanel();
        jPanel38.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel39.add((Component)jPanel38, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        jPanel38.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), null, 0, 0, null, null));
        this.myOutputNameLabel = jBLabel18 = new JBLabel();
        jBLabel18.setText("Name:");
        jPanel38.add((Component)jBLabel18, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(60, -1), null, null));
        JPanel jPanel40 = new JPanel();
        jPanel40.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel38.add((Component)jPanel40, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myOutputNameTextField = jTextField3 = new JTextField();
        jTextField3.setText("(name)");
        jTextField3.setToolTipText("The filename which will be used for these icons.");
        jPanel40.add((Component)jTextField3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JBTabbedPane jBTabbedPane = new JBTabbedPane();
        jBTabbedPane.setTabPlacement(1);
        jPanel39.add((Component)jBTabbedPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        jBTabbedPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0), null, 0, 0, null, null));
        JPanel jPanel41 = new JPanel();
        jPanel41.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Foreground Layer", null, jPanel41, null);
        this.myForegroundScrollPane = jBScrollPane3 = new JBScrollPane();
        jBScrollPane3.setHorizontalScrollBarPolicy(31);
        jPanel41.add((Component)jBScrollPane3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myForegroundAllOptionsPanel = jPanel37 = new JPanel();
        jPanel37.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane3.setViewportView(jPanel37);
        this.myForegroundLayerNamePanel = jPanel36 = new JPanel();
        jPanel36.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel36).setVisible(true);
        jPanel37.add((Component)jPanel36, new GridConstraints(0, 0, 1, 2, 0, 3, 7, 0, null, null, null, 0, true));
        this.myForegroundLayerNameLabel = jBLabel17 = new JBLabel();
        jBLabel17.setText("Layer Name:");
        jPanel36.add((Component)jBLabel17, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null));
        JPanel jPanel42 = new JPanel();
        jPanel42.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel36.add((Component)jPanel42, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myForegroundLayerNameTextField = jTextField2 = new JTextField();
        jTextField2.setText("(name)");
        jTextField2.setToolTipText("The filename which will be used for these icons.");
        jPanel42.add((Component)jTextField2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.mySourceAssetTitleSeparator = titledSeparator4 = new TitledSeparator();
        titledSeparator4.setText("Source Asset");
        jPanel37.add((Component)titledSeparator4, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        this.myForegroundAssetTypePanel = jPanel35 = new JPanel();
        jPanel35.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel37.add((Component)jPanel35, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundAssetTypeLabel = jLabel4 = new JLabel();
        jLabel4.setText("Asset Type:");
        jPanel35.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myForegroundAssetRadioButtonsPanel = jPanel34 = new JPanel();
        jPanel34.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel35.add((Component)jPanel34, new GridConstraints(0, 1, 1, 1, 8, 2, 3, 0, null, null, null));
        this.myForegroundClipartRadioButton = jRadioButton12 = new JRadioButton();
        jRadioButton12.setText("Clip Art");
        jRadioButton12.setToolTipText("Select from a list of clipart choices to generate Android icons for your app.");
        jPanel34.add((Component)jRadioButton12, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myForegroundTextRadioButton = jRadioButton11 = new JRadioButton();
        jRadioButton11.setText("Text");
        jRadioButton11.setToolTipText("Enter text which will be rendered into Android icons for your app.");
        jPanel34.add((Component)jRadioButton11, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myForegroundImageRadioButton = jRadioButton10 = new JRadioButton();
        jRadioButton10.setText("Image");
        jRadioButton10.setToolTipText("Select an image, e.g. PNG, SVG, PSD, or a drawable from disk to generate Android icons for your app.");
        jPanel34.add((Component)jRadioButton10, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myForegroundAssetTypeSourcePanel = jPanel33 = new JPanel();
        jPanel33.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel37.add((Component)jPanel33, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundImageAssetRowPanel = jPanel32 = new JPanel();
        jPanel32.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel33.add((Component)jPanel32, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundImagePathLabel = jBLabel16 = new JBLabel();
        jBLabel16.setText("Path:");
        jPanel32.add((Component)jBLabel16, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myForegroundImageAssetBrowser = imageAssetBrowser2 = new ImageAssetBrowser();
        jPanel32.add((Component)((Object)imageAssetBrowser2), new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myForegroundClipartAssetRowPanel = jPanel31 = new JPanel();
        jPanel31.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel33.add((Component)jPanel31, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundClipartLabel = jBLabel15 = new JBLabel();
        jBLabel15.setText("Clip Art:");
        jPanel31.add((Component)jBLabel15, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myForegroundClipartAssetButton = clipartIconButton = new ClipartIconButton();
        jPanel31.add((Component)clipartIconButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 2, null, null, null));
        this.myForegroundTextAssetRowPanel = jPanel30 = new JPanel();
        jPanel30.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel33.add((Component)jPanel30, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundTextLabel = jBLabel14 = new JBLabel();
        jBLabel14.setText("Text:");
        jPanel30.add((Component)jBLabel14, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myForegroundTextAssetEditor = textAssetEditor = new TextAssetEditor();
        jPanel30.add((Component)textAssetEditor, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myForegroundColorRowPanel = jPanel29 = new JPanel();
        jPanel29.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel33.add((Component)jPanel29, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myForegroundColorLabel = jBLabel13 = new JBLabel();
        jBLabel13.setText("Color:");
        jPanel29.add((Component)jBLabel13, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myForegroundColorPanel = colorPanel2 = new ColorPanel();
        colorPanel2.setSelectedColor(new Color(-16777216));
        jPanel29.add((Component)colorPanel2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myForegroundImageOptionsPanel = jPanel28 = new JPanel();
        jPanel28.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel37.add((Component)jPanel28, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myForegroundScalingTitleSeparator = titledSeparator3 = new TitledSeparator();
        titledSeparator3.setText("Scaling");
        jPanel28.add((Component)titledSeparator3, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        this.myForegroundTrimPanel = jPanel27 = new JPanel();
        jPanel27.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel27).setVisible(true);
        jPanel28.add((Component)jPanel27, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myForegroundTrimLabel = jBLabel12 = new JBLabel();
        jBLabel12.setText("Trim:");
        jPanel27.add((Component)jBLabel12, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myForegroundTrimOptionsPanel = jPanel26 = new JPanel();
        jPanel26.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel27.add((Component)jPanel26, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel26.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myForegroundTrimYesRadioButton = jRadioButton9 = new JRadioButton();
        jRadioButton9.setText("Yes");
        jRadioButton9.setToolTipText("Remove any transparent space from around your source asset before rendering to icon.");
        jPanel26.add((Component)jRadioButton9, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myForegroundTrimNoRadioButton = jRadioButton8 = new JRadioButton();
        jRadioButton8.setSelected(true);
        jRadioButton8.setText("No");
        jRadioButton8.setToolTipText("Leave the original asset unmodified.");
        jPanel26.add((Component)jRadioButton8, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myForegroundResizePanel = jPanel25 = new JPanel();
        jPanel25.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel25).setVisible(true);
        jPanel28.add((Component)jPanel25, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myForegroundResizeLabel = jBLabel11 = new JBLabel();
        jBLabel11.setText("Resize:");
        jPanel25.add((Component)jBLabel11, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myForegroundResizeSliderPanel = jPanel24 = new JPanel();
        jPanel24.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel25.add((Component)jPanel24, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myForegroundResizeSlider = jSlider2 = new JSlider();
        jSlider2.setMaximum(400);
        jSlider2.setMinimum(0);
        jSlider2.setMinorTickSpacing(20);
        jSlider2.setPaintLabels(false);
        jSlider2.setPaintTicks(true);
        jSlider2.setSnapToTicks(false);
        jSlider2.setToolTipText("Resize the original asset using the specified scaling factor (in percent). This happens after any trimming.");
        jSlider2.setValue(100);
        jSlider2.setValueIsAdjusting(false);
        jPanel24.add((Component)jSlider2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myForegroundResizeValueLabel = jLabel3 = new JLabel();
        jLabel3.setHorizontalAlignment(4);
        jLabel3.setText("100 %");
        jPanel24.add((Component)jLabel3, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, new Dimension(40, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel37.add((Component)spacer2, new GridConstraints(5, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JPanel jPanel43 = new JPanel();
        jPanel43.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Background Layer", null, jPanel43, null);
        this.myBackgroundScrollPane = jBScrollPane2 = new JBScrollPane();
        jBScrollPane2.setHorizontalScrollBarPolicy(31);
        jPanel43.add((Component)jBScrollPane2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myBackgroundAllOptionsPanel = jPanel23 = new JPanel();
        jPanel23.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane2.setViewportView(jPanel23);
        this.myBackgroundLayerNamePanel = jPanel22 = new JPanel();
        jPanel22.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel22).setVisible(true);
        jPanel23.add((Component)jPanel22, new GridConstraints(0, 0, 1, 2, 0, 3, 7, 3, null, null, null, 0, true));
        this.myBackgroundLayerNameLabel = jBLabel10 = new JBLabel();
        jBLabel10.setText("Layer Name:");
        jPanel22.add((Component)jBLabel10, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null));
        JPanel jPanel44 = new JPanel();
        jPanel44.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel22.add((Component)jPanel44, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myBackgroundLayerNameTextField = jTextField = new JTextField();
        jTextField.setText("(name)");
        jTextField.setToolTipText("The filename which will be used for these icons.");
        jPanel44.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myBackgroundSourceAssetTitleSeparator = titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText("Source Asset");
        jPanel23.add((Component)titledSeparator2, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        this.myBackgroundAssetTypePanel = jPanel21 = new JPanel();
        jPanel21.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel23.add((Component)jPanel21, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myBackgroundAssetTypeLabel = jLabel2 = new JLabel();
        jLabel2.setText("Asset Type:");
        jPanel21.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myBackgroundAssetRadioButtonsPanel = jPanel20 = new JPanel();
        jPanel20.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel21.add((Component)jPanel20, new GridConstraints(0, 1, 1, 1, 8, 2, 3, 3, null, null, null));
        this.myBackgroundImageRadioButton = jRadioButton7 = new JRadioButton();
        jRadioButton7.setText("Image");
        jRadioButton7.setToolTipText("Select an image, e.g. PNG, SVG, PSD, or a drawable from disk to generate Android icons for your app.");
        jPanel20.add((Component)jRadioButton7, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBackgroundColorRadioButton = jRadioButton6 = new JRadioButton();
        jRadioButton6.setText("Color");
        jRadioButton6.setToolTipText("Select from a background color for the Android icons for your app.");
        jPanel20.add((Component)jRadioButton6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBackgroundAssetTypeSourcePanel = jPanel19 = new JPanel();
        jPanel19.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel23.add((Component)jPanel19, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myBackgroundImageAssetRowPanel = jPanel18 = new JPanel();
        jPanel18.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel19.add((Component)jPanel18, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 0, new Dimension(30, 30), null, null, 0, true));
        this.myBackgroundImagePathLabel = jBLabel9 = new JBLabel();
        jBLabel9.setText("Path:");
        jPanel18.add((Component)jBLabel9, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myBackgroundImageAssetBrowser = imageAssetBrowser = new ImageAssetBrowser();
        jPanel18.add((Component)((Object)imageAssetBrowser), new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myBackgroundColorRowPanel = jPanel17 = new JPanel();
        jPanel17.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel19.add((Component)jPanel17, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 0, new Dimension(30, 30), null, null, 0, true));
        this.myBackgroundColorLabel = jBLabel8 = new JBLabel();
        jBLabel8.setText("Color:");
        jPanel17.add((Component)jBLabel8, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myBackgroundColorPanel = colorPanel = new ColorPanel();
        colorPanel.setSelectedColor(new Color(-16777216));
        jPanel17.add((Component)colorPanel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBackgroundScalingTitleSeparator = titledSeparator = new TitledSeparator();
        titledSeparator.setText("Scaling");
        jPanel19.add((Component)titledSeparator, new GridConstraints(2, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        this.myBackgroundImageOptionsPanel = jPanel16 = new JPanel();
        jPanel16.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel23.add((Component)jPanel16, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myBackgroundTrimRowPanel = jPanel15 = new JPanel();
        jPanel15.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel15).setVisible(true);
        jPanel16.add((Component)jPanel15, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myBackgroundTrimLabel = jBLabel7 = new JBLabel();
        jBLabel7.setText("Trim:");
        jPanel15.add((Component)jBLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myBackgroundTrimOptionsPanel = jPanel14 = new JPanel();
        jPanel14.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel14, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel14.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myBackgroundTrimYesRadioButton = jRadioButton5 = new JRadioButton();
        jRadioButton5.setText("Yes");
        jRadioButton5.setToolTipText("Remove any transparent space from around your source asset before rendering to icon.");
        jPanel14.add((Component)jRadioButton5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBackgroundTrimNoRadioButton = jRadioButton4 = new JRadioButton();
        jRadioButton4.setSelected(true);
        jRadioButton4.setText("No");
        jRadioButton4.setToolTipText("Leave the original asset unmodified.");
        jPanel14.add((Component)jRadioButton4, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBackgroundResizeRowPanel = jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel13).setVisible(true);
        jPanel16.add((Component)jPanel13, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myBackgroundResizeLabel = jBLabel6 = new JBLabel();
        jBLabel6.setText("Resize:");
        jPanel13.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myBackgroundResizeSliderPanel = jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel13.add((Component)jPanel12, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myBackgroundResizeSlider = jSlider = new JSlider();
        jSlider.setMaximum(400);
        jSlider.setMinimum(0);
        jSlider.setMinorTickSpacing(20);
        jSlider.setPaintLabels(false);
        jSlider.setPaintTicks(true);
        jSlider.setSnapToTicks(false);
        jSlider.setToolTipText("Resize the original asset using the specified scaling factor (in percent). This happens after any trimming.");
        jSlider.setValue(100);
        jPanel12.add((Component)jSlider, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myBackgroundResizeValueLabel = jLabel = new JLabel();
        jLabel.setHorizontalAlignment(4);
        jLabel.setText("100 %");
        jPanel12.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, new Dimension(40, -1), null));
        Spacer spacer4 = new Spacer();
        jPanel23.add((Component)spacer4, new GridConstraints(5, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JPanel jPanel45 = new JPanel();
        jPanel45.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Legacy", null, jPanel45, null);
        this.myOtherIconsScrollPane = jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel45.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myOtherIconsAllOptionsPanel = jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel11);
        jPanel11.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), null, 0, 0, null, null));
        TitledSeparator titledSeparator5 = new TitledSeparator();
        titledSeparator5.setText("Legacy Icon (API \u2264 25)");
        jPanel11.add((Component)titledSeparator5, new GridConstraints(0, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        this.myGenerateLegacyIconRowPanel = jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel10).setVisible(true);
        jPanel11.add((Component)jPanel10, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myGenerateLegacyIconLabel = jBLabel5 = new JBLabel();
        jBLabel5.setText("Generate:");
        jPanel10.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.mGenerateLegacyIconRadioButtonsPanel = jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel9, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myGenerateLegacyIconYesRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setSelected(true);
        jRadioButton3.setText("Yes");
        jRadioButton3.setToolTipText("Generate Legacy icon (API <= 24)");
        jPanel9.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JRadioButton jRadioButton13 = new JRadioButton();
        jRadioButton13.setSelected(false);
        jRadioButton13.setText("No");
        jRadioButton13.setToolTipText("");
        jPanel9.add((Component)jRadioButton13, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel9.add((Component)spacer5, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myLegacyIconShapePanelRow = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel8, new GridConstraints(2, 0, 1, 2, 0, 3, 7, 3, null, null, null, 0, true));
        this.myLegacyIconShapeLabel = jBLabel4 = new JBLabel();
        jBLabel4.setText("Shape:");
        jPanel8.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myLegacyIconShapePanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel7, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myLegacyIconShapeComboBox = jComboBox;
        jComboBox.setToolTipText("The shape of the launcher icon's backdrop.");
        jPanel7.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel7.add((Component)spacer6, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        TitledSeparator titledSeparator6 = new TitledSeparator();
        titledSeparator6.setText("Round Icon (API = 25)");
        jPanel11.add((Component)titledSeparator6, new GridConstraints(3, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        this.myGenerateRoundIconRowPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel6).setVisible(true);
        jPanel11.add((Component)jPanel6, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myGenerateRoundIconLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Generate:");
        jPanel6.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myGenerateRoundIconRadioButtonsPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myGenerateRoundIconYesRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        jRadioButton2.setText("Yes");
        jRadioButton2.setToolTipText("Generate Round icon (API 25)");
        jPanel5.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JRadioButton jRadioButton14 = new JRadioButton();
        jRadioButton14.setSelected(false);
        jRadioButton14.setText("No");
        jRadioButton14.setToolTipText("");
        jPanel5.add((Component)jRadioButton14, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel5.add((Component)spacer7, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        TitledSeparator titledSeparator7 = new TitledSeparator();
        titledSeparator7.setText("Google Play Store Icon");
        jPanel11.add((Component)titledSeparator7, new GridConstraints(5, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        this.myGenerateWebIconRowPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel4).setVisible(true);
        jPanel11.add((Component)jPanel4, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myGenerateWebIconLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Generate:");
        jPanel4.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myGenerateWebIconRadioButtonsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myGenerateWebIconYesRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setSelected(true);
        jRadioButton.setText("Yes");
        jRadioButton.setToolTipText("Generate Web Image (512x512)");
        jPanel3.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JRadioButton jRadioButton15 = new JRadioButton();
        jRadioButton15.setSelected(false);
        jRadioButton15.setText("No");
        jRadioButton15.setToolTipText("");
        jPanel3.add((Component)jRadioButton15, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel3.add((Component)spacer8, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer9 = new Spacer();
        jPanel11.add((Component)spacer9, new GridConstraints(8, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myWebIconShapePanelRow = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel2, new GridConstraints(7, 0, 1, 2, 0, 3, 7, 3, null, null, null, 0, true));
        this.myWebIconShapeLabel = jBLabel = new JBLabel();
        jBLabel.setText("Shape:");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(70, -1), null, null, 1));
        this.myWebIconShapePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        JComboBox jComboBox2 = new JComboBox();
        this.myWebIconShapeComboBox = jComboBox2;
        jComboBox2.setToolTipText("The shape of the launcher icon's backdrop.");
        jPanel.add(jComboBox2, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer10 = new Spacer();
        jPanel.add((Component)spacer10, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton10);
        buttonGroup.add(jRadioButton12);
        buttonGroup.add(jRadioButton11);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton8);
        buttonGroup.add(jRadioButton9);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton13);
        buttonGroup.add(jRadioButton3);
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton7);
        buttonGroup.add(jRadioButton6);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton5);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton14);
        buttonGroup.add(jRadioButton2);
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton15);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private static enum BackgroundAssetType {
        IMAGE,
        COLOR;

    }

    private static enum ForegroundAssetType {
        IMAGE,
        CLIP_ART,
        TEXT;

    }
}

