/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.AssetUtil;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.VectorDrawableTransformer;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TransformedImageAsset {
    @Nullable
    private final ListenableFuture<BufferedImage> myImageFuture;
    @Nullable
    private final ListenableFuture<String> myDrawableFuture;
    @NotNull
    private final GraphicGeneratorContext myContext;
    @Nullable
    private final Color myTint;
    private final double myOpacity;
    private final boolean myIsTrimmed;
    @NotNull
    private final Dimension myTargetSize;
    private final double myScaleFactor;
    @Nullable
    private Rectangle2D myTrimRectangle;
    @GuardedBy(value="myLock")
    @Nullable
    private String myTransformedDrawable;
    @GuardedBy(value="myLock")
    @Nullable
    private BufferedImage myTrimmedImage;
    private final Object myLock;

    /*
     * WARNING - void declaration
     */
    public TransformedImageAsset(@NotNull BaseAsset asset, @NotNull Dimension targetSize, double scaleFactor, @Nullable Color tint, double opacity, @NotNull GraphicGeneratorContext graphicGeneratorContext) {
        void context;
        if (asset == null) {
            TransformedImageAsset.$$$reportNull$$$0(0);
        }
        if (targetSize == null) {
            TransformedImageAsset.$$$reportNull$$$0(1);
        }
        if (graphicGeneratorContext == null) {
            TransformedImageAsset.$$$reportNull$$$0(2);
        }
        this.myLock = new Object();
        this.myDrawableFuture = asset instanceof ImageAsset ? ((ImageAsset)asset).getXmlDrawable() : null;
        this.myImageFuture = this.myDrawableFuture == null ? asset.toImage() : null;
        this.myTint = tint;
        this.myOpacity = (double)((Integer)asset.opacityPercent().get()).intValue() / 100.0;
        this.myIsTrimmed = (Boolean)asset.trimmed().get();
        this.myTargetSize = targetSize;
        this.myScaleFactor = scaleFactor;
        this.myContext = context;
    }

    public boolean isDrawable() {
        return this.myDrawableFuture != null;
    }

    public boolean isRasterImage() {
        return this.myImageFuture != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getTransformedDrawable() {
        if (this.myDrawableFuture == null) {
            return null;
        }
        try {
            Object object = this.myLock;
            synchronized (object) {
                String xmlDrawable = (String)this.myDrawableFuture.get();
                if (xmlDrawable == null) {
                    return null;
                }
                if (this.myTransformedDrawable == null) {
                    Rectangle2D clipRectangle = this.myIsTrimmed ? this.getTrimRectangle(xmlDrawable) : null;
                    this.myTransformedDrawable = VectorDrawableTransformer.transform(xmlDrawable, this.myTargetSize, this.myScaleFactor, clipRectangle, this.myTint, this.myOpacity);
                }
                return this.myTransformedDrawable;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
    }

    @NotNull
    public BufferedImage getTransformedImage(@NotNull Dimension imageSize) {
        BufferedImage sourceImage;
        String drawable;
        if (imageSize == null) {
            TransformedImageAsset.$$$reportNull$$$0(3);
        }
        if (this.isDrawable() && (drawable = this.getTransformedDrawable()) != null) {
            BufferedImage bufferedImage;
            ListenableFuture<BufferedImage> future2 = this.myContext.renderDrawable(drawable, imageSize);
            try {
                bufferedImage = (BufferedImage)future2.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
            if (bufferedImage == null) {
                TransformedImageAsset.$$$reportNull$$$0(4);
            }
            return bufferedImage;
        }
        if ((sourceImage = this.getTrimmedImage()) == null) {
            sourceImage = AssetStudioUtils.createDummyImage();
        }
        double scaleFactor = Math.min(imageSize.getWidth() * this.myScaleFactor / (double)sourceImage.getWidth(), imageSize.getHeight() * this.myScaleFactor / (double)sourceImage.getHeight());
        int width = AssetStudioUtils.roundToInt((double)sourceImage.getWidth() * scaleFactor);
        int height = AssetStudioUtils.roundToInt((double)sourceImage.getHeight() * scaleFactor);
        BufferedImage scaledImage = AssetUtil.scaledImage((BufferedImage)sourceImage, (int)width, (int)height);
        int x = AssetStudioUtils.roundToInt((double)(imageSize.width - width) / 2.0);
        int y = AssetStudioUtils.roundToInt((double)(imageSize.height - height) / 2.0);
        BufferedImage outImage = AssetUtil.newArgbBufferedImage((int)imageSize.width, (int)imageSize.height);
        Graphics2D g = (Graphics2D)outImage.getGraphics();
        AssetUtil.drawEffects((Graphics2D)g, (BufferedImage)scaledImage, (int)x, (int)y, (AssetUtil.Effect[])new AssetUtil.Effect[]{new AssetUtil.FillEffect((Paint)this.myTint, this.myOpacity)});
        g.dispose();
        BufferedImage bufferedImage = outImage;
        if (bufferedImage == null) {
            TransformedImageAsset.$$$reportNull$$$0(5);
        }
        return bufferedImage;
    }

    public double getScaleFactor() {
        return this.myScaleFactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BufferedImage getTrimmedImage() {
        if (this.myImageFuture == null) {
            return null;
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myTrimmedImage == null) {
                try {
                    BufferedImage image = (BufferedImage)this.myImageFuture.get();
                    this.myTrimmedImage = this.myIsTrimmed ? AssetStudioUtils.trim(image) : image;
                }
                catch (InterruptedException | ExecutionException e) {
                    return null;
                }
            }
            return this.myTrimmedImage;
        }
    }

    @NotNull
    private Rectangle2D getTrimRectangle(@NotNull String xmlDrawable) {
        if (xmlDrawable == null) {
            TransformedImageAsset.$$$reportNull$$$0(6);
        }
        if (this.myTrimRectangle == null) {
            this.myTrimRectangle = this.calculateTrimRectangle(xmlDrawable);
        }
        Rectangle2D rectangle2D = this.myTrimRectangle;
        if (rectangle2D == null) {
            TransformedImageAsset.$$$reportNull$$$0(7);
        }
        return rectangle2D;
    }

    @NotNull
    private Rectangle2D calculateTrimRectangle(@NotNull String xmlDrawable) {
        Rectangle2D rectangle2D;
        if (xmlDrawable == null) {
            TransformedImageAsset.$$$reportNull$$$0(8);
        }
        ListenableFuture<BufferedImage> futureImage = this.myContext.renderDrawable(xmlDrawable, this.myTargetSize);
        ListenableFuture rectangleFuture = Futures.transform(futureImage, image -> {
            Rectangle bounds = ImageUtils.getCropBounds((BufferedImage)image, (ImageUtils.CropFilter)ImageUtils.TRANSPARENCY_FILTER, null);
            if (bounds == null) {
                return new Rectangle(this.myTargetSize);
            }
            double width = this.myTargetSize.getWidth();
            double height = this.myTargetSize.getHeight();
            return new Rectangle2D.Double(bounds.getX() / width, bounds.getY() / height, bounds.getWidth() / width, bounds.getHeight() / height);
        }, (Executor)MoreExecutors.directExecutor());
        try {
            rectangle2D = (Rectangle2D)rectangleFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Rectangle rectangle = new Rectangle(this.myTargetSize);
            if (rectangle == null) {
                TransformedImageAsset.$$$reportNull$$$0(10);
            }
            return rectangle;
        }
        if (rectangle2D == null) {
            TransformedImageAsset.$$$reportNull$$$0(9);
        }
        return rectangle2D;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asset";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetSize";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageSize";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/TransformedImageAsset";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlDrawable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/TransformedImageAsset";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransformedImage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrimRectangle";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateTrimRectangle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTransformedImage";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTrimRectangle";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "calculateTrimRectangle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

