/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.tools.idea.npw.assetstudio.ProportionalImageScalerKt;
import com.intellij.util.ui.JBUI;
import java.awt.Image;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0003R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/npw/assetstudio/ProportionalImageScaler;", "", "minHeight", "", "maxHeight", "(II)V", "scale", "Ljava/awt/Image;", "image", "maxAllowedHeight", "Companion", "intellij.android.core"})
public final class ProportionalImageScaler {
    private final int minHeight;
    private final int maxHeight;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Image scale(@NotNull Image image, int maxAllowedHeight) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        if (maxAllowedHeight < 0) {
            throw (Throwable)new IllegalArgumentException("Height constraint " + maxAllowedHeight + " is invalid because image heights can't be negative.");
        }
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        if (height == 0 || this.maxHeight < maxAllowedHeight) {
            return image;
        }
        double scaleFactor = ProportionalImageScalerKt.determineScaleFactor(height, this.minHeight, this.maxHeight, maxAllowedHeight);
        int newWidth = (int)JBUI.scale((float)((float)((double)width * scaleFactor)));
        int newHeight = (int)JBUI.scale((float)((float)((double)height * scaleFactor)));
        Image image2 = image.getScaledInstance(newWidth, newHeight, 4);
        Intrinsics.checkExpressionValueIsNotNull((Object)image2, (String)"image.getScaledInstance(\u2026ight, Image.SCALE_SMOOTH)");
        return image2;
    }

    private ProportionalImageScaler(int minHeight, int maxHeight) {
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
    }

    public /* synthetic */ ProportionalImageScaler(int minHeight, int maxHeight, DefaultConstructorMarker $constructor_marker) {
        this(minHeight, maxHeight);
    }

    @JvmStatic
    @NotNull
    public static final ProportionalImageScaler forImages(@NotNull Collection<? extends Image> images) {
        return Companion.forImages(images);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/npw/assetstudio/ProportionalImageScaler$Companion;", "", "()V", "forImages", "Lcom/android/tools/idea/npw/assetstudio/ProportionalImageScaler;", "images", "", "Ljava/awt/Image;", "intellij.android.core"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ProportionalImageScaler forImages(@NotNull Collection<? extends Image> images) {
            Intrinsics.checkParameterIsNotNull(images, (String)"images");
            int minHeight = Integer.MAX_VALUE;
            int maxHeight = 0;
            for (Image image : images) {
                int height = image.getHeight(null);
                minHeight = Math.min(minHeight, height);
                maxHeight = Math.max(maxHeight, height);
            }
            return new ProportionalImageScaler(minHeight, maxHeight, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

