/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.AssetUtil;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.DrawableRenderer;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.TransformedImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.utils.Pair;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.project.Project;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LauncherLegacyIconGenerator
extends IconGenerator {
    public static final Color DEFAULT_FOREGROUND_COLOR = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND_COLOR = Color.WHITE;
    public static final IconGenerator.Shape DEFAULT_ICON_SHAPE = IconGenerator.Shape.SQUARE;
    private static final Rectangle IMAGE_SIZE_WEB = new Rectangle(0, 0, 512, 512);
    private static final Rectangle IMAGE_SIZE_MDPI = new Rectangle(0, 0, 48, 48);
    private static final Map<Pair<IconGenerator.Shape, Density>, Rectangle> TARGET_RECTS = LauncherLegacyIconGenerator.buildTargetRectangles();
    private final BoolProperty myUseForegroundColor;
    private final ObjectProperty<Color> myForegroundColor;
    private final ObjectProperty<Color> myBackgroundColor;
    private final ObjectProperty<IconGenerator.Shape> myShape;
    private final BoolProperty myCropped;
    private final BoolProperty myDogEared;

    public LauncherLegacyIconGenerator(@NotNull Project project, int minSdkVersion2, @Nullable DrawableRenderer renderer) {
        if (project == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(0);
        }
        super(project, minSdkVersion2, new GraphicGeneratorContext(40, renderer));
        this.myUseForegroundColor = new BoolValueProperty(true);
        this.myForegroundColor = new ObjectValueProperty<Color>(DEFAULT_FOREGROUND_COLOR);
        this.myBackgroundColor = new ObjectValueProperty<Color>(DEFAULT_BACKGROUND_COLOR);
        this.myShape = new ObjectValueProperty<IconGenerator.Shape>(DEFAULT_ICON_SHAPE);
        this.myCropped = new BoolValueProperty();
        this.myDogEared = new BoolValueProperty();
    }

    @NotNull
    public BoolProperty useForegroundColor() {
        BoolProperty boolProperty = this.myUseForegroundColor;
        if (boolProperty == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(1);
        }
        return boolProperty;
    }

    @NotNull
    public ObjectProperty<Color> foregroundColor() {
        ObjectProperty<Color> objectProperty = this.myForegroundColor;
        if (objectProperty == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(2);
        }
        return objectProperty;
    }

    @NotNull
    public ObjectProperty<Color> backgroundColor() {
        ObjectProperty<Color> objectProperty = this.myBackgroundColor;
        if (objectProperty == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(3);
        }
        return objectProperty;
    }

    @NotNull
    public BoolProperty cropped() {
        BoolProperty boolProperty = this.myCropped;
        if (boolProperty == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(4);
        }
        return boolProperty;
    }

    @NotNull
    public ObjectProperty<IconGenerator.Shape> shape() {
        ObjectProperty<IconGenerator.Shape> objectProperty = this.myShape;
        if (objectProperty == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(5);
        }
        return objectProperty;
    }

    @NotNull
    public BoolProperty dogEared() {
        BoolProperty boolProperty = this.myDogEared;
        if (boolProperty == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(6);
        }
        return boolProperty;
    }

    @Override
    @NotNull
    public LauncherLegacyOptions createOptions(boolean forPreview) {
        LauncherLegacyOptions options = new LauncherLegacyOptions(forPreview);
        BaseAsset asset = this.sourceAsset().getValueOrNull();
        if (asset != null) {
            Color color = (Boolean)this.myUseForegroundColor.get() != false ? (Color)this.myForegroundColor.get() : null;
            double paddingFactor = (double)((Integer)asset.paddingPercent().get()).intValue() / 100.0;
            double scaleFactor = 1.0 / (1.0 + paddingFactor * 2.0);
            options.image = new TransformedImageAsset(asset, IMAGE_SIZE_MDPI.getSize(), scaleFactor, color, 1.0, this.getGraphicGeneratorContext());
        }
        options.shape = (IconGenerator.Shape)((Object)this.myShape.get());
        options.crop = (Boolean)this.myCropped.get();
        options.style = IconGenerator.Style.SIMPLE;
        options.useForegroundColor = (Boolean)this.myUseForegroundColor.get();
        options.foregroundColor = ((Color)this.myForegroundColor.get()).getRGB();
        options.backgroundColor = ((Color)this.myBackgroundColor.get()).getRGB();
        options.generateWebIcon = true;
        options.isDogEar = (Boolean)this.myDogEared.get();
        LauncherLegacyOptions launcherLegacyOptions = options;
        if (launcherLegacyOptions == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(7);
        }
        return launcherLegacyOptions;
    }

    private static IconGenerator.Shape applyDog(IconGenerator.Shape shape) {
        if (shape == IconGenerator.Shape.SQUARE) {
            return IconGenerator.Shape.SQUARE_DOG;
        }
        if (shape == IconGenerator.Shape.HRECT) {
            return IconGenerator.Shape.HRECT_DOG;
        }
        if (shape == IconGenerator.Shape.VRECT) {
            return IconGenerator.Shape.VRECT_DOG;
        }
        return shape;
    }

    @Nullable
    private static BufferedImage loadImage(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.Shape shape, @NotNull Density density, @NotNull String fileName) {
        if (context == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(8);
        }
        if (shape == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(9);
        }
        if (density == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(10);
        }
        if (fileName == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(11);
        }
        String densityValue = density == Density.NODPI ? "web" : density.getResourceValue();
        String name = String.format("/images/launcher_stencil/%s/%s/%s.png", shape.id, densityValue, fileName);
        return context.loadImageResource(name);
    }

    @Nullable
    public static BufferedImage loadMaskImage(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.Shape shape, @NotNull Density density) {
        if (context == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(12);
        }
        if (shape == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(13);
        }
        if (density == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(14);
        }
        return LauncherLegacyIconGenerator.loadImage(context, shape, density, "mask");
    }

    @Nullable
    public static BufferedImage loadBackImage(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.Shape shape, @NotNull Density density) {
        if (context == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(15);
        }
        if (shape == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(16);
        }
        if (density == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(17);
        }
        return LauncherLegacyIconGenerator.loadImage(context, shape, density, "back");
    }

    @Nullable
    public static BufferedImage loadStyleImage(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.Shape shape, @NotNull Density density, @NotNull IconGenerator.Style style) {
        if (context == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(18);
        }
        if (shape == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(19);
        }
        if (density == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(20);
        }
        if (style == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(21);
        }
        return LauncherLegacyIconGenerator.loadImage(context, shape, density, style.id);
    }

    @NotNull
    public static Rectangle getTargetRect(@Nullable IconGenerator.Shape shape, @NotNull Density density) {
        Rectangle targetRect;
        if (density == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(22);
        }
        if ((targetRect = TARGET_RECTS.get(Pair.of((Object)((Object)shape), (Object)density))) == null) {
            targetRect = AssetStudioUtils.scaleRectangle(TARGET_RECTS.get(Pair.of((Object)((Object)shape), (Object)Density.MEDIUM)), LauncherLegacyIconGenerator.getMdpiScaleFactor(density));
        }
        Rectangle rectangle = targetRect;
        if (rectangle == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(23);
        }
        return rectangle;
    }

    @Override
    @NotNull
    public BufferedImage generateRasterImage(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.Options options) {
        Rectangle imageRect;
        if (context == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(24);
        }
        if (options == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(25);
        }
        if (options.usePlaceholders) {
            BufferedImage bufferedImage = PLACEHOLDER_IMAGE;
            if (bufferedImage == null) {
                LauncherLegacyIconGenerator.$$$reportNull$$$0(26);
            }
            return bufferedImage;
        }
        LauncherLegacyOptions launcherOptions = (LauncherLegacyOptions)options;
        Rectangle rectangle = imageRect = launcherOptions.generateWebIcon ? IMAGE_SIZE_WEB : AssetStudioUtils.scaleRectangle(IMAGE_SIZE_MDPI, LauncherLegacyIconGenerator.getMdpiScaleFactor(launcherOptions.density));
        if (launcherOptions.isDogEar) {
            launcherOptions.shape = LauncherLegacyIconGenerator.applyDog(launcherOptions.shape);
        }
        BufferedImage shapeImageBack = null;
        BufferedImage shapeImageFore = null;
        BufferedImage shapeImageMask = null;
        if (launcherOptions.shape != IconGenerator.Shape.NONE && launcherOptions.shape != null && launcherOptions.renderShape) {
            Density loadImageDensity = launcherOptions.generateWebIcon ? Density.NODPI : launcherOptions.density;
            shapeImageBack = LauncherLegacyIconGenerator.loadBackImage(context, launcherOptions.shape, loadImageDensity);
            shapeImageFore = LauncherLegacyIconGenerator.loadStyleImage(context, launcherOptions.shape, loadImageDensity, launcherOptions.style);
            shapeImageMask = LauncherLegacyIconGenerator.loadMaskImage(context, launcherOptions.shape, loadImageDensity);
        }
        Rectangle targetRect = LauncherLegacyIconGenerator.getTargetRect(launcherOptions.shape, launcherOptions.density);
        BufferedImage outImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gOut = (Graphics2D)outImage.getGraphics();
        if (shapeImageBack != null) {
            gOut.drawImage((Image)shapeImageBack, 0, 0, null);
        }
        BufferedImage tempImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gTemp = (Graphics2D)tempImage.getGraphics();
        if (shapeImageMask != null) {
            gTemp.drawImage((Image)shapeImageMask, 0, 0, null);
            gTemp.setComposite(AlphaComposite.SrcAtop);
            gTemp.setPaint(new Color(launcherOptions.backgroundColor));
            gTemp.fillRect(0, 0, imageRect.width, imageRect.height);
        }
        BufferedImage sourceImage = this.generateRasterImage(targetRect.getSize(), options);
        BufferedImage iconImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gIcon = (Graphics2D)iconImage.getGraphics();
        if (launcherOptions.crop) {
            AssetUtil.drawCenterCrop((Graphics2D)gIcon, (BufferedImage)sourceImage, (Rectangle)targetRect);
        } else {
            AssetUtil.drawCenterInside((Graphics2D)gIcon, (BufferedImage)sourceImage, (Rectangle)targetRect);
        }
        AssetUtil.Effect[] effects = launcherOptions.useForegroundColor ? new AssetUtil.Effect[]{new AssetUtil.FillEffect((Paint)new Color(launcherOptions.foregroundColor), 1.0)} : AssetUtil.NO_EFFECTS;
        AssetUtil.drawEffects((Graphics2D)gTemp, (BufferedImage)iconImage, (int)0, (int)0, (AssetUtil.Effect[])effects);
        gOut.drawImage((Image)tempImage, 0, 0, null);
        if (shapeImageFore != null) {
            gOut.drawImage((Image)shapeImageFore, 0, 0, null);
        }
        gOut.dispose();
        gTemp.dispose();
        gIcon.dispose();
        BufferedImage bufferedImage = outImage;
        if (bufferedImage == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(27);
        }
        return bufferedImage;
    }

    @Override
    protected boolean includeDensity(@NotNull Density density) {
        if (density == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(28);
        }
        return super.includeDensity(density) || density == Density.XXXHIGH;
    }

    @Override
    public void generateRasterImage(@Nullable String category, @NotNull Map<String, Map<String, BufferedImage>> categoryMap, @NotNull GraphicGeneratorContext context, @NotNull IconGenerator.Options options, @NotNull String name) {
        if (categoryMap == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(29);
        }
        if (context == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(30);
        }
        if (options == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(31);
        }
        if (name == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(32);
        }
        LauncherLegacyOptions launcherOptions = (LauncherLegacyOptions)options;
        boolean generateWebImage = launcherOptions.generateWebIcon;
        launcherOptions.generateWebIcon = false;
        super.generateRasterImage(category, categoryMap, context, options, name);
        if (generateWebImage) {
            launcherOptions.generateWebIcon = true;
            launcherOptions.density = Density.NODPI;
            BufferedImage image = this.generateRasterImage(context, options);
            HashMap<String, BufferedImage> imageMap = new HashMap<String, BufferedImage>();
            categoryMap.put("Web", imageMap);
            imageMap.put(this.getIconPath(options, name), image);
        }
    }

    @Override
    @NotNull
    public Collection<GeneratedIcon> generateIcons(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.Options options, @NotNull String name) {
        if (context == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(33);
        }
        if (options == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(34);
        }
        if (name == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(35);
        }
        HashMap<String, Map<String, BufferedImage>> categoryMap = new HashMap<String, Map<String, BufferedImage>>();
        this.generateRasterImage(null, categoryMap, context, options, name);
        ArrayList<GeneratedIcon> icons = new ArrayList<GeneratedIcon>();
        categoryMap.forEach((category, images) -> images.forEach((path, image) -> {
            Density density = LauncherLegacyIconGenerator.pathToDensity(path);
            if (density == null) {
                density = Density.NODPI;
            }
            GeneratedImageIcon icon = new GeneratedImageIcon((String)path, new PathString(path), IconCategory.REGULAR, density, (BufferedImage)image);
            icons.add(icon);
        }));
        ArrayList<GeneratedIcon> arrayList = icons;
        if (arrayList == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(36);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected String getIconPath(@NotNull IconGenerator.Options options, @NotNull String iconName) {
        if (options == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(37);
        }
        if (iconName == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(38);
        }
        if (((LauncherLegacyOptions)options).generateWebIcon) {
            String string = iconName + "-web.png";
            if (string == null) {
                LauncherLegacyIconGenerator.$$$reportNull$$$0(39);
            }
            return string;
        }
        String string = super.getIconPath(options, iconName);
        if (string == null) {
            LauncherLegacyIconGenerator.$$$reportNull$$$0(40);
        }
        return string;
    }

    private static Map<Pair<IconGenerator.Shape, Density>, Rectangle> buildTargetRectangles() {
        ImmutableMap.Builder targetRects = new ImmutableMap.Builder();
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.NONE), (Object)Density.NODPI), (Object)new Rectangle(32, 32, 448, 448));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.NONE), (Object)Density.HIGH), (Object)new Rectangle(4, 4, 64, 64));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.NONE), (Object)Density.MEDIUM), (Object)new Rectangle(3, 3, 42, 42));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.CIRCLE), (Object)Density.NODPI), (Object)new Rectangle(21, 21, 470, 470));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.CIRCLE), (Object)Density.HIGH), (Object)new Rectangle(3, 3, 66, 66));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.CIRCLE), (Object)Density.MEDIUM), (Object)new Rectangle(2, 2, 44, 44));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.SQUARE), (Object)Density.NODPI), (Object)new Rectangle(53, 53, 406, 406));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.SQUARE), (Object)Density.HIGH), (Object)new Rectangle(7, 7, 57, 57));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.SQUARE), (Object)Density.MEDIUM), (Object)new Rectangle(5, 5, 38, 38));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.VRECT), (Object)Density.NODPI), (Object)new Rectangle(85, 21, 342, 470));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.VRECT), (Object)Density.HIGH), (Object)new Rectangle(12, 3, 48, 66));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.VRECT), (Object)Density.MEDIUM), (Object)new Rectangle(8, 2, 32, 44));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.HRECT), (Object)Density.NODPI), (Object)new Rectangle(21, 85, 470, 342));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.HRECT), (Object)Density.HIGH), (Object)new Rectangle(3, 12, 66, 48));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.HRECT), (Object)Density.MEDIUM), (Object)new Rectangle(2, 8, 44, 32));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.SQUARE_DOG), (Object)Density.NODPI), (Object)new Rectangle(53, 149, 406, 312));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.SQUARE_DOG), (Object)Density.HIGH), (Object)new Rectangle(7, 21, 57, 43));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.SQUARE_DOG), (Object)Density.MEDIUM), (Object)new Rectangle(5, 14, 38, 29));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.VRECT_DOG), (Object)Density.NODPI), (Object)new Rectangle(85, 117, 342, 374));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.VRECT_DOG), (Object)Density.HIGH), (Object)new Rectangle(12, 17, 48, 52));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.VRECT_DOG), (Object)Density.MEDIUM), (Object)new Rectangle(8, 11, 32, 35));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.HRECT_DOG), (Object)Density.NODPI), (Object)new Rectangle(21, 85, 374, 342));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.HRECT_DOG), (Object)Density.HIGH), (Object)new Rectangle(3, 12, 52, 48));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.HRECT_DOG), (Object)Density.MEDIUM), (Object)new Rectangle(2, 8, 35, 32));
        return targetRects.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 23: 
            case 26: 
            case 27: 
            case 36: 
            case 39: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 23: 
            case 26: 
            case 27: 
            case 36: 
            case 39: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 23: 
            case 26: 
            case 27: 
            case 36: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/LauncherLegacyIconGenerator";
                break;
            }
            case 8: 
            case 12: 
            case 15: 
            case 18: 
            case 24: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shape";
                break;
            }
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "density";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 25: 
            case 31: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "categoryMap";
                break;
            }
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/LauncherLegacyIconGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "useForegroundColor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "foregroundColor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "backgroundColor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "cropped";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "shape";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "dogEared";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptions";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetRect";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "generateRasterImage";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIcons";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 23: 
            case 26: 
            case 27: 
            case 36: 
            case 39: 
            case 40: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadImage";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadMaskImage";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "loadBackImage";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "loadStyleImage";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTargetRect";
                break;
            }
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "generateRasterImage";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "includeDensity";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "generateIcons";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getIconPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 23: 
            case 26: 
            case 27: 
            case 36: 
            case 39: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LauncherLegacyOptions
    extends IconGenerator.Options {
        public boolean useForegroundColor = true;
        public int foregroundColor;
        public int backgroundColor;
        public boolean crop = true;
        public IconGenerator.Shape shape = IconGenerator.Shape.SQUARE;
        public IconGenerator.Style style = IconGenerator.Style.SIMPLE;
        public boolean isDogEar;
        public boolean renderShape = true;
        public boolean generateWebIcon;

        public LauncherLegacyOptions(boolean forPreview) {
            super(forPreview);
            this.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
        }
    }
}

