/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.AssetUtil;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.tools.idea.concurrent.FutureUtils;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.DrawableRenderer;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedXmlResource;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.LauncherLegacyIconGenerator;
import com.android.tools.idea.npw.assetstudio.PrimitiveShapesHelper;
import com.android.tools.idea.npw.assetstudio.TransformedImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.TextAsset;
import com.android.tools.idea.npw.assetstudio.assets.VectorAsset;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.project.Project;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LauncherIconGenerator
extends IconGenerator {
    public static final Color DEFAULT_FOREGROUND_COLOR = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND_COLOR = new Color(2533018);
    public static final Rectangle IMAGE_SIZE_FULL_BLEED_DP = new Rectangle(0, 0, 108, 108);
    public static final Dimension SIZE_FULL_BLEED_DP = IMAGE_SIZE_FULL_BLEED_DP.getSize();
    private static final Rectangle IMAGE_SIZE_SAFE_ZONE_DP = new Rectangle(0, 0, 66, 66);
    private static final Rectangle IMAGE_SIZE_VIEWPORT_DP = new Rectangle(0, 0, 72, 72);
    private static final Rectangle IMAGE_SIZE_LEGACY_DP = new Rectangle(0, 0, 48, 48);
    private static final Rectangle IMAGE_SIZE_VIEW_PORT_WEB_PX = new Rectangle(0, 0, 512, 512);
    private static final Rectangle IMAGE_SIZE_FULL_BLEED_WEB_PX = new Rectangle(0, 0, 768, 768);
    private final BoolProperty myUseForegroundColor;
    private final ObjectProperty<Color> myForegroundColor;
    private final ObjectProperty<Color> myBackgroundColor;
    private final BoolProperty myGenerateLegacyIcon;
    private final BoolProperty myGenerateRoundIcon;
    private final BoolProperty myGenerateWebIcon;
    private final ObjectProperty<IconGenerator.Shape> myLegacyIconShape;
    private final ObjectProperty<IconGenerator.Shape> myWebIconShape;
    private final BoolProperty myShowGrid;
    private final BoolProperty myShowSafeZone;
    private final ObjectValueProperty<Density> myPreviewDensity;
    private final OptionalProperty<ImageAsset> myBackgroundImageAsset;
    private final StringProperty myForegroundLayerName;
    private final StringProperty myBackgroundLayerName;

    public LauncherIconGenerator(@NotNull Project project, int minSdkVersion2, @Nullable DrawableRenderer renderer) {
        if (project == null) {
            LauncherIconGenerator.$$$reportNull$$$0(0);
        }
        super(project, minSdkVersion2, new GraphicGeneratorContext(40, renderer));
        this.myUseForegroundColor = new BoolValueProperty(true);
        this.myForegroundColor = new ObjectValueProperty<Color>(DEFAULT_FOREGROUND_COLOR);
        this.myBackgroundColor = new ObjectValueProperty<Color>(DEFAULT_BACKGROUND_COLOR);
        this.myGenerateLegacyIcon = new BoolValueProperty(true);
        this.myGenerateRoundIcon = new BoolValueProperty(true);
        this.myGenerateWebIcon = new BoolValueProperty(true);
        this.myLegacyIconShape = new ObjectValueProperty<IconGenerator.Shape>(IconGenerator.Shape.SQUARE);
        this.myWebIconShape = new ObjectValueProperty<IconGenerator.Shape>(IconGenerator.Shape.SQUARE);
        this.myShowGrid = new BoolValueProperty();
        this.myShowSafeZone = new BoolValueProperty(true);
        this.myPreviewDensity = new ObjectValueProperty<Density>(Density.XHIGH);
        this.myBackgroundImageAsset = new OptionalValueProperty<ImageAsset>();
        this.myForegroundLayerName = new StringValueProperty();
        this.myBackgroundLayerName = new StringValueProperty();
    }

    @NotNull
    public BoolProperty useForegroundColor() {
        BoolProperty boolProperty = this.myUseForegroundColor;
        if (boolProperty == null) {
            LauncherIconGenerator.$$$reportNull$$$0(1);
        }
        return boolProperty;
    }

    @NotNull
    public ObjectProperty<Color> foregroundColor() {
        ObjectProperty<Color> objectProperty = this.myForegroundColor;
        if (objectProperty == null) {
            LauncherIconGenerator.$$$reportNull$$$0(2);
        }
        return objectProperty;
    }

    @NotNull
    public ObjectProperty<Color> backgroundColor() {
        ObjectProperty<Color> objectProperty = this.myBackgroundColor;
        if (objectProperty == null) {
            LauncherIconGenerator.$$$reportNull$$$0(3);
        }
        return objectProperty;
    }

    @NotNull
    public BoolProperty generateLegacyIcon() {
        BoolProperty boolProperty = this.myGenerateLegacyIcon;
        if (boolProperty == null) {
            LauncherIconGenerator.$$$reportNull$$$0(4);
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty generateRoundIcon() {
        BoolProperty boolProperty = this.myGenerateRoundIcon;
        if (boolProperty == null) {
            LauncherIconGenerator.$$$reportNull$$$0(5);
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty generateWebIcon() {
        BoolProperty boolProperty = this.myGenerateWebIcon;
        if (boolProperty == null) {
            LauncherIconGenerator.$$$reportNull$$$0(6);
        }
        return boolProperty;
    }

    @NotNull
    public ObjectProperty<IconGenerator.Shape> legacyIconShape() {
        ObjectProperty<IconGenerator.Shape> objectProperty = this.myLegacyIconShape;
        if (objectProperty == null) {
            LauncherIconGenerator.$$$reportNull$$$0(7);
        }
        return objectProperty;
    }

    @NotNull
    public ObjectProperty<IconGenerator.Shape> webIconShape() {
        ObjectProperty<IconGenerator.Shape> objectProperty = this.myWebIconShape;
        if (objectProperty == null) {
            LauncherIconGenerator.$$$reportNull$$$0(8);
        }
        return objectProperty;
    }

    @NotNull
    public OptionalProperty<ImageAsset> backgroundImageAsset() {
        OptionalProperty<ImageAsset> optionalProperty = this.myBackgroundImageAsset;
        if (optionalProperty == null) {
            LauncherIconGenerator.$$$reportNull$$$0(9);
        }
        return optionalProperty;
    }

    @NotNull
    public BoolProperty showGrid() {
        BoolProperty boolProperty = this.myShowGrid;
        if (boolProperty == null) {
            LauncherIconGenerator.$$$reportNull$$$0(10);
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty showSafeZone() {
        BoolProperty boolProperty = this.myShowSafeZone;
        if (boolProperty == null) {
            LauncherIconGenerator.$$$reportNull$$$0(11);
        }
        return boolProperty;
    }

    @NotNull
    public ObjectValueProperty<Density> previewDensity() {
        ObjectValueProperty<Density> objectValueProperty = this.myPreviewDensity;
        if (objectValueProperty == null) {
            LauncherIconGenerator.$$$reportNull$$$0(12);
        }
        return objectValueProperty;
    }

    @NotNull
    public StringProperty foregroundLayerName() {
        StringProperty stringProperty = this.myForegroundLayerName;
        if (stringProperty == null) {
            LauncherIconGenerator.$$$reportNull$$$0(13);
        }
        return stringProperty;
    }

    @NotNull
    public StringProperty backgroundLayerName() {
        StringProperty stringProperty = this.myBackgroundLayerName;
        if (stringProperty == null) {
            LauncherIconGenerator.$$$reportNull$$$0(14);
        }
        return stringProperty;
    }

    @Override
    @NotNull
    public LauncherIconOptions createOptions(boolean forPreview) {
        ImageAsset backgroundAsset;
        LauncherIconOptions options = new LauncherIconOptions(forPreview);
        options.useForegroundColor = (Boolean)this.myUseForegroundColor.get();
        options.foregroundColor = ((Color)this.myForegroundColor.get()).getRGB();
        BaseAsset foregroundAsset = this.sourceAsset().getValueOrNull();
        if (foregroundAsset != null) {
            double scaleFactor = (double)((Integer)foregroundAsset.scalingPercent().get()).intValue() / 100.0;
            if (foregroundAsset instanceof VectorAsset) {
                scaleFactor *= 0.58;
            } else if (foregroundAsset instanceof TextAsset) {
                scaleFactor *= 0.46;
            } else if (((Boolean)foregroundAsset.trimmed().get()).booleanValue()) {
                scaleFactor *= IMAGE_SIZE_SAFE_ZONE_DP.getWidth() / SIZE_FULL_BLEED_DP.getWidth();
            }
            options.foregroundImage = new TransformedImageAsset(foregroundAsset, SIZE_FULL_BLEED_DP, scaleFactor, null, 1.0, this.getGraphicGeneratorContext());
        }
        if ((backgroundAsset = this.myBackgroundImageAsset.getValueOrNull()) != null) {
            double scaleFactor = (double)((Integer)backgroundAsset.scalingPercent().get()).intValue() / 100.0;
            options.backgroundImage = new TransformedImageAsset(backgroundAsset, SIZE_FULL_BLEED_DP, scaleFactor, null, 1.0, this.getGraphicGeneratorContext());
        }
        options.backgroundColor = ((Color)this.myBackgroundColor.get()).getRGB();
        options.showGrid = (Boolean)this.myShowGrid.get();
        options.showSafeZone = (Boolean)this.myShowSafeZone.get();
        options.previewDensity = this.myPreviewDensity.get();
        options.foregroundLayerName = (String)this.myForegroundLayerName.get();
        options.backgroundLayerName = (String)this.myBackgroundLayerName.get();
        options.generateLegacyIcon = (Boolean)this.myGenerateLegacyIcon.get();
        options.legacyIconShape = (IconGenerator.Shape)((Object)this.myLegacyIconShape.get());
        options.webIconShape = (IconGenerator.Shape)((Object)this.myWebIconShape.get());
        options.generateRoundIcon = (Boolean)this.myGenerateRoundIcon.get();
        options.generateWebIcon = (Boolean)this.myGenerateWebIcon.get();
        LauncherIconOptions launcherIconOptions = options;
        if (launcherIconOptions == null) {
            LauncherIconGenerator.$$$reportNull$$$0(15);
        }
        return launcherIconOptions;
    }

    @Override
    @NotNull
    protected List<Callable<GeneratedIcon>> createIconGenerationTasks(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.Options options, @NotNull String name) {
        if (context == null) {
            LauncherIconGenerator.$$$reportNull$$$0(16);
        }
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(17);
        }
        if (name == null) {
            LauncherIconGenerator.$$$reportNull$$$0(18);
        }
        LauncherIconOptions launcherIconOptions = (LauncherIconOptions)options;
        ArrayList<Callable<GeneratedIcon>> tasks = new ArrayList<Callable<GeneratedIcon>>();
        this.createOutputIconsTasks(context, name, launcherIconOptions, tasks);
        this.createXmlDrawableResourcesTasks(name, launcherIconOptions, tasks);
        LauncherIconGenerator.createPreviewImagesTasks(context, launcherIconOptions, tasks);
        ArrayList<Callable<GeneratedIcon>> arrayList = tasks;
        if (arrayList == null) {
            LauncherIconGenerator.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    private void createOutputIconsTasks(@NotNull GraphicGeneratorContext context, @NotNull String name, @NotNull LauncherIconOptions options, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (context == null) {
            LauncherIconGenerator.$$$reportNull$$$0(20);
        }
        if (name == null) {
            LauncherIconGenerator.$$$reportNull$$$0(21);
        }
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(22);
        }
        if (tasks == null) {
            LauncherIconGenerator.$$$reportNull$$$0(23);
        }
        if (!options.generateOutputIcons) {
            return;
        }
        for (Density density : DENSITIES) {
            LauncherIconOptions localOptions = options.clone();
            localOptions.density = density;
            localOptions.showGrid = false;
            localOptions.showSafeZone = false;
            this.createOutputIconsForSingleDensityTasks(context, name, localOptions, density, tasks);
        }
        if (options.generateWebIcon) {
            tasks.add(() -> {
                LauncherIconOptions localOptions = options.clone();
                localOptions.showGrid = false;
                localOptions.showSafeZone = false;
                localOptions.generateWebIcon = true;
                localOptions.generateOutputIcons = true;
                localOptions.generatePreviewIcons = false;
                localOptions.legacyIconShape = localOptions.webIconShape;
                BufferedImage image = LauncherIconGenerator.generateLegacyImage(context, localOptions);
                return new GeneratedImageIcon(name, new PathString(this.getIconPath(localOptions, name)), IconCategory.WEB, Density.NODPI, image);
            });
        }
    }

    private void createOutputIconsForSingleDensityTasks(@NotNull GraphicGeneratorContext context, @NotNull String name, @NotNull LauncherIconOptions options, @NotNull Density density, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (context == null) {
            LauncherIconGenerator.$$$reportNull$$$0(24);
        }
        if (name == null) {
            LauncherIconGenerator.$$$reportNull$$$0(25);
        }
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(26);
        }
        if (density == null) {
            LauncherIconGenerator.$$$reportNull$$$0(27);
        }
        if (tasks == null) {
            LauncherIconGenerator.$$$reportNull$$$0(28);
        }
        if (options.foregroundImage != null && options.foregroundImage.isRasterImage()) {
            tasks.add(() -> {
                LauncherIconOptions foregroundOptions = options.clone();
                foregroundOptions.generateWebIcon = false;
                foregroundOptions.generatePreviewIcons = false;
                foregroundOptions.generateOutputIcons = true;
                BufferedImage foregroundImage = LauncherIconGenerator.generateIconForegroundLayer(context, foregroundOptions);
                return new GeneratedImageIcon(foregroundOptions.foregroundLayerName, new PathString(this.getIconPath(foregroundOptions, options.foregroundLayerName)), IconCategory.ADAPTIVE_FOREGROUND_LAYER, density, foregroundImage);
            });
        }
        if (options.backgroundImage != null && options.backgroundImage.isRasterImage()) {
            tasks.add(() -> {
                LauncherIconOptions backgroundOptions = options.clone();
                backgroundOptions.generateWebIcon = false;
                backgroundOptions.generatePreviewIcons = false;
                backgroundOptions.generateOutputIcons = true;
                BufferedImage backgroundImage = LauncherIconGenerator.generateIconBackgroundLayer(context, backgroundOptions);
                return new GeneratedImageIcon(backgroundOptions.backgroundLayerName, new PathString(this.getIconPath(backgroundOptions, options.backgroundLayerName)), IconCategory.ADAPTIVE_BACKGROUND_LAYER, density, backgroundImage);
            });
        }
        if (options.generateLegacyIcon) {
            tasks.add(() -> {
                LauncherIconOptions legacyOptions = options.clone();
                legacyOptions.previewShape = PreviewShape.LEGACY;
                legacyOptions.generateWebIcon = false;
                legacyOptions.generatePreviewIcons = false;
                legacyOptions.generateOutputIcons = true;
                BufferedImage legacy = LauncherIconGenerator.generateLegacyImage(context, legacyOptions);
                return new GeneratedImageIcon(name, new PathString(this.getIconPath(legacyOptions, name)), IconCategory.LEGACY, density, legacy);
            });
        }
        if (options.generateRoundIcon) {
            tasks.add(() -> {
                LauncherIconOptions legacyOptions = options.clone();
                legacyOptions.previewShape = PreviewShape.LEGACY_ROUND;
                legacyOptions.generateWebIcon = false;
                legacyOptions.generatePreviewIcons = false;
                legacyOptions.generateOutputIcons = true;
                legacyOptions.legacyIconShape = IconGenerator.Shape.CIRCLE;
                BufferedImage legacyRound = LauncherIconGenerator.generateLegacyImage(context, legacyOptions);
                return new GeneratedImageIcon(name + "_round", new PathString(this.getIconPath(legacyOptions, name + "_round")), IconCategory.ROUND_API_25, density, legacyRound);
            });
        }
    }

    private void createXmlDrawableResourcesTasks(@NotNull String name, @NotNull LauncherIconOptions options, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (name == null) {
            LauncherIconGenerator.$$$reportNull$$$0(29);
        }
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(30);
        }
        if (tasks == null) {
            LauncherIconGenerator.$$$reportNull$$$0(31);
        }
        if (!options.generateOutputIcons) {
            return;
        }
        LauncherIconOptions iconOptions = options.clone();
        iconOptions.density = Density.ANYDPI;
        iconOptions.generateWebIcon = false;
        iconOptions.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
        iconOptions.apiVersion = 26;
        tasks.add(() -> {
            String xmlAdaptiveIcon = this.getAdaptiveIconXml(iconOptions);
            return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, name)), IconCategory.XML_RESOURCE, xmlAdaptiveIcon);
        });
        tasks.add(() -> {
            String xmlAdaptiveIcon = this.getAdaptiveIconXml(iconOptions);
            return new GeneratedXmlResource(name + "_round", new PathString(this.getIconPath(iconOptions, name + "_round")), IconCategory.XML_RESOURCE, xmlAdaptiveIcon);
        });
        if (options.foregroundImage != null && options.foregroundImage.isDrawable()) {
            tasks.add(() -> {
                LauncherIconOptions iconOptions = options.clone();
                iconOptions.generateWebIcon = false;
                iconOptions.density = Density.ANYDPI;
                iconOptions.iconFolderKind = IconGenerator.IconFolderKind.DRAWABLE_NO_DPI;
                String xmlDrawableText = options.foregroundImage.getTransformedDrawable();
                assert (xmlDrawableText != null);
                iconOptions.apiVersion = this.calculateMinRequiredApiLevel(xmlDrawableText, this.myMinSdkVersion);
                return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, iconOptions.foregroundLayerName)), IconCategory.ADAPTIVE_FOREGROUND_LAYER, xmlDrawableText);
            });
        }
        if (options.backgroundImage != null && options.backgroundImage.isDrawable()) {
            tasks.add(() -> {
                LauncherIconOptions iconOptions = options.clone();
                iconOptions.generateWebIcon = false;
                iconOptions.density = Density.ANYDPI;
                iconOptions.iconFolderKind = IconGenerator.IconFolderKind.DRAWABLE_NO_DPI;
                String xmlDrawableText = options.backgroundImage.getTransformedDrawable();
                assert (xmlDrawableText != null);
                iconOptions.apiVersion = this.calculateMinRequiredApiLevel(xmlDrawableText, this.myMinSdkVersion);
                return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, iconOptions.backgroundLayerName)), IconCategory.ADAPTIVE_BACKGROUND_LAYER, xmlDrawableText);
            });
        } else if (options.backgroundImage == null) {
            tasks.add(() -> {
                LauncherIconOptions iconOptions = options.clone();
                iconOptions.generateWebIcon = false;
                iconOptions.density = Density.ANYDPI;
                iconOptions.iconFolderKind = IconGenerator.IconFolderKind.VALUES;
                String format = "<?xml version=\"1.0\" encoding=\"utf-8\"?>%1$s<resources>%1$s    <color name=\"%2$s\">#%3$06X</color>%1$s</resources>";
                String xmlColor = String.format(format, this.myLineSeparator, iconOptions.backgroundLayerName, iconOptions.backgroundColor & 0xFFFFFF);
                return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, iconOptions.backgroundLayerName)), IconCategory.XML_RESOURCE, xmlColor);
            });
        }
    }

    @NotNull
    private String getAdaptiveIconXml(@NotNull LauncherIconOptions options) {
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(32);
        }
        String backgroundType = options.backgroundImage == null ? "color" : (options.backgroundImage.isDrawable() ? "drawable" : "mipmap");
        String foregroundType = options.foregroundImage != null && options.foregroundImage.isDrawable() ? "drawable" : "mipmap";
        String format = "<?xml version=\"1.0\" encoding=\"utf-8\"?>%1$s<adaptive-icon xmlns:android=\"http://schemas.android.com/apk/res/android\">%1$s    <background android:drawable=\"@%2$s/%3$s\"/>%1$s    <foreground android:drawable=\"@%4$s/%5$s\"/>%1$s</adaptive-icon>";
        String string = String.format(format, this.myLineSeparator, backgroundType, options.backgroundLayerName, foregroundType, options.foregroundLayerName);
        if (string == null) {
            LauncherIconGenerator.$$$reportNull$$$0(33);
        }
        return string;
    }

    private static void createPreviewImagesTasks(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (context == null) {
            LauncherIconGenerator.$$$reportNull$$$0(34);
        }
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(35);
        }
        if (tasks == null) {
            LauncherIconGenerator.$$$reportNull$$$0(36);
        }
        if (!options.generatePreviewIcons) {
            return;
        }
        ArrayList<PreviewShape> previewShapes = new ArrayList<PreviewShape>();
        previewShapes.add(PreviewShape.FULL_BLEED);
        previewShapes.add(PreviewShape.SQUIRCLE);
        previewShapes.add(PreviewShape.CIRCLE);
        previewShapes.add(PreviewShape.SQUARE);
        previewShapes.add(PreviewShape.ROUNDED_SQUARE);
        if (options.generateLegacyIcon) {
            previewShapes.add(PreviewShape.LEGACY);
        }
        if (options.generateRoundIcon) {
            previewShapes.add(PreviewShape.LEGACY_ROUND);
        }
        if (options.generateWebIcon) {
            previewShapes.add(PreviewShape.WEB);
        }
        for (PreviewShape previewShape : previewShapes) {
            tasks.add(() -> {
                LauncherIconOptions localOptions = options.clone();
                localOptions.density = options.previewDensity;
                localOptions.previewShape = previewShape;
                localOptions.generateLegacyIcon = previewShape == PreviewShape.LEGACY;
                localOptions.generateRoundIcon = previewShape == PreviewShape.LEGACY_ROUND;
                localOptions.generateWebIcon = previewShape == PreviewShape.WEB;
                BufferedImage image = LauncherIconGenerator.generatePreviewImage(context, localOptions);
                return new GeneratedImageIcon(previewShape.id, null, IconCategory.PREVIEW, localOptions.density, image);
            });
        }
    }

    @Override
    public void generateRasterImage(@Nullable String category, @NotNull Map<String, Map<String, BufferedImage>> categoryMap, @NotNull GraphicGeneratorContext context, @NotNull IconGenerator.Options options, @NotNull String name) {
        if (categoryMap == null) {
            LauncherIconGenerator.$$$reportNull$$$0(37);
        }
        if (context == null) {
            LauncherIconGenerator.$$$reportNull$$$0(38);
        }
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(39);
        }
        if (name == null) {
            LauncherIconGenerator.$$$reportNull$$$0(40);
        }
        LauncherIconOptions launcherIconOptions = (LauncherIconOptions)options;
        LauncherIconOptions localOptions = launcherIconOptions.clone();
        localOptions.generateWebIcon = false;
        Collection<GeneratedIcon> icons = this.generateIcons(context, options, name);
        icons.stream().filter(x -> x instanceof GeneratedImageIcon).map(x -> (GeneratedImageIcon)x).filter(x -> x.getOutputPath() != null).forEach(x -> {
            assert (x.getOutputPath() != null);
            Map imageMap = categoryMap.computeIfAbsent(x.getCategory().toString(), k -> new LinkedHashMap());
            LauncherIconOptions iconOptions = localOptions.clone();
            iconOptions.density = x.getDensity();
            iconOptions.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
            iconOptions.generateWebIcon = x.getCategory() == IconCategory.WEB;
            imageMap.put(x.getOutputPath().toString(), x.getImage());
        });
    }

    @Override
    @NotNull
    public BufferedImage generateRasterImage(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.Options options) {
        if (context == null) {
            LauncherIconGenerator.$$$reportNull$$$0(41);
        }
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(42);
        }
        if (options.usePlaceholders) {
            BufferedImage bufferedImage = PLACEHOLDER_IMAGE;
            if (bufferedImage == null) {
                LauncherIconGenerator.$$$reportNull$$$0(43);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = LauncherIconGenerator.generatePreviewImage(context, (LauncherIconOptions)options);
        if (bufferedImage == null) {
            LauncherIconGenerator.$$$reportNull$$$0(44);
        }
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage generatePreviewImage(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options) {
        if (context == null) {
            LauncherIconGenerator.$$$reportNull$$$0(45);
        }
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(46);
        }
        switch (options.previewShape) {
            case CIRCLE: 
            case SQUIRCLE: 
            case ROUNDED_SQUARE: 
            case SQUARE: {
                BufferedImage bufferedImage = LauncherIconGenerator.generateViewportPreviewImage(context, options);
                if (bufferedImage == null) {
                    LauncherIconGenerator.$$$reportNull$$$0(47);
                }
                return bufferedImage;
            }
            case LEGACY: {
                options.generatePreviewIcons = true;
                options.generateWebIcon = false;
                BufferedImage bufferedImage = LauncherIconGenerator.generateLegacyImage(context, options);
                if (bufferedImage == null) {
                    LauncherIconGenerator.$$$reportNull$$$0(48);
                }
                return bufferedImage;
            }
            case LEGACY_ROUND: {
                options.generatePreviewIcons = true;
                options.generateWebIcon = false;
                options.legacyIconShape = IconGenerator.Shape.CIRCLE;
                BufferedImage bufferedImage = LauncherIconGenerator.generateLegacyImage(context, options);
                if (bufferedImage == null) {
                    LauncherIconGenerator.$$$reportNull$$$0(49);
                }
                return bufferedImage;
            }
            case FULL_BLEED: {
                BufferedImage image = LauncherIconGenerator.generateFullBleedPreviewImage(context, options);
                BufferedImage bufferedImage = LauncherIconGenerator.scaledPreviewImage(image, 0.8f);
                if (bufferedImage == null) {
                    LauncherIconGenerator.$$$reportNull$$$0(50);
                }
                return bufferedImage;
            }
            case WEB: {
                options.generatePreviewIcons = true;
                options.generateWebIcon = true;
                options.legacyIconShape = options.webIconShape;
                BufferedImage image = LauncherIconGenerator.generateLegacyImage(context, options);
                image = AssetUtil.trimmedImage((BufferedImage)image);
                double scale = LauncherIconGenerator.getMdpiScaleFactor(options.previewDensity);
                BufferedImage bufferedImage = LauncherIconGenerator.scaledPreviewImage(image, 0.25 * scale);
                if (bufferedImage == null) {
                    LauncherIconGenerator.$$$reportNull$$$0(51);
                }
                return bufferedImage;
            }
        }
        throw new IllegalArgumentException();
    }

    @NotNull
    private static BufferedImage generateFullBleedPreviewImage(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options) {
        if (context == null) {
            LauncherIconGenerator.$$$reportNull$$$0(52);
        }
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(53);
        }
        Layers layers = LauncherIconGenerator.generateIconLayers(context, options);
        BufferedImage result2 = LauncherIconGenerator.mergeLayers(layers, Color.BLACK);
        LauncherIconGenerator.drawGrid(options, result2);
        BufferedImage bufferedImage = result2;
        if (bufferedImage == null) {
            LauncherIconGenerator.$$$reportNull$$$0(54);
        }
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage generateLegacyImage(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options) {
        if (context == null) {
            LauncherIconGenerator.$$$reportNull$$$0(55);
        }
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(56);
        }
        Rectangle viewportRect = LauncherIconGenerator.getViewportRectangle(options);
        Rectangle legacyRect = LauncherIconGenerator.getLegacyRectangle(options);
        Density legacyOrWebDensity = options.generateWebIcon ? Density.NODPI : options.density;
        Rectangle legacyShapeRect = LauncherLegacyIconGenerator.getTargetRect(options.legacyIconShape, legacyOrWebDensity);
        Layers layers = LauncherIconGenerator.generateIconLayers(context, options);
        BufferedImage fullBleed = LauncherIconGenerator.mergeLayers(layers);
        float viewportScale = LauncherIconGenerator.getRectangleInsideScale(viewportRect, legacyShapeRect);
        BufferedImage scaledFullBleed = options.generatePreviewIcons ? LauncherIconGenerator.scaledPreviewImage(fullBleed, viewportScale) : LauncherIconGenerator.scaledImage(fullBleed, viewportScale);
        BufferedImage shapeImageBack = null;
        BufferedImage shapeImageFore = null;
        BufferedImage shapeImageMask = null;
        if (options.legacyIconShape != IconGenerator.Shape.NONE) {
            shapeImageBack = LauncherLegacyIconGenerator.loadBackImage(context, options.legacyIconShape, legacyOrWebDensity);
            shapeImageFore = LauncherLegacyIconGenerator.loadStyleImage(context, options.legacyIconShape, legacyOrWebDensity, IconGenerator.Style.SIMPLE);
            shapeImageMask = LauncherLegacyIconGenerator.loadMaskImage(context, options.legacyIconShape, legacyOrWebDensity);
        }
        BufferedImage legacyImage = AssetUtil.newArgbBufferedImage((int)legacyRect.width, (int)legacyRect.height);
        Graphics2D gLegacy = (Graphics2D)legacyImage.getGraphics();
        if (shapeImageBack != null) {
            AssetUtil.drawCentered((Graphics2D)gLegacy, (BufferedImage)shapeImageBack, (Rectangle)legacyRect);
        }
        if (shapeImageMask != null) {
            scaledFullBleed = LauncherIconGenerator.applyMask(scaledFullBleed, shapeImageMask);
        }
        AssetUtil.drawCentered((Graphics2D)gLegacy, (BufferedImage)scaledFullBleed, (Rectangle)legacyRect);
        if (shapeImageFore != null) {
            gLegacy.drawImage((Image)shapeImageFore, 0, 0, null);
        }
        gLegacy.dispose();
        BufferedImage bufferedImage = legacyImage;
        if (bufferedImage == null) {
            LauncherIconGenerator.$$$reportNull$$$0(57);
        }
        return bufferedImage;
    }

    public static float getRectangleInsideScale(@NotNull Rectangle source, @NotNull Rectangle destination) {
        if (source == null) {
            LauncherIconGenerator.$$$reportNull$$$0(58);
        }
        if (destination == null) {
            LauncherIconGenerator.$$$reportNull$$$0(59);
        }
        float scaleWidth = (float)destination.width / (float)source.width;
        float scaleHeight = (float)destination.height / (float)source.height;
        return Math.min(scaleWidth, scaleHeight);
    }

    @NotNull
    private static BufferedImage scaledImage(@NotNull BufferedImage image, float scale) {
        if (image == null) {
            LauncherIconGenerator.$$$reportNull$$$0(60);
        }
        int width = Math.round((float)image.getWidth() * scale);
        int height = Math.round((float)image.getHeight() * scale);
        BufferedImage bufferedImage = AssetUtil.scaledImage((BufferedImage)image, (int)width, (int)height);
        if (bufferedImage == null) {
            LauncherIconGenerator.$$$reportNull$$$0(61);
        }
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage scaledPreviewImage(@NotNull BufferedImage image, double scale) {
        if (image == null) {
            LauncherIconGenerator.$$$reportNull$$$0(62);
        }
        int width = (int)Math.round((double)image.getWidth() * scale);
        int height = (int)Math.round((double)image.getHeight() * scale);
        BufferedImage bufferedImage = LauncherIconGenerator.scaledPreviewImage(image, width, height);
        if (bufferedImage == null) {
            LauncherIconGenerator.$$$reportNull$$$0(63);
        }
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage scaledPreviewImage(@NotNull BufferedImage source, int width, int height) {
        if (source == null) {
            LauncherIconGenerator.$$$reportNull$$$0(64);
        }
        if (source.getWidth() == width && source.getHeight() == height) {
            BufferedImage bufferedImage = source;
            if (bufferedImage == null) {
                LauncherIconGenerator.$$$reportNull$$$0(65);
            }
            return bufferedImage;
        }
        BufferedImage scaledBufImage = AssetUtil.newArgbBufferedImage((int)width, (int)height);
        Graphics2D g = scaledBufImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(source, 0, 0, width, height, null);
        g.dispose();
        BufferedImage bufferedImage = scaledBufImage;
        if (bufferedImage == null) {
            LauncherIconGenerator.$$$reportNull$$$0(66);
        }
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage generateViewportPreviewImage(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options) {
        if (context == null) {
            LauncherIconGenerator.$$$reportNull$$$0(67);
        }
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(68);
        }
        Layers layers = LauncherIconGenerator.generateIconLayers(context, options);
        BufferedImage result2 = LauncherIconGenerator.mergeLayers(layers);
        BufferedImage mask = LauncherIconGenerator.generateMaskLayer(context, options, options.previewShape);
        result2 = LauncherIconGenerator.cropImageToViewport(options, result2);
        result2 = LauncherIconGenerator.applyMask(result2, mask);
        LauncherIconGenerator.drawGrid(options, result2);
        BufferedImage bufferedImage = result2;
        if (bufferedImage == null) {
            LauncherIconGenerator.$$$reportNull$$$0(69);
        }
        return bufferedImage;
    }

    private static BufferedImage cropImageToViewport(@NotNull LauncherIconOptions options, @NotNull BufferedImage image) {
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(70);
        }
        if (image == null) {
            LauncherIconGenerator.$$$reportNull$$$0(71);
        }
        return LauncherIconGenerator.cropImage(image, LauncherIconGenerator.getViewportRectangle(options));
    }

    private static BufferedImage cropImage(@NotNull BufferedImage image, @NotNull Rectangle targetRect) {
        if (image == null) {
            LauncherIconGenerator.$$$reportNull$$$0(72);
        }
        if (targetRect == null) {
            LauncherIconGenerator.$$$reportNull$$$0(73);
        }
        Rectangle imageRect = new Rectangle(0, 0, image.getWidth(), image.getHeight());
        BufferedImage subImage = image.getSubimage((imageRect.width - targetRect.width) / 2, (imageRect.height - targetRect.height) / 2, targetRect.width, targetRect.height);
        BufferedImage viewportImage = AssetUtil.newArgbBufferedImage((int)targetRect.width, (int)targetRect.height);
        Graphics2D gViewport = (Graphics2D)viewportImage.getGraphics();
        gViewport.drawImage((Image)subImage, 0, 0, null);
        gViewport.dispose();
        return viewportImage;
    }

    @NotNull
    private static BufferedImage mergeLayers(@NotNull Layers layers) {
        if (layers == null) {
            LauncherIconGenerator.$$$reportNull$$$0(74);
        }
        BufferedImage bufferedImage = LauncherIconGenerator.mergeLayers(layers, null);
        if (bufferedImage == null) {
            LauncherIconGenerator.$$$reportNull$$$0(75);
        }
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage mergeLayers(@NotNull Layers layers, @Nullable Color fillColor) {
        if (layers == null) {
            LauncherIconGenerator.$$$reportNull$$$0(76);
        }
        int width = Math.max(layers.background.getWidth(), layers.foreground.getWidth());
        int height = Math.max(layers.background.getHeight(), layers.foreground.getHeight());
        BufferedImage outImage = AssetUtil.newArgbBufferedImage((int)width, (int)height);
        Graphics2D gOut = (Graphics2D)outImage.getGraphics();
        if (fillColor != null) {
            gOut.setPaint(fillColor);
            gOut.fillRect(0, 0, width, height);
        }
        gOut.drawImage((Image)layers.background, 0, 0, null);
        gOut.drawImage((Image)layers.foreground, 0, 0, null);
        gOut.dispose();
        BufferedImage bufferedImage = outImage;
        if (bufferedImage == null) {
            LauncherIconGenerator.$$$reportNull$$$0(77);
        }
        return bufferedImage;
    }

    @NotNull
    private static Layers generateIconLayers(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options) {
        if (context == null) {
            LauncherIconGenerator.$$$reportNull$$$0(78);
        }
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(79);
        }
        BufferedImage backgroundImage = LauncherIconGenerator.generateIconBackgroundLayer(context, options);
        BufferedImage foregroundImage = LauncherIconGenerator.generateIconForegroundLayer(context, options);
        Layers layers = new Layers(backgroundImage, foregroundImage);
        if (layers == null) {
            LauncherIconGenerator.$$$reportNull$$$0(80);
        }
        return layers;
    }

    @Nullable
    private static BufferedImage generateMaskLayer(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options, @NotNull PreviewShape shape) {
        String maskName;
        if (context == null) {
            LauncherIconGenerator.$$$reportNull$$$0(81);
        }
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(82);
        }
        if (shape == null) {
            LauncherIconGenerator.$$$reportNull$$$0(83);
        }
        switch (shape) {
            case CIRCLE: {
                maskName = "circle";
                break;
            }
            case SQUARE: {
                maskName = "square";
                break;
            }
            case ROUNDED_SQUARE: {
                maskName = "rounded_corner";
                break;
            }
            case SQUIRCLE: {
                maskName = "squircle";
                break;
            }
            default: {
                maskName = null;
            }
        }
        if (maskName == null) {
            return null;
        }
        if (options.generateWebIcon) {
            String resourceName = String.format("/images/adaptive_icons_masks/adaptive_%s-%s.png", maskName, Density.XXXHIGH.getResourceValue());
            BufferedImage mask = context.loadImageResource(resourceName);
            if (mask == null) {
                return null;
            }
            Rectangle maskRect = new Rectangle(0, 0, mask.getWidth(), mask.getHeight());
            float scale = LauncherIconGenerator.getRectangleInsideScale(maskRect, LauncherIconGenerator.getViewportRectangle(options));
            return options.generatePreviewIcons ? LauncherIconGenerator.scaledPreviewImage(mask, scale) : LauncherIconGenerator.scaledImage(mask, scale);
        }
        String resourceName = String.format("/images/adaptive_icons_masks/adaptive_%s-%s.png", maskName, options.density.getResourceValue());
        return context.loadImageResource(resourceName);
    }

    @NotNull
    private static Rectangle getFullBleedRectangle(@NotNull LauncherIconOptions options) {
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(84);
        }
        if (options.generateWebIcon) {
            Rectangle rectangle = IMAGE_SIZE_FULL_BLEED_WEB_PX;
            if (rectangle == null) {
                LauncherIconGenerator.$$$reportNull$$$0(85);
            }
            return rectangle;
        }
        Rectangle rectangle = AssetStudioUtils.scaleRectangle(IMAGE_SIZE_FULL_BLEED_DP, LauncherIconGenerator.getMdpiScaleFactor(options.density));
        if (rectangle == null) {
            LauncherIconGenerator.$$$reportNull$$$0(86);
        }
        return rectangle;
    }

    @NotNull
    private static Rectangle getViewportRectangle(@NotNull LauncherIconOptions options) {
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(87);
        }
        if (options.generateWebIcon) {
            Rectangle rectangle = IMAGE_SIZE_VIEW_PORT_WEB_PX;
            if (rectangle == null) {
                LauncherIconGenerator.$$$reportNull$$$0(88);
            }
            return rectangle;
        }
        Rectangle rectangle = AssetStudioUtils.scaleRectangle(IMAGE_SIZE_VIEWPORT_DP, LauncherIconGenerator.getMdpiScaleFactor(options.density));
        if (rectangle == null) {
            LauncherIconGenerator.$$$reportNull$$$0(89);
        }
        return rectangle;
    }

    @NotNull
    private static Rectangle getLegacyRectangle(@NotNull LauncherIconOptions options) {
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(90);
        }
        if (options.generateWebIcon) {
            Rectangle rectangle = IMAGE_SIZE_VIEW_PORT_WEB_PX;
            if (rectangle == null) {
                LauncherIconGenerator.$$$reportNull$$$0(91);
            }
            return rectangle;
        }
        Rectangle rectangle = AssetStudioUtils.scaleRectangle(IMAGE_SIZE_LEGACY_DP, LauncherIconGenerator.getMdpiScaleFactor(options.density));
        if (rectangle == null) {
            LauncherIconGenerator.$$$reportNull$$$0(92);
        }
        return rectangle;
    }

    @NotNull
    private static BufferedImage generateIconBackgroundLayer(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options) {
        if (context == null) {
            LauncherIconGenerator.$$$reportNull$$$0(93);
        }
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(94);
        }
        if (options.usePlaceholders) {
            BufferedImage bufferedImage = PLACEHOLDER_IMAGE;
            if (bufferedImage == null) {
                LauncherIconGenerator.$$$reportNull$$$0(95);
            }
            return bufferedImage;
        }
        Rectangle imageRect = LauncherIconGenerator.getFullBleedRectangle(options);
        if (options.backgroundImage != null) {
            BufferedImage bufferedImage = LauncherIconGenerator.generateIconLayer(context, options.backgroundImage, imageRect, false, 0, !options.generateOutputIcons);
            if (bufferedImage == null) {
                LauncherIconGenerator.$$$reportNull$$$0(96);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = LauncherIconGenerator.generateFlatColorRectangle(new Color(options.backgroundColor), imageRect);
        if (bufferedImage == null) {
            LauncherIconGenerator.$$$reportNull$$$0(97);
        }
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage generateIconForegroundLayer(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options) {
        if (context == null) {
            LauncherIconGenerator.$$$reportNull$$$0(98);
        }
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(99);
        }
        if (options.usePlaceholders) {
            BufferedImage bufferedImage = PLACEHOLDER_IMAGE;
            if (bufferedImage == null) {
                LauncherIconGenerator.$$$reportNull$$$0(100);
            }
            return bufferedImage;
        }
        Rectangle imageRect = LauncherIconGenerator.getFullBleedRectangle(options);
        if (options.foregroundImage != null) {
            BufferedImage bufferedImage = LauncherIconGenerator.generateIconLayer(context, options.foregroundImage, imageRect, options.useForegroundColor, options.foregroundColor, !options.generateOutputIcons);
            if (bufferedImage == null) {
                LauncherIconGenerator.$$$reportNull$$$0(101);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        if (bufferedImage == null) {
            LauncherIconGenerator.$$$reportNull$$$0(102);
        }
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage generateFlatColorRectangle(@NotNull Color color, @NotNull Rectangle imageRect) {
        if (color == null) {
            LauncherIconGenerator.$$$reportNull$$$0(103);
        }
        if (imageRect == null) {
            LauncherIconGenerator.$$$reportNull$$$0(104);
        }
        BufferedImage result2 = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gTemp = (Graphics2D)result2.getGraphics();
        gTemp.setPaint(color);
        gTemp.fillRect(0, 0, imageRect.width, imageRect.height);
        gTemp.dispose();
        BufferedImage bufferedImage = result2;
        if (bufferedImage == null) {
            LauncherIconGenerator.$$$reportNull$$$0(105);
        }
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage applyMask(@NotNull BufferedImage image, @Nullable BufferedImage mask) {
        if (image == null) {
            LauncherIconGenerator.$$$reportNull$$$0(106);
        }
        if (mask == null) {
            BufferedImage bufferedImage = image;
            if (bufferedImage == null) {
                LauncherIconGenerator.$$$reportNull$$$0(107);
            }
            return bufferedImage;
        }
        Rectangle imageRect = new Rectangle(0, 0, image.getWidth(), image.getHeight());
        BufferedImage tempImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gTemp = (Graphics2D)tempImage.getGraphics();
        AssetUtil.drawCentered((Graphics2D)gTemp, (BufferedImage)mask, (Rectangle)imageRect);
        gTemp.setComposite(AlphaComposite.SrcIn);
        AssetUtil.drawCentered((Graphics2D)gTemp, (BufferedImage)image, (Rectangle)imageRect);
        gTemp.dispose();
        BufferedImage bufferedImage = tempImage;
        if (bufferedImage == null) {
            LauncherIconGenerator.$$$reportNull$$$0(108);
        }
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage generateIconLayer(@NotNull GraphicGeneratorContext context, @NotNull TransformedImageAsset sourceImage, @NotNull Rectangle imageRect, boolean useFillColor, int fillColor, boolean forPreview) {
        String scaledDrawable;
        if (context == null) {
            LauncherIconGenerator.$$$reportNull$$$0(109);
        }
        if (sourceImage == null) {
            LauncherIconGenerator.$$$reportNull$$$0(110);
        }
        if (imageRect == null) {
            LauncherIconGenerator.$$$reportNull$$$0(111);
        }
        if ((scaledDrawable = sourceImage.getTransformedDrawable()) != null) {
            BufferedImage bufferedImage = LauncherIconGenerator.generateIconLayer(context, scaledDrawable, imageRect);
            if (bufferedImage == null) {
                LauncherIconGenerator.$$$reportNull$$$0(112);
            }
            return bufferedImage;
        }
        BufferedImage trimmedImage = sourceImage.getTrimmedImage();
        if (trimmedImage != null) {
            BufferedImage bufferedImage = LauncherIconGenerator.generateIconLayer(context, trimmedImage, imageRect, sourceImage.getScaleFactor(), useFillColor, fillColor, forPreview);
            if (bufferedImage == null) {
                LauncherIconGenerator.$$$reportNull$$$0(113);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        if (bufferedImage == null) {
            LauncherIconGenerator.$$$reportNull$$$0(114);
        }
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage generateIconLayer(@NotNull GraphicGeneratorContext context, @NotNull String xmlDrawable, @NotNull Rectangle imageRect) {
        block7: {
            BufferedImage bufferedImage;
            if (context == null) {
                LauncherIconGenerator.$$$reportNull$$$0(115);
            }
            if (xmlDrawable == null) {
                LauncherIconGenerator.$$$reportNull$$$0(116);
            }
            if (imageRect == null) {
                LauncherIconGenerator.$$$reportNull$$$0(117);
            }
            ListenableFuture<BufferedImage> imageFuture = context.renderDrawable(xmlDrawable, imageRect.getSize());
            try {
                BufferedImage image = (BufferedImage)imageFuture.get();
                if (image == null) break block7;
                bufferedImage = image;
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
            if (bufferedImage == null) {
                LauncherIconGenerator.$$$reportNull$$$0(118);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        if (bufferedImage == null) {
            LauncherIconGenerator.$$$reportNull$$$0(119);
        }
        return bufferedImage;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static BufferedImage generateIconLayer(@NotNull GraphicGeneratorContext context, @NotNull BufferedImage sourceImage, @NotNull Rectangle imageRect, double scaleFactor, boolean useFillColor, int fillColor, boolean bl) {
        void forPreview;
        if (context == null) {
            LauncherIconGenerator.$$$reportNull$$$0(120);
        }
        if (sourceImage == null) {
            LauncherIconGenerator.$$$reportNull$$$0(121);
        }
        if (imageRect == null) {
            LauncherIconGenerator.$$$reportNull$$$0(122);
        }
        if (forPreview != false && (double)Math.max(sourceImage.getWidth(), sourceImage.getHeight()) > IMAGE_SIZE_FULL_BLEED_WEB_PX.getWidth() * 1.2) {
            sourceImage = LauncherIconGenerator.generateIconLayer(context, sourceImage, IMAGE_SIZE_FULL_BLEED_WEB_PX, 1.0, false, 0);
        }
        BufferedImage bufferedImage = LauncherIconGenerator.generateIconLayer(context, sourceImage, imageRect, scaleFactor, useFillColor, fillColor);
        if (bufferedImage == null) {
            LauncherIconGenerator.$$$reportNull$$$0(123);
        }
        return bufferedImage;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static BufferedImage generateIconLayer(@NotNull GraphicGeneratorContext context, @NotNull BufferedImage sourceImage, @NotNull Rectangle imageRect, double scaleFactor, boolean useFillColor, int n) {
        void fillColor;
        if (context == null) {
            LauncherIconGenerator.$$$reportNull$$$0(124);
        }
        if (sourceImage == null) {
            LauncherIconGenerator.$$$reportNull$$$0(125);
        }
        if (imageRect == null) {
            LauncherIconGenerator.$$$reportNull$$$0(126);
        }
        Callable<ListenableFuture> generator = () -> LauncherIconGenerator.lambda$generateIconLayer$17(imageRect, scaleFactor, sourceImage, useFillColor, (int)fillColor);
        class CacheKey {
            @NotNull
            private final Object mySource;
            @NotNull
            private final Rectangle myImageRect;
            private final int myScaleFactorTimes1000;
            private final boolean myUseFillColor;
            private final int myFillColor;

            /*
             * WARNING - void declaration
             */
            CacheKey(@NotNull Object source, @NotNull Rectangle imageRect, double scaleFactor, boolean useFillColor, int n) {
                void fillColor;
                if (source == null) {
                    CacheKey.$$$reportNull$$$0(0);
                }
                if (imageRect == null) {
                    CacheKey.$$$reportNull$$$0(1);
                }
                this.mySource = source;
                this.myImageRect = imageRect;
                this.myScaleFactorTimes1000 = AssetStudioUtils.roundToInt(scaleFactor * 1000.0);
                this.myUseFillColor = useFillColor;
                this.myFillColor = fillColor;
            }

            public int hashCode() {
                return Objects.hash(this.mySource, this.myImageRect, this.myScaleFactorTimes1000, this.myUseFillColor, this.myFillColor);
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof CacheKey)) {
                    return false;
                }
                CacheKey other = (CacheKey)obj;
                return Objects.equals(this.mySource, other.mySource) && Objects.equals(this.myImageRect, other.myImageRect) && this.myScaleFactorTimes1000 == other.myScaleFactorTimes1000 && this.myUseFillColor == other.myUseFillColor && this.myFillColor == other.myFillColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "imageRect";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/npw/assetstudio/LauncherIconGenerator$1CacheKey";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        CacheKey cacheKey = new CacheKey(sourceImage, imageRect, scaleFactor, useFillColor, (int)fillColor);
        ListenableFuture<BufferedImage> imageFuture = context.getFromCacheOrCreate(cacheKey, generator);
        BufferedImage bufferedImage = (BufferedImage)Futures.getUnchecked(imageFuture);
        if (bufferedImage == null) {
            LauncherIconGenerator.$$$reportNull$$$0(127);
        }
        return bufferedImage;
    }

    private static void drawGrid(@NotNull LauncherIconOptions launcherIconOptions, @NotNull BufferedImage image) {
        if (launcherIconOptions == null) {
            LauncherIconGenerator.$$$reportNull$$$0(128);
        }
        if (image == null) {
            LauncherIconGenerator.$$$reportNull$$$0(129);
        }
        Graphics2D gOut = (Graphics2D)image.getGraphics();
        LauncherIconGenerator.drawGrid(launcherIconOptions, gOut);
        gOut.dispose();
    }

    private static void drawGrid(@NotNull LauncherIconOptions launcherIconOptions, @NotNull Graphics2D gOut) {
        if (launcherIconOptions == null) {
            LauncherIconGenerator.$$$reportNull$$$0(130);
        }
        if (gOut == null) {
            LauncherIconGenerator.$$$reportNull$$$0(131);
        }
        if (launcherIconOptions.generateWebIcon) {
            return;
        }
        if (launcherIconOptions.previewShape == PreviewShape.FULL_BLEED) {
            if (launcherIconOptions.showGrid || launcherIconOptions.showSafeZone) {
                LauncherIconGenerator.drawFullBleedIconGrid(launcherIconOptions, gOut);
            }
            return;
        }
        if (launcherIconOptions.previewShape == PreviewShape.LEGACY || launcherIconOptions.previewShape == PreviewShape.LEGACY_ROUND) {
            if (launcherIconOptions.showGrid) {
                LauncherIconGenerator.drawLegacyIconGrid(launcherIconOptions, gOut);
            }
            return;
        }
        if (launcherIconOptions.showGrid || launcherIconOptions.showSafeZone) {
            LauncherIconGenerator.drawAdaptiveIconGrid(launcherIconOptions, gOut);
        }
    }

    private static void drawAdaptiveIconGrid(@NotNull LauncherIconOptions options, @NotNull Graphics2D out) {
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(132);
        }
        if (out == null) {
            LauncherIconGenerator.$$$reportNull$$$0(133);
        }
        double scaleFactor = LauncherIconGenerator.getMdpiScaleFactor(options.density);
        int size = LauncherIconGenerator.IMAGE_SIZE_VIEWPORT_DP.width;
        int center = size / 2;
        Color c = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        out.setColor(c);
        out.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PrimitiveShapesHelper g = new PrimitiveShapesHelper(out, scaleFactor);
        if (options.showGrid) {
            g.drawRect(0, 0, size, size);
            g.drawLine(0, 0, size, size);
            g.drawLine(size, 0, 0, size);
            g.drawLine(0, center, size, center);
            g.drawLine(center, 0, center, size);
            int arcSize = 4;
            int rect1 = 36;
            int rect2 = 44;
            int rect3 = 52;
            g.drawRoundRect((size - rect1) / 2, (size - rect3) / 2, rect1, rect3, arcSize, arcSize);
            g.drawRoundRect((size - rect2) / 2, (size - rect2) / 2, rect2, rect2, arcSize, arcSize);
            g.drawRoundRect((size - rect3) / 2, (size - rect1) / 2, rect3, rect1, arcSize, arcSize);
            g.drawCenteredCircle(center, center, 18);
            g.drawCenteredCircle(center, center, 26);
        }
        if (options.showSafeZone) {
            g.drawCenteredCircle(center, center, 33);
        }
    }

    private static void drawFullBleedIconGrid(@NotNull LauncherIconOptions options, @NotNull Graphics2D out) {
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(134);
        }
        if (out == null) {
            LauncherIconGenerator.$$$reportNull$$$0(135);
        }
        double scaleFactor = LauncherIconGenerator.getMdpiScaleFactor(options.density);
        int size = LauncherIconGenerator.IMAGE_SIZE_FULL_BLEED_DP.width;
        int center = size / 2;
        Color c = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        out.setColor(c);
        out.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PrimitiveShapesHelper g = new PrimitiveShapesHelper(out, scaleFactor);
        if (options.showGrid) {
            g.drawRect(0, 0, size, size);
            g.drawRect(18, 18, LauncherIconGenerator.IMAGE_SIZE_VIEWPORT_DP.width, LauncherIconGenerator.IMAGE_SIZE_VIEWPORT_DP.height);
            g.drawLine(0, 0, size, size);
            g.drawLine(size, 0, 0, size);
            g.drawLine(0, center, size, center);
            g.drawLine(center, 0, center, size);
        }
        if (options.showSafeZone) {
            g.drawCenteredCircle(center, center, LauncherIconGenerator.IMAGE_SIZE_SAFE_ZONE_DP.width / 2);
        }
    }

    private static void drawLegacyIconGrid(@NotNull LauncherIconOptions options, @NotNull Graphics2D out) {
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(136);
        }
        if (out == null) {
            LauncherIconGenerator.$$$reportNull$$$0(137);
        }
        double scaleFactor = LauncherIconGenerator.getMdpiScaleFactor(options.density);
        int size = LauncherIconGenerator.IMAGE_SIZE_LEGACY_DP.width;
        int center = size / 2;
        Color c = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        out.setColor(c);
        out.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PrimitiveShapesHelper g = new PrimitiveShapesHelper(out, scaleFactor);
        g.drawRect(0, 0, size, size);
        g.drawLine(0, 0, size, size);
        g.drawLine(size, 0, 0, size);
        g.drawLine(0, center, size, center);
        g.drawLine(center, 0, center, size);
        int arcSize = 3;
        int rect1 = 32;
        int rect3 = 44;
        g.drawRoundRect((size - rect1) / 2, (size - rect3) / 2, rect1, rect3, arcSize, arcSize);
        g.drawRoundRect((size - rect3) / 2, (size - rect1) / 2, rect3, rect1, arcSize, arcSize);
        g.drawCenteredCircle(center, center, 10);
        g.drawCenteredCircle(center, center, 22);
    }

    @Override
    protected boolean includeDensity(@NotNull Density density) {
        if (density == null) {
            LauncherIconGenerator.$$$reportNull$$$0(138);
        }
        return super.includeDensity(density) || density == Density.XXXHIGH;
    }

    @Override
    @NotNull
    protected String getIconPath(@NotNull IconGenerator.Options options, @NotNull String iconName) {
        if (options == null) {
            LauncherIconGenerator.$$$reportNull$$$0(139);
        }
        if (iconName == null) {
            LauncherIconGenerator.$$$reportNull$$$0(140);
        }
        if (((LauncherIconOptions)options).generateWebIcon) {
            String string = iconName + "-web.png";
            if (string == null) {
                LauncherIconGenerator.$$$reportNull$$$0(141);
            }
            return string;
        }
        String string = super.getIconPath(options, iconName);
        if (string == null) {
            LauncherIconGenerator.$$$reportNull$$$0(142);
        }
        return string;
    }

    private static /* synthetic */ ListenableFuture lambda$generateIconLayer$17(Rectangle imageRect, double scaleFactor, BufferedImage sourceImage, boolean useFillColor, int fillColor) throws Exception {
        return FutureUtils.executeOnPooledThread(() -> {
            BufferedImage iconImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
            Graphics2D gIcon = (Graphics2D)iconImage.getGraphics();
            Rectangle rect = AssetStudioUtils.scaleRectangleAroundCenter(imageRect, scaleFactor);
            AssetUtil.drawCenterInside((Graphics2D)gIcon, (BufferedImage)sourceImage, (Rectangle)rect);
            gIcon.dispose();
            if (!useFillColor) {
                return iconImage;
            }
            BufferedImage effectImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
            Graphics2D gEffect = (Graphics2D)effectImage.getGraphics();
            AssetUtil.Effect[] effects = new AssetUtil.Effect[]{new AssetUtil.FillEffect((Paint)new Color(fillColor), 1.0)};
            AssetUtil.drawEffects((Graphics2D)gEffect, (BufferedImage)iconImage, (int)0, (int)0, (AssetUtil.Effect[])effects);
            gEffect.dispose();
            return effectImage;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 33: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 57: 
            case 61: 
            case 63: 
            case 65: 
            case 66: 
            case 69: 
            case 75: 
            case 77: 
            case 80: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 95: 
            case 96: 
            case 97: 
            case 100: 
            case 101: 
            case 102: 
            case 105: 
            case 107: 
            case 108: 
            case 112: 
            case 113: 
            case 114: 
            case 118: 
            case 119: 
            case 123: 
            case 127: 
            case 141: 
            case 142: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 33: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 57: 
            case 61: 
            case 63: 
            case 65: 
            case 66: 
            case 69: 
            case 75: 
            case 77: 
            case 80: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 95: 
            case 96: 
            case 97: 
            case 100: 
            case 101: 
            case 102: 
            case 105: 
            case 107: 
            case 108: 
            case 112: 
            case 113: 
            case 114: 
            case 118: 
            case 119: 
            case 123: 
            case 127: 
            case 141: 
            case 142: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 33: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 57: 
            case 61: 
            case 63: 
            case 65: 
            case 66: 
            case 69: 
            case 75: 
            case 77: 
            case 80: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 95: 
            case 96: 
            case 97: 
            case 100: 
            case 101: 
            case 102: 
            case 105: 
            case 107: 
            case 108: 
            case 112: 
            case 113: 
            case 114: 
            case 118: 
            case 119: 
            case 123: 
            case 127: 
            case 141: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/LauncherIconGenerator";
                break;
            }
            case 16: 
            case 20: 
            case 24: 
            case 34: 
            case 38: 
            case 41: 
            case 45: 
            case 52: 
            case 55: 
            case 67: 
            case 78: 
            case 81: 
            case 93: 
            case 98: 
            case 109: 
            case 115: 
            case 120: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 17: 
            case 22: 
            case 26: 
            case 30: 
            case 32: 
            case 35: 
            case 39: 
            case 42: 
            case 46: 
            case 53: 
            case 56: 
            case 68: 
            case 70: 
            case 79: 
            case 82: 
            case 84: 
            case 87: 
            case 90: 
            case 94: 
            case 99: 
            case 132: 
            case 134: 
            case 136: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 18: 
            case 21: 
            case 25: 
            case 29: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 23: 
            case 28: 
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 27: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "density";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "categoryMap";
                break;
            }
            case 58: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 60: 
            case 62: 
            case 71: 
            case 72: 
            case 106: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRect";
                break;
            }
            case 74: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layers";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shape";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 104: 
            case 111: 
            case 117: 
            case 122: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageRect";
                break;
            }
            case 110: 
            case 121: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceImage";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlDrawable";
                break;
            }
            case 128: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcherIconOptions";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gOut";
                break;
            }
            case 133: 
            case 135: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/LauncherIconGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "useForegroundColor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "foregroundColor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "backgroundColor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generateLegacyIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generateRoundIcon";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "generateWebIcon";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "legacyIconShape";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "webIconShape";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "backgroundImageAsset";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "showGrid";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "showSafeZone";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "previewDensity";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "foregroundLayerName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "backgroundLayerName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptions";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createIconGenerationTasks";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdaptiveIconXml";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "generateRasterImage";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreviewImage";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "generateFullBleedPreviewImage";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "generateLegacyImage";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "scaledImage";
                break;
            }
            case 63: 
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "scaledPreviewImage";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "generateViewportPreviewImage";
                break;
            }
            case 75: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeLayers";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIconLayers";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullBleedRectangle";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewportRectangle";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getLegacyRectangle";
                break;
            }
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIconBackgroundLayer";
                break;
            }
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIconForegroundLayer";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "generateFlatColorRectangle";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "applyMask";
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 118: 
            case 119: 
            case 123: 
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIconLayer";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 33: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 57: 
            case 61: 
            case 63: 
            case 65: 
            case 66: 
            case 69: 
            case 75: 
            case 77: 
            case 80: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 95: 
            case 96: 
            case 97: 
            case 100: 
            case 101: 
            case 102: 
            case 105: 
            case 107: 
            case 108: 
            case 112: 
            case 113: 
            case 114: 
            case 118: 
            case 119: 
            case 123: 
            case 127: 
            case 141: 
            case 142: {
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createIconGenerationTasks";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createOutputIconsTasks";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createOutputIconsForSingleDensityTasks";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createXmlDrawableResourcesTasks";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getAdaptiveIconXml";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createPreviewImagesTasks";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "generateRasterImage";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "generatePreviewImage";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "generateFullBleedPreviewImage";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "generateLegacyImage";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getRectangleInsideScale";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "scaledImage";
                break;
            }
            case 62: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "scaledPreviewImage";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "generateViewportPreviewImage";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "cropImageToViewport";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "cropImage";
                break;
            }
            case 74: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "mergeLayers";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "generateIconLayers";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "generateMaskLayer";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getFullBleedRectangle";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getViewportRectangle";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getLegacyRectangle";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "generateIconBackgroundLayer";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "generateIconForegroundLayer";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "generateFlatColorRectangle";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "applyMask";
                break;
            }
            case 109: 
            case 110: 
            case 111: 
            case 115: 
            case 116: 
            case 117: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "generateIconLayer";
                break;
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "drawGrid";
                break;
            }
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "drawAdaptiveIconGrid";
                break;
            }
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "drawFullBleedIconGrid";
                break;
            }
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "drawLegacyIconGrid";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "includeDensity";
                break;
            }
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "getIconPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 33: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 57: 
            case 61: 
            case 63: 
            case 65: 
            case 66: 
            case 69: 
            case 75: 
            case 77: 
            case 80: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 95: 
            case 96: 
            case 97: 
            case 100: 
            case 101: 
            case 102: 
            case 105: 
            case 107: 
            case 108: 
            case 112: 
            case 113: 
            case 114: 
            case 118: 
            case 119: 
            case 123: 
            case 127: 
            case 141: 
            case 142: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Layers {
        @NotNull
        public BufferedImage background;
        @NotNull
        public BufferedImage foreground;

        public Layers(@NotNull BufferedImage background, @NotNull BufferedImage foreground) {
            if (background == null) {
                Layers.$$$reportNull$$$0(0);
            }
            if (foreground == null) {
                Layers.$$$reportNull$$$0(1);
            }
            this.background = background;
            this.foreground = foreground;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "background";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "foreground";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/npw/assetstudio/LauncherIconGenerator$Layers";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum PreviewShape {
        NONE("none", "none"),
        CIRCLE("circle", "Circle"),
        SQUIRCLE("squircle", "Squircle"),
        ROUNDED_SQUARE("rounded-square", "Rounded Square"),
        SQUARE("square", "Square"),
        FULL_BLEED("full-bleed-layers", "Full Bleed Layers"),
        LEGACY("legacy", "Legacy Icon"),
        LEGACY_ROUND("legacy-round", "Round Icon"),
        WEB("web", "Google Play Store");

        public final String id;
        public final String displayName;

        private PreviewShape(String id, String displayName) {
            this.id = id;
            this.displayName = displayName;
        }
    }

    public static class LauncherIconOptions
    extends IconGenerator.Options
    implements Cloneable {
        public String foregroundLayerName;
        public String backgroundLayerName;
        public boolean useForegroundColor = true;
        public int foregroundColor = 0;
        @Nullable
        public TransformedImageAsset foregroundImage;
        public int backgroundColor = 0;
        @Nullable
        public TransformedImageAsset backgroundImage;
        public boolean generateLegacyIcon = true;
        public boolean generateRoundIcon = true;
        public boolean generateWebIcon;
        public PreviewShape previewShape = PreviewShape.NONE;
        public Density previewDensity;
        public IconGenerator.Shape legacyIconShape = IconGenerator.Shape.SQUARE;
        public IconGenerator.Shape webIconShape = IconGenerator.Shape.SQUARE;
        public boolean showGrid;
        public boolean showSafeZone;

        public LauncherIconOptions(boolean forPreview) {
            super(forPreview);
            this.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
        }

        @Override
        @NotNull
        public LauncherIconOptions clone() {
            LauncherIconOptions launcherIconOptions = (LauncherIconOptions)super.clone();
            if (launcherIconOptions == null) {
                LauncherIconOptions.$$$reportNull$$$0(0);
            }
            return launcherIconOptions;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/LauncherIconGenerator$LauncherIconOptions", "clone"));
        }
    }
}

