/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.tools.idea.npw.assetstudio.DrawableRenderer;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.TransformedImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.intellij.openapi.project.Project;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionBarIconGenerator
extends IconGenerator {
    public static final Theme DEFAULT_THEME = Theme.HOLO_LIGHT;
    public static final Color DEFAULT_CUSTOM_COLOR = new Color(3388901);
    private static final Color HOLO_LIGHT_COLOR = new Color(0x333333);
    private static final Color HOLO_DARK_COLOR = new Color(0xFFFFFF);
    private static final Dimension ICON_SIZE = new Dimension(24, 24);
    private final ObjectProperty<Theme> myTheme;
    private final ObjectProperty<Color> myCustomColor;

    public ActionBarIconGenerator(@NotNull Project project, int minSdkVersion2, @Nullable DrawableRenderer renderer) {
        if (project == null) {
            ActionBarIconGenerator.$$$reportNull$$$0(0);
        }
        super(project, minSdkVersion2, new GraphicGeneratorContext(40, renderer));
        this.myTheme = new ObjectValueProperty<Theme>(DEFAULT_THEME);
        this.myCustomColor = new ObjectValueProperty<Color>(DEFAULT_CUSTOM_COLOR);
    }

    @NotNull
    public ObjectProperty<Theme> theme() {
        ObjectProperty<Theme> objectProperty = this.myTheme;
        if (objectProperty == null) {
            ActionBarIconGenerator.$$$reportNull$$$0(1);
        }
        return objectProperty;
    }

    @NotNull
    public ObjectProperty<Color> customColor() {
        ObjectProperty<Color> objectProperty = this.myCustomColor;
        if (objectProperty == null) {
            ActionBarIconGenerator.$$$reportNull$$$0(2);
        }
        return objectProperty;
    }

    @Override
    @NotNull
    public IconGenerator.Options createOptions(boolean forPreview) {
        IconGenerator.Options options = new IconGenerator.Options(forPreview);
        BaseAsset asset = this.sourceAsset().getValueOrNull();
        if (asset != null) {
            double opacity;
            Color color;
            double paddingFactor = (double)((Integer)asset.paddingPercent().get()).intValue() / 100.0;
            double scaleFactor = 1.0 / (1.0 + paddingFactor * 2.0);
            switch ((Theme)((Object)this.myTheme.get())) {
                case HOLO_DARK: {
                    color = HOLO_DARK_COLOR;
                    opacity = 0.8;
                    break;
                }
                case HOLO_LIGHT: {
                    color = HOLO_LIGHT_COLOR;
                    opacity = 0.6;
                    break;
                }
                case CUSTOM: {
                    color = (Color)this.myCustomColor.get();
                    opacity = 0.8;
                    break;
                }
                default: {
                    color = null;
                    opacity = 1.0;
                }
            }
            options.image = new TransformedImageAsset(asset, ICON_SIZE, scaleFactor, color, opacity, this.getGraphicGeneratorContext());
        }
        IconGenerator.Options options2 = options;
        if (options2 == null) {
            ActionBarIconGenerator.$$$reportNull$$$0(3);
        }
        return options2;
    }

    @Override
    @NotNull
    public BufferedImage generateRasterImage(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.Options options) {
        if (context == null) {
            ActionBarIconGenerator.$$$reportNull$$$0(4);
        }
        if (options == null) {
            ActionBarIconGenerator.$$$reportNull$$$0(5);
        }
        BufferedImage bufferedImage = this.generateRasterImage(ICON_SIZE, options);
        if (bufferedImage == null) {
            ActionBarIconGenerator.$$$reportNull$$$0(6);
        }
        return bufferedImage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/ActionBarIconGenerator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/ActionBarIconGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "theme";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "customColor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "generateRasterImage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generateRasterImage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Theme {
        HOLO_DARK,
        HOLO_LIGHT,
        CUSTOM;

    }
}

