/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.other;

import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.other.NonAndroidSourceType;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonAndroidSourceTypeNode
extends ProjectViewNode<Module>
implements FolderGroupNode {
    private final NonAndroidSourceType mySourceType;

    NonAndroidSourceTypeNode(@NotNull Project project, @NotNull Module module, @NotNull ViewSettings settings, @NotNull NonAndroidSourceType type) {
        if (project == null) {
            NonAndroidSourceTypeNode.$$$reportNull$$$0(0);
        }
        if (module == null) {
            NonAndroidSourceTypeNode.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            NonAndroidSourceTypeNode.$$$reportNull$$$0(2);
        }
        if (type == null) {
            NonAndroidSourceTypeNode.$$$reportNull$$$0(3);
        }
        super(project, (Object)module, settings);
        this.mySourceType = type;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        List<VirtualFile> sourceFolders = this.getSourceFolders();
        ArrayList children = new ArrayList(sourceFolders.size());
        assert (this.myProject != null);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ProjectViewDirectoryHelper directoryHelper = ProjectViewDirectoryHelper.getInstance((Project)this.myProject);
        for (VirtualFile file : sourceFolders) {
            PsiDirectory dir = psiManager.findDirectory(file);
            if (dir == null) continue;
            children.addAll(directoryHelper.getDirectoryChildren(dir, this.getSettings(), true));
        }
        ArrayList arrayList = children;
        if (arrayList == null) {
            NonAndroidSourceTypeNode.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private List<VirtualFile> getSourceFolders() {
        ContentEntry[] contentEntries;
        Module module = this.getModule();
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        ArrayList<VirtualFile> folders = new ArrayList<VirtualFile>();
        for (ContentEntry entry : contentEntries = rootManager.getContentEntries()) {
            List sources = entry.getSourceFolders(this.mySourceType.rootType);
            for (SourceFolder folder : sources) {
                VirtualFile file = folder.getFile();
                if (file == null) continue;
                folders.add(file);
            }
        }
        ArrayList<VirtualFile> arrayList = folders;
        if (arrayList == null) {
            NonAndroidSourceTypeNode.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private Module getModule() {
        Module module = (Module)this.getValue();
        assert (module != null);
        Module module2 = module;
        if (module2 == null) {
            NonAndroidSourceTypeNode.$$$reportNull$$$0(6);
        }
        return module2;
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            NonAndroidSourceTypeNode.$$$reportNull$$$0(7);
        }
        presentation.addText(this.mySourceType.presentableName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.setPresentableText(this.mySourceType.presentableName);
        presentation.setIcon(this.mySourceType.icon);
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            NonAndroidSourceTypeNode.$$$reportNull$$$0(8);
        }
        for (VirtualFile folder : this.getSourceFolders()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)folder, (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Comparable getSortKey() {
        return this.mySourceType;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.mySourceType;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.mySourceType.presentableName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NonAndroidSourceTypeNode that = (NonAndroidSourceTypeNode)o;
        return this.mySourceType == that.mySourceType;
    }

    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.mySourceType.hashCode();
        return result2;
    }

    @Override
    @NotNull
    public PsiDirectory[] getFolders() {
        assert (this.myProject != null);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        List<VirtualFile> sourceFolders = this.getSourceFolders();
        ArrayList<PsiDirectory> folders = new ArrayList<PsiDirectory>(sourceFolders.size());
        for (VirtualFile f : sourceFolders) {
            PsiDirectory dir = psiManager.findDirectory(f);
            if (dir == null) continue;
            folders.add(dir);
        }
        PsiDirectory[] psiDirectoryArray = folders.toArray(PsiDirectory.EMPTY_ARRAY);
        if (psiDirectoryArray == null) {
            NonAndroidSourceTypeNode.$$$reportNull$$$0(9);
        }
        return psiDirectoryArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/other/NonAndroidSourceTypeNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/other/NonAndroidSourceTypeNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFolders";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFolders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

