/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.model;

import com.android.tools.idea.navigator.nodes.ndk.includes.model.ClassifiedIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.IncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.PackageKey;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.PackageType;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.SimpleIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.LexicalIncludePaths;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class PackageValue
extends ClassifiedIncludeValue {
    @NotNull
    public final PackageKey myKey;
    @NotNull
    public final ImmutableList<SimpleIncludeValue> myIncludes;
    @NotNull
    private final String myCommonRelativeFolder;

    public PackageValue(@NotNull PackageKey key, @NotNull Collection<SimpleIncludeValue> simpleIncludeValues) {
        if (key == null) {
            PackageValue.$$$reportNull$$$0(0);
        }
        if (simpleIncludeValues == null) {
            PackageValue.$$$reportNull$$$0(1);
        }
        this.myKey = key;
        this.myIncludes = ImmutableList.copyOf(simpleIncludeValues);
        this.myCommonRelativeFolder = LexicalIncludePaths.findCommonParentFolder(simpleIncludeValues.stream().map(expression -> expression.myRelativeIncludeSubFolder).collect(Collectors.toList()));
    }

    public String toString() {
        return String.format("%s (%s, %s)", this.myKey.mySimplePackageName, this.myKey.myPackageType.myDescription, this.getDescriptiveText());
    }

    @NotNull
    public String getDescriptiveText() {
        String commonRelativeFolderWithNoSlashes = LexicalIncludePaths.trimPathSeparators(this.myCommonRelativeFolder);
        if (commonRelativeFolderWithNoSlashes.isEmpty()) {
            String string = String.format("%s include paths", this.myIncludes.size());
            if (string == null) {
                PackageValue.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = String.format("%s", commonRelativeFolderWithNoSlashes);
        if (string == null) {
            PackageValue.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getSimplePackageName() {
        String string = this.myKey.mySimplePackageName;
        if (string == null) {
            PackageValue.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public String getSortKey() {
        String string = IncludeValue.SortOrderKey.PACKAGING.myKey + this.toString();
        if (string == null) {
            PackageValue.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public PackageType getPackageType() {
        PackageType packageType = this.myKey.myPackageType;
        if (packageType == null) {
            PackageValue.$$$reportNull$$$0(6);
        }
        return packageType;
    }

    @Override
    @NotNull
    public File getPackageFamilyBaseFolder() {
        File file = this.myKey.myPackagingFamilyBaseFolder;
        if (file == null) {
            PackageValue.$$$reportNull$$$0(7);
        }
        return file;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageValue)) {
            return false;
        }
        PackageValue that = (PackageValue)obj;
        return Objects.equals(this.myCommonRelativeFolder, that.myCommonRelativeFolder) && Objects.equals(this.myIncludes, that.myIncludes) && Objects.equals(this.myKey, that.myKey);
    }

    public int hashCode() {
        return Objects.hash(this.myCommonRelativeFolder, this.myIncludes, this.myKey);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simpleIncludeValues";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/ndk/includes/model/PackageValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/ndk/includes/model/PackageValue";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptiveText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimplePackageName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortKey";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageFamilyBaseFolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

