/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.model;

import com.android.tools.idea.navigator.nodes.ndk.includes.model.ClassifiedIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.IncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.PackageFamilyKey;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.PackageFamilyValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.PackageKey;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.PackageValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.ShadowingIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.SimpleIncludeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class IncludeValues {
    @NotNull
    private static final Comparator<IncludeValue> COMPARE_NATIVE_DEPENDENCY = Comparator.comparing(IncludeValue::getSortKey);

    @NotNull
    public static List<IncludeValue> organize(@NotNull List<SimpleIncludeValue> simpleIncludes) {
        if (simpleIncludes == null) {
            IncludeValues.$$$reportNull$$$0(0);
        }
        List<ClassifiedIncludeValue> simplifiedPackages = IncludeValues.simplifyPackageWithSingleIncludeFolder(IncludeValues.convertGroupsToPackage(IncludeValues.groupByPackageKey(simpleIncludes)));
        Collections.sort(simplifiedPackages, COMPARE_NATIVE_DEPENDENCY);
        List<ClassifiedIncludeValue> simplifiedFamilies = IncludeValues.simplifyPackageFamilyWithSinglePackage(IncludeValues.convertGroupsToPackageFamily(IncludeValues.groupByPackageFamilyKey(simplifiedPackages)));
        Collections.sort(simplifiedFamilies, COMPARE_NATIVE_DEPENDENCY);
        List<IncludeValue> result2 = IncludeValues.groupTopLevelIncludesIntoShadowExpression(simplifiedFamilies);
        Collections.sort(result2, COMPARE_NATIVE_DEPENDENCY);
        List<IncludeValue> list = result2;
        if (list == null) {
            IncludeValues.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    private static Map<PackageKey, List<SimpleIncludeValue>> groupByPackageKey(@NotNull List<SimpleIncludeValue> includes) {
        if (includes == null) {
            IncludeValues.$$$reportNull$$$0(2);
        }
        Map<PackageKey, List<SimpleIncludeValue>> map2 = includes.stream().collect(Collectors.groupingBy(IncludeValues::toPackageKey, Collectors.toList()));
        if (map2 == null) {
            IncludeValues.$$$reportNull$$$0(3);
        }
        return map2;
    }

    @NotNull
    private static List<PackageValue> convertGroupsToPackage(@NotNull Map<PackageKey, List<SimpleIncludeValue>> groupsByPackingExpressionKey) {
        if (groupsByPackingExpressionKey == null) {
            IncludeValues.$$$reportNull$$$0(4);
        }
        List<PackageValue> list = groupsByPackingExpressionKey.entrySet().stream().map(entry -> new PackageValue((PackageKey)entry.getKey(), (Collection)entry.getValue())).collect(Collectors.toList());
        if (list == null) {
            IncludeValues.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private static List<ClassifiedIncludeValue> simplifyPackageWithSingleIncludeFolder(List<PackageValue> includes) {
        List<ClassifiedIncludeValue> list = includes.stream().map(expression -> expression.myIncludes.size() == 1 ? (ClassifiedIncludeValue)expression.myIncludes.get(0) : expression).collect(Collectors.toList());
        if (list == null) {
            IncludeValues.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private static Map<PackageFamilyKey, List<ClassifiedIncludeValue>> groupByPackageFamilyKey(@NotNull List<ClassifiedIncludeValue> includes) {
        if (includes == null) {
            IncludeValues.$$$reportNull$$$0(7);
        }
        Map<PackageFamilyKey, List<ClassifiedIncludeValue>> map2 = includes.stream().collect(Collectors.groupingBy(IncludeValues::toPackageFamilyKey, Collectors.toList()));
        if (map2 == null) {
            IncludeValues.$$$reportNull$$$0(8);
        }
        return map2;
    }

    @NotNull
    private static List<PackageFamilyValue> convertGroupsToPackageFamily(@NotNull Map<PackageFamilyKey, List<ClassifiedIncludeValue>> groups) {
        if (groups == null) {
            IncludeValues.$$$reportNull$$$0(9);
        }
        List<PackageFamilyValue> list = groups.entrySet().stream().map(entry -> new PackageFamilyValue((PackageFamilyKey)entry.getKey(), (Collection)entry.getValue())).collect(Collectors.toList());
        if (list == null) {
            IncludeValues.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static List<ClassifiedIncludeValue> simplifyPackageFamilyWithSinglePackage(List<PackageFamilyValue> families) {
        return families.stream().map(family -> family.myIncludes.size() == 1 ? (ClassifiedIncludeValue)family.myIncludes.get(0) : family).collect(Collectors.toList());
    }

    private static PackageKey toPackageKey(@NotNull SimpleIncludeValue include) {
        if (include == null) {
            IncludeValues.$$$reportNull$$$0(11);
        }
        return new PackageKey(include.getPackageType(), include.mySimplePackageName, include.getPackageFamilyBaseFolder());
    }

    private static PackageFamilyKey toPackageFamilyKey(@NotNull ClassifiedIncludeValue include) {
        if (include == null) {
            IncludeValues.$$$reportNull$$$0(12);
        }
        return new PackageFamilyKey(include.getPackageType(), include.getPackageFamilyBaseFolder());
    }

    @NotNull
    public static List<IncludeValue> groupTopLevelIncludesIntoShadowExpression(@NotNull List<ClassifiedIncludeValue> includes) {
        if (includes == null) {
            IncludeValues.$$$reportNull$$$0(13);
        }
        ArrayList<IncludeValue> result2 = new ArrayList<IncludeValue>();
        ArrayList<SimpleIncludeValue> simpleIncludeValues = new ArrayList<SimpleIncludeValue>();
        HashSet<String> excludes = new HashSet<String>();
        for (ClassifiedIncludeValue child : includes) {
            if (child instanceof SimpleIncludeValue) {
                simpleIncludeValues.add((SimpleIncludeValue)child);
                continue;
            }
            excludes.add(child.getPackageFamilyBaseFolder().getPath());
            result2.add(child);
        }
        if (!simpleIncludeValues.isEmpty()) {
            result2.add(new ShadowingIncludeValue(simpleIncludeValues, excludes));
        }
        ArrayList<IncludeValue> arrayList = result2;
        if (arrayList == null) {
            IncludeValues.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simpleIncludes";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/ndk/includes/model/IncludeValues";
                break;
            }
            case 2: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupsByPackingExpressionKey";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "include";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/ndk/includes/model/IncludeValues";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "organize";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "groupByPackageKey";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convertGroupsToPackage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "simplifyPackageWithSingleIncludeFolder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "groupByPackageFamilyKey";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "convertGroupsToPackageFamily";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "groupTopLevelIncludesIntoShadowExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "organize";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 14: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "groupByPackageKey";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertGroupsToPackage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "groupByPackageFamilyKey";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "convertGroupsToPackageFamily";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "toPackageKey";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "toPackageFamilyKey";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "groupTopLevelIncludesIntoShadowExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

