/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk;

import com.android.tools.idea.flags.StudioFlags;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class NdkSourceFolderNode
extends PsiDirectoryNode {
    @NotNull
    private final Collection<String> myFileExtensions;
    @NotNull
    private final Collection<VirtualFile> mySourceFolders;
    @NotNull
    private final Collection<VirtualFile> mySourceFiles;
    private boolean myShowFolderPath;

    public NdkSourceFolderNode(@NotNull Project project, @NotNull PsiDirectory folder, @NotNull ViewSettings settings, @NotNull Collection<String> fileExtensions, @NotNull Collection<VirtualFile> sourceFolders, @NotNull Collection<VirtualFile> sourceFiles) {
        if (project == null) {
            NdkSourceFolderNode.$$$reportNull$$$0(0);
        }
        if (folder == null) {
            NdkSourceFolderNode.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            NdkSourceFolderNode.$$$reportNull$$$0(2);
        }
        if (fileExtensions == null) {
            NdkSourceFolderNode.$$$reportNull$$$0(3);
        }
        if (sourceFolders == null) {
            NdkSourceFolderNode.$$$reportNull$$$0(4);
        }
        if (sourceFiles == null) {
            NdkSourceFolderNode.$$$reportNull$$$0(5);
        }
        super(project, folder, settings);
        this.myFileExtensions = fileExtensions;
        this.mySourceFolders = sourceFolders;
        this.mySourceFiles = sourceFiles;
    }

    protected boolean shouldShowModuleName() {
        return false;
    }

    protected boolean shouldShowSourcesRoot() {
        return false;
    }

    protected void updateImpl(@NotNull PresentationData presentation) {
        if (presentation == null) {
            NdkSourceFolderNode.$$$reportNull$$$0(6);
        }
        VirtualFile folder = this.getVirtualFile();
        assert (folder != null);
        presentation.setPresentableText(folder.getName());
        presentation.addText(folder.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.myShowFolderPath) {
            String text = String.format(" (%1$s)", FileUtil.getLocationRelativeToUserHome((String)folder.getPresentableUrl()));
            presentation.addText(text, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        presentation.setIcon(AllIcons.Nodes.Folder);
    }

    public Collection<AbstractTreeNode> getChildrenImpl() {
        PsiDirectory folder = (PsiDirectory)this.getValue();
        if (folder == null) {
            return Collections.emptyList();
        }
        Collection folderChildren = ProjectViewDirectoryHelper.getInstance((Project)this.myProject).getDirectoryChildren(folder, this.getSettings(), true);
        if (((Boolean)StudioFlags.ENABLE_ENHANCED_NATIVE_HEADER_SUPPORT.get()).booleanValue()) {
            return folderChildren;
        }
        ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>();
        for (AbstractTreeNode child : folderChildren) {
            Object value2 = child.getValue();
            if (value2 instanceof PsiFile) {
                VirtualFile file = ((PsiFile)value2).getVirtualFile();
                if ((!this.mySourceFolders.contains(folder.getVirtualFile()) || !this.myFileExtensions.contains(file.getExtension())) && !this.mySourceFiles.contains(file)) continue;
                result2.add(child);
                continue;
            }
            if (!(value2 instanceof PsiDirectory)) continue;
            VirtualFile childFolder = ((PsiDirectory)value2).getVirtualFile();
            Project project = this.getNotNullProject();
            if (this.mySourceFolders.contains(childFolder) || this.mySourceFolders.contains(folder.getVirtualFile())) {
                result2.add((AbstractTreeNode)new NdkSourceFolderNode(project, (PsiDirectory)value2, this.getSettings(), this.myFileExtensions, Collections.singletonList(childFolder), Collections.emptyList()));
                continue;
            }
            ArrayList<VirtualFile> childFolders = new ArrayList<VirtualFile>();
            for (VirtualFile sourceFolder : this.mySourceFolders) {
                if (!VfsUtilCore.isAncestor((VirtualFile)childFolder, (VirtualFile)sourceFolder, (boolean)true)) continue;
                childFolders.add(sourceFolder);
            }
            ArrayList<VirtualFile> childFiles = new ArrayList<VirtualFile>();
            for (VirtualFile file : this.mySourceFiles) {
                if (!VfsUtilCore.isAncestor((VirtualFile)childFolder, (VirtualFile)file, (boolean)true)) continue;
                childFiles.add(file);
            }
            if (childFolders.isEmpty() && childFiles.isEmpty()) continue;
            result2.add((AbstractTreeNode)new NdkSourceFolderNode(project, (PsiDirectory)value2, this.getSettings(), this.myFileExtensions, childFolders, childFiles));
        }
        return result2;
    }

    @NotNull
    private Project getNotNullProject() {
        assert (this.myProject != null);
        Project project = this.myProject;
        if (project == null) {
            NdkSourceFolderNode.$$$reportNull$$$0(7);
        }
        return project;
    }

    void setShowFolderPath(boolean showFolderPath) {
        this.myShowFolderPath = showFolderPath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileExtensions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFolders";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFiles";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/ndk/NdkSourceFolderNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/ndk/NdkSourceFolderNode";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateImpl";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

