/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk;

import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeFile;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.ndk.NdkSourceFolderNode;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NdkLibraryNode
extends ProjectViewNode<Collection<NativeArtifact>>
implements FolderGroupNode {
    private static final Set<String> HEADER_FILE_EXTENSIONS = ImmutableSet.of((Object)"h", (Object)"hpp", (Object)"hh", (Object)"h++", (Object)"hxx");
    @NotNull
    private final String myNativeLibraryName;
    @NotNull
    private final String myNativeLibraryType;
    @NotNull
    private final Collection<String> mySourceFileExtensions;
    @Nullable
    private VirtualFile myLibraryFolder;

    public NdkLibraryNode(@NotNull Project project, @NotNull String nativeLibraryName, @NotNull String nativeLibraryType, @NotNull Collection<NativeArtifact> artifacts, @NotNull ViewSettings settings, @NotNull Collection<String> sourceFileExtensions) {
        if (project == null) {
            NdkLibraryNode.$$$reportNull$$$0(0);
        }
        if (nativeLibraryName == null) {
            NdkLibraryNode.$$$reportNull$$$0(1);
        }
        if (nativeLibraryType == null) {
            NdkLibraryNode.$$$reportNull$$$0(2);
        }
        if (artifacts == null) {
            NdkLibraryNode.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            NdkLibraryNode.$$$reportNull$$$0(4);
        }
        if (sourceFileExtensions == null) {
            NdkLibraryNode.$$$reportNull$$$0(5);
        }
        super(project, artifacts, settings);
        assert (!((Boolean)StudioFlags.ENABLE_ENHANCED_NATIVE_HEADER_SUPPORT.get()).booleanValue());
        this.myNativeLibraryName = nativeLibraryName;
        this.myNativeLibraryType = nativeLibraryType;
        this.mySourceFileExtensions = sourceFileExtensions;
    }

    @NotNull
    static Collection<AbstractTreeNode> getSourceFolderNodes(@NotNull Project project, @NotNull Collection<NativeArtifact> artifacts, @NotNull ViewSettings settings, @NotNull Collection<String> sourceFileExtensions) {
        if (project == null) {
            NdkLibraryNode.$$$reportNull$$$0(6);
        }
        if (artifacts == null) {
            NdkLibraryNode.$$$reportNull$$$0(7);
        }
        if (settings == null) {
            NdkLibraryNode.$$$reportNull$$$0(8);
        }
        if (sourceFileExtensions == null) {
            NdkLibraryNode.$$$reportNull$$$0(9);
        }
        TreeMap<String, RootFolder> rootFolders = new TreeMap<String, RootFolder>();
        for (NativeArtifact artifact : artifacts) {
            NdkLibraryNode.addSourceFolders(rootFolders, artifact);
            NdkLibraryNode.addSourceFiles(rootFolders, artifact);
        }
        if (rootFolders.size() > 1) {
            NdkLibraryNode.groupFolders(rootFolders);
        }
        if (rootFolders.size() > 1) {
            NdkLibraryNode.mergeFolders(rootFolders);
        }
        HashSet<String> fileExtensions = new HashSet<String>(sourceFileExtensions.size() + HEADER_FILE_EXTENSIONS.size());
        fileExtensions.addAll(sourceFileExtensions);
        fileExtensions.addAll(HEADER_FILE_EXTENSIONS);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        for (RootFolder rootFolder : rootFolders.values()) {
            PsiDirectory directory = psiManager.findDirectory(rootFolder.rootFolder);
            if (directory == null) continue;
            children.add((AbstractTreeNode)new NdkSourceFolderNode(project, directory, settings, fileExtensions, rootFolder.sourceFolders, rootFolder.sourceFiles));
        }
        ArrayList<AbstractTreeNode> arrayList = children;
        if (arrayList == null) {
            NdkLibraryNode.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private static void addSourceFolders(@NotNull TreeMap<String, RootFolder> rootFolders, @NotNull NativeArtifact artifact) {
        if (rootFolders == null) {
            NdkLibraryNode.$$$reportNull$$$0(11);
        }
        if (artifact == null) {
            NdkLibraryNode.$$$reportNull$$$0(12);
        }
        for (VirtualFile sourceFolder : NdkLibraryNode.getSourceFolders(artifact)) {
            String path = sourceFolder.getPath();
            if (rootFolders.containsKey(path)) continue;
            RootFolder rootFolder = new RootFolder(sourceFolder);
            rootFolder.sourceFolders.add(sourceFolder);
            rootFolders.put(path, rootFolder);
        }
    }

    @NotNull
    private static List<VirtualFile> getSourceFolders(@NotNull NativeArtifact artifact) {
        if (artifact == null) {
            NdkLibraryNode.$$$reportNull$$$0(13);
        }
        ArrayList<File> sourceFolders = new ArrayList<File>();
        sourceFolders.addAll(artifact.getExportedHeaders());
        List<VirtualFile> list = NdkLibraryNode.convertToVirtualFiles(sourceFolders);
        if (list == null) {
            NdkLibraryNode.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static void addSourceFiles(TreeMap<String, RootFolder> rootFolders, NativeArtifact artifact) {
        for (VirtualFile sourceFile : NdkLibraryNode.getSourceFiles(artifact)) {
            VirtualFile sourceFolder = sourceFile.getParent();
            String path = sourceFolder.getPath();
            RootFolder rootFolder = rootFolders.computeIfAbsent(path, k -> new RootFolder(sourceFolder));
            rootFolder.sourceFiles.add(sourceFile);
        }
    }

    @NotNull
    private static List<VirtualFile> getSourceFiles(@NotNull NativeArtifact artifact) {
        if (artifact == null) {
            NdkLibraryNode.$$$reportNull$$$0(15);
        }
        ArrayList<File> sourceFiles = new ArrayList<File>();
        for (NativeFile sourceFile : artifact.getSourceFiles()) {
            File source = sourceFile.getFilePath();
            sourceFiles.add(source);
            for (String extension : HEADER_FILE_EXTENSIONS) {
                sourceFiles.add(new File(source.getParentFile(), FileUtil.getNameWithoutExtension((File)source) + "." + extension));
            }
        }
        List<VirtualFile> list = NdkLibraryNode.convertToVirtualFiles(sourceFiles);
        if (list == null) {
            NdkLibraryNode.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    private static List<VirtualFile> convertToVirtualFiles(@NotNull Collection<File> files2) {
        if (files2 == null) {
            NdkLibraryNode.$$$reportNull$$$0(17);
        }
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(files2.size());
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        for (File file : files2) {
            VirtualFile virtualFile = fileSystem.findFileByIoFile(file);
            if (virtualFile == null) continue;
            result2.add(virtualFile);
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            NdkLibraryNode.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    private static void groupFolders(TreeMap<String, RootFolder> rootFolders) {
        String keyToMerge = rootFolders.lastKey();
        while (keyToMerge != null) {
            RootFolder folderToMerge = rootFolders.get(keyToMerge);
            VirtualFile folderToMergeParent = folderToMerge.rootFolder.getParent();
            if (folderToMergeParent == null) {
                keyToMerge = rootFolders.lowerKey(keyToMerge);
                continue;
            }
            RootFolder targetFolder = rootFolders.get(folderToMergeParent.getPath());
            if (targetFolder != null) {
                targetFolder.sourceFolders.addAll(folderToMerge.sourceFolders);
                targetFolder.sourceFiles.addAll(folderToMerge.sourceFiles);
                rootFolders.remove(keyToMerge);
                keyToMerge = rootFolders.lastKey();
                continue;
            }
            String previousKey = rootFolders.lowerKey(keyToMerge);
            if (previousKey == null) break;
            RootFolder previousFolder = rootFolders.get(previousKey);
            VirtualFile previousFolderParent = previousFolder.rootFolder.getParent();
            if (previousFolderParent != null && previousFolderParent.getPath().equals(folderToMergeParent.getPath())) {
                targetFolder = rootFolders.computeIfAbsent(folderToMergeParent.getPath(), k -> new RootFolder(folderToMergeParent));
                targetFolder.sourceFolders.addAll(folderToMerge.sourceFolders);
                targetFolder.sourceFolders.addAll(previousFolder.sourceFolders);
                targetFolder.sourceFiles.addAll(folderToMerge.sourceFiles);
                targetFolder.sourceFiles.addAll(previousFolder.sourceFiles);
                rootFolders.remove(keyToMerge);
                rootFolders.remove(previousKey);
                keyToMerge = rootFolders.lastKey();
                continue;
            }
            keyToMerge = previousKey;
        }
    }

    private static void mergeFolders(TreeMap<String, RootFolder> rootFolders) {
        String keyToMerge = rootFolders.lastKey();
        while (keyToMerge != null) {
            VirtualFile folder;
            RootFolder folderToMerge = rootFolders.get(keyToMerge);
            for (folder = folderToMerge.rootFolder.getParent(); folder != null; folder = folder.getParent()) {
                RootFolder targetFolder = rootFolders.get(folder.getPath());
                if (targetFolder == null) {
                    continue;
                }
                targetFolder.sourceFolders.addAll(folderToMerge.sourceFolders);
                targetFolder.sourceFiles.addAll(folderToMerge.sourceFiles);
                rootFolders.remove(keyToMerge);
                keyToMerge = rootFolders.lastKey();
                break;
            }
            if (rootFolders.size() <= 1) break;
            if (folder != null) continue;
            keyToMerge = rootFolders.lowerKey(keyToMerge);
        }
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        Collection<AbstractTreeNode> sourceFolderNodes = NdkLibraryNode.getSourceFolderNodes(this.getNotNullProject(), this.getArtifacts(), this.getSettings(), this.mySourceFileExtensions);
        if (sourceFolderNodes.size() == 1) {
            AbstractTreeNode node = (AbstractTreeNode)Iterables.getOnlyElement(sourceFolderNodes);
            assert (node instanceof NdkSourceFolderNode);
            NdkSourceFolderNode sourceFolderNode = (NdkSourceFolderNode)node;
            sourceFolderNode.setShowFolderPath(false);
            this.myLibraryFolder = sourceFolderNode.getVirtualFile();
            Collection collection = sourceFolderNode.getChildren();
            if (collection == null) {
                NdkLibraryNode.$$$reportNull$$$0(19);
            }
            return collection;
        }
        for (AbstractTreeNode sourceFolderNode : sourceFolderNodes) {
            if (!(sourceFolderNode instanceof NdkSourceFolderNode)) continue;
            ((NdkSourceFolderNode)sourceFolderNode).setShowFolderPath(true);
        }
        this.myLibraryFolder = null;
        Collection<AbstractTreeNode> collection = sourceFolderNodes;
        if (collection == null) {
            NdkLibraryNode.$$$reportNull$$$0(20);
        }
        return collection;
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            NdkLibraryNode.$$$reportNull$$$0(21);
        }
        presentation.addText(this.myNativeLibraryName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (!this.myNativeLibraryType.isEmpty()) {
            presentation.addText(" (" + this.myNativeLibraryType + (this.myLibraryFolder != null ? ", " + FileUtil.getLocationRelativeToUserHome((String)this.myLibraryFolder.getPresentableUrl()) : "") + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        presentation.setIcon(AllIcons.Nodes.NativeLibrariesFolder);
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            NdkLibraryNode.$$$reportNull$$$0(22);
        }
        for (NativeArtifact artifact : this.getArtifacts()) {
            for (VirtualFile folder : NdkLibraryNode.getSourceFolders(artifact)) {
                if (!VfsUtilCore.isAncestor((VirtualFile)folder, (VirtualFile)file, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public Comparable getSortKey() {
        return this.myNativeLibraryType + this.myNativeLibraryName;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.myNativeLibraryName + (this.myNativeLibraryType.isEmpty() ? "" : " (" + this.myNativeLibraryType + ")");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NdkLibraryNode that = (NdkLibraryNode)o;
        return this.getValue() == that.getValue();
    }

    public int hashCode() {
        int result2 = super.hashCode();
        for (NativeArtifact artifact : this.getArtifacts()) {
            result2 = 31 * result2 + artifact.hashCode();
        }
        return result2;
    }

    @Override
    @NotNull
    public PsiDirectory[] getFolders() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.getNotNullProject());
        ArrayList<PsiDirectory> folders = new ArrayList<PsiDirectory>();
        for (NativeArtifact artifact : this.getArtifacts()) {
            for (VirtualFile f : NdkLibraryNode.getSourceFolders(artifact)) {
                PsiDirectory dir = psiManager.findDirectory(f);
                if (dir == null) continue;
                folders.add(dir);
            }
        }
        PsiDirectory[] psiDirectoryArray = folders.toArray(PsiDirectory.EMPTY_ARRAY);
        if (psiDirectoryArray == null) {
            NdkLibraryNode.$$$reportNull$$$0(23);
        }
        return psiDirectoryArray;
    }

    @NotNull
    private Project getNotNullProject() {
        assert (this.myProject != null);
        Project project = this.myProject;
        if (project == null) {
            NdkLibraryNode.$$$reportNull$$$0(24);
        }
        return project;
    }

    @NotNull
    private Collection<NativeArtifact> getArtifacts() {
        Collection artifacts = (Collection)this.getValue();
        assert (artifacts != null);
        Collection collection = artifacts;
        if (collection == null) {
            NdkLibraryNode.$$$reportNull$$$0(25);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeLibraryName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeLibraryType";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFileExtensions";
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/ndk/NdkLibraryNode";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFolders";
                break;
            }
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/ndk/NdkLibraryNode";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFolderNodes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFolders";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFiles";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToVirtualFiles";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFolders";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullProject";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifacts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFolderNodes";
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addSourceFolders";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFolders";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFiles";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "convertToVirtualFiles";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class RootFolder {
        @NotNull
        final VirtualFile rootFolder;
        @NotNull
        final List<VirtualFile> sourceFolders;
        @NotNull
        final List<VirtualFile> sourceFiles;

        RootFolder(@NotNull VirtualFile rootFolder) {
            if (rootFolder == null) {
                RootFolder.$$$reportNull$$$0(0);
            }
            this.sourceFolders = new ArrayList<VirtualFile>();
            this.sourceFiles = new ArrayList<VirtualFile>();
            this.rootFolder = rootFolder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootFolder", "com/android/tools/idea/navigator/nodes/ndk/NdkLibraryNode$RootFolder", "<init>"));
        }
    }
}

