/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalBuildFileNode
extends PsiFileNode {
    @NotNull
    private final String myModuleName;

    ExternalBuildFileNode(@NotNull Project project, @NotNull PsiFile value2, @NotNull ViewSettings settings, @NotNull String moduleName) {
        if (project == null) {
            ExternalBuildFileNode.$$$reportNull$$$0(0);
        }
        if (value2 == null) {
            ExternalBuildFileNode.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            ExternalBuildFileNode.$$$reportNull$$$0(2);
        }
        if (moduleName == null) {
            ExternalBuildFileNode.$$$reportNull$$$0(3);
        }
        super(project, value2, settings);
        this.myModuleName = moduleName;
    }

    public void update(@NotNull PresentationData data) {
        if (data == null) {
            ExternalBuildFileNode.$$$reportNull$$$0(4);
        }
        super.update(data);
        String fileName = this.getFileName();
        data.addText(fileName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        data.setPresentableText(fileName);
        data.addText(" (" + this.myModuleName + ", " + this.getFilePath() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    @Nullable
    public Comparable getSortKey() {
        return this.myModuleName + "-" + this.getFileName() + "-" + this.getFilePath();
    }

    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.getFileName() + " (" + this.myModuleName + ", " + this.getFilePath() + ")";
    }

    @NotNull
    private String getFileName() {
        String string = this.getFile().getName();
        if (string == null) {
            ExternalBuildFileNode.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private String getFilePath() {
        String string = FileUtil.getLocationRelativeToUserHome((String)this.getFile().getVirtualFile().getPresentableUrl());
        if (string == null) {
            ExternalBuildFileNode.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private PsiFile getFile() {
        PsiFile value2 = (PsiFile)this.getValue();
        assert (value2 != null);
        PsiFile psiFile = value2;
        if (psiFile == null) {
            ExternalBuildFileNode.$$$reportNull$$$0(7);
        }
        return psiFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/ndk/ExternalBuildFileNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/ndk/ExternalBuildFileNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

