/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.apk.ndk;

import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.navigator.nodes.apk.ndk.LibraryNode;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryFileNode
extends LibraryNode {
    @Nullable
    private VirtualFile myFile;

    public LibraryFileNode(@NotNull Project project, @NotNull NativeLibrary library, @NotNull ViewSettings settings) {
        if (project == null) {
            LibraryFileNode.$$$reportNull$$$0(0);
        }
        if (library == null) {
            LibraryFileNode.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            LibraryFileNode.$$$reportNull$$$0(2);
        }
        super(project, library, settings);
        this.myFile = this.getFirstFile();
    }

    @Override
    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        List list = Collections.emptyList();
        if (list == null) {
            LibraryFileNode.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            LibraryFileNode.$$$reportNull$$$0(4);
        }
        presentation.setIcon(AllIcons.FileTypes.JavaClass);
        boolean hasDebugSymbols = this.myLibrary.hasDebugSymbols;
        boolean missingPathMappings = this.myLibrary.isMissingPathMappings();
        SimpleTextAttributes attributes = !hasDebugSymbols | missingPathMappings ? new SimpleTextAttributes(8, null, (Color)JBColor.GRAY) : SimpleTextAttributes.REGULAR_ATTRIBUTES;
        presentation.addText(this.myLibrary.name, attributes);
        if (!hasDebugSymbols) {
            presentation.setTooltip("Library does not have debug symbols");
        }
        if (missingPathMappings) {
            presentation.setTooltip("Library is missing path mappings");
        }
    }

    public void navigate(boolean requestFocus) {
        VirtualFile file = this.getFile();
        if (file != null) {
            FileEditorManager.getInstance((Project)this.myProject).openFile(file, requestFocus);
        }
    }

    public boolean canRepresent(Object element) {
        if (element instanceof PsiBinaryFile) {
            VirtualFile virtualFile = ((PsiBinaryFile)element).getVirtualFile();
            return Objects.equals(virtualFile, this.getFile());
        }
        return false;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            LibraryFileNode.$$$reportNull$$$0(5);
        }
        return file.equals(this.getFile());
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return this.getFile();
    }

    @Nullable
    private VirtualFile getFile() {
        if (this.myFile == null) {
            this.myFile = this.getFirstFile();
        }
        return this.myFile;
    }

    public int getWeight() {
        return 10;
    }

    public int getTypeSortWeight(boolean sortByType) {
        return 1;
    }

    @Nullable
    public Comparable getSortKey() {
        return this.getTypeSortKey();
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.myLibrary.name;
    }

    public boolean isAlwaysLeaf() {
        return true;
    }

    @Override
    public boolean isAlwaysShowPlus() {
        return false;
    }

    @Override
    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.myLibrary.name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LibraryFileNode node = (LibraryFileNode)((Object)o);
        return Objects.equals(this.myFile, node.myFile);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/apk/ndk/LibraryFileNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/apk/ndk/LibraryFileNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

