/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.android.AndroidModuleNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidTestsNode
extends ProjectViewNode<AndroidFacet>
implements FolderGroupNode {
    private static final String ANDROID_TESTS = "androidTests";
    private final AndroidProjectViewPane myProjectViewPane;

    AndroidTestsNode(@NotNull Project project, @NotNull AndroidFacet androidFacet, @NotNull ViewSettings settings, @NotNull AndroidProjectViewPane projectViewPane) {
        if (project == null) {
            AndroidTestsNode.$$$reportNull$$$0(0);
        }
        if (androidFacet == null) {
            AndroidTestsNode.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            AndroidTestsNode.$$$reportNull$$$0(2);
        }
        if (projectViewPane == null) {
            AndroidTestsNode.$$$reportNull$$$0(3);
        }
        super(project, (Object)androidFacet, settings);
        this.myProjectViewPane = projectViewPane;
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        Module module = this.getModule();
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null || ((AndroidFacetConfiguration)facet.getConfiguration()).getModel() == null) {
            List<AbstractTreeNode> list = Collections.emptyList();
            if (list == null) {
                AndroidTestsNode.$$$reportNull$$$0(4);
            }
            return list;
        }
        Collection<AbstractTreeNode> collection = AndroidModuleNode.getChildren(facet, this.getSettings(), this.myProjectViewPane, IdeaSourceProvider.getCurrentTestSourceProviders(facet));
        if (collection == null) {
            AndroidTestsNode.$$$reportNull$$$0(5);
        }
        return collection;
    }

    public boolean contains(@NotNull VirtualFile file) {
        Module module;
        AndroidFacet facet;
        if (file == null) {
            AndroidTestsNode.$$$reportNull$$$0(6);
        }
        if ((facet = AndroidFacet.getInstance(module = this.getModule())) == null || ((AndroidFacetConfiguration)facet.getConfiguration()).getModel() == null) {
            return false;
        }
        for (IdeaSourceProvider provider : IdeaSourceProvider.getCurrentTestSourceProviders(facet)) {
            if (!provider.containsFile(file)) continue;
            return true;
        }
        return false;
    }

    public void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            AndroidTestsNode.$$$reportNull$$$0(7);
        }
        presentation.setPresentableText(ANDROID_TESTS);
        presentation.addText(ANDROID_TESTS, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.setIcon(ModuleType.get((Module)this.getModule()).getIcon());
    }

    @NotNull
    private Module getModule() {
        Module module = this.getAndroidFacet().getModule();
        if (module == null) {
            AndroidTestsNode.$$$reportNull$$$0(8);
        }
        return module;
    }

    @NotNull
    private AndroidFacet getAndroidFacet() {
        AndroidFacet facet = (AndroidFacet)((Object)this.getValue());
        assert (facet != null);
        AndroidFacet androidFacet = facet;
        if (androidFacet == null) {
            AndroidTestsNode.$$$reportNull$$$0(9);
        }
        return androidFacet;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return ANDROID_TESTS;
    }

    public boolean equals(Object object) {
        return object instanceof AndroidTestsNode && super.equals(object);
    }

    @Override
    @NotNull
    public PsiDirectory[] getFolders() {
        if (PsiDirectory.EMPTY_ARRAY == null) {
            AndroidTestsNode.$$$reportNull$$$0(10);
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidFacet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectViewPane";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/android/AndroidTestsNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/android/AndroidTestsNode";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidFacet";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFolders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

