/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeBaseArtifact;
import com.android.ide.common.gradle.model.IdeJavaArtifact;
import com.android.ide.common.util.PathString;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.AndroidViewModuleNode;
import com.android.tools.idea.navigator.nodes.android.AndroidJniFolderNode;
import com.android.tools.idea.navigator.nodes.android.AndroidManifestsGroupNode;
import com.android.tools.idea.navigator.nodes.android.AndroidResFolderNode;
import com.android.tools.idea.navigator.nodes.android.AndroidSourceTypeNode;
import com.android.tools.idea.navigator.nodes.ndk.NdkModuleNode;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.util.FileExtensions;
import com.google.common.collect.HashMultimap;
import com.intellij.codeInsight.dataflow.SetUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModuleNode
extends AndroidViewModuleNode {
    private final AndroidProjectViewPane myProjectViewPane;

    public AndroidModuleNode(@NotNull Project project, @NotNull Module module, @NotNull ViewSettings settings, @NotNull AndroidProjectViewPane projectViewPane) {
        if (project == null) {
            AndroidModuleNode.$$$reportNull$$$0(0);
        }
        if (module == null) {
            AndroidModuleNode.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            AndroidModuleNode.$$$reportNull$$$0(2);
        }
        if (projectViewPane == null) {
            AndroidModuleNode.$$$reportNull$$$0(3);
        }
        super(project, module, settings);
        this.myProjectViewPane = projectViewPane;
    }

    @NotNull
    private Module getModule() {
        Module module = (Module)this.getValue();
        assert (module != null);
        Module module2 = module;
        if (module2 == null) {
            AndroidModuleNode.$$$reportNull$$$0(4);
        }
        return module2;
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        AndroidFacet facet = AndroidFacet.getInstance(this.getModule());
        if (facet == null || ((AndroidFacetConfiguration)facet.getConfiguration()).getModel() == null) {
            Collection collection = super.getChildren();
            if (collection == null) {
                AndroidModuleNode.$$$reportNull$$$0(5);
            }
            return collection;
        }
        Collection<AbstractTreeNode> collection = AndroidModuleNode.getChildren(facet, this.getSettings(), this.myProjectViewPane, AndroidProjectViewPane.getSourceProviders(facet));
        if (collection == null) {
            AndroidModuleNode.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    static Collection<AbstractTreeNode> getChildren(@NotNull AndroidFacet facet, @NotNull ViewSettings settings, @NotNull AndroidProjectViewPane projectViewPane, @NotNull List<IdeaSourceProvider> providers) {
        AndroidModuleSystem moduleSystem;
        PsiDirectory sampleDataPsi;
        if (facet == null) {
            AndroidModuleNode.$$$reportNull$$$0(7);
        }
        if (settings == null) {
            AndroidModuleNode.$$$reportNull$$$0(8);
        }
        if (projectViewPane == null) {
            AndroidModuleNode.$$$reportNull$$$0(9);
        }
        if (providers == null) {
            AndroidModuleNode.$$$reportNull$$$0(10);
        }
        Project project = facet.getModule().getProject();
        ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>();
        AndroidModuleModel androidModuleModel = AndroidModuleModel.get(facet);
        HashMultimap<AndroidSourceType, VirtualFile> sourcesByType = AndroidModuleNode.getSourcesBySourceType(providers, androidModuleModel);
        NdkModuleModel ndkModuleModel = NdkModuleModel.get(facet.getModule());
        for (AndroidSourceType sourceType : sourcesByType.keySet()) {
            if (sourceType == AndroidSourceType.CPP && ndkModuleModel != null) continue;
            if (sourceType == AndroidSourceType.MANIFEST) {
                result2.add((AbstractTreeNode)new AndroidManifestsGroupNode(project, facet, settings, sourcesByType.get((Object)sourceType)));
                continue;
            }
            if (sourceType == AndroidSourceType.RES) {
                result2.add((AbstractTreeNode)new AndroidResFolderNode(project, facet, settings, sourcesByType.get((Object)sourceType), projectViewPane));
                continue;
            }
            if (sourceType == AndroidSourceType.SHADERS && (androidModuleModel == null || !androidModuleModel.getFeatures().isShadersSupported())) continue;
            result2.add((AbstractTreeNode)new AndroidSourceTypeNode(project, facet, settings, sourceType, sourcesByType.get((Object)sourceType), projectViewPane));
        }
        if (ndkModuleModel != null) {
            result2.add((AbstractTreeNode)new AndroidJniFolderNode(project, ndkModuleModel, settings));
        }
        if ((sampleDataPsi = AndroidModuleNode.getPsiDirectory(project, (moduleSystem = ProjectSystemUtil.getModuleSystem(facet.getModule())).getSampleDataDirectory())) != null) {
            result2.add((AbstractTreeNode)new PsiDirectoryNode(project, sampleDataPsi, settings));
        }
        ArrayList<AbstractTreeNode> arrayList = result2;
        if (arrayList == null) {
            AndroidModuleNode.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Nullable
    private static PsiDirectory getPsiDirectory(@NotNull Project project, @Nullable PathString path) {
        VirtualFile virtualFile;
        if (project == null) {
            AndroidModuleNode.$$$reportNull$$$0(12);
        }
        return (virtualFile = FileExtensions.toVirtualFile(path)) != null ? PsiManager.getInstance((Project)project).findDirectory(virtualFile) : null;
    }

    @NotNull
    private static HashMultimap<AndroidSourceType, VirtualFile> getSourcesBySourceType(@NotNull List<IdeaSourceProvider> providers, @Nullable AndroidModuleModel androidModel) {
        if (providers == null) {
            AndroidModuleNode.$$$reportNull$$$0(13);
        }
        HashMultimap sourcesByType = HashMultimap.create();
        HashSet<VirtualFile> allSources = new HashSet<VirtualFile>();
        for (AndroidSourceType sourceType : AndroidSourceType.values()) {
            Set<VirtualFile> sources;
            if (sourceType == AndroidSourceType.SHADERS && (androidModel == null || !androidModel.getFeatures().isShadersSupported())) continue;
            Set<VirtualFile> set = sources = sourceType == AndroidSourceType.GENERATED_JAVA ? AndroidModuleNode.getGeneratedSources(androidModel) : AndroidModuleNode.getSources(sourceType, providers);
            if (sources.isEmpty()) continue;
            if (SetUtil.intersect(allSources, sources).isEmpty()) {
                sourcesByType.putAll((Object)sourceType, sources);
            } else if (!allSources.containsAll(sources)) {
                sources.removeAll(allSources);
                sourcesByType.putAll((Object)sourceType, sources);
            }
            allSources.addAll(sources);
        }
        HashMultimap hashMultimap = sourcesByType;
        if (hashMultimap == null) {
            AndroidModuleNode.$$$reportNull$$$0(14);
        }
        return hashMultimap;
    }

    @NotNull
    private static Set<VirtualFile> getSources(@NotNull AndroidSourceType sourceType, @NotNull Iterable<IdeaSourceProvider> providers) {
        if (sourceType == null) {
            AndroidModuleNode.$$$reportNull$$$0(15);
        }
        if (providers == null) {
            AndroidModuleNode.$$$reportNull$$$0(16);
        }
        HashSet<VirtualFile> sources = new HashSet<VirtualFile>();
        for (IdeaSourceProvider provider : providers) {
            sources.addAll(sourceType.getSources(provider));
        }
        HashSet<VirtualFile> hashSet = sources;
        if (hashSet == null) {
            AndroidModuleNode.$$$reportNull$$$0(17);
        }
        return hashSet;
    }

    @NotNull
    private static Set<VirtualFile> getGeneratedSources(@Nullable AndroidModuleModel androidModuleModel) {
        HashSet<VirtualFile> sources = new HashSet<VirtualFile>();
        if (androidModuleModel != null) {
            IdeJavaArtifact unitTestArtifact;
            ArrayList<File> files2 = new ArrayList<File>(GradleUtil.getGeneratedSourceFoldersToUse((IdeBaseArtifact)androidModuleModel.getMainArtifact(), androidModuleModel));
            IdeAndroidArtifact androidTestArtifact = androidModuleModel.getArtifactForAndroidTest();
            if (androidTestArtifact != null) {
                files2.addAll(GradleUtil.getGeneratedSourceFoldersToUse((IdeBaseArtifact)androidTestArtifact, androidModuleModel));
            }
            if ((unitTestArtifact = androidModuleModel.getSelectedVariant().getUnitTestArtifact()) != null) {
                files2.addAll(unitTestArtifact.getGeneratedSourceFolders());
            }
            for (File file : files2) {
                VirtualFile vFile = VfsUtil.findFileByIoFile((File)file, (boolean)false);
                if (vFile == null) continue;
                sources.add(vFile);
            }
        }
        HashSet<VirtualFile> hashSet = sources;
        if (hashSet == null) {
            AndroidModuleNode.$$$reportNull$$$0(18);
        }
        return hashSet;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            AndroidModuleNode.$$$reportNull$$$0(19);
        }
        if (super.contains(file)) {
            return true;
        }
        if (((Boolean)StudioFlags.ENABLE_ENHANCED_NATIVE_HEADER_SUPPORT.get()).booleanValue()) {
            AndroidFacet facet = AndroidFacet.getInstance(this.getModule());
            if (facet == null || ((AndroidFacetConfiguration)facet.getConfiguration()).getModel() == null) {
                return false;
            }
            NdkModuleModel ndkModuleModel = NdkModuleModel.get(facet.getModule());
            if (ndkModuleModel != null) {
                return NdkModuleNode.containedInIncludeFolders(ndkModuleModel, file);
            }
            return false;
        }
        return false;
    }

    @Nullable
    public Comparable getSortKey() {
        return this.getModule().getName();
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return String.format("%1$s (Android)", this.getModule().getName());
    }

    public void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            AndroidModuleNode.$$$reportNull$$$0(20);
        }
        super.update(presentation);
        Module module = (Module)this.getValue();
        if (module != null) {
            presentation.setIcon(GradleUtil.getModuleIcon(module));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 14: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 14: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectViewPane";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/android/AndroidModuleNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/android/AndroidModuleNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 5: 
            case 6: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourcesBySourceType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSources";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratedSources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 14: 
            case 17: 
            case 18: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPsiDirectory";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSourcesBySourceType";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSources";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 14: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

