/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.android.AndroidManifestFileNode;
import com.google.common.collect.Iterables;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidManifestsGroupNode
extends ProjectViewNode<AndroidFacet>
implements FolderGroupNode {
    private static final String MANIFESTS_NODE = "manifests";
    @NotNull
    private final Set<VirtualFile> mySources;

    public AndroidManifestsGroupNode(@NotNull Project project, @NotNull AndroidFacet androidFacet, @NotNull ViewSettings settings, @NotNull Set<VirtualFile> sources) {
        if (project == null) {
            AndroidManifestsGroupNode.$$$reportNull$$$0(0);
        }
        if (androidFacet == null) {
            AndroidManifestsGroupNode.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            AndroidManifestsGroupNode.$$$reportNull$$$0(2);
        }
        if (sources == null) {
            AndroidManifestsGroupNode.$$$reportNull$$$0(3);
        }
        super(project, (Object)androidFacet, settings);
        this.mySources = sources;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            AndroidManifestsGroupNode.$$$reportNull$$$0(4);
        }
        return this.mySources.contains(file);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        Project project = this.getNotNullProject();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        ArrayList<AndroidManifestFileNode> children = new ArrayList<AndroidManifestFileNode>();
        for (VirtualFile manifest : this.mySources) {
            PsiFile psiFile;
            if (!manifest.isValid() || (psiFile = psiManager.findFile(manifest)) == null) continue;
            AndroidFacet facet = this.getAndroidFacet();
            children.add(new AndroidManifestFileNode(project, psiFile, this.getSettings(), facet));
        }
        ArrayList<AndroidManifestFileNode> arrayList = children;
        if (arrayList == null) {
            AndroidManifestsGroupNode.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            AndroidManifestsGroupNode.$$$reportNull$$$0(6);
        }
        presentation.addText(MANIFESTS_NODE, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        Icon icon = AndroidSourceType.MANIFEST.getIcon();
        if (icon != null) {
            presentation.setIcon(icon);
        }
        presentation.setPresentableText(MANIFESTS_NODE);
    }

    public boolean expandOnDoubleClick() {
        return false;
    }

    public boolean canNavigate() {
        return !this.mySources.isEmpty();
    }

    public void navigate(boolean requestFocus) {
        VirtualFile fileToOpen = this.findFileToOpen(this.mySources);
        if (fileToOpen == null) {
            return;
        }
        new OpenFileDescriptor(this.getNotNullProject(), fileToOpen).navigate(requestFocus);
    }

    @Nullable
    private VirtualFile findFileToOpen(@NotNull Set<VirtualFile> files2) {
        if (files2 == null) {
            AndroidManifestsGroupNode.$$$reportNull$$$0(7);
        }
        VirtualFile bestFile = (VirtualFile)Iterables.getFirst(files2, null);
        PsiManager psiManager = PsiManager.getInstance((Project)this.getNotNullProject());
        for (VirtualFile file : files2) {
            AndroidFacet facet;
            IdeaSourceProvider sourceProvider;
            PsiFile psiFile = psiManager.findFile(file);
            if (psiFile == null || (sourceProvider = AndroidManifestFileNode.getSourceProvider(facet = this.getAndroidFacet(), psiFile)) == null || !"main".equals(sourceProvider.getName())) continue;
            bestFile = file;
        }
        return bestFile;
    }

    @NotNull
    private AndroidFacet getAndroidFacet() {
        AndroidFacet facet = (AndroidFacet)((Object)this.getValue());
        assert (facet != null) : "Android Facet for module cannot be null";
        AndroidFacet androidFacet = facet;
        if (androidFacet == null) {
            AndroidManifestsGroupNode.$$$reportNull$$$0(8);
        }
        return androidFacet;
    }

    @NotNull
    private Project getNotNullProject() {
        assert (this.myProject != null);
        Project project = this.myProject;
        if (project == null) {
            AndroidManifestsGroupNode.$$$reportNull$$$0(9);
        }
        return project;
    }

    @Override
    @NotNull
    public PsiDirectory[] getFolders() {
        if (PsiDirectory.EMPTY_ARRAY == null) {
            AndroidManifestsGroupNode.$$$reportNull$$$0(10);
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    @Nullable
    public Comparable getSortKey() {
        return AndroidSourceType.MANIFEST;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return AndroidSourceType.MANIFEST;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return MANIFESTS_NODE;
    }

    public boolean isAlwaysShowPlus() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidFacet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/android/AndroidManifestsGroupNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/android/AndroidManifestsGroupNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidFacet";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullProject";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFolders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findFileToOpen";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

