/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.lang.proguard.ProguardFileType;
import com.android.tools.idea.navigator.nodes.android.AndroidBuildScriptNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import icons.GradleIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidBuildScriptsGroupNode
extends ProjectViewNode<List<PsiDirectory>> {
    public AndroidBuildScriptsGroupNode(@NotNull Project project, @NotNull ViewSettings settings) {
        if (project == null) {
            AndroidBuildScriptsGroupNode.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            AndroidBuildScriptsGroupNode.$$$reportNull$$$0(1);
        }
        super(project, Collections.emptyList(), settings);
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            AndroidBuildScriptsGroupNode.$$$reportNull$$$0(2);
        }
        return this.getBuildScriptsWithQualifiers().containsKey(file);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        Map<VirtualFile, String> scripts = this.getBuildScriptsWithQualifiers();
        ArrayList<PsiFileNode> children = new ArrayList<PsiFileNode>(scripts.size());
        for (Map.Entry<VirtualFile, String> scriptWithQualifier : scripts.entrySet()) {
            this.addPsiFile(children, scriptWithQualifier.getKey(), scriptWithQualifier.getValue());
        }
        ArrayList<PsiFileNode> arrayList = children;
        if (arrayList == null) {
            AndroidBuildScriptsGroupNode.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    private Map<VirtualFile, String> getBuildScriptsWithQualifiers() {
        VirtualFile file;
        File userSettingsFile;
        HashMap<VirtualFile, String> buildScripts = new HashMap<VirtualFile, String>();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            String moduleName = AndroidBuildScriptsGroupNode.getPrefixForModule(module) + module.getName();
            VirtualFile gradleBuildFile = GradleUtil.getGradleBuildFile(module);
            if (gradleBuildFile != null) {
                buildScripts.put(gradleBuildFile, moduleName);
            }
            for (VirtualFile file2 : AndroidBuildScriptsGroupNode.findAllGradleScriptsInModule(module)) {
                if (file2.getFileType() == ProguardFileType.INSTANCE) {
                    buildScripts.put(file2, String.format("ProGuard Rules for %1$s", module.getName()));
                    continue;
                }
                buildScripts.put(file2, moduleName);
            }
        }
        VirtualFile projectRootFolder = this.myProject.getBaseDir();
        if (projectRootFolder != null) {
            AndroidBuildScriptsGroupNode.findChildAndAddToMapIfFound("settings.gradle", projectRootFolder, "Project Settings", buildScripts);
            AndroidBuildScriptsGroupNode.findChildAndAddToMapIfFound("settings.gradle.kts", projectRootFolder, "Project Settings", buildScripts);
            AndroidBuildScriptsGroupNode.findChildAndAddToMapIfFound("gradle.properties", projectRootFolder, "Project Properties", buildScripts);
            VirtualFile child = projectRootFolder.findFileByRelativePath(FileUtilRt.toSystemIndependentName((String)GradleUtil.GRADLEW_PROPERTIES_PATH));
            if (child != null) {
                buildScripts.put(child, "Gradle Version");
            }
            AndroidBuildScriptsGroupNode.findChildAndAddToMapIfFound("local.properties", projectRootFolder, "SDK Location", buildScripts);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && (userSettingsFile = GradleUtil.getGradleUserSettingsFile()) != null && (file = VfsUtil.findFileByIoFile((File)userSettingsFile, (boolean)false)) != null) {
            buildScripts.put(file, "Global Properties");
        }
        buildScripts.remove(null);
        HashMap<VirtualFile, String> hashMap = buildScripts;
        if (hashMap == null) {
            AndroidBuildScriptsGroupNode.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    private static void findChildAndAddToMapIfFound(@NotNull String childName, @NotNull VirtualFile parent, @NotNull String value2, @NotNull Map<VirtualFile, String> map2) {
        VirtualFile child;
        if (childName == null) {
            AndroidBuildScriptsGroupNode.$$$reportNull$$$0(5);
        }
        if (parent == null) {
            AndroidBuildScriptsGroupNode.$$$reportNull$$$0(6);
        }
        if (value2 == null) {
            AndroidBuildScriptsGroupNode.$$$reportNull$$$0(7);
        }
        if (map2 == null) {
            AndroidBuildScriptsGroupNode.$$$reportNull$$$0(8);
        }
        if ((child = parent.findChild(childName)) != null) {
            map2.put(child, value2);
        }
    }

    @NotNull
    private static String getPrefixForModule(@NotNull Module module) {
        if (module == null) {
            AndroidBuildScriptsGroupNode.$$$reportNull$$$0(9);
        }
        String string = GradleUtil.isRootModuleWithNoSources(module) ? "Project: " : "Module: ";
        if (string == null) {
            AndroidBuildScriptsGroupNode.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    private static List<VirtualFile> findAllGradleScriptsInModule(@NotNull Module module) {
        if (module == null) {
            AndroidBuildScriptsGroupNode.$$$reportNull$$$0(11);
        }
        File moduleRootFolderPath = GradleProjects.findModuleRootFolderPath(module);
        assert (moduleRootFolderPath != null);
        VirtualFile moduleRootFolder = VfsUtil.findFileByIoFile((File)moduleRootFolderPath, (boolean)false);
        if (moduleRootFolder == null || moduleRootFolder.getChildren() == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                AndroidBuildScriptsGroupNode.$$$reportNull$$$0(12);
            }
            return list;
        }
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
        for (VirtualFile child : moduleRootFolder.getChildren()) {
            if (!child.isValid() || child.isDirectory() || !child.getName().endsWith("gradle") && !child.getName().endsWith("gradle.kts") && child.getFileType() != ProguardFileType.INSTANCE || ApplicationManager.getApplication().isUnitTestMode() && (child.getName().startsWith("ijinit") || child.getName().startsWith("asLocalRepo"))) continue;
            files2.add(child);
        }
        ArrayList<VirtualFile> arrayList = files2;
        if (arrayList == null) {
            AndroidBuildScriptsGroupNode.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    private void addPsiFile(@NotNull List<PsiFileNode> psiFileNodes, @Nullable VirtualFile file, @Nullable String qualifier) {
        PsiFile psiFile;
        if (psiFileNodes == null) {
            AndroidBuildScriptsGroupNode.$$$reportNull$$$0(14);
        }
        if (file != null && (psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file)) != null) {
            psiFileNodes.add(new AndroidBuildScriptNode(this.myProject, psiFile, this.getSettings(), qualifier));
        }
    }

    public int getWeight() {
        return 100;
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            AndroidBuildScriptsGroupNode.$$$reportNull$$$0(15);
        }
        presentation.setPresentableText("Gradle Scripts");
        presentation.setIcon(GradleIcons.Gradle);
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return "Gradle Scripts";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/android/AndroidBuildScriptsGroupNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFileNodes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/android/AndroidBuildScriptsGroupNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildScriptsWithQualifiers";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefixForModule";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllGradleScriptsInModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findChildAndAddToMapIfFound";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixForModule";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findAllGradleScriptsInModule";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addPsiFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

