/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.ArrowDirection;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawArrow;
import com.android.tools.idea.common.scene.draw.DrawCommandBase;
import com.android.tools.idea.common.scene.draw.DrawCommandSerializationHelperKt;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.naveditor.model.ActionType;
import com.android.tools.idea.naveditor.scene.ConnectionDirection;
import com.android.tools.idea.naveditor.scene.CurvePoints;
import com.android.tools.idea.naveditor.scene.NavActionHelperKt;
import com.android.tools.idea.naveditor.scene.NavDrawHelperKt;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public class DrawAction
extends DrawCommandBase {
    private static final GeneralPath PATH = new GeneralPath();
    private final ActionType myActionType;
    private final Rectangle2D.Float mySource;
    private final Rectangle2D.Float myDest;
    private final Color myColor;

    public DrawAction(@NotNull String s) {
        if (s == null) {
            DrawAction.$$$reportNull$$$0(0);
        }
        this(DrawCommandSerializationHelperKt.parse(s, 4));
    }

    @Override
    public int getLevel() {
        return 2;
    }

    @Override
    public String serialize() {
        return DrawCommandSerializationHelperKt.buildString(this.getClass().getSimpleName(), new Object[]{this.myActionType, DrawCommandSerializationHelperKt.rect2DToString(this.mySource), DrawCommandSerializationHelperKt.rect2DToString(this.myDest), DrawCommandSerializationHelperKt.colorToString(this.myColor)});
    }

    @Override
    protected void onPaint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        if (g == null) {
            DrawAction.$$$reportNull$$$0(1);
        }
        if (sceneContext == null) {
            DrawAction.$$$reportNull$$$0(2);
        }
        NavDrawHelperKt.setRenderingHints(g);
        DrawAction.draw(g, this.myColor, this.myActionType, this.mySource, this.myDest, sceneContext);
    }

    public DrawAction(@NotNull ActionType actionType, Rectangle2D.Float source, Rectangle2D.Float dest, @NotNull Color color) {
        if (actionType == null) {
            DrawAction.$$$reportNull$$$0(3);
        }
        if (color == null) {
            DrawAction.$$$reportNull$$$0(4);
        }
        this.mySource = new Rectangle2D.Float();
        this.myDest = new Rectangle2D.Float();
        this.mySource.setRect(source);
        this.myDest.setRect(dest);
        this.myActionType = actionType;
        this.myColor = color;
    }

    private DrawAction(@NotNull String[] s) {
        if (s == null) {
            DrawAction.$$$reportNull$$$0(5);
        }
        this(ActionType.valueOf(s[0]), DrawCommandSerializationHelperKt.stringToRect2D(s[1]), DrawCommandSerializationHelperKt.stringToRect2D(s[2]), DrawCommandSerializationHelperKt.stringToColor(s[3]));
    }

    public static void buildDisplayList(@NotNull DisplayList list, @NotNull SceneView sceneView, @NotNull ActionType connectionType, Rectangle2D.Float source, Rectangle2D.Float dest, @NotNull Color color) {
        if (list == null) {
            DrawAction.$$$reportNull$$$0(6);
        }
        if (sceneView == null) {
            DrawAction.$$$reportNull$$$0(7);
        }
        if (connectionType == null) {
            DrawAction.$$$reportNull$$$0(8);
        }
        if (color == null) {
            DrawAction.$$$reportNull$$$0(9);
        }
        SceneContext sceneContext = SceneContext.get(sceneView);
        list.add(new DrawAction(connectionType, source, dest, color));
        ConnectionDirection direction = NavActionHelperKt.getDestinationDirection(source, dest);
        Point2D.Float arrowPoint = NavActionHelperKt.getArrowPoint(sceneContext, dest, direction);
        ArrowDirection arrowDirection = DrawAction.getArrowDirection(direction);
        Rectangle2D.Float arrowRectangle = NavActionHelperKt.getArrowRectangle(sceneView, arrowPoint, direction);
        list.add(new DrawArrow(2, arrowDirection, arrowRectangle, color));
    }

    private static void draw(@NotNull Graphics2D g, @NotNull Color color, @NotNull ActionType connectionType, Rectangle2D.Float source, Rectangle2D.Float dest, @NotNull SceneContext sceneContext) {
        if (g == null) {
            DrawAction.$$$reportNull$$$0(10);
        }
        if (color == null) {
            DrawAction.$$$reportNull$$$0(11);
        }
        if (connectionType == null) {
            DrawAction.$$$reportNull$$$0(12);
        }
        if (sceneContext == null) {
            DrawAction.$$$reportNull$$$0(13);
        }
        PATH.reset();
        CurvePoints points = NavActionHelperKt.getCurvePoints(source, dest, sceneContext);
        PATH.moveTo(points.p1.x, points.p1.y);
        PATH.curveTo(points.p2.x, points.p2.y, points.p3.x, points.p3.y, points.p4.x, points.p4.y);
        BasicStroke actionStroke = connectionType == ActionType.EXIT_DESTINATION ? NavActionHelperKt.DASHED_ACTION_STROKE : NavActionHelperKt.ACTION_STROKE;
        g.setStroke(actionStroke);
        g.setColor(color);
        g.draw(PATH);
    }

    @NotNull
    private static ArrowDirection getArrowDirection(@NotNull ConnectionDirection direction) {
        if (direction == null) {
            DrawAction.$$$reportNull$$$0(14);
        }
        switch (direction) {
            case LEFT: {
                ArrowDirection arrowDirection = ArrowDirection.RIGHT;
                if (arrowDirection == null) {
                    DrawAction.$$$reportNull$$$0(15);
                }
                return arrowDirection;
            }
            case RIGHT: {
                ArrowDirection arrowDirection = ArrowDirection.LEFT;
                if (arrowDirection == null) {
                    DrawAction.$$$reportNull$$$0(16);
                }
                return arrowDirection;
            }
            case TOP: {
                ArrowDirection arrowDirection = ArrowDirection.DOWN;
                if (arrowDirection == null) {
                    DrawAction.$$$reportNull$$$0(17);
                }
                return arrowDirection;
            }
            case BOTTOM: {
                ArrowDirection arrowDirection = ArrowDirection.UP;
                if (arrowDirection == null) {
                    DrawAction.$$$reportNull$$$0(18);
                }
                return arrowDirection;
            }
        }
        throw new IllegalArgumentException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionType";
                break;
            }
            case 4: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneView";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/naveditor/scene/draw/DrawAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/naveditor/scene/draw/DrawAction";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrowDirection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onPaint";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildDisplayList";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "draw";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getArrowDirection";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

